/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.ProgressRequestBody;
import org.wso2.am.integration.clients.store.api.ProgressResponseBody;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyMappingRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyReGenerateResponseDTO;

public class ApplicationKeysApi {
    private ApiClient apiClient;

    public ApplicationKeysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationKeysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call applicationsApplicationIdGenerateKeysPostCall(String applicationId, ApplicationKeyGenerateRequestDTO body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApplicationKeyGenerateRequestDTO localVarPostBody = body;
        String localVarPath = "/applications/{applicationId}/generate-keys".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdGenerateKeysPostValidateBeforeCall(String applicationId, ApplicationKeyGenerateRequestDTO body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdGenerateKeysPost(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling applicationsApplicationIdGenerateKeysPost(Async)");
        }
        Call call = this.applicationsApplicationIdGenerateKeysPostCall(applicationId, body, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationKeyDTO applicationsApplicationIdGenerateKeysPost(String applicationId, ApplicationKeyGenerateRequestDTO body) throws ApiException {
        ApiResponse<ApplicationKeyDTO> resp = this.applicationsApplicationIdGenerateKeysPostWithHttpInfo(applicationId, body);
        return resp.getData();
    }

    public ApiResponse<ApplicationKeyDTO> applicationsApplicationIdGenerateKeysPostWithHttpInfo(String applicationId, ApplicationKeyGenerateRequestDTO body) throws ApiException {
        Call call = this.applicationsApplicationIdGenerateKeysPostValidateBeforeCall(applicationId, body, null, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsApplicationIdGenerateKeysPostAsync(String applicationId, ApplicationKeyGenerateRequestDTO body, final ApiCallback<ApplicationKeyDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdGenerateKeysPostValidateBeforeCall(applicationId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsApplicationIdKeysGetCall(String applicationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications/{applicationId}/keys".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdKeysGetValidateBeforeCall(String applicationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdKeysGet(Async)");
        }
        Call call = this.applicationsApplicationIdKeysGetCall(applicationId, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationKeyListDTO applicationsApplicationIdKeysGet(String applicationId) throws ApiException {
        ApiResponse<ApplicationKeyListDTO> resp = this.applicationsApplicationIdKeysGetWithHttpInfo(applicationId);
        return resp.getData();
    }

    public ApiResponse<ApplicationKeyListDTO> applicationsApplicationIdKeysGetWithHttpInfo(String applicationId) throws ApiException {
        Call call = this.applicationsApplicationIdKeysGetValidateBeforeCall(applicationId, null, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyListDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsApplicationIdKeysGetAsync(String applicationId, final ApiCallback<ApplicationKeyListDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdKeysGetValidateBeforeCall(applicationId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationKeyListDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsApplicationIdKeysKeyTypeCleanUpPostCall(String applicationId, String keyType, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications/{applicationId}/keys/{keyType}/clean-up".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString())).replaceAll("\\{keyType\\}", this.apiClient.escapeString(keyType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdKeysKeyTypeCleanUpPostValidateBeforeCall(String applicationId, String keyType, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdKeysKeyTypeCleanUpPost(Async)");
        }
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling applicationsApplicationIdKeysKeyTypeCleanUpPost(Async)");
        }
        Call call = this.applicationsApplicationIdKeysKeyTypeCleanUpPostCall(applicationId, keyType, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public void applicationsApplicationIdKeysKeyTypeCleanUpPost(String applicationId, String keyType, String ifMatch) throws ApiException {
        this.applicationsApplicationIdKeysKeyTypeCleanUpPostWithHttpInfo(applicationId, keyType, ifMatch);
    }

    public ApiResponse<Void> applicationsApplicationIdKeysKeyTypeCleanUpPostWithHttpInfo(String applicationId, String keyType, String ifMatch) throws ApiException {
        Call call = this.applicationsApplicationIdKeysKeyTypeCleanUpPostValidateBeforeCall(applicationId, keyType, ifMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call applicationsApplicationIdKeysKeyTypeCleanUpPostAsync(String applicationId, String keyType, String ifMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdKeysKeyTypeCleanUpPostValidateBeforeCall(applicationId, keyType, ifMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call applicationsApplicationIdKeysKeyTypeGetCall(String applicationId, String keyType, String groupId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications/{applicationId}/keys/{keyType}".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString())).replaceAll("\\{keyType\\}", this.apiClient.escapeString(keyType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (groupId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("groupId", groupId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdKeysKeyTypeGetValidateBeforeCall(String applicationId, String keyType, String groupId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdKeysKeyTypeGet(Async)");
        }
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling applicationsApplicationIdKeysKeyTypeGet(Async)");
        }
        Call call = this.applicationsApplicationIdKeysKeyTypeGetCall(applicationId, keyType, groupId, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationKeyDTO applicationsApplicationIdKeysKeyTypeGet(String applicationId, String keyType, String groupId) throws ApiException {
        ApiResponse<ApplicationKeyDTO> resp = this.applicationsApplicationIdKeysKeyTypeGetWithHttpInfo(applicationId, keyType, groupId);
        return resp.getData();
    }

    public ApiResponse<ApplicationKeyDTO> applicationsApplicationIdKeysKeyTypeGetWithHttpInfo(String applicationId, String keyType, String groupId) throws ApiException {
        Call call = this.applicationsApplicationIdKeysKeyTypeGetValidateBeforeCall(applicationId, keyType, groupId, null, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsApplicationIdKeysKeyTypeGetAsync(String applicationId, String keyType, String groupId, final ApiCallback<ApplicationKeyDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdKeysKeyTypeGetValidateBeforeCall(applicationId, keyType, groupId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsApplicationIdKeysKeyTypePutCall(String applicationId, String keyType, ApplicationKeyDTO body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApplicationKeyDTO localVarPostBody = body;
        String localVarPath = "/applications/{applicationId}/keys/{keyType}".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString())).replaceAll("\\{keyType\\}", this.apiClient.escapeString(keyType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdKeysKeyTypePutValidateBeforeCall(String applicationId, String keyType, ApplicationKeyDTO body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdKeysKeyTypePut(Async)");
        }
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling applicationsApplicationIdKeysKeyTypePut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling applicationsApplicationIdKeysKeyTypePut(Async)");
        }
        Call call = this.applicationsApplicationIdKeysKeyTypePutCall(applicationId, keyType, body, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationKeyDTO applicationsApplicationIdKeysKeyTypePut(String applicationId, String keyType, ApplicationKeyDTO body) throws ApiException {
        ApiResponse<ApplicationKeyDTO> resp = this.applicationsApplicationIdKeysKeyTypePutWithHttpInfo(applicationId, keyType, body);
        return resp.getData();
    }

    public ApiResponse<ApplicationKeyDTO> applicationsApplicationIdKeysKeyTypePutWithHttpInfo(String applicationId, String keyType, ApplicationKeyDTO body) throws ApiException {
        Call call = this.applicationsApplicationIdKeysKeyTypePutValidateBeforeCall(applicationId, keyType, body, null, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsApplicationIdKeysKeyTypePutAsync(String applicationId, String keyType, ApplicationKeyDTO body, final ApiCallback<ApplicationKeyDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdKeysKeyTypePutValidateBeforeCall(applicationId, keyType, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsApplicationIdKeysKeyTypeRegenerateSecretPostCall(String applicationId, String keyType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications/{applicationId}/keys/{keyType}/regenerate-secret".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString())).replaceAll("\\{keyType\\}", this.apiClient.escapeString(keyType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdKeysKeyTypeRegenerateSecretPostValidateBeforeCall(String applicationId, String keyType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdKeysKeyTypeRegenerateSecretPost(Async)");
        }
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling applicationsApplicationIdKeysKeyTypeRegenerateSecretPost(Async)");
        }
        Call call = this.applicationsApplicationIdKeysKeyTypeRegenerateSecretPostCall(applicationId, keyType, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationKeyReGenerateResponseDTO applicationsApplicationIdKeysKeyTypeRegenerateSecretPost(String applicationId, String keyType) throws ApiException {
        ApiResponse<ApplicationKeyReGenerateResponseDTO> resp = this.applicationsApplicationIdKeysKeyTypeRegenerateSecretPostWithHttpInfo(applicationId, keyType);
        return resp.getData();
    }

    public ApiResponse<ApplicationKeyReGenerateResponseDTO> applicationsApplicationIdKeysKeyTypeRegenerateSecretPostWithHttpInfo(String applicationId, String keyType) throws ApiException {
        Call call = this.applicationsApplicationIdKeysKeyTypeRegenerateSecretPostValidateBeforeCall(applicationId, keyType, null, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyReGenerateResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsApplicationIdKeysKeyTypeRegenerateSecretPostAsync(String applicationId, String keyType, final ApiCallback<ApplicationKeyReGenerateResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdKeysKeyTypeRegenerateSecretPostValidateBeforeCall(applicationId, keyType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationKeyReGenerateResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsApplicationIdMapKeysPostCall(String applicationId, ApplicationKeyMappingRequestDTO body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApplicationKeyMappingRequestDTO localVarPostBody = body;
        String localVarPath = "/applications/{applicationId}/map-keys".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdMapKeysPostValidateBeforeCall(String applicationId, ApplicationKeyMappingRequestDTO body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdMapKeysPost(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling applicationsApplicationIdMapKeysPost(Async)");
        }
        Call call = this.applicationsApplicationIdMapKeysPostCall(applicationId, body, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationKeyDTO applicationsApplicationIdMapKeysPost(String applicationId, ApplicationKeyMappingRequestDTO body) throws ApiException {
        ApiResponse<ApplicationKeyDTO> resp = this.applicationsApplicationIdMapKeysPostWithHttpInfo(applicationId, body);
        return resp.getData();
    }

    public ApiResponse<ApplicationKeyDTO> applicationsApplicationIdMapKeysPostWithHttpInfo(String applicationId, ApplicationKeyMappingRequestDTO body) throws ApiException {
        Call call = this.applicationsApplicationIdMapKeysPostValidateBeforeCall(applicationId, body, null, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsApplicationIdMapKeysPostAsync(String applicationId, ApplicationKeyMappingRequestDTO body, final ApiCallback<ApplicationKeyDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdMapKeysPostValidateBeforeCall(applicationId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

