/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationTokenDTO;

public class ApplicationKeyDTO {
    @SerializedName(value="consumerKey")
    private String consumerKey = null;
    @SerializedName(value="consumerSecret")
    private String consumerSecret = null;
    @SerializedName(value="supportedGrantTypes")
    private List<String> supportedGrantTypes = null;
    @SerializedName(value="callbackUrl")
    private String callbackUrl = null;
    @SerializedName(value="keyState")
    private String keyState = null;
    @SerializedName(value="keyType")
    private KeyTypeEnum keyType = null;
    @SerializedName(value="groupId")
    private String groupId = null;
    @SerializedName(value="token")
    private ApplicationTokenDTO token = null;

    public ApplicationKeyDTO consumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    @ApiModelProperty(example="vYDoc9s7IgAFdkSyNDaswBX7ejoa", value="Consumer key of the application")
    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public ApplicationKeyDTO consumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
        return this;
    }

    @ApiModelProperty(example="TIDlOFkpzB7WjufO3OJUhy1fsvAa", value="Consumer secret of the application")
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public ApplicationKeyDTO supportedGrantTypes(List<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
        return this;
    }

    public ApplicationKeyDTO addSupportedGrantTypesItem(String supportedGrantTypesItem) {
        if (this.supportedGrantTypes == null) {
            this.supportedGrantTypes = new ArrayList<String>();
        }
        this.supportedGrantTypes.add(supportedGrantTypesItem);
        return this;
    }

    @ApiModelProperty(example="[\"client_credentials\",\"password\"]", value="The grant types that are supported by the application")
    public List<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public void setSupportedGrantTypes(List<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
    }

    public ApplicationKeyDTO callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @ApiModelProperty(example="http://sample.com/callback/url", value="Callback URL")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public ApplicationKeyDTO keyState(String keyState) {
        this.keyState = keyState;
        return this;
    }

    @ApiModelProperty(example="APPROVED", value="Describes the state of the key generation.")
    public String getKeyState() {
        return this.keyState;
    }

    public void setKeyState(String keyState) {
        this.keyState = keyState;
    }

    public ApplicationKeyDTO keyType(KeyTypeEnum keyType) {
        this.keyType = keyType;
        return this;
    }

    @ApiModelProperty(example="PRODUCTION", value="Describes to which endpoint the key belongs")
    public KeyTypeEnum getKeyType() {
        return this.keyType;
    }

    public void setKeyType(KeyTypeEnum keyType) {
        this.keyType = keyType;
    }

    public ApplicationKeyDTO groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @ApiModelProperty(example="2", value="Application group id (if any).")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public ApplicationKeyDTO token(ApplicationTokenDTO token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(value="")
    public ApplicationTokenDTO getToken() {
        return this.token;
    }

    public void setToken(ApplicationTokenDTO token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationKeyDTO applicationKey = (ApplicationKeyDTO)o;
        return Objects.equals(this.consumerKey, applicationKey.consumerKey) && Objects.equals(this.consumerSecret, applicationKey.consumerSecret) && Objects.equals(this.supportedGrantTypes, applicationKey.supportedGrantTypes) && Objects.equals(this.callbackUrl, applicationKey.callbackUrl) && Objects.equals(this.keyState, applicationKey.keyState) && Objects.equals((Object)this.keyType, (Object)applicationKey.keyType) && Objects.equals(this.groupId, applicationKey.groupId) && Objects.equals(this.token, applicationKey.token);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.consumerKey, this.consumerSecret, this.supportedGrantTypes, this.callbackUrl, this.keyState, this.keyType, this.groupId, this.token});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationKeyDTO {\n");
        sb.append("    consumerKey: ").append(this.toIndentedString(this.consumerKey)).append("\n");
        sb.append("    consumerSecret: ").append(this.toIndentedString(this.consumerSecret)).append("\n");
        sb.append("    supportedGrantTypes: ").append(this.toIndentedString(this.supportedGrantTypes)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    keyState: ").append(this.toIndentedString(this.keyState)).append("\n");
        sb.append("    keyType: ").append(this.toIndentedString((Object)this.keyType)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KeyTypeEnum {
        PRODUCTION("PRODUCTION"),
        SANDBOX("SANDBOX");

        private String value;

        private KeyTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KeyTypeEnum fromValue(String text) {
            for (KeyTypeEnum b : KeyTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<KeyTypeEnum> {
            public void write(JsonWriter jsonWriter, KeyTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KeyTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KeyTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

