/*
 * WSO2 API Manager - Store
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Store.  It is written with [swagger 2](http://swagger.io/). 
 *
 * OpenAPI spec version: v1.1
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.store.api.v1.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * AdvertiseInfoDTO
 */

public class AdvertiseInfoDTO {
  @SerializedName("advertised")
  private Boolean advertised = null;

  @SerializedName("originalStoreUrl")
  private String originalStoreUrl = null;

  @SerializedName("apiOwner")
  private String apiOwner = null;

  public AdvertiseInfoDTO advertised(Boolean advertised) {
    this.advertised = advertised;
    return this;
  }

   /**
   * Get advertised
   * @return advertised
  **/
  @ApiModelProperty(example = "true", value = "")
  public Boolean isAdvertised() {
    return advertised;
  }

  public void setAdvertised(Boolean advertised) {
    this.advertised = advertised;
  }

  public AdvertiseInfoDTO originalStoreUrl(String originalStoreUrl) {
    this.originalStoreUrl = originalStoreUrl;
    return this;
  }

   /**
   * Get originalStoreUrl
   * @return originalStoreUrl
  **/
  @ApiModelProperty(example = "https://localhost:9443/store", value = "")
  public String getOriginalStoreUrl() {
    return originalStoreUrl;
  }

  public void setOriginalStoreUrl(String originalStoreUrl) {
    this.originalStoreUrl = originalStoreUrl;
  }

  public AdvertiseInfoDTO apiOwner(String apiOwner) {
    this.apiOwner = apiOwner;
    return this;
  }

   /**
   * Get apiOwner
   * @return apiOwner
  **/
  @ApiModelProperty(example = "admin", value = "")
  public String getApiOwner() {
    return apiOwner;
  }

  public void setApiOwner(String apiOwner) {
    this.apiOwner = apiOwner;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdvertiseInfoDTO advertiseInfo = (AdvertiseInfoDTO) o;
    return Objects.equals(this.advertised, advertiseInfo.advertised) &&
        Objects.equals(this.originalStoreUrl, advertiseInfo.originalStoreUrl) &&
        Objects.equals(this.apiOwner, advertiseInfo.apiOwner);
  }

  @Override
  public int hashCode() {
    return Objects.hash(advertised, originalStoreUrl, apiOwner);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdvertiseInfoDTO {\n");
    
    sb.append("    advertised: ").append(toIndentedString(advertised)).append("\n");
    sb.append("    originalStoreUrl: ").append(toIndentedString(originalStoreUrl)).append("\n");
    sb.append("    apiOwner: ").append(toIndentedString(apiOwner)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

