/*
 * WSO2 API Manager - Store
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Store.  It is written with [swagger 2](http://swagger.io/). 
 *
 * OpenAPI spec version: v1.1
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.store.api.v1.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * SettingsDTO
 */

public class SettingsDTO {
  @SerializedName("grantTypes")
  private List<String> grantTypes = null;

  @SerializedName("scopes")
  private List<String> scopes = null;

  @SerializedName("applicationSharingEnabled")
  private Boolean applicationSharingEnabled = false;

  @SerializedName("mapExistingAuthApps")
  private Boolean mapExistingAuthApps = false;

  @SerializedName("apiGatewayEndpoint")
  private String apiGatewayEndpoint = null;

  @SerializedName("monetizationEnabled")
  private Boolean monetizationEnabled = false;

  @SerializedName("IsUnlimitedTierPaid")
  private Boolean isUnlimitedTierPaid = false;

  public SettingsDTO grantTypes(List<String> grantTypes) {
    this.grantTypes = grantTypes;
    return this;
  }

  public SettingsDTO addGrantTypesItem(String grantTypesItem) {
    if (this.grantTypes == null) {
      this.grantTypes = new ArrayList<>();
    }
    this.grantTypes.add(grantTypesItem);
    return this;
  }

   /**
   * Get grantTypes
   * @return grantTypes
  **/
  @ApiModelProperty(value = "")
  public List<String> getGrantTypes() {
    return grantTypes;
  }

  public void setGrantTypes(List<String> grantTypes) {
    this.grantTypes = grantTypes;
  }

  public SettingsDTO scopes(List<String> scopes) {
    this.scopes = scopes;
    return this;
  }

  public SettingsDTO addScopesItem(String scopesItem) {
    if (this.scopes == null) {
      this.scopes = new ArrayList<>();
    }
    this.scopes.add(scopesItem);
    return this;
  }

   /**
   * Get scopes
   * @return scopes
  **/
  @ApiModelProperty(value = "")
  public List<String> getScopes() {
    return scopes;
  }

  public void setScopes(List<String> scopes) {
    this.scopes = scopes;
  }

  public SettingsDTO applicationSharingEnabled(Boolean applicationSharingEnabled) {
    this.applicationSharingEnabled = applicationSharingEnabled;
    return this;
  }

   /**
   * Get applicationSharingEnabled
   * @return applicationSharingEnabled
  **/
  @ApiModelProperty(value = "")
  public Boolean isApplicationSharingEnabled() {
    return applicationSharingEnabled;
  }

  public void setApplicationSharingEnabled(Boolean applicationSharingEnabled) {
    this.applicationSharingEnabled = applicationSharingEnabled;
  }

  public SettingsDTO mapExistingAuthApps(Boolean mapExistingAuthApps) {
    this.mapExistingAuthApps = mapExistingAuthApps;
    return this;
  }

   /**
   * Get mapExistingAuthApps
   * @return mapExistingAuthApps
  **/
  @ApiModelProperty(value = "")
  public Boolean isMapExistingAuthApps() {
    return mapExistingAuthApps;
  }

  public void setMapExistingAuthApps(Boolean mapExistingAuthApps) {
    this.mapExistingAuthApps = mapExistingAuthApps;
  }

  public SettingsDTO apiGatewayEndpoint(String apiGatewayEndpoint) {
    this.apiGatewayEndpoint = apiGatewayEndpoint;
    return this;
  }

   /**
   * Get apiGatewayEndpoint
   * @return apiGatewayEndpoint
  **/
  @ApiModelProperty(value = "")
  public String getApiGatewayEndpoint() {
    return apiGatewayEndpoint;
  }

  public void setApiGatewayEndpoint(String apiGatewayEndpoint) {
    this.apiGatewayEndpoint = apiGatewayEndpoint;
  }

  public SettingsDTO monetizationEnabled(Boolean monetizationEnabled) {
    this.monetizationEnabled = monetizationEnabled;
    return this;
  }

   /**
   * Get monetizationEnabled
   * @return monetizationEnabled
  **/
  @ApiModelProperty(value = "")
  public Boolean isMonetizationEnabled() {
    return monetizationEnabled;
  }

  public void setMonetizationEnabled(Boolean monetizationEnabled) {
    this.monetizationEnabled = monetizationEnabled;
  }

  public SettingsDTO isUnlimitedTierPaid(Boolean isUnlimitedTierPaid) {
    this.isUnlimitedTierPaid = isUnlimitedTierPaid;
    return this;
  }

   /**
   * Get isUnlimitedTierPaid
   * @return isUnlimitedTierPaid
  **/
  @ApiModelProperty(value = "")
  public Boolean isIsUnlimitedTierPaid() {
    return isUnlimitedTierPaid;
  }

  public void setIsUnlimitedTierPaid(Boolean isUnlimitedTierPaid) {
    this.isUnlimitedTierPaid = isUnlimitedTierPaid;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SettingsDTO settings = (SettingsDTO) o;
    return Objects.equals(this.grantTypes, settings.grantTypes) &&
        Objects.equals(this.scopes, settings.scopes) &&
        Objects.equals(this.applicationSharingEnabled, settings.applicationSharingEnabled) &&
        Objects.equals(this.mapExistingAuthApps, settings.mapExistingAuthApps) &&
        Objects.equals(this.apiGatewayEndpoint, settings.apiGatewayEndpoint) &&
        Objects.equals(this.monetizationEnabled, settings.monetizationEnabled) &&
        Objects.equals(this.isUnlimitedTierPaid, settings.isUnlimitedTierPaid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(grantTypes, scopes, applicationSharingEnabled, mapExistingAuthApps, apiGatewayEndpoint, monetizationEnabled, isUnlimitedTierPaid);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SettingsDTO {\n");
    
    sb.append("    grantTypes: ").append(toIndentedString(grantTypes)).append("\n");
    sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
    sb.append("    applicationSharingEnabled: ").append(toIndentedString(applicationSharingEnabled)).append("\n");
    sb.append("    mapExistingAuthApps: ").append(toIndentedString(mapExistingAuthApps)).append("\n");
    sb.append("    apiGatewayEndpoint: ").append(toIndentedString(apiGatewayEndpoint)).append("\n");
    sb.append("    monetizationEnabled: ").append(toIndentedString(monetizationEnabled)).append("\n");
    sb.append("    isUnlimitedTierPaid: ").append(toIndentedString(isUnlimitedTierPaid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

