/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.ProgressRequestBody;
import org.wso2.am.integration.clients.store.api.ProgressResponseBody;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationTokenDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationTokenGenerateRequestDTO;

public class ApplicationTokensApi {
    private ApiClient apiClient;

    public ApplicationTokensApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationTokensApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call applicationsApplicationIdKeysKeyTypeGenerateTokenPostCall(String applicationId, String keyType, ApplicationTokenGenerateRequestDTO body, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApplicationTokenGenerateRequestDTO localVarPostBody = body;
        String localVarPath = "/applications/{applicationId}/keys/{keyType}/generate-token".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString())).replaceAll("\\{keyType\\}", this.apiClient.escapeString(keyType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdKeysKeyTypeGenerateTokenPostValidateBeforeCall(String applicationId, String keyType, ApplicationTokenGenerateRequestDTO body, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdKeysKeyTypeGenerateTokenPost(Async)");
        }
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling applicationsApplicationIdKeysKeyTypeGenerateTokenPost(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling applicationsApplicationIdKeysKeyTypeGenerateTokenPost(Async)");
        }
        Call call = this.applicationsApplicationIdKeysKeyTypeGenerateTokenPostCall(applicationId, keyType, body, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationTokenDTO applicationsApplicationIdKeysKeyTypeGenerateTokenPost(String applicationId, String keyType, ApplicationTokenGenerateRequestDTO body, String ifMatch) throws ApiException {
        ApiResponse<ApplicationTokenDTO> resp = this.applicationsApplicationIdKeysKeyTypeGenerateTokenPostWithHttpInfo(applicationId, keyType, body, ifMatch);
        return resp.getData();
    }

    public ApiResponse<ApplicationTokenDTO> applicationsApplicationIdKeysKeyTypeGenerateTokenPostWithHttpInfo(String applicationId, String keyType, ApplicationTokenGenerateRequestDTO body, String ifMatch) throws ApiException {
        Call call = this.applicationsApplicationIdKeysKeyTypeGenerateTokenPostValidateBeforeCall(applicationId, keyType, body, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<ApplicationTokenDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsApplicationIdKeysKeyTypeGenerateTokenPostAsync(String applicationId, String keyType, ApplicationTokenGenerateRequestDTO body, String ifMatch, final ApiCallback<ApplicationTokenDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdKeysKeyTypeGenerateTokenPostValidateBeforeCall(applicationId, keyType, body, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationTokenDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPostCall(String applicationId, String keyMappingId, ApplicationTokenGenerateRequestDTO body, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApplicationTokenGenerateRequestDTO localVarPostBody = body;
        String localVarPath = "/applications/{applicationId}/oauth-keys/{keyMappingId}/generate-token".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString())).replaceAll("\\{keyMappingId\\}", this.apiClient.escapeString(keyMappingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPostValidateBeforeCall(String applicationId, String keyMappingId, ApplicationTokenGenerateRequestDTO body, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPost(Async)");
        }
        if (keyMappingId == null) {
            throw new ApiException("Missing the required parameter 'keyMappingId' when calling applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPost(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPost(Async)");
        }
        Call call = this.applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPostCall(applicationId, keyMappingId, body, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationTokenDTO applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPost(String applicationId, String keyMappingId, ApplicationTokenGenerateRequestDTO body, String ifMatch) throws ApiException {
        ApiResponse<ApplicationTokenDTO> resp = this.applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPostWithHttpInfo(applicationId, keyMappingId, body, ifMatch);
        return resp.getData();
    }

    public ApiResponse<ApplicationTokenDTO> applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPostWithHttpInfo(String applicationId, String keyMappingId, ApplicationTokenGenerateRequestDTO body, String ifMatch) throws ApiException {
        Call call = this.applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPostValidateBeforeCall(applicationId, keyMappingId, body, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<ApplicationTokenDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPostAsync(String applicationId, String keyMappingId, ApplicationTokenGenerateRequestDTO body, String ifMatch, final ApiCallback<ApplicationTokenDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdOauthKeysKeyMappingIdGenerateTokenPostValidateBeforeCall(applicationId, keyMappingId, body, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationTokenDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

