/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.ProgressRequestBody;
import org.wso2.am.integration.clients.store.api.ProgressResponseBody;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationListDTO;

public class ApplicationsApi {
    private ApiClient apiClient;

    public ApplicationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call applicationsApplicationIdDeleteCall(String applicationId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications/{applicationId}".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdDeleteValidateBeforeCall(String applicationId, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdDelete(Async)");
        }
        Call call = this.applicationsApplicationIdDeleteCall(applicationId, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public void applicationsApplicationIdDelete(String applicationId, String ifMatch) throws ApiException {
        this.applicationsApplicationIdDeleteWithHttpInfo(applicationId, ifMatch);
    }

    public ApiResponse<Void> applicationsApplicationIdDeleteWithHttpInfo(String applicationId, String ifMatch) throws ApiException {
        Call call = this.applicationsApplicationIdDeleteValidateBeforeCall(applicationId, ifMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call applicationsApplicationIdDeleteAsync(String applicationId, String ifMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdDeleteValidateBeforeCall(applicationId, ifMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call applicationsApplicationIdGetCall(String applicationId, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications/{applicationId}".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdGetValidateBeforeCall(String applicationId, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdGet(Async)");
        }
        Call call = this.applicationsApplicationIdGetCall(applicationId, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationDTO applicationsApplicationIdGet(String applicationId, String ifNoneMatch) throws ApiException {
        ApiResponse<ApplicationDTO> resp = this.applicationsApplicationIdGetWithHttpInfo(applicationId, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<ApplicationDTO> applicationsApplicationIdGetWithHttpInfo(String applicationId, String ifNoneMatch) throws ApiException {
        Call call = this.applicationsApplicationIdGetValidateBeforeCall(applicationId, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsApplicationIdGetAsync(String applicationId, String ifNoneMatch, final ApiCallback<ApplicationDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdGetValidateBeforeCall(applicationId, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsApplicationIdPutCall(String applicationId, ApplicationDTO body, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApplicationDTO localVarPostBody = body;
        String localVarPath = "/applications/{applicationId}".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdPutValidateBeforeCall(String applicationId, ApplicationDTO body, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling applicationsApplicationIdPut(Async)");
        }
        Call call = this.applicationsApplicationIdPutCall(applicationId, body, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationDTO applicationsApplicationIdPut(String applicationId, ApplicationDTO body, String ifMatch) throws ApiException {
        ApiResponse<ApplicationDTO> resp = this.applicationsApplicationIdPutWithHttpInfo(applicationId, body, ifMatch);
        return resp.getData();
    }

    public ApiResponse<ApplicationDTO> applicationsApplicationIdPutWithHttpInfo(String applicationId, ApplicationDTO body, String ifMatch) throws ApiException {
        Call call = this.applicationsApplicationIdPutValidateBeforeCall(applicationId, body, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsApplicationIdPutAsync(String applicationId, ApplicationDTO body, String ifMatch, final ApiCallback<ApplicationDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdPutValidateBeforeCall(applicationId, body, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsGetCall(String groupId, String query, String sortBy, String sortOrder, Integer limit, Integer offset, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (groupId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("groupId", groupId));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("query", query));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsGetValidateBeforeCall(String groupId, String query, String sortBy, String sortOrder, Integer limit, Integer offset, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.applicationsGetCall(groupId, query, sortBy, sortOrder, limit, offset, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationListDTO applicationsGet(String groupId, String query, String sortBy, String sortOrder, Integer limit, Integer offset, String ifNoneMatch) throws ApiException {
        ApiResponse<ApplicationListDTO> resp = this.applicationsGetWithHttpInfo(groupId, query, sortBy, sortOrder, limit, offset, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<ApplicationListDTO> applicationsGetWithHttpInfo(String groupId, String query, String sortBy, String sortOrder, Integer limit, Integer offset, String ifNoneMatch) throws ApiException {
        Call call = this.applicationsGetValidateBeforeCall(groupId, query, sortBy, sortOrder, limit, offset, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<ApplicationListDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsGetAsync(String groupId, String query, String sortBy, String sortOrder, Integer limit, Integer offset, String ifNoneMatch, final ApiCallback<ApplicationListDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsGetValidateBeforeCall(groupId, query, sortBy, sortOrder, limit, offset, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationListDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsPostCall(ApplicationDTO body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApplicationDTO localVarPostBody = body;
        String localVarPath = "/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsPostValidateBeforeCall(ApplicationDTO body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling applicationsPost(Async)");
        }
        Call call = this.applicationsPostCall(body, progressListener, progressRequestListener);
        return call;
    }

    public ApplicationDTO applicationsPost(ApplicationDTO body) throws ApiException {
        ApiResponse<ApplicationDTO> resp = this.applicationsPostWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<ApplicationDTO> applicationsPostWithHttpInfo(ApplicationDTO body) throws ApiException {
        Call call = this.applicationsPostValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsPostAsync(ApplicationDTO body, final ApiCallback<ApplicationDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsPostValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

