/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.ProgressRequestBody;
import org.wso2.am.integration.clients.store.api.ProgressResponseBody;
import org.wso2.am.integration.clients.store.api.v1.dto.RatingDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.RatingListDTO;

public class RatingsApi {
    private ApiClient apiClient;

    public RatingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RatingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call apisApiIdRatingsGetCall(String apiId, Integer limit, Integer offset, String xWSO2Tenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/ratings".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdRatingsGetValidateBeforeCall(String apiId, Integer limit, Integer offset, String xWSO2Tenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdRatingsGet(Async)");
        }
        Call call = this.apisApiIdRatingsGetCall(apiId, limit, offset, xWSO2Tenant, progressListener, progressRequestListener);
        return call;
    }

    public RatingListDTO apisApiIdRatingsGet(String apiId, Integer limit, Integer offset, String xWSO2Tenant) throws ApiException {
        ApiResponse<RatingListDTO> resp = this.apisApiIdRatingsGetWithHttpInfo(apiId, limit, offset, xWSO2Tenant);
        return resp.getData();
    }

    public ApiResponse<RatingListDTO> apisApiIdRatingsGetWithHttpInfo(String apiId, Integer limit, Integer offset, String xWSO2Tenant) throws ApiException {
        Call call = this.apisApiIdRatingsGetValidateBeforeCall(apiId, limit, offset, xWSO2Tenant, null, null);
        Type localVarReturnType = new TypeToken<RatingListDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdRatingsGetAsync(String apiId, Integer limit, Integer offset, String xWSO2Tenant, final ApiCallback<RatingListDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdRatingsGetValidateBeforeCall(apiId, limit, offset, xWSO2Tenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RatingListDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdUserRatingDeleteCall(String apiId, String xWSO2Tenant, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/user-rating".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdUserRatingDeleteValidateBeforeCall(String apiId, String xWSO2Tenant, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdUserRatingDelete(Async)");
        }
        Call call = this.apisApiIdUserRatingDeleteCall(apiId, xWSO2Tenant, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdUserRatingDelete(String apiId, String xWSO2Tenant, String ifMatch) throws ApiException {
        this.apisApiIdUserRatingDeleteWithHttpInfo(apiId, xWSO2Tenant, ifMatch);
    }

    public ApiResponse<Void> apisApiIdUserRatingDeleteWithHttpInfo(String apiId, String xWSO2Tenant, String ifMatch) throws ApiException {
        Call call = this.apisApiIdUserRatingDeleteValidateBeforeCall(apiId, xWSO2Tenant, ifMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdUserRatingDeleteAsync(String apiId, String xWSO2Tenant, String ifMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdUserRatingDeleteValidateBeforeCall(apiId, xWSO2Tenant, ifMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdUserRatingGetCall(String apiId, String xWSO2Tenant, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/user-rating".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdUserRatingGetValidateBeforeCall(String apiId, String xWSO2Tenant, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdUserRatingGet(Async)");
        }
        Call call = this.apisApiIdUserRatingGetCall(apiId, xWSO2Tenant, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public RatingDTO apisApiIdUserRatingGet(String apiId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        ApiResponse<RatingDTO> resp = this.apisApiIdUserRatingGetWithHttpInfo(apiId, xWSO2Tenant, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<RatingDTO> apisApiIdUserRatingGetWithHttpInfo(String apiId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        Call call = this.apisApiIdUserRatingGetValidateBeforeCall(apiId, xWSO2Tenant, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<RatingDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdUserRatingGetAsync(String apiId, String xWSO2Tenant, String ifNoneMatch, final ApiCallback<RatingDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdUserRatingGetValidateBeforeCall(apiId, xWSO2Tenant, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RatingDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdUserRatingPutCall(String apiId, RatingDTO body, String xWSO2Tenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RatingDTO localVarPostBody = body;
        String localVarPath = "/apis/{apiId}/user-rating".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdUserRatingPutValidateBeforeCall(String apiId, RatingDTO body, String xWSO2Tenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdUserRatingPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling apisApiIdUserRatingPut(Async)");
        }
        Call call = this.apisApiIdUserRatingPutCall(apiId, body, xWSO2Tenant, progressListener, progressRequestListener);
        return call;
    }

    public RatingDTO apisApiIdUserRatingPut(String apiId, RatingDTO body, String xWSO2Tenant) throws ApiException {
        ApiResponse<RatingDTO> resp = this.apisApiIdUserRatingPutWithHttpInfo(apiId, body, xWSO2Tenant);
        return resp.getData();
    }

    public ApiResponse<RatingDTO> apisApiIdUserRatingPutWithHttpInfo(String apiId, RatingDTO body, String xWSO2Tenant) throws ApiException {
        Call call = this.apisApiIdUserRatingPutValidateBeforeCall(apiId, body, xWSO2Tenant, null, null);
        Type localVarReturnType = new TypeToken<RatingDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdUserRatingPutAsync(String apiId, RatingDTO body, String xWSO2Tenant, final ApiCallback<RatingDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdUserRatingPutValidateBeforeCall(apiId, body, xWSO2Tenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RatingDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

