/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.wso2.am.integration.clients.store.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationInfoDTO;

public class SubscriptionDTO {
    @SerializedName(value="subscriptionId")
    private String subscriptionId = null;
    @SerializedName(value="applicationId")
    private String applicationId = null;
    @SerializedName(value="apiId")
    private String apiId = null;
    @SerializedName(value="apiInfo")
    private APIInfoDTO apiInfo = null;
    @SerializedName(value="applicationInfo")
    private ApplicationInfoDTO applicationInfo = null;
    @SerializedName(value="throttlingPolicy")
    private String throttlingPolicy = null;
    @SerializedName(value="requestedThrottlingPolicy")
    private String requestedThrottlingPolicy = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="redirectionParams")
    private String redirectionParams = null;

    public SubscriptionDTO subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    @ApiModelProperty(example="faae5fcc-cbae-40c4-bf43-89931630d313", value="The UUID of the subscription")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public SubscriptionDTO applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @ApiModelProperty(example="b3ade481-30b0-4b38-9a67-498a40873a6d", required=true, value="The UUID of the application")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public SubscriptionDTO apiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the API.")
    public String getApiId() {
        return this.apiId;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public SubscriptionDTO apiInfo(APIInfoDTO apiInfo) {
        this.apiInfo = apiInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public APIInfoDTO getApiInfo() {
        return this.apiInfo;
    }

    public void setApiInfo(APIInfoDTO apiInfo) {
        this.apiInfo = apiInfo;
    }

    public SubscriptionDTO applicationInfo(ApplicationInfoDTO applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ApplicationInfoDTO getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfoDTO applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public SubscriptionDTO throttlingPolicy(String throttlingPolicy) {
        this.throttlingPolicy = throttlingPolicy;
        return this;
    }

    @ApiModelProperty(example="Unlimited", required=true, value="")
    public String getThrottlingPolicy() {
        return this.throttlingPolicy;
    }

    public void setThrottlingPolicy(String throttlingPolicy) {
        this.throttlingPolicy = throttlingPolicy;
    }

    public SubscriptionDTO requestedThrottlingPolicy(String requestedThrottlingPolicy) {
        this.requestedThrottlingPolicy = requestedThrottlingPolicy;
        return this;
    }

    @ApiModelProperty(example="Unlimited", value="")
    public String getRequestedThrottlingPolicy() {
        return this.requestedThrottlingPolicy;
    }

    public void setRequestedThrottlingPolicy(String requestedThrottlingPolicy) {
        this.requestedThrottlingPolicy = requestedThrottlingPolicy;
    }

    public SubscriptionDTO status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="UNBLOCKED", value="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public SubscriptionDTO redirectionParams(String redirectionParams) {
        this.redirectionParams = redirectionParams;
        return this;
    }

    @ApiModelProperty(value="A url and other parameters the subscriber can be redirected.")
    public String getRedirectionParams() {
        return this.redirectionParams;
    }

    public void setRedirectionParams(String redirectionParams) {
        this.redirectionParams = redirectionParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionDTO subscription = (SubscriptionDTO)o;
        return Objects.equals(this.subscriptionId, subscription.subscriptionId) && Objects.equals(this.applicationId, subscription.applicationId) && Objects.equals(this.apiId, subscription.apiId) && Objects.equals(this.apiInfo, subscription.apiInfo) && Objects.equals(this.applicationInfo, subscription.applicationInfo) && Objects.equals(this.throttlingPolicy, subscription.throttlingPolicy) && Objects.equals(this.requestedThrottlingPolicy, subscription.requestedThrottlingPolicy) && Objects.equals((Object)this.status, (Object)subscription.status) && Objects.equals(this.redirectionParams, subscription.redirectionParams);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subscriptionId, this.applicationId, this.apiId, this.apiInfo, this.applicationInfo, this.throttlingPolicy, this.requestedThrottlingPolicy, this.status, this.redirectionParams});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionDTO {\n");
        sb.append("    subscriptionId: ").append(this.toIndentedString(this.subscriptionId)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    apiId: ").append(this.toIndentedString(this.apiId)).append("\n");
        sb.append("    apiInfo: ").append(this.toIndentedString(this.apiInfo)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    throttlingPolicy: ").append(this.toIndentedString(this.throttlingPolicy)).append("\n");
        sb.append("    requestedThrottlingPolicy: ").append(this.toIndentedString(this.requestedThrottlingPolicy)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    redirectionParams: ").append(this.toIndentedString(this.redirectionParams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        BLOCKED("BLOCKED"),
        PROD_ONLY_BLOCKED("PROD_ONLY_BLOCKED"),
        UNBLOCKED("UNBLOCKED"),
        ON_HOLD("ON_HOLD"),
        REJECTED("REJECTED"),
        TIER_UPDATE_PENDING("TIER_UPDATE_PENDING");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

