/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.wso2.am.integration.clients.store.api.v1.dto.MonetizationInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ThrottlingPolicyPermissionInfoDTO;

public class ThrottlingPolicyDTO {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="policyLevel")
    private PolicyLevelEnum policyLevel = null;
    @SerializedName(value="attributes")
    private Map<String, String> attributes = null;
    @SerializedName(value="requestCount")
    private Long requestCount = null;
    @SerializedName(value="unitTime")
    private Long unitTime = null;
    @SerializedName(value="tierPlan")
    private TierPlanEnum tierPlan = null;
    @SerializedName(value="stopOnQuotaReach")
    private Boolean stopOnQuotaReach = null;
    @SerializedName(value="monetizationAttributes")
    private MonetizationInfoDTO monetizationAttributes = null;
    @SerializedName(value="throttlingPolicyPermissions")
    private ThrottlingPolicyPermissionInfoDTO throttlingPolicyPermissions = null;

    public ThrottlingPolicyDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Platinum", required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ThrottlingPolicyDTO description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Allows 50 request(s) per minute.", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ThrottlingPolicyDTO policyLevel(PolicyLevelEnum policyLevel) {
        this.policyLevel = policyLevel;
        return this;
    }

    @ApiModelProperty(example="subscription", value="")
    public PolicyLevelEnum getPolicyLevel() {
        return this.policyLevel;
    }

    public void setPolicyLevel(PolicyLevelEnum policyLevel) {
        this.policyLevel = policyLevel;
    }

    public ThrottlingPolicyDTO attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ThrottlingPolicyDTO putAttributesItem(String key, String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @ApiModelProperty(example="{}", value="Custom attributes added to the throttling policy ")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ThrottlingPolicyDTO requestCount(Long requestCount) {
        this.requestCount = requestCount;
        return this;
    }

    @ApiModelProperty(example="50", required=true, value="Maximum number of requests which can be sent within a provided unit time ")
    public Long getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(Long requestCount) {
        this.requestCount = requestCount;
    }

    public ThrottlingPolicyDTO unitTime(Long unitTime) {
        this.unitTime = unitTime;
        return this;
    }

    @ApiModelProperty(example="60000", required=true, value="")
    public Long getUnitTime() {
        return this.unitTime;
    }

    public void setUnitTime(Long unitTime) {
        this.unitTime = unitTime;
    }

    public ThrottlingPolicyDTO tierPlan(TierPlanEnum tierPlan) {
        this.tierPlan = tierPlan;
        return this;
    }

    @ApiModelProperty(example="FREE", required=true, value="This attribute declares whether this tier is available under commercial or free ")
    public TierPlanEnum getTierPlan() {
        return this.tierPlan;
    }

    public void setTierPlan(TierPlanEnum tierPlan) {
        this.tierPlan = tierPlan;
    }

    public ThrottlingPolicyDTO stopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="If this attribute is set to false, you are capabale of sending requests even if the request count exceeded within a unit time ")
    public Boolean isStopOnQuotaReach() {
        return this.stopOnQuotaReach;
    }

    public void setStopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
    }

    public ThrottlingPolicyDTO monetizationAttributes(MonetizationInfoDTO monetizationAttributes) {
        this.monetizationAttributes = monetizationAttributes;
        return this;
    }

    @ApiModelProperty(value="")
    public MonetizationInfoDTO getMonetizationAttributes() {
        return this.monetizationAttributes;
    }

    public void setMonetizationAttributes(MonetizationInfoDTO monetizationAttributes) {
        this.monetizationAttributes = monetizationAttributes;
    }

    public ThrottlingPolicyDTO throttlingPolicyPermissions(ThrottlingPolicyPermissionInfoDTO throttlingPolicyPermissions) {
        this.throttlingPolicyPermissions = throttlingPolicyPermissions;
        return this;
    }

    @ApiModelProperty(value="")
    public ThrottlingPolicyPermissionInfoDTO getThrottlingPolicyPermissions() {
        return this.throttlingPolicyPermissions;
    }

    public void setThrottlingPolicyPermissions(ThrottlingPolicyPermissionInfoDTO throttlingPolicyPermissions) {
        this.throttlingPolicyPermissions = throttlingPolicyPermissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThrottlingPolicyDTO throttlingPolicy = (ThrottlingPolicyDTO)o;
        return Objects.equals(this.name, throttlingPolicy.name) && Objects.equals(this.description, throttlingPolicy.description) && Objects.equals((Object)this.policyLevel, (Object)throttlingPolicy.policyLevel) && Objects.equals(this.attributes, throttlingPolicy.attributes) && Objects.equals(this.requestCount, throttlingPolicy.requestCount) && Objects.equals(this.unitTime, throttlingPolicy.unitTime) && Objects.equals((Object)this.tierPlan, (Object)throttlingPolicy.tierPlan) && Objects.equals(this.stopOnQuotaReach, throttlingPolicy.stopOnQuotaReach) && Objects.equals(this.monetizationAttributes, throttlingPolicy.monetizationAttributes) && Objects.equals(this.throttlingPolicyPermissions, throttlingPolicy.throttlingPolicyPermissions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.policyLevel, this.attributes, this.requestCount, this.unitTime, this.tierPlan, this.stopOnQuotaReach, this.monetizationAttributes, this.throttlingPolicyPermissions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThrottlingPolicyDTO {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    policyLevel: ").append(this.toIndentedString((Object)this.policyLevel)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    requestCount: ").append(this.toIndentedString(this.requestCount)).append("\n");
        sb.append("    unitTime: ").append(this.toIndentedString(this.unitTime)).append("\n");
        sb.append("    tierPlan: ").append(this.toIndentedString((Object)this.tierPlan)).append("\n");
        sb.append("    stopOnQuotaReach: ").append(this.toIndentedString(this.stopOnQuotaReach)).append("\n");
        sb.append("    monetizationAttributes: ").append(this.toIndentedString(this.monetizationAttributes)).append("\n");
        sb.append("    throttlingPolicyPermissions: ").append(this.toIndentedString(this.throttlingPolicyPermissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TierPlanEnum {
        FREE("FREE"),
        COMMERCIAL("COMMERCIAL");

        private String value;

        private TierPlanEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TierPlanEnum fromValue(String text) {
            for (TierPlanEnum b : TierPlanEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TierPlanEnum> {
            public void write(JsonWriter jsonWriter, TierPlanEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TierPlanEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TierPlanEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PolicyLevelEnum {
        APPLICATION("application"),
        SUBSCRIPTION("subscription");

        private String value;

        private PolicyLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PolicyLevelEnum fromValue(String text) {
            for (PolicyLevelEnum b : PolicyLevelEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PolicyLevelEnum> {
            public void write(JsonWriter jsonWriter, PolicyLevelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PolicyLevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PolicyLevelEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

