/*
 * WSO2 API Manager - Store
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Store.  It is written with [swagger 2](http://swagger.io/). 
 *
 * OpenAPI spec version: v1.1
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.store.api.v1.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * AlertConfigDTO
 */

public class AlertConfigDTO {
  @SerializedName("configurationId")
  private String configurationId = null;

  @SerializedName("configuration")
  private Map<String, String> _configuration = null;

  public AlertConfigDTO configurationId(String configurationId) {
    this.configurationId = configurationId;
    return this;
  }

   /**
   * The alert config subscription id.
   * @return configurationId
  **/
  @ApiModelProperty(example = "UGl6emFTaGFja0FQSSsxLjAuMCtEZWZhdWx0QXBwbGljYXRpb24K", value = "The alert config subscription id.")
  public String getConfigurationId() {
    return configurationId;
  }

  public void setConfigurationId(String configurationId) {
    this.configurationId = configurationId;
  }

  public AlertConfigDTO _configuration(Map<String, String> _configuration) {
    this._configuration = _configuration;
    return this;
  }

  public AlertConfigDTO putConfigurationItem(String key, String _configurationItem) {
    if (this._configuration == null) {
      this._configuration = new HashMap<>();
    }
    this._configuration.put(key, _configurationItem);
    return this;
  }

   /**
   * The config parameters.
   * @return _configuration
  **/
  @ApiModelProperty(example = "{\"apiName\":\"PizzaShackAPI\",\"apiVersion\":\"1.0.0\",\"applicationName\":\"DefaultApplication\",\"requestConunt\":\"12\"}", value = "The config parameters.")
  public Map<String, String> getConfiguration() {
    return _configuration;
  }

  public void setConfiguration(Map<String, String> _configuration) {
    this._configuration = _configuration;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AlertConfigDTO alertConfig = (AlertConfigDTO) o;
    return Objects.equals(this.configurationId, alertConfig.configurationId) &&
        Objects.equals(this._configuration, alertConfig._configuration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configurationId, _configuration);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AlertConfigDTO {\n");
    
    sb.append("    configurationId: ").append(toIndentedString(configurationId)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

