/*
 * WSO2 API Manager - Store
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Store.  It is written with [swagger 2](http://swagger.io/). 
 *
 * OpenAPI spec version: v1.1
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.store.api.v1.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * MonetizationInfoDTO
 */

public class MonetizationInfoDTO {
  /**
   * Gets or Sets billingType
   */
  @JsonAdapter(BillingTypeEnum.Adapter.class)
  public enum BillingTypeEnum {
    FIXEDPRICE("fixedPrice"),
    
    DYNAMICRATE("dynamicRate");

    private String value;

    BillingTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BillingTypeEnum fromValue(String text) {
      for (BillingTypeEnum b : BillingTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<BillingTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BillingTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BillingTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return BillingTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("billingType")
  private BillingTypeEnum billingType = null;

  @SerializedName("billingCycle")
  private String billingCycle = null;

  @SerializedName("fixedPrice")
  private String fixedPrice = null;

  @SerializedName("pricePerRequest")
  private String pricePerRequest = null;

  @SerializedName("currencyType")
  private String currencyType = null;

  public MonetizationInfoDTO billingType(BillingTypeEnum billingType) {
    this.billingType = billingType;
    return this;
  }

   /**
   * Get billingType
   * @return billingType
  **/
  @ApiModelProperty(example = "fixedPrice", value = "")
  public BillingTypeEnum getBillingType() {
    return billingType;
  }

  public void setBillingType(BillingTypeEnum billingType) {
    this.billingType = billingType;
  }

  public MonetizationInfoDTO billingCycle(String billingCycle) {
    this.billingCycle = billingCycle;
    return this;
  }

   /**
   * Get billingCycle
   * @return billingCycle
  **/
  @ApiModelProperty(example = "month", value = "")
  public String getBillingCycle() {
    return billingCycle;
  }

  public void setBillingCycle(String billingCycle) {
    this.billingCycle = billingCycle;
  }

  public MonetizationInfoDTO fixedPrice(String fixedPrice) {
    this.fixedPrice = fixedPrice;
    return this;
  }

   /**
   * Get fixedPrice
   * @return fixedPrice
  **/
  @ApiModelProperty(example = "10", value = "")
  public String getFixedPrice() {
    return fixedPrice;
  }

  public void setFixedPrice(String fixedPrice) {
    this.fixedPrice = fixedPrice;
  }

  public MonetizationInfoDTO pricePerRequest(String pricePerRequest) {
    this.pricePerRequest = pricePerRequest;
    return this;
  }

   /**
   * Get pricePerRequest
   * @return pricePerRequest
  **/
  @ApiModelProperty(example = "1", value = "")
  public String getPricePerRequest() {
    return pricePerRequest;
  }

  public void setPricePerRequest(String pricePerRequest) {
    this.pricePerRequest = pricePerRequest;
  }

  public MonetizationInfoDTO currencyType(String currencyType) {
    this.currencyType = currencyType;
    return this;
  }

   /**
   * Get currencyType
   * @return currencyType
  **/
  @ApiModelProperty(example = "USD", value = "")
  public String getCurrencyType() {
    return currencyType;
  }

  public void setCurrencyType(String currencyType) {
    this.currencyType = currencyType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MonetizationInfoDTO monetizationInfo = (MonetizationInfoDTO) o;
    return Objects.equals(this.billingType, monetizationInfo.billingType) &&
        Objects.equals(this.billingCycle, monetizationInfo.billingCycle) &&
        Objects.equals(this.fixedPrice, monetizationInfo.fixedPrice) &&
        Objects.equals(this.pricePerRequest, monetizationInfo.pricePerRequest) &&
        Objects.equals(this.currencyType, monetizationInfo.currencyType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billingType, billingCycle, fixedPrice, pricePerRequest, currencyType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MonetizationInfoDTO {\n");
    
    sb.append("    billingType: ").append(toIndentedString(billingType)).append("\n");
    sb.append("    billingCycle: ").append(toIndentedString(billingCycle)).append("\n");
    sb.append("    fixedPrice: ").append(toIndentedString(fixedPrice)).append("\n");
    sb.append("    pricePerRequest: ").append(toIndentedString(pricePerRequest)).append("\n");
    sb.append("    currencyType: ").append(toIndentedString(currencyType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

