/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.ProgressRequestBody;
import org.wso2.am.integration.clients.store.api.ProgressResponseBody;
import org.wso2.am.integration.clients.store.api.v1.dto.AlertConfigDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.AlertConfigInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.AlertConfigListDTO;

public class AlertConfigurationApi {
    private ApiClient apiClient;

    public AlertConfigurationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlertConfigurationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addAlertConfigCall(String alertType, String configurationId, AlertConfigInfoDTO body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AlertConfigInfoDTO localVarPostBody = body;
        String localVarPath = "/alerts/{alertType}/configurations/{configurationId}".replaceAll("\\{alertType\\}", this.apiClient.escapeString(alertType.toString())).replaceAll("\\{configurationId\\}", this.apiClient.escapeString(configurationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addAlertConfigValidateBeforeCall(String alertType, String configurationId, AlertConfigInfoDTO body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alertType == null) {
            throw new ApiException("Missing the required parameter 'alertType' when calling addAlertConfig(Async)");
        }
        if (configurationId == null) {
            throw new ApiException("Missing the required parameter 'configurationId' when calling addAlertConfig(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addAlertConfig(Async)");
        }
        Call call = this.addAlertConfigCall(alertType, configurationId, body, progressListener, progressRequestListener);
        return call;
    }

    public AlertConfigDTO addAlertConfig(String alertType, String configurationId, AlertConfigInfoDTO body) throws ApiException {
        ApiResponse<AlertConfigDTO> resp = this.addAlertConfigWithHttpInfo(alertType, configurationId, body);
        return resp.getData();
    }

    public ApiResponse<AlertConfigDTO> addAlertConfigWithHttpInfo(String alertType, String configurationId, AlertConfigInfoDTO body) throws ApiException {
        Call call = this.addAlertConfigValidateBeforeCall(alertType, configurationId, body, null, null);
        Type localVarReturnType = new TypeToken<AlertConfigDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addAlertConfigAsync(String alertType, String configurationId, AlertConfigInfoDTO body, final ApiCallback<AlertConfigDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addAlertConfigValidateBeforeCall(alertType, configurationId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AlertConfigDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteAlertConfigCall(String alertType, String configurationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/alerts/{alertType}/configurations/{configurationId}".replaceAll("\\{alertType\\}", this.apiClient.escapeString(alertType.toString())).replaceAll("\\{configurationId\\}", this.apiClient.escapeString(configurationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAlertConfigValidateBeforeCall(String alertType, String configurationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alertType == null) {
            throw new ApiException("Missing the required parameter 'alertType' when calling deleteAlertConfig(Async)");
        }
        if (configurationId == null) {
            throw new ApiException("Missing the required parameter 'configurationId' when calling deleteAlertConfig(Async)");
        }
        Call call = this.deleteAlertConfigCall(alertType, configurationId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteAlertConfig(String alertType, String configurationId) throws ApiException {
        this.deleteAlertConfigWithHttpInfo(alertType, configurationId);
    }

    public ApiResponse<Void> deleteAlertConfigWithHttpInfo(String alertType, String configurationId) throws ApiException {
        Call call = this.deleteAlertConfigValidateBeforeCall(alertType, configurationId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteAlertConfigAsync(String alertType, String configurationId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAlertConfigValidateBeforeCall(alertType, configurationId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getAllAlertConfigsCall(String alertType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/alerts/{alertType}/configurations".replaceAll("\\{alertType\\}", this.apiClient.escapeString(alertType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllAlertConfigsValidateBeforeCall(String alertType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (alertType == null) {
            throw new ApiException("Missing the required parameter 'alertType' when calling getAllAlertConfigs(Async)");
        }
        Call call = this.getAllAlertConfigsCall(alertType, progressListener, progressRequestListener);
        return call;
    }

    public AlertConfigListDTO getAllAlertConfigs(String alertType) throws ApiException {
        ApiResponse<AlertConfigListDTO> resp = this.getAllAlertConfigsWithHttpInfo(alertType);
        return resp.getData();
    }

    public ApiResponse<AlertConfigListDTO> getAllAlertConfigsWithHttpInfo(String alertType) throws ApiException {
        Call call = this.getAllAlertConfigsValidateBeforeCall(alertType, null, null);
        Type localVarReturnType = new TypeToken<AlertConfigListDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllAlertConfigsAsync(String alertType, final ApiCallback<AlertConfigListDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllAlertConfigsValidateBeforeCall(alertType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AlertConfigListDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

