/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.ProgressRequestBody;
import org.wso2.am.integration.clients.store.api.ProgressResponseBody;
import org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIKeyRevokeRequestDTO;

public class ApiKeysApi {
    private ApiClient apiClient;

    public ApiKeysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiKeysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call applicationsApplicationIdApiKeysKeyTypeGeneratePostCall(String applicationId, String keyType, APIKeyGenerateRequestDTO body, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        APIKeyGenerateRequestDTO localVarPostBody = body;
        String localVarPath = "/applications/{applicationId}/api-keys/{keyType}/generate".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString())).replaceAll("\\{keyType\\}", this.apiClient.escapeString(keyType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdApiKeysKeyTypeGeneratePostValidateBeforeCall(String applicationId, String keyType, APIKeyGenerateRequestDTO body, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdApiKeysKeyTypeGeneratePost(Async)");
        }
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling applicationsApplicationIdApiKeysKeyTypeGeneratePost(Async)");
        }
        Call call = this.applicationsApplicationIdApiKeysKeyTypeGeneratePostCall(applicationId, keyType, body, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public APIKeyDTO applicationsApplicationIdApiKeysKeyTypeGeneratePost(String applicationId, String keyType, APIKeyGenerateRequestDTO body, String ifMatch) throws ApiException {
        ApiResponse<APIKeyDTO> resp = this.applicationsApplicationIdApiKeysKeyTypeGeneratePostWithHttpInfo(applicationId, keyType, body, ifMatch);
        return resp.getData();
    }

    public ApiResponse<APIKeyDTO> applicationsApplicationIdApiKeysKeyTypeGeneratePostWithHttpInfo(String applicationId, String keyType, APIKeyGenerateRequestDTO body, String ifMatch) throws ApiException {
        Call call = this.applicationsApplicationIdApiKeysKeyTypeGeneratePostValidateBeforeCall(applicationId, keyType, body, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<APIKeyDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applicationsApplicationIdApiKeysKeyTypeGeneratePostAsync(String applicationId, String keyType, APIKeyGenerateRequestDTO body, String ifMatch, final ApiCallback<APIKeyDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdApiKeysKeyTypeGeneratePostValidateBeforeCall(applicationId, keyType, body, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIKeyDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call applicationsApplicationIdApiKeysKeyTypeRevokePostCall(String applicationId, String keyType, APIKeyRevokeRequestDTO body, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        APIKeyRevokeRequestDTO localVarPostBody = body;
        String localVarPath = "/applications/{applicationId}/api-keys/{keyType}/revoke".replaceAll("\\{applicationId\\}", this.apiClient.escapeString(applicationId.toString())).replaceAll("\\{keyType\\}", this.apiClient.escapeString(keyType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applicationsApplicationIdApiKeysKeyTypeRevokePostValidateBeforeCall(String applicationId, String keyType, APIKeyRevokeRequestDTO body, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdApiKeysKeyTypeRevokePost(Async)");
        }
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling applicationsApplicationIdApiKeysKeyTypeRevokePost(Async)");
        }
        Call call = this.applicationsApplicationIdApiKeysKeyTypeRevokePostCall(applicationId, keyType, body, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public void applicationsApplicationIdApiKeysKeyTypeRevokePost(String applicationId, String keyType, APIKeyRevokeRequestDTO body, String ifMatch) throws ApiException {
        this.applicationsApplicationIdApiKeysKeyTypeRevokePostWithHttpInfo(applicationId, keyType, body, ifMatch);
    }

    public ApiResponse<Void> applicationsApplicationIdApiKeysKeyTypeRevokePostWithHttpInfo(String applicationId, String keyType, APIKeyRevokeRequestDTO body, String ifMatch) throws ApiException {
        Call call = this.applicationsApplicationIdApiKeysKeyTypeRevokePostValidateBeforeCall(applicationId, keyType, body, ifMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call applicationsApplicationIdApiKeysKeyTypeRevokePostAsync(String applicationId, String keyType, APIKeyRevokeRequestDTO body, String ifMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applicationsApplicationIdApiKeysKeyTypeRevokePostValidateBeforeCall(applicationId, keyType, body, ifMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

