/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.ProgressRequestBody;
import org.wso2.am.integration.clients.store.api.ProgressResponseBody;
import org.wso2.am.integration.clients.store.api.v1.dto.ThrottlingPolicyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ThrottlingPolicyListDTO;

public class ThrottlingPoliciesApi {
    private ApiClient apiClient;

    public ThrottlingPoliciesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ThrottlingPoliciesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call throttlingPoliciesPolicyLevelGetCall(String policyLevel, Integer limit, Integer offset, String ifNoneMatch, String xWSO2Tenant, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/throttling-policies/{policyLevel}".replaceAll("\\{policyLevel\\}", this.apiClient.escapeString(policyLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call throttlingPoliciesPolicyLevelGetValidateBeforeCall(String policyLevel, Integer limit, Integer offset, String ifNoneMatch, String xWSO2Tenant, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (policyLevel == null) {
            throw new ApiException("Missing the required parameter 'policyLevel' when calling throttlingPoliciesPolicyLevelGet(Async)");
        }
        Call call = this.throttlingPoliciesPolicyLevelGetCall(policyLevel, limit, offset, ifNoneMatch, xWSO2Tenant, progressListener, progressRequestListener);
        return call;
    }

    public List<ThrottlingPolicyListDTO> throttlingPoliciesPolicyLevelGet(String policyLevel, Integer limit, Integer offset, String ifNoneMatch, String xWSO2Tenant) throws ApiException {
        ApiResponse<List<ThrottlingPolicyListDTO>> resp = this.throttlingPoliciesPolicyLevelGetWithHttpInfo(policyLevel, limit, offset, ifNoneMatch, xWSO2Tenant);
        return resp.getData();
    }

    public ApiResponse<List<ThrottlingPolicyListDTO>> throttlingPoliciesPolicyLevelGetWithHttpInfo(String policyLevel, Integer limit, Integer offset, String ifNoneMatch, String xWSO2Tenant) throws ApiException {
        Call call = this.throttlingPoliciesPolicyLevelGetValidateBeforeCall(policyLevel, limit, offset, ifNoneMatch, xWSO2Tenant, null, null);
        Type localVarReturnType = new TypeToken<List<ThrottlingPolicyListDTO>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call throttlingPoliciesPolicyLevelGetAsync(String policyLevel, Integer limit, Integer offset, String ifNoneMatch, String xWSO2Tenant, final ApiCallback<List<ThrottlingPolicyListDTO>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.throttlingPoliciesPolicyLevelGetValidateBeforeCall(policyLevel, limit, offset, ifNoneMatch, xWSO2Tenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ThrottlingPolicyListDTO>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call throttlingPoliciesPolicyLevelPolicyIdGetCall(String policyId, String policyLevel, String xWSO2Tenant, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/throttling-policies/{policyLevel}/{policyId}".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{policyLevel\\}", this.apiClient.escapeString(policyLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call throttlingPoliciesPolicyLevelPolicyIdGetValidateBeforeCall(String policyId, String policyLevel, String xWSO2Tenant, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling throttlingPoliciesPolicyLevelPolicyIdGet(Async)");
        }
        if (policyLevel == null) {
            throw new ApiException("Missing the required parameter 'policyLevel' when calling throttlingPoliciesPolicyLevelPolicyIdGet(Async)");
        }
        Call call = this.throttlingPoliciesPolicyLevelPolicyIdGetCall(policyId, policyLevel, xWSO2Tenant, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public ThrottlingPolicyDTO throttlingPoliciesPolicyLevelPolicyIdGet(String policyId, String policyLevel, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        ApiResponse<ThrottlingPolicyDTO> resp = this.throttlingPoliciesPolicyLevelPolicyIdGetWithHttpInfo(policyId, policyLevel, xWSO2Tenant, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<ThrottlingPolicyDTO> throttlingPoliciesPolicyLevelPolicyIdGetWithHttpInfo(String policyId, String policyLevel, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        Call call = this.throttlingPoliciesPolicyLevelPolicyIdGetValidateBeforeCall(policyId, policyLevel, xWSO2Tenant, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<ThrottlingPolicyDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call throttlingPoliciesPolicyLevelPolicyIdGetAsync(String policyId, String policyLevel, String xWSO2Tenant, String ifNoneMatch, final ApiCallback<ThrottlingPolicyDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.throttlingPoliciesPolicyLevelPolicyIdGetValidateBeforeCall(policyId, policyLevel, xWSO2Tenant, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ThrottlingPolicyDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

