/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ScopeInfoDTO;

public class ApplicationDTO {
    public static final String SERIALIZED_NAME_APPLICATION_ID = "applicationId";
    @SerializedName(value="applicationId")
    private String applicationId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_THROTTLING_POLICY = "throttlingPolicy";
    @SerializedName(value="throttlingPolicy")
    private String throttlingPolicy;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "tokenType";
    @SerializedName(value="tokenType")
    private TokenTypeEnum tokenType = TokenTypeEnum.JWT;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status = "";
    public static final String SERIALIZED_NAME_GROUPS = "groups";
    @SerializedName(value="groups")
    private List<String> groups = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_COUNT = "subscriptionCount";
    @SerializedName(value="subscriptionCount")
    private Integer subscriptionCount;
    public static final String SERIALIZED_NAME_KEYS = "keys";
    @SerializedName(value="keys")
    private List<ApplicationKeyDTO> keys = null;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private Map<String, String> attributes = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_SCOPES = "subscriptionScopes";
    @SerializedName(value="subscriptionScopes")
    private List<ScopeInfoDTO> subscriptionScopes = null;
    public static final String SERIALIZED_NAME_OWNER = "owner";
    @SerializedName(value="owner")
    private String owner;
    public static final String SERIALIZED_NAME_HASH_ENABLED = "hashEnabled";
    @SerializedName(value="hashEnabled")
    private Boolean hashEnabled;

    public ApplicationDTO applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", value="")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public ApplicationDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="CalculatorApp", required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationDTO throttlingPolicy(String throttlingPolicy) {
        this.throttlingPolicy = throttlingPolicy;
        return this;
    }

    @ApiModelProperty(example="Unlimited", required=true, value="")
    public String getThrottlingPolicy() {
        return this.throttlingPolicy;
    }

    public void setThrottlingPolicy(String throttlingPolicy) {
        this.throttlingPolicy = throttlingPolicy;
    }

    public ApplicationDTO description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sample calculator application", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApplicationDTO tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="JWT", value="Type of the access token generated for this application.  **OAUTH:** A UUID based access token **JWT:** A self-contained, signed JWT based access token which is issued by default. ")
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public ApplicationDTO status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="APPROVED", value="")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ApplicationDTO groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[]", value="")
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public ApplicationDTO subscriptionCount(Integer subscriptionCount) {
        this.subscriptionCount = subscriptionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getSubscriptionCount() {
        return this.subscriptionCount;
    }

    public void setSubscriptionCount(Integer subscriptionCount) {
        this.subscriptionCount = subscriptionCount;
    }

    public ApplicationDTO keys(List<ApplicationKeyDTO> keys) {
        this.keys = keys;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[]", value="")
    public List<ApplicationKeyDTO> getKeys() {
        return this.keys;
    }

    public void setKeys(List<ApplicationKeyDTO> keys) {
        this.keys = keys;
    }

    public ApplicationDTO attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{}", value="")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ApplicationDTO subscriptionScopes(List<ScopeInfoDTO> subscriptionScopes) {
        this.subscriptionScopes = subscriptionScopes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[]", value="")
    public List<ScopeInfoDTO> getSubscriptionScopes() {
        return this.subscriptionScopes;
    }

    public void setSubscriptionScopes(List<ScopeInfoDTO> subscriptionScopes) {
        this.subscriptionScopes = subscriptionScopes;
    }

    public ApplicationDTO owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="admin", value="Application created user ")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ApplicationDTO hashEnabled(Boolean hashEnabled) {
        this.hashEnabled = hashEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="")
    public Boolean isHashEnabled() {
        return this.hashEnabled;
    }

    public void setHashEnabled(Boolean hashEnabled) {
        this.hashEnabled = hashEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationDTO application = (ApplicationDTO)o;
        return Objects.equals(this.applicationId, application.applicationId) && Objects.equals(this.name, application.name) && Objects.equals(this.throttlingPolicy, application.throttlingPolicy) && Objects.equals(this.description, application.description) && Objects.equals((Object)this.tokenType, (Object)application.tokenType) && Objects.equals(this.status, application.status) && Objects.equals(this.groups, application.groups) && Objects.equals(this.subscriptionCount, application.subscriptionCount) && Objects.equals(this.keys, application.keys) && Objects.equals(this.attributes, application.attributes) && Objects.equals(this.subscriptionScopes, application.subscriptionScopes) && Objects.equals(this.owner, application.owner) && Objects.equals(this.hashEnabled, application.hashEnabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicationId, this.name, this.throttlingPolicy, this.description, this.tokenType, this.status, this.groups, this.subscriptionCount, this.keys, this.attributes, this.subscriptionScopes, this.owner, this.hashEnabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationDTO {\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    throttlingPolicy: ").append(this.toIndentedString(this.throttlingPolicy)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    subscriptionCount: ").append(this.toIndentedString(this.subscriptionCount)).append("\n");
        sb.append("    keys: ").append(this.toIndentedString(this.keys)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    subscriptionScopes: ").append(this.toIndentedString(this.subscriptionScopes)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    hashEnabled: ").append(this.toIndentedString(this.hashEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TokenTypeEnum {
        OAUTH("OAUTH"),
        JWT("JWT");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TokenTypeEnum fromValue(String value) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TokenTypeEnum> {
            public void write(JsonWriter jsonWriter, TokenTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TokenTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TokenTypeEnum.fromValue(value);
            }
        }
    }
}

