/*
 * WSO2 API Manager - Developer Portal
 * This document specifies a **RESTful API** for WSO2 **API Manager** - **Developer Portal**. Please see [full OpenAPI Specification](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.7.206/components/apimgt/org.wso2.carbon.apimgt.rest.api.store.v1/src/main/resources/devportal-api.yaml) of the API which is written using [OAS 3.0](http://swagger.io/) specification.  # Authentication Our REST APIs are protected using OAuth2 and access control is achieved through scopes. Before you start invoking the API, you need to obtain an access token with the required scopes. This guide will walk you through the steps that you will need to follow to obtain an access token. First you need to obtain the consumer key/secret key pair by calling the dynamic client registration (DCR) endpoint. You can add your preferred grant types in the payload. A Sample payload is shown below. ```   {   \"callbackUrl\":\"www.google.lk\",   \"clientName\":\"rest_api_devportal\",   \"owner\":\"admin\",   \"grantType\":\"client_credentials password refresh_token\",   \"saasApp\":true   } ``` Create a file (payload.json) with the above sample payload, and use the cURL shown below to invoke the DCR endpoint. Authorization header of this should contain the base64 encoded admin username and password. **Format of the request** ```   curl -X POST -H \"Authorization: Basic Base64(admin_username:admin_password)\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://<host>:<servlet_port>/client-registration/v0.17/register ``` **Sample request** ```   curl -X POST -H \"Authorization: Basic YWRtaW46YWRtaW4=\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://localhost:9443/client-registration/v0.17/register ``` Following is a sample response after invoking the above curl. ``` { \"clientId\": \"fOCi4vNJ59PpHucC2CAYfYuADdMa\", \"clientName\": \"rest_api_devportal\", \"callBackURL\": \"www.google.lk\", \"clientSecret\": \"a4FwHlq0iCIKVs2MPIIDnepZnYMa\", \"isSaasApplication\": true, \"appOwner\": \"admin\", \"jsonString\": \"{\\\"grant_types\\\":\\\"client_credentials password refresh_token\\\",\\\"redirect_uris\\\":\\\"www.google.lk\\\",\\\"client_name\\\":\\\"rest_api_devportal\\\"}\", \"jsonAppAttribute\": \"{}\", \"tokenType\": null } ``` Next you must use the above client id and secret to obtain the access token. We will be using the password grant type for this, you can use any grant type you desire. You also need to add the proper **scope** when getting the access token. All possible scopes for devportal REST API can be viewed in **OAuth2 Security** section of this document and scope for each resource is given in **authorization** section of resource documentation. Following is the format of the request if you are using the password grant type. ``` curl -k -d \"grant_type=password&username=<admin_username>&password=<admin_password>&scope=<scopes separated by space>\" \\ -H \"Authorization: Basic base64(cliet_id:client_secret)\" \\ https://<host>:<gateway_port>/token ``` **Sample request** ``` curl https://localhost:8243/token -k \\ -H \"Authorization: Basic Zk9DaTR2Tko1OVBwSHVjQzJDQVlmWXVBRGRNYTphNEZ3SGxxMGlDSUtWczJNUElJRG5lcFpuWU1h\" \\ -d \"grant_type=password&username=admin&password=admin&scope=apim:subscribe apim:api_key\" ``` Shown below is a sample response to the above request. ``` { \"access_token\": \"e79bda48-3406-3178-acce-f6e4dbdcbb12\", \"refresh_token\": \"a757795d-e69f-38b8-bd85-9aded677a97c\", \"scope\": \"apim:subscribe apim:api_key\", \"token_type\": \"Bearer\", \"expires_in\": 3600 } ``` Now you have a valid access token, which you can use to invoke an API. Navigate through the API descriptions to find the required API, obtain an access token as described above and invoke the API with the authentication header. If you use a different authentication mechanism, this process may change.  # Try out in Postman If you want to try-out the embedded postman collection with \"Run in Postman\" option, please follow the guidelines listed below. * All of the OAuth2 secured endpoints have been configured with an Authorization Bearer header with a parameterized access token. Before invoking any REST API resource make sure you run the `Register DCR Application` and `Generate Access Token` requests to fetch an access token with all required scopes. * Make sure you have an API Manager instance up and running. * Update the `basepath` parameter to match the hostname and port of the APIM instance.  [![Run in Postman](https://run.pstmn.io/button.svg)](https://app.getpostman.com/run-collection/5bc0161b8aa7e701d7bf) 
 *
 * The version of the OpenAPI document: v2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.store.api.v1;

import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.ProgressRequestBody;
import org.wso2.am.integration.clients.store.api.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.wso2.am.integration.clients.store.api.v1.dto.AlertConfigDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.AlertConfigListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ErrorDTO;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlertConfigurationApi {
    private ApiClient localVarApiClient;

    public AlertConfigurationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlertConfigurationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for addAlertConfig
     * @param alertType The alert type.  (required)
     * @param configurationId The alert configuration id. Base64 encoded value of &#39;apiName#apiVersion#applicationName&#39;.  (required)
     * @param requestBody Configuration for AbnormalRequestCount alert type (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created. Successful response with newly created object as entity. Location header contains URL of newly created entity.  </td><td>  * Location - The location of the newly created entity.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addAlertConfigCall(String alertType, String configurationId, Map<String, String> requestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/alerts/{alertType}/configurations/{configurationId}"
            .replaceAll("\\{" + "alertType" + "\\}", localVarApiClient.escapeString(alertType.toString()))
            .replaceAll("\\{" + "configurationId" + "\\}", localVarApiClient.escapeString(configurationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call addAlertConfigValidateBeforeCall(String alertType, String configurationId, Map<String, String> requestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'alertType' is set
        if (alertType == null) {
            throw new ApiException("Missing the required parameter 'alertType' when calling addAlertConfig(Async)");
        }
        
        // verify the required parameter 'configurationId' is set
        if (configurationId == null) {
            throw new ApiException("Missing the required parameter 'configurationId' when calling addAlertConfig(Async)");
        }
        
        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling addAlertConfig(Async)");
        }
        

        okhttp3.Call localVarCall = addAlertConfigCall(alertType, configurationId, requestBody, _callback);
        return localVarCall;

    }

    /**
     * Add AbnormalRequestsPerMin Alert Configurations. 
     * This operation is used to add configuration for the AbnormalRequestsPerMin alert type. 
     * @param alertType The alert type.  (required)
     * @param configurationId The alert configuration id. Base64 encoded value of &#39;apiName#apiVersion#applicationName&#39;.  (required)
     * @param requestBody Configuration for AbnormalRequestCount alert type (required)
     * @return AlertConfigDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created. Successful response with newly created object as entity. Location header contains URL of newly created entity.  </td><td>  * Location - The location of the newly created entity.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public AlertConfigDTO addAlertConfig(String alertType, String configurationId, Map<String, String> requestBody) throws ApiException {
        ApiResponse<AlertConfigDTO> localVarResp = addAlertConfigWithHttpInfo(alertType, configurationId, requestBody);
        return localVarResp.getData();
    }

    /**
     * Add AbnormalRequestsPerMin Alert Configurations. 
     * This operation is used to add configuration for the AbnormalRequestsPerMin alert type. 
     * @param alertType The alert type.  (required)
     * @param configurationId The alert configuration id. Base64 encoded value of &#39;apiName#apiVersion#applicationName&#39;.  (required)
     * @param requestBody Configuration for AbnormalRequestCount alert type (required)
     * @return ApiResponse&lt;AlertConfigDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created. Successful response with newly created object as entity. Location header contains URL of newly created entity.  </td><td>  * Location - The location of the newly created entity.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AlertConfigDTO> addAlertConfigWithHttpInfo(String alertType, String configurationId, Map<String, String> requestBody) throws ApiException {
        okhttp3.Call localVarCall = addAlertConfigValidateBeforeCall(alertType, configurationId, requestBody, null);
        Type localVarReturnType = new TypeToken<AlertConfigDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Add AbnormalRequestsPerMin Alert Configurations.  (asynchronously)
     * This operation is used to add configuration for the AbnormalRequestsPerMin alert type. 
     * @param alertType The alert type.  (required)
     * @param configurationId The alert configuration id. Base64 encoded value of &#39;apiName#apiVersion#applicationName&#39;.  (required)
     * @param requestBody Configuration for AbnormalRequestCount alert type (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created. Successful response with newly created object as entity. Location header contains URL of newly created entity.  </td><td>  * Location - The location of the newly created entity.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addAlertConfigAsync(String alertType, String configurationId, Map<String, String> requestBody, final ApiCallback<AlertConfigDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = addAlertConfigValidateBeforeCall(alertType, configurationId, requestBody, _callback);
        Type localVarReturnType = new TypeToken<AlertConfigDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteAlertConfig
     * @param alertType The alert type.  (required)
     * @param configurationId The alert configuration id. Base64 encoded value of &#39;apiName#apiVersion#applicationName&#39;.  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. The alert config is deleted successfully.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAlertConfigCall(String alertType, String configurationId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/alerts/{alertType}/configurations/{configurationId}"
            .replaceAll("\\{" + "alertType" + "\\}", localVarApiClient.escapeString(alertType.toString()))
            .replaceAll("\\{" + "configurationId" + "\\}", localVarApiClient.escapeString(configurationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAlertConfigValidateBeforeCall(String alertType, String configurationId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'alertType' is set
        if (alertType == null) {
            throw new ApiException("Missing the required parameter 'alertType' when calling deleteAlertConfig(Async)");
        }
        
        // verify the required parameter 'configurationId' is set
        if (configurationId == null) {
            throw new ApiException("Missing the required parameter 'configurationId' when calling deleteAlertConfig(Async)");
        }
        

        okhttp3.Call localVarCall = deleteAlertConfigCall(alertType, configurationId, _callback);
        return localVarCall;

    }

    /**
     * Delete the Selected Configuration from AbnormalRequestsPerMin Alert Type. 
     * This operation is used to delete configuration from the AbnormalRequestsPerMin alert type. 
     * @param alertType The alert type.  (required)
     * @param configurationId The alert configuration id. Base64 encoded value of &#39;apiName#apiVersion#applicationName&#39;.  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. The alert config is deleted successfully.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteAlertConfig(String alertType, String configurationId) throws ApiException {
        deleteAlertConfigWithHttpInfo(alertType, configurationId);
    }

    /**
     * Delete the Selected Configuration from AbnormalRequestsPerMin Alert Type. 
     * This operation is used to delete configuration from the AbnormalRequestsPerMin alert type. 
     * @param alertType The alert type.  (required)
     * @param configurationId The alert configuration id. Base64 encoded value of &#39;apiName#apiVersion#applicationName&#39;.  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. The alert config is deleted successfully.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteAlertConfigWithHttpInfo(String alertType, String configurationId) throws ApiException {
        okhttp3.Call localVarCall = deleteAlertConfigValidateBeforeCall(alertType, configurationId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete the Selected Configuration from AbnormalRequestsPerMin Alert Type.  (asynchronously)
     * This operation is used to delete configuration from the AbnormalRequestsPerMin alert type. 
     * @param alertType The alert type.  (required)
     * @param configurationId The alert configuration id. Base64 encoded value of &#39;apiName#apiVersion#applicationName&#39;.  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. The alert config is deleted successfully.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAlertConfigAsync(String alertType, String configurationId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAlertConfigValidateBeforeCall(alertType, configurationId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllAlertConfigs
     * @param alertType The alert type.  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. The Developer Portal alert configuration.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllAlertConfigsCall(String alertType, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/alerts/{alertType}/configurations"
            .replaceAll("\\{" + "alertType" + "\\}", localVarApiClient.escapeString(alertType.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllAlertConfigsValidateBeforeCall(String alertType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'alertType' is set
        if (alertType == null) {
            throw new ApiException("Missing the required parameter 'alertType' when calling getAllAlertConfigs(Async)");
        }
        

        okhttp3.Call localVarCall = getAllAlertConfigsCall(alertType, _callback);
        return localVarCall;

    }

    /**
     * Get All AbnormalRequestsPerMin Alert Configurations 
     * This operation is used to get all configurations of the AbnormalRequestsPerMin alert type. 
     * @param alertType The alert type.  (required)
     * @return AlertConfigListDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. The Developer Portal alert configuration.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public AlertConfigListDTO getAllAlertConfigs(String alertType) throws ApiException {
        ApiResponse<AlertConfigListDTO> localVarResp = getAllAlertConfigsWithHttpInfo(alertType);
        return localVarResp.getData();
    }

    /**
     * Get All AbnormalRequestsPerMin Alert Configurations 
     * This operation is used to get all configurations of the AbnormalRequestsPerMin alert type. 
     * @param alertType The alert type.  (required)
     * @return ApiResponse&lt;AlertConfigListDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. The Developer Portal alert configuration.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AlertConfigListDTO> getAllAlertConfigsWithHttpInfo(String alertType) throws ApiException {
        okhttp3.Call localVarCall = getAllAlertConfigsValidateBeforeCall(alertType, null);
        Type localVarReturnType = new TypeToken<AlertConfigListDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get All AbnormalRequestsPerMin Alert Configurations  (asynchronously)
     * This operation is used to get all configurations of the AbnormalRequestsPerMin alert type. 
     * @param alertType The alert type.  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. The Developer Portal alert configuration.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 500 </td><td> Internal Server Error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllAlertConfigsAsync(String alertType, final ApiCallback<AlertConfigListDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllAlertConfigsValidateBeforeCall(alertType, _callback);
        Type localVarReturnType = new TypeToken<AlertConfigListDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
