/*
 * WSO2 API Manager - Developer Portal
 * This document specifies a **RESTful API** for WSO2 **API Manager** - **Developer Portal**. Please see [full OpenAPI Specification](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.7.206/components/apimgt/org.wso2.carbon.apimgt.rest.api.store.v1/src/main/resources/devportal-api.yaml) of the API which is written using [OAS 3.0](http://swagger.io/) specification.  # Authentication Our REST APIs are protected using OAuth2 and access control is achieved through scopes. Before you start invoking the API, you need to obtain an access token with the required scopes. This guide will walk you through the steps that you will need to follow to obtain an access token. First you need to obtain the consumer key/secret key pair by calling the dynamic client registration (DCR) endpoint. You can add your preferred grant types in the payload. A Sample payload is shown below. ```   {   \"callbackUrl\":\"www.google.lk\",   \"clientName\":\"rest_api_devportal\",   \"owner\":\"admin\",   \"grantType\":\"client_credentials password refresh_token\",   \"saasApp\":true   } ``` Create a file (payload.json) with the above sample payload, and use the cURL shown below to invoke the DCR endpoint. Authorization header of this should contain the base64 encoded admin username and password. **Format of the request** ```   curl -X POST -H \"Authorization: Basic Base64(admin_username:admin_password)\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://<host>:<servlet_port>/client-registration/v0.17/register ``` **Sample request** ```   curl -X POST -H \"Authorization: Basic YWRtaW46YWRtaW4=\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://localhost:9443/client-registration/v0.17/register ``` Following is a sample response after invoking the above curl. ``` { \"clientId\": \"fOCi4vNJ59PpHucC2CAYfYuADdMa\", \"clientName\": \"rest_api_devportal\", \"callBackURL\": \"www.google.lk\", \"clientSecret\": \"a4FwHlq0iCIKVs2MPIIDnepZnYMa\", \"isSaasApplication\": true, \"appOwner\": \"admin\", \"jsonString\": \"{\\\"grant_types\\\":\\\"client_credentials password refresh_token\\\",\\\"redirect_uris\\\":\\\"www.google.lk\\\",\\\"client_name\\\":\\\"rest_api_devportal\\\"}\", \"jsonAppAttribute\": \"{}\", \"tokenType\": null } ``` Next you must use the above client id and secret to obtain the access token. We will be using the password grant type for this, you can use any grant type you desire. You also need to add the proper **scope** when getting the access token. All possible scopes for devportal REST API can be viewed in **OAuth2 Security** section of this document and scope for each resource is given in **authorization** section of resource documentation. Following is the format of the request if you are using the password grant type. ``` curl -k -d \"grant_type=password&username=<admin_username>&password=<admin_password>&scope=<scopes separated by space>\" \\ -H \"Authorization: Basic base64(cliet_id:client_secret)\" \\ https://<host>:<gateway_port>/token ``` **Sample request** ``` curl https://localhost:8243/token -k \\ -H \"Authorization: Basic Zk9DaTR2Tko1OVBwSHVjQzJDQVlmWXVBRGRNYTphNEZ3SGxxMGlDSUtWczJNUElJRG5lcFpuWU1h\" \\ -d \"grant_type=password&username=admin&password=admin&scope=apim:subscribe apim:api_key\" ``` Shown below is a sample response to the above request. ``` { \"access_token\": \"e79bda48-3406-3178-acce-f6e4dbdcbb12\", \"refresh_token\": \"a757795d-e69f-38b8-bd85-9aded677a97c\", \"scope\": \"apim:subscribe apim:api_key\", \"token_type\": \"Bearer\", \"expires_in\": 3600 } ``` Now you have a valid access token, which you can use to invoke an API. Navigate through the API descriptions to find the required API, obtain an access token as described above and invoke the API with the authentication header. If you use a different authentication mechanism, this process may change.  # Try out in Postman If you want to try-out the embedded postman collection with \"Run in Postman\" option, please follow the guidelines listed below. * All of the OAuth2 secured endpoints have been configured with an Authorization Bearer header with a parameterized access token. Before invoking any REST API resource make sure you run the `Register DCR Application` and `Generate Access Token` requests to fetch an access token with all required scopes. * Make sure you have an API Manager instance up and running. * Update the `basepath` parameter to match the hostname and port of the APIM instance.  [![Run in Postman](https://run.pstmn.io/button.svg)](https://app.getpostman.com/run-collection/5bc0161b8aa7e701d7bf) 
 *
 * The version of the OpenAPI document: v2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.store.api.v1;

import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.ProgressRequestBody;
import org.wso2.am.integration.clients.store.api.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.wso2.am.integration.clients.store.api.v1.dto.APIInfoListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ErrorDTO;
import java.io.File;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplicationIndividualApi {
    private ApiClient localVarApiClient;

    public ApplicationIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationIndividualApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for applicationsImportPost
     * @param file Zip archive consisting of exported Application Configuration.  (required)
     * @param preserveOwner Preserve Original Creator of the Application  (optional)
     * @param skipSubscriptions Skip importing Subscriptions of the Application  (optional)
     * @param appOwner Expected Owner of the Application in the Import Environment  (optional)
     * @param skipApplicationKeys Skip importing Keys of the Application  (optional)
     * @param update Update if application exists  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Successful response with the updated object information as entity in the body.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 207 </td><td> Multi Status. Partially successful response with skipped APIs information object as entity in the body.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> Not Acceptable. The requested media type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsImportPostCall(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/applications/import";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (preserveOwner != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("preserveOwner", preserveOwner));
        }

        if (skipSubscriptions != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skipSubscriptions", skipSubscriptions));
        }

        if (appOwner != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("appOwner", appOwner));
        }

        if (skipApplicationKeys != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skipApplicationKeys", skipApplicationKeys));
        }

        if (update != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("update", update));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsImportPostValidateBeforeCall(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'file' is set
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling applicationsImportPost(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsImportPostCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, _callback);
        return localVarCall;

    }

    /**
     * Import an Application
     * This operation can be used to import an application. 
     * @param file Zip archive consisting of exported Application Configuration.  (required)
     * @param preserveOwner Preserve Original Creator of the Application  (optional)
     * @param skipSubscriptions Skip importing Subscriptions of the Application  (optional)
     * @param appOwner Expected Owner of the Application in the Import Environment  (optional)
     * @param skipApplicationKeys Skip importing Keys of the Application  (optional)
     * @param update Update if application exists  (optional)
     * @return ApplicationInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Successful response with the updated object information as entity in the body.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 207 </td><td> Multi Status. Partially successful response with skipped APIs information object as entity in the body.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> Not Acceptable. The requested media type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public ApplicationInfoDTO applicationsImportPost(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update) throws ApiException {
        ApiResponse<ApplicationInfoDTO> localVarResp = applicationsImportPostWithHttpInfo(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update);
        return localVarResp.getData();
    }

    /**
     * Import an Application
     * This operation can be used to import an application. 
     * @param file Zip archive consisting of exported Application Configuration.  (required)
     * @param preserveOwner Preserve Original Creator of the Application  (optional)
     * @param skipSubscriptions Skip importing Subscriptions of the Application  (optional)
     * @param appOwner Expected Owner of the Application in the Import Environment  (optional)
     * @param skipApplicationKeys Skip importing Keys of the Application  (optional)
     * @param update Update if application exists  (optional)
     * @return ApiResponse&lt;ApplicationInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Successful response with the updated object information as entity in the body.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 207 </td><td> Multi Status. Partially successful response with skipped APIs information object as entity in the body.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> Not Acceptable. The requested media type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ApplicationInfoDTO> applicationsImportPostWithHttpInfo(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update) throws ApiException {
        okhttp3.Call localVarCall = applicationsImportPostValidateBeforeCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, null);
        Type localVarReturnType = new TypeToken<ApplicationInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Import an Application (asynchronously)
     * This operation can be used to import an application. 
     * @param file Zip archive consisting of exported Application Configuration.  (required)
     * @param preserveOwner Preserve Original Creator of the Application  (optional)
     * @param skipSubscriptions Skip importing Subscriptions of the Application  (optional)
     * @param appOwner Expected Owner of the Application in the Import Environment  (optional)
     * @param skipApplicationKeys Skip importing Keys of the Application  (optional)
     * @param update Update if application exists  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Successful response with the updated object information as entity in the body.  </td><td>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 207 </td><td> Multi Status. Partially successful response with skipped APIs information object as entity in the body.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> Not Acceptable. The requested media type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsImportPostAsync(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, final ApiCallback<ApplicationInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsImportPostValidateBeforeCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, _callback);
        Type localVarReturnType = new TypeToken<ApplicationInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
