/*
 * WSO2 API Manager - Developer Portal
 * This document specifies a **RESTful API** for WSO2 **API Manager** - **Developer Portal**. Please see [full OpenAPI Specification](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.7.206/components/apimgt/org.wso2.carbon.apimgt.rest.api.store.v1/src/main/resources/devportal-api.yaml) of the API which is written using [OAS 3.0](http://swagger.io/) specification.  # Authentication Our REST APIs are protected using OAuth2 and access control is achieved through scopes. Before you start invoking the API, you need to obtain an access token with the required scopes. This guide will walk you through the steps that you will need to follow to obtain an access token. First you need to obtain the consumer key/secret key pair by calling the dynamic client registration (DCR) endpoint. You can add your preferred grant types in the payload. A Sample payload is shown below. ```   {   \"callbackUrl\":\"www.google.lk\",   \"clientName\":\"rest_api_devportal\",   \"owner\":\"admin\",   \"grantType\":\"client_credentials password refresh_token\",   \"saasApp\":true   } ``` Create a file (payload.json) with the above sample payload, and use the cURL shown below to invoke the DCR endpoint. Authorization header of this should contain the base64 encoded admin username and password. **Format of the request** ```   curl -X POST -H \"Authorization: Basic Base64(admin_username:admin_password)\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://<host>:<servlet_port>/client-registration/v0.17/register ``` **Sample request** ```   curl -X POST -H \"Authorization: Basic YWRtaW46YWRtaW4=\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://localhost:9443/client-registration/v0.17/register ``` Following is a sample response after invoking the above curl. ``` { \"clientId\": \"fOCi4vNJ59PpHucC2CAYfYuADdMa\", \"clientName\": \"rest_api_devportal\", \"callBackURL\": \"www.google.lk\", \"clientSecret\": \"a4FwHlq0iCIKVs2MPIIDnepZnYMa\", \"isSaasApplication\": true, \"appOwner\": \"admin\", \"jsonString\": \"{\\\"grant_types\\\":\\\"client_credentials password refresh_token\\\",\\\"redirect_uris\\\":\\\"www.google.lk\\\",\\\"client_name\\\":\\\"rest_api_devportal\\\"}\", \"jsonAppAttribute\": \"{}\", \"tokenType\": null } ``` Next you must use the above client id and secret to obtain the access token. We will be using the password grant type for this, you can use any grant type you desire. You also need to add the proper **scope** when getting the access token. All possible scopes for devportal REST API can be viewed in **OAuth2 Security** section of this document and scope for each resource is given in **authorization** section of resource documentation. Following is the format of the request if you are using the password grant type. ``` curl -k -d \"grant_type=password&username=<admin_username>&password=<admin_password>&scope=<scopes separated by space>\" \\ -H \"Authorization: Basic base64(cliet_id:client_secret)\" \\ https://<host>:<gateway_port>/token ``` **Sample request** ``` curl https://localhost:8243/token -k \\ -H \"Authorization: Basic Zk9DaTR2Tko1OVBwSHVjQzJDQVlmWXVBRGRNYTphNEZ3SGxxMGlDSUtWczJNUElJRG5lcFpuWU1h\" \\ -d \"grant_type=password&username=admin&password=admin&scope=apim:subscribe apim:api_key\" ``` Shown below is a sample response to the above request. ``` { \"access_token\": \"e79bda48-3406-3178-acce-f6e4dbdcbb12\", \"refresh_token\": \"a757795d-e69f-38b8-bd85-9aded677a97c\", \"scope\": \"apim:subscribe apim:api_key\", \"token_type\": \"Bearer\", \"expires_in\": 3600 } ``` Now you have a valid access token, which you can use to invoke an API. Navigate through the API descriptions to find the required API, obtain an access token as described above and invoke the API with the authentication header. If you use a different authentication mechanism, this process may change.  # Try out in Postman If you want to try-out the embedded postman collection with \"Run in Postman\" option, please follow the guidelines listed below. * All of the OAuth2 secured endpoints have been configured with an Authorization Bearer header with a parameterized access token. Before invoking any REST API resource make sure you run the `Register DCR Application` and `Generate Access Token` requests to fetch an access token with all required scopes. * Make sure you have an API Manager instance up and running. * Update the `basepath` parameter to match the hostname and port of the APIM instance.  [![Run in Postman](https://run.pstmn.io/button.svg)](https://app.getpostman.com/run-collection/5bc0161b8aa7e701d7bf) 
 *
 * The version of the OpenAPI document: v2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.store.api.v1;

import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.ProgressRequestBody;
import org.wso2.am.integration.clients.store.api.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyMappingRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyReGenerateResponseDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ErrorDTO;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplicationKeysApi {
    private ApiClient localVarApiClient;

    public ApplicationKeysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationKeysApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for applicationsApplicationIdGenerateKeysPost
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param applicationKeyGenerateRequestDTO Application key generation request object  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are generated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdGenerateKeysPostCall(String applicationId, ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequestDTO, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = applicationKeyGenerateRequestDTO;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/generate-keys"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdGenerateKeysPostValidateBeforeCall(String applicationId, ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequestDTO, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdGenerateKeysPost(Async)");
        }
        
        // verify the required parameter 'applicationKeyGenerateRequestDTO' is set
        if (applicationKeyGenerateRequestDTO == null) {
            throw new ApiException("Missing the required parameter 'applicationKeyGenerateRequestDTO' when calling applicationsApplicationIdGenerateKeysPost(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdGenerateKeysPostCall(applicationId, applicationKeyGenerateRequestDTO, _callback);
        return localVarCall;

    }

    /**
     * Generate Application Keys
     * Generate keys (Consumer key/secret) for application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param applicationKeyGenerateRequestDTO Application key generation request object  (required)
     * @return ApplicationKeyDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are generated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApplicationKeyDTO applicationsApplicationIdGenerateKeysPost(String applicationId, ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequestDTO) throws ApiException {
        ApiResponse<ApplicationKeyDTO> localVarResp = applicationsApplicationIdGenerateKeysPostWithHttpInfo(applicationId, applicationKeyGenerateRequestDTO);
        return localVarResp.getData();
    }

    /**
     * Generate Application Keys
     * Generate keys (Consumer key/secret) for application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param applicationKeyGenerateRequestDTO Application key generation request object  (required)
     * @return ApiResponse&lt;ApplicationKeyDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are generated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ApplicationKeyDTO> applicationsApplicationIdGenerateKeysPostWithHttpInfo(String applicationId, ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequestDTO) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdGenerateKeysPostValidateBeforeCall(applicationId, applicationKeyGenerateRequestDTO, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Generate Application Keys (asynchronously)
     * Generate keys (Consumer key/secret) for application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param applicationKeyGenerateRequestDTO Application key generation request object  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are generated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdGenerateKeysPostAsync(String applicationId, ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequestDTO, final ApiCallback<ApplicationKeyDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdGenerateKeysPostValidateBeforeCall(applicationId, applicationKeyGenerateRequestDTO, _callback);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for applicationsApplicationIdKeysGet
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call applicationsApplicationIdKeysGetCall(String applicationId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/keys"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdKeysGetValidateBeforeCall(String applicationId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdKeysGet(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdKeysGetCall(applicationId, _callback);
        return localVarCall;

    }

    /**
     * Retrieve All Application Keys
     * Retrieve keys (Consumer key/secret) of application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @return ApplicationKeyListDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApplicationKeyListDTO applicationsApplicationIdKeysGet(String applicationId) throws ApiException {
        ApiResponse<ApplicationKeyListDTO> localVarResp = applicationsApplicationIdKeysGetWithHttpInfo(applicationId);
        return localVarResp.getData();
    }

    /**
     * Retrieve All Application Keys
     * Retrieve keys (Consumer key/secret) of application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @return ApiResponse&lt;ApplicationKeyListDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApiResponse<ApplicationKeyListDTO> applicationsApplicationIdKeysGetWithHttpInfo(String applicationId) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdKeysGetValidateBeforeCall(applicationId, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyListDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve All Application Keys (asynchronously)
     * Retrieve keys (Consumer key/secret) of application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call applicationsApplicationIdKeysGetAsync(String applicationId, final ApiCallback<ApplicationKeyListDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdKeysGetValidateBeforeCall(applicationId, _callback);
        Type localVarReturnType = new TypeToken<ApplicationKeyListDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for applicationsApplicationIdKeysKeyTypeCleanUpPost
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Clean up is performed  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call applicationsApplicationIdKeysKeyTypeCleanUpPostCall(String applicationId, String keyType, String ifMatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/keys/{keyType}/clean-up"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()))
            .replaceAll("\\{" + "keyType" + "\\}", localVarApiClient.escapeString(keyType.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", localVarApiClient.parameterToString(ifMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdKeysKeyTypeCleanUpPostValidateBeforeCall(String applicationId, String keyType, String ifMatch, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdKeysKeyTypeCleanUpPost(Async)");
        }
        
        // verify the required parameter 'keyType' is set
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling applicationsApplicationIdKeysKeyTypeCleanUpPost(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypeCleanUpPostCall(applicationId, keyType, ifMatch, _callback);
        return localVarCall;

    }

    /**
     * Clean-Up Application Keys
     * Clean up keys after failed key generation of an application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Clean up is performed  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public void applicationsApplicationIdKeysKeyTypeCleanUpPost(String applicationId, String keyType, String ifMatch) throws ApiException {
        applicationsApplicationIdKeysKeyTypeCleanUpPostWithHttpInfo(applicationId, keyType, ifMatch);
    }

    /**
     * Clean-Up Application Keys
     * Clean up keys after failed key generation of an application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Clean up is performed  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApiResponse<Void> applicationsApplicationIdKeysKeyTypeCleanUpPostWithHttpInfo(String applicationId, String keyType, String ifMatch) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypeCleanUpPostValidateBeforeCall(applicationId, keyType, ifMatch, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Clean-Up Application Keys (asynchronously)
     * Clean up keys after failed key generation of an application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Clean up is performed  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call applicationsApplicationIdKeysKeyTypeCleanUpPostAsync(String applicationId, String keyType, String ifMatch, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypeCleanUpPostValidateBeforeCall(applicationId, keyType, ifMatch, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for applicationsApplicationIdKeysKeyTypeGet
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param groupId Application Group Id  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys of given type are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call applicationsApplicationIdKeysKeyTypeGetCall(String applicationId, String keyType, String groupId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/keys/{keyType}"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()))
            .replaceAll("\\{" + "keyType" + "\\}", localVarApiClient.escapeString(keyType.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (groupId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("groupId", groupId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdKeysKeyTypeGetValidateBeforeCall(String applicationId, String keyType, String groupId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdKeysKeyTypeGet(Async)");
        }
        
        // verify the required parameter 'keyType' is set
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling applicationsApplicationIdKeysKeyTypeGet(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypeGetCall(applicationId, keyType, groupId, _callback);
        return localVarCall;

    }

    /**
     * Get Key Details of a Given Type 
     * This operation can be used to retrieve key details of an individual application specifying the key type in the URI. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param groupId Application Group Id  (optional)
     * @return ApplicationKeyDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys of given type are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApplicationKeyDTO applicationsApplicationIdKeysKeyTypeGet(String applicationId, String keyType, String groupId) throws ApiException {
        ApiResponse<ApplicationKeyDTO> localVarResp = applicationsApplicationIdKeysKeyTypeGetWithHttpInfo(applicationId, keyType, groupId);
        return localVarResp.getData();
    }

    /**
     * Get Key Details of a Given Type 
     * This operation can be used to retrieve key details of an individual application specifying the key type in the URI. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param groupId Application Group Id  (optional)
     * @return ApiResponse&lt;ApplicationKeyDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys of given type are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApiResponse<ApplicationKeyDTO> applicationsApplicationIdKeysKeyTypeGetWithHttpInfo(String applicationId, String keyType, String groupId) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypeGetValidateBeforeCall(applicationId, keyType, groupId, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Key Details of a Given Type  (asynchronously)
     * This operation can be used to retrieve key details of an individual application specifying the key type in the URI. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param groupId Application Group Id  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys of given type are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call applicationsApplicationIdKeysKeyTypeGetAsync(String applicationId, String keyType, String groupId, final ApiCallback<ApplicationKeyDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypeGetValidateBeforeCall(applicationId, keyType, groupId, _callback);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for applicationsApplicationIdKeysKeyTypePut
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param applicationKeyDTO Grant types/Callback URL update request object  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Ok. Grant types or/and callback url is/are updated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call applicationsApplicationIdKeysKeyTypePutCall(String applicationId, String keyType, ApplicationKeyDTO applicationKeyDTO, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = applicationKeyDTO;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/keys/{keyType}"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()))
            .replaceAll("\\{" + "keyType" + "\\}", localVarApiClient.escapeString(keyType.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdKeysKeyTypePutValidateBeforeCall(String applicationId, String keyType, ApplicationKeyDTO applicationKeyDTO, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdKeysKeyTypePut(Async)");
        }
        
        // verify the required parameter 'keyType' is set
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling applicationsApplicationIdKeysKeyTypePut(Async)");
        }
        
        // verify the required parameter 'applicationKeyDTO' is set
        if (applicationKeyDTO == null) {
            throw new ApiException("Missing the required parameter 'applicationKeyDTO' when calling applicationsApplicationIdKeysKeyTypePut(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypePutCall(applicationId, keyType, applicationKeyDTO, _callback);
        return localVarCall;

    }

    /**
     * Update Grant Types and Callback Url of an Application 
     * This operation can be used to update grant types and callback url of an application. (Consumer Key and Consumer Secret are ignored) Upon succesfull you will retrieve the updated key details as the response. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param applicationKeyDTO Grant types/Callback URL update request object  (required)
     * @return ApplicationKeyDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Ok. Grant types or/and callback url is/are updated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApplicationKeyDTO applicationsApplicationIdKeysKeyTypePut(String applicationId, String keyType, ApplicationKeyDTO applicationKeyDTO) throws ApiException {
        ApiResponse<ApplicationKeyDTO> localVarResp = applicationsApplicationIdKeysKeyTypePutWithHttpInfo(applicationId, keyType, applicationKeyDTO);
        return localVarResp.getData();
    }

    /**
     * Update Grant Types and Callback Url of an Application 
     * This operation can be used to update grant types and callback url of an application. (Consumer Key and Consumer Secret are ignored) Upon succesfull you will retrieve the updated key details as the response. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param applicationKeyDTO Grant types/Callback URL update request object  (required)
     * @return ApiResponse&lt;ApplicationKeyDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Ok. Grant types or/and callback url is/are updated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApiResponse<ApplicationKeyDTO> applicationsApplicationIdKeysKeyTypePutWithHttpInfo(String applicationId, String keyType, ApplicationKeyDTO applicationKeyDTO) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypePutValidateBeforeCall(applicationId, keyType, applicationKeyDTO, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update Grant Types and Callback Url of an Application  (asynchronously)
     * This operation can be used to update grant types and callback url of an application. (Consumer Key and Consumer Secret are ignored) Upon succesfull you will retrieve the updated key details as the response. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param applicationKeyDTO Grant types/Callback URL update request object  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Ok. Grant types or/and callback url is/are updated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call applicationsApplicationIdKeysKeyTypePutAsync(String applicationId, String keyType, ApplicationKeyDTO applicationKeyDTO, final ApiCallback<ApplicationKeyDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypePutValidateBeforeCall(applicationId, keyType, applicationKeyDTO, _callback);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for applicationsApplicationIdKeysKeyTypeRegenerateSecretPost
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are re generated.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional requests (Will be supported in future).‚  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call applicationsApplicationIdKeysKeyTypeRegenerateSecretPostCall(String applicationId, String keyType, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/keys/{keyType}/regenerate-secret"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()))
            .replaceAll("\\{" + "keyType" + "\\}", localVarApiClient.escapeString(keyType.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdKeysKeyTypeRegenerateSecretPostValidateBeforeCall(String applicationId, String keyType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdKeysKeyTypeRegenerateSecretPost(Async)");
        }
        
        // verify the required parameter 'keyType' is set
        if (keyType == null) {
            throw new ApiException("Missing the required parameter 'keyType' when calling applicationsApplicationIdKeysKeyTypeRegenerateSecretPost(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypeRegenerateSecretPostCall(applicationId, keyType, _callback);
        return localVarCall;

    }

    /**
     * Re-Generate Consumer Secret 
     * This operation can be used to re generate consumer secret for an application for the give key type 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @return ApplicationKeyReGenerateResponseDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are re generated.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional requests (Will be supported in future).‚  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApplicationKeyReGenerateResponseDTO applicationsApplicationIdKeysKeyTypeRegenerateSecretPost(String applicationId, String keyType) throws ApiException {
        ApiResponse<ApplicationKeyReGenerateResponseDTO> localVarResp = applicationsApplicationIdKeysKeyTypeRegenerateSecretPostWithHttpInfo(applicationId, keyType);
        return localVarResp.getData();
    }

    /**
     * Re-Generate Consumer Secret 
     * This operation can be used to re generate consumer secret for an application for the give key type 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @return ApiResponse&lt;ApplicationKeyReGenerateResponseDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are re generated.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional requests (Will be supported in future).‚  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApiResponse<ApplicationKeyReGenerateResponseDTO> applicationsApplicationIdKeysKeyTypeRegenerateSecretPostWithHttpInfo(String applicationId, String keyType) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypeRegenerateSecretPostValidateBeforeCall(applicationId, keyType, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyReGenerateResponseDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Re-Generate Consumer Secret  (asynchronously)
     * This operation can be used to re generate consumer secret for an application for the give key type 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyType **Application Key Type** standing for the type of the keys (i.e. Production or Sandbox).  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are re generated.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional requests (Will be supported in future).‚  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call applicationsApplicationIdKeysKeyTypeRegenerateSecretPostAsync(String applicationId, String keyType, final ApiCallback<ApplicationKeyReGenerateResponseDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdKeysKeyTypeRegenerateSecretPostValidateBeforeCall(applicationId, keyType, _callback);
        Type localVarReturnType = new TypeToken<ApplicationKeyReGenerateResponseDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for applicationsApplicationIdMapKeysPost
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param applicationKeyMappingRequestDTO Application key mapping request object  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are mapped.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdMapKeysPostCall(String applicationId, ApplicationKeyMappingRequestDTO applicationKeyMappingRequestDTO, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = applicationKeyMappingRequestDTO;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/map-keys"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdMapKeysPostValidateBeforeCall(String applicationId, ApplicationKeyMappingRequestDTO applicationKeyMappingRequestDTO, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdMapKeysPost(Async)");
        }
        
        // verify the required parameter 'applicationKeyMappingRequestDTO' is set
        if (applicationKeyMappingRequestDTO == null) {
            throw new ApiException("Missing the required parameter 'applicationKeyMappingRequestDTO' when calling applicationsApplicationIdMapKeysPost(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdMapKeysPostCall(applicationId, applicationKeyMappingRequestDTO, _callback);
        return localVarCall;

    }

    /**
     * Map Application Keys
     * Map keys (Consumer key/secret) to an application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param applicationKeyMappingRequestDTO Application key mapping request object  (required)
     * @return ApplicationKeyDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are mapped.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApplicationKeyDTO applicationsApplicationIdMapKeysPost(String applicationId, ApplicationKeyMappingRequestDTO applicationKeyMappingRequestDTO) throws ApiException {
        ApiResponse<ApplicationKeyDTO> localVarResp = applicationsApplicationIdMapKeysPostWithHttpInfo(applicationId, applicationKeyMappingRequestDTO);
        return localVarResp.getData();
    }

    /**
     * Map Application Keys
     * Map keys (Consumer key/secret) to an application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param applicationKeyMappingRequestDTO Application key mapping request object  (required)
     * @return ApiResponse&lt;ApplicationKeyDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are mapped.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ApplicationKeyDTO> applicationsApplicationIdMapKeysPostWithHttpInfo(String applicationId, ApplicationKeyMappingRequestDTO applicationKeyMappingRequestDTO) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdMapKeysPostValidateBeforeCall(applicationId, applicationKeyMappingRequestDTO, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Map Application Keys (asynchronously)
     * Map keys (Consumer key/secret) to an application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param applicationKeyMappingRequestDTO Application key mapping request object  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are mapped.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdMapKeysPostAsync(String applicationId, ApplicationKeyMappingRequestDTO applicationKeyMappingRequestDTO, final ApiCallback<ApplicationKeyDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdMapKeysPostValidateBeforeCall(applicationId, applicationKeyMappingRequestDTO, _callback);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for applicationsApplicationIdOauthKeysGet
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdOauthKeysGetCall(String applicationId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/oauth-keys"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdOauthKeysGetValidateBeforeCall(String applicationId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdOauthKeysGet(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysGetCall(applicationId, _callback);
        return localVarCall;

    }

    /**
     * Retrieve All Application Keys
     * Retrieve keys (Consumer key/secret) of application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @return ApplicationKeyListDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApplicationKeyListDTO applicationsApplicationIdOauthKeysGet(String applicationId) throws ApiException {
        ApiResponse<ApplicationKeyListDTO> localVarResp = applicationsApplicationIdOauthKeysGetWithHttpInfo(applicationId);
        return localVarResp.getData();
    }

    /**
     * Retrieve All Application Keys
     * Retrieve keys (Consumer key/secret) of application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @return ApiResponse&lt;ApplicationKeyListDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ApplicationKeyListDTO> applicationsApplicationIdOauthKeysGetWithHttpInfo(String applicationId) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysGetValidateBeforeCall(applicationId, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyListDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve All Application Keys (asynchronously)
     * Retrieve keys (Consumer key/secret) of application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdOauthKeysGetAsync(String applicationId, final ApiCallback<ApplicationKeyListDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysGetValidateBeforeCall(applicationId, _callback);
        Type localVarReturnType = new TypeToken<ApplicationKeyListDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPost
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Clean up is performed  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPostCall(String applicationId, String keyMappingId, String ifMatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/oauth-keys/{keyMappingId}/clean-up"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()))
            .replaceAll("\\{" + "keyMappingId" + "\\}", localVarApiClient.escapeString(keyMappingId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", localVarApiClient.parameterToString(ifMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPostValidateBeforeCall(String applicationId, String keyMappingId, String ifMatch, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPost(Async)");
        }
        
        // verify the required parameter 'keyMappingId' is set
        if (keyMappingId == null) {
            throw new ApiException("Missing the required parameter 'keyMappingId' when calling applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPost(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPostCall(applicationId, keyMappingId, ifMatch, _callback);
        return localVarCall;

    }

    /**
     * Clean-Up Application Keys
     * Clean up keys after failed key generation of an application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Clean up is performed  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public void applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPost(String applicationId, String keyMappingId, String ifMatch) throws ApiException {
        applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPostWithHttpInfo(applicationId, keyMappingId, ifMatch);
    }

    /**
     * Clean-Up Application Keys
     * Clean up keys after failed key generation of an application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Clean up is performed  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPostWithHttpInfo(String applicationId, String keyMappingId, String ifMatch) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPostValidateBeforeCall(applicationId, keyMappingId, ifMatch, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Clean-Up Application Keys (asynchronously)
     * Clean up keys after failed key generation of an application 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Clean up is performed  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPostAsync(String applicationId, String keyMappingId, String ifMatch, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdCleanUpPostValidateBeforeCall(applicationId, keyMappingId, ifMatch, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for applicationsApplicationIdOauthKeysKeyMappingIdGet
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param groupId Application Group Id  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys of given type are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdGetCall(String applicationId, String keyMappingId, String groupId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/oauth-keys/{keyMappingId}"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()))
            .replaceAll("\\{" + "keyMappingId" + "\\}", localVarApiClient.escapeString(keyMappingId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (groupId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("groupId", groupId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdGetValidateBeforeCall(String applicationId, String keyMappingId, String groupId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdOauthKeysKeyMappingIdGet(Async)");
        }
        
        // verify the required parameter 'keyMappingId' is set
        if (keyMappingId == null) {
            throw new ApiException("Missing the required parameter 'keyMappingId' when calling applicationsApplicationIdOauthKeysKeyMappingIdGet(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdGetCall(applicationId, keyMappingId, groupId, _callback);
        return localVarCall;

    }

    /**
     * Get Key Details of a Given Type 
     * This operation can be used to retrieve key details of an individual application specifying the key type in the URI. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param groupId Application Group Id  (optional)
     * @return ApplicationKeyDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys of given type are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApplicationKeyDTO applicationsApplicationIdOauthKeysKeyMappingIdGet(String applicationId, String keyMappingId, String groupId) throws ApiException {
        ApiResponse<ApplicationKeyDTO> localVarResp = applicationsApplicationIdOauthKeysKeyMappingIdGetWithHttpInfo(applicationId, keyMappingId, groupId);
        return localVarResp.getData();
    }

    /**
     * Get Key Details of a Given Type 
     * This operation can be used to retrieve key details of an individual application specifying the key type in the URI. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param groupId Application Group Id  (optional)
     * @return ApiResponse&lt;ApplicationKeyDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys of given type are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ApplicationKeyDTO> applicationsApplicationIdOauthKeysKeyMappingIdGetWithHttpInfo(String applicationId, String keyMappingId, String groupId) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdGetValidateBeforeCall(applicationId, keyMappingId, groupId, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Key Details of a Given Type  (asynchronously)
     * This operation can be used to retrieve key details of an individual application specifying the key type in the URI. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param groupId Application Group Id  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys of given type are returned.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdGetAsync(String applicationId, String keyMappingId, String groupId, final ApiCallback<ApplicationKeyDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdGetValidateBeforeCall(applicationId, keyMappingId, groupId, _callback);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for applicationsApplicationIdOauthKeysKeyMappingIdPut
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param applicationKeyDTO Grant types/Callback URL update request object  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Ok. Grant types or/and callback url is/are updated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdPutCall(String applicationId, String keyMappingId, ApplicationKeyDTO applicationKeyDTO, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = applicationKeyDTO;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/oauth-keys/{keyMappingId}"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()))
            .replaceAll("\\{" + "keyMappingId" + "\\}", localVarApiClient.escapeString(keyMappingId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdPutValidateBeforeCall(String applicationId, String keyMappingId, ApplicationKeyDTO applicationKeyDTO, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdOauthKeysKeyMappingIdPut(Async)");
        }
        
        // verify the required parameter 'keyMappingId' is set
        if (keyMappingId == null) {
            throw new ApiException("Missing the required parameter 'keyMappingId' when calling applicationsApplicationIdOauthKeysKeyMappingIdPut(Async)");
        }
        
        // verify the required parameter 'applicationKeyDTO' is set
        if (applicationKeyDTO == null) {
            throw new ApiException("Missing the required parameter 'applicationKeyDTO' when calling applicationsApplicationIdOauthKeysKeyMappingIdPut(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdPutCall(applicationId, keyMappingId, applicationKeyDTO, _callback);
        return localVarCall;

    }

    /**
     * Update Grant Types and Callback URL of an Application 
     * This operation can be used to update grant types and callback url of an application. (Consumer Key and Consumer Secret are ignored) Upon succesfull you will retrieve the updated key details as the response. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param applicationKeyDTO Grant types/Callback URL update request object  (required)
     * @return ApplicationKeyDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Ok. Grant types or/and callback url is/are updated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApplicationKeyDTO applicationsApplicationIdOauthKeysKeyMappingIdPut(String applicationId, String keyMappingId, ApplicationKeyDTO applicationKeyDTO) throws ApiException {
        ApiResponse<ApplicationKeyDTO> localVarResp = applicationsApplicationIdOauthKeysKeyMappingIdPutWithHttpInfo(applicationId, keyMappingId, applicationKeyDTO);
        return localVarResp.getData();
    }

    /**
     * Update Grant Types and Callback URL of an Application 
     * This operation can be used to update grant types and callback url of an application. (Consumer Key and Consumer Secret are ignored) Upon succesfull you will retrieve the updated key details as the response. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param applicationKeyDTO Grant types/Callback URL update request object  (required)
     * @return ApiResponse&lt;ApplicationKeyDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Ok. Grant types or/and callback url is/are updated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ApplicationKeyDTO> applicationsApplicationIdOauthKeysKeyMappingIdPutWithHttpInfo(String applicationId, String keyMappingId, ApplicationKeyDTO applicationKeyDTO) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdPutValidateBeforeCall(applicationId, keyMappingId, applicationKeyDTO, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update Grant Types and Callback URL of an Application  (asynchronously)
     * This operation can be used to update grant types and callback url of an application. (Consumer Key and Consumer Secret are ignored) Upon succesfull you will retrieve the updated key details as the response. 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param applicationKeyDTO Grant types/Callback URL update request object  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Ok. Grant types or/and callback url is/are updated.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdPutAsync(String applicationId, String keyMappingId, ApplicationKeyDTO applicationKeyDTO, final ApiCallback<ApplicationKeyDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdPutValidateBeforeCall(applicationId, keyMappingId, applicationKeyDTO, _callback);
        Type localVarReturnType = new TypeToken<ApplicationKeyDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPost
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are re generated.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional requests (Will be supported in future).‚  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPostCall(String applicationId, String keyMappingId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/applications/{applicationId}/oauth-keys/{keyMappingId}/regenerate-secret"
            .replaceAll("\\{" + "applicationId" + "\\}", localVarApiClient.escapeString(applicationId.toString()))
            .replaceAll("\\{" + "keyMappingId" + "\\}", localVarApiClient.escapeString(keyMappingId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPostValidateBeforeCall(String applicationId, String keyMappingId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPost(Async)");
        }
        
        // verify the required parameter 'keyMappingId' is set
        if (keyMappingId == null) {
            throw new ApiException("Missing the required parameter 'keyMappingId' when calling applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPost(Async)");
        }
        

        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPostCall(applicationId, keyMappingId, _callback);
        return localVarCall;

    }

    /**
     * Re-Generate Consumer Secret 
     * This operation can be used to re generate consumer secret for an application for the give key type 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @return ApplicationKeyReGenerateResponseDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are re generated.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional requests (Will be supported in future).‚  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApplicationKeyReGenerateResponseDTO applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPost(String applicationId, String keyMappingId) throws ApiException {
        ApiResponse<ApplicationKeyReGenerateResponseDTO> localVarResp = applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPostWithHttpInfo(applicationId, keyMappingId);
        return localVarResp.getData();
    }

    /**
     * Re-Generate Consumer Secret 
     * This operation can be used to re generate consumer secret for an application for the give key type 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @return ApiResponse&lt;ApplicationKeyReGenerateResponseDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are re generated.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional requests (Will be supported in future).‚  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ApplicationKeyReGenerateResponseDTO> applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPostWithHttpInfo(String applicationId, String keyMappingId) throws ApiException {
        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPostValidateBeforeCall(applicationId, keyMappingId, null);
        Type localVarReturnType = new TypeToken<ApplicationKeyReGenerateResponseDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Re-Generate Consumer Secret  (asynchronously)
     * This operation can be used to re generate consumer secret for an application for the give key type 
     * @param applicationId Application Identifier consisting of the UUID of the Application.  (required)
     * @param keyMappingId OAuth Key Identifier consisting of the UUID of the Oauth Key Mapping.  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Keys are re generated.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional requests (Will be supported in future).‚  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPostAsync(String applicationId, String keyMappingId, final ApiCallback<ApplicationKeyReGenerateResponseDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = applicationsApplicationIdOauthKeysKeyMappingIdRegenerateSecretPostValidateBeforeCall(applicationId, keyMappingId, _callback);
        Type localVarReturnType = new TypeToken<ApplicationKeyReGenerateResponseDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
