/*
 * WSO2 API Manager - Developer Portal
 * This document specifies a **RESTful API** for WSO2 **API Manager** - **Developer Portal**. Please see [full OpenAPI Specification](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.7.206/components/apimgt/org.wso2.carbon.apimgt.rest.api.store.v1/src/main/resources/devportal-api.yaml) of the API which is written using [OAS 3.0](http://swagger.io/) specification.  # Authentication Our REST APIs are protected using OAuth2 and access control is achieved through scopes. Before you start invoking the API, you need to obtain an access token with the required scopes. This guide will walk you through the steps that you will need to follow to obtain an access token. First you need to obtain the consumer key/secret key pair by calling the dynamic client registration (DCR) endpoint. You can add your preferred grant types in the payload. A Sample payload is shown below. ```   {   \"callbackUrl\":\"www.google.lk\",   \"clientName\":\"rest_api_devportal\",   \"owner\":\"admin\",   \"grantType\":\"client_credentials password refresh_token\",   \"saasApp\":true   } ``` Create a file (payload.json) with the above sample payload, and use the cURL shown below to invoke the DCR endpoint. Authorization header of this should contain the base64 encoded admin username and password. **Format of the request** ```   curl -X POST -H \"Authorization: Basic Base64(admin_username:admin_password)\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://<host>:<servlet_port>/client-registration/v0.17/register ``` **Sample request** ```   curl -X POST -H \"Authorization: Basic YWRtaW46YWRtaW4=\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://localhost:9443/client-registration/v0.17/register ``` Following is a sample response after invoking the above curl. ``` { \"clientId\": \"fOCi4vNJ59PpHucC2CAYfYuADdMa\", \"clientName\": \"rest_api_devportal\", \"callBackURL\": \"www.google.lk\", \"clientSecret\": \"a4FwHlq0iCIKVs2MPIIDnepZnYMa\", \"isSaasApplication\": true, \"appOwner\": \"admin\", \"jsonString\": \"{\\\"grant_types\\\":\\\"client_credentials password refresh_token\\\",\\\"redirect_uris\\\":\\\"www.google.lk\\\",\\\"client_name\\\":\\\"rest_api_devportal\\\"}\", \"jsonAppAttribute\": \"{}\", \"tokenType\": null } ``` Next you must use the above client id and secret to obtain the access token. We will be using the password grant type for this, you can use any grant type you desire. You also need to add the proper **scope** when getting the access token. All possible scopes for devportal REST API can be viewed in **OAuth2 Security** section of this document and scope for each resource is given in **authorization** section of resource documentation. Following is the format of the request if you are using the password grant type. ``` curl -k -d \"grant_type=password&username=<admin_username>&password=<admin_password>&scope=<scopes separated by space>\" \\ -H \"Authorization: Basic base64(cliet_id:client_secret)\" \\ https://<host>:<gateway_port>/token ``` **Sample request** ``` curl https://localhost:8243/token -k \\ -H \"Authorization: Basic Zk9DaTR2Tko1OVBwSHVjQzJDQVlmWXVBRGRNYTphNEZ3SGxxMGlDSUtWczJNUElJRG5lcFpuWU1h\" \\ -d \"grant_type=password&username=admin&password=admin&scope=apim:subscribe apim:api_key\" ``` Shown below is a sample response to the above request. ``` { \"access_token\": \"e79bda48-3406-3178-acce-f6e4dbdcbb12\", \"refresh_token\": \"a757795d-e69f-38b8-bd85-9aded677a97c\", \"scope\": \"apim:subscribe apim:api_key\", \"token_type\": \"Bearer\", \"expires_in\": 3600 } ``` Now you have a valid access token, which you can use to invoke an API. Navigate through the API descriptions to find the required API, obtain an access token as described above and invoke the API with the authentication header. If you use a different authentication mechanism, this process may change.  # Try out in Postman If you want to try-out the embedded postman collection with \"Run in Postman\" option, please follow the guidelines listed below. * All of the OAuth2 secured endpoints have been configured with an Authorization Bearer header with a parameterized access token. Before invoking any REST API resource make sure you run the `Register DCR Application` and `Generate Access Token` requests to fetch an access token with all required scopes. * Make sure you have an API Manager instance up and running. * Update the `basepath` parameter to match the hostname and port of the APIM instance.  [![Run in Postman](https://run.pstmn.io/button.svg)](https://app.getpostman.com/run-collection/5bc0161b8aa7e701d7bf) 
 *
 * The version of the OpenAPI document: v2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.store.api.v1.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonCreator;
/**
* DocumentDTO
*/

public class DocumentDTO {
        public static final String SERIALIZED_NAME_DOCUMENT_ID = "documentId";
        @SerializedName(SERIALIZED_NAME_DOCUMENT_ID)
            private String documentId;

        public static final String SERIALIZED_NAME_NAME = "name";
        @SerializedName(SERIALIZED_NAME_NAME)
            private String name;

            /**
* Gets or Sets type
*/
    @JsonAdapter(TypeEnum.Adapter.class)
public enum TypeEnum {
        HOWTO("HOWTO"),
        
        SAMPLES("SAMPLES"),
        
        PUBLIC_FORUM("PUBLIC_FORUM"),
        
        SUPPORT_FORUM("SUPPORT_FORUM"),
        
        API_MESSAGE_FORMAT("API_MESSAGE_FORMAT"),
        
        SWAGGER_DOC("SWAGGER_DOC"),
        
        OTHER("OTHER");

private String value;

TypeEnum(String value) {
this.value = value;
}

public String getValue() {
return value;
}

@Override
public String toString() {
return String.valueOf(value);
}

public static TypeEnum fromValue(String value) {
    for (TypeEnum b : TypeEnum.values()) {
    if (b.name().equals(value)) {
        return b;
    }
}
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
}

    public static class Adapter extends TypeAdapter<TypeEnum> {
    @Override
    public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
    jsonWriter.value(enumeration.getValue());
    }

    @Override
    public TypeEnum read(final JsonReader jsonReader) throws IOException {
    String value =  jsonReader.nextString();
    return TypeEnum.fromValue(value);
    }
    }
}

        public static final String SERIALIZED_NAME_TYPE = "type";
        @SerializedName(SERIALIZED_NAME_TYPE)
            private TypeEnum type;

        public static final String SERIALIZED_NAME_SUMMARY = "summary";
        @SerializedName(SERIALIZED_NAME_SUMMARY)
            private String summary;

            /**
* Gets or Sets sourceType
*/
    @JsonAdapter(SourceTypeEnum.Adapter.class)
public enum SourceTypeEnum {
        INLINE("INLINE"),
        
        MARKDOWN("MARKDOWN"),
        
        URL("URL"),
        
        FILE("FILE");

private String value;

SourceTypeEnum(String value) {
this.value = value;
}

public String getValue() {
return value;
}

@Override
public String toString() {
return String.valueOf(value);
}

public static SourceTypeEnum fromValue(String value) {
    for (SourceTypeEnum b : SourceTypeEnum.values()) {
    if (b.name().equals(value)) {
        return b;
    }
}
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
}

    public static class Adapter extends TypeAdapter<SourceTypeEnum> {
    @Override
    public void write(final JsonWriter jsonWriter, final SourceTypeEnum enumeration) throws IOException {
    jsonWriter.value(enumeration.getValue());
    }

    @Override
    public SourceTypeEnum read(final JsonReader jsonReader) throws IOException {
    String value =  jsonReader.nextString();
    return SourceTypeEnum.fromValue(value);
    }
    }
}

        public static final String SERIALIZED_NAME_SOURCE_TYPE = "sourceType";
        @SerializedName(SERIALIZED_NAME_SOURCE_TYPE)
            private SourceTypeEnum sourceType;

        public static final String SERIALIZED_NAME_SOURCE_URL = "sourceUrl";
        @SerializedName(SERIALIZED_NAME_SOURCE_URL)
            private String sourceUrl;

        public static final String SERIALIZED_NAME_OTHER_TYPE_NAME = "otherTypeName";
        @SerializedName(SERIALIZED_NAME_OTHER_TYPE_NAME)
            private String otherTypeName;


        public DocumentDTO documentId(String documentId) {
        
        this.documentId = documentId;
        return this;
        }

    /**
        * Get documentId
    * @return documentId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "01234567-0123-0123-0123-012345678901", value = "")
    
    public String getDocumentId() {
        return documentId;
    }


    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }


        public DocumentDTO name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Get name
    * @return name
    **/
      @ApiModelProperty(example = "CalculatorDoc", required = true, value = "")
    
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }


        public DocumentDTO type(TypeEnum type) {
        
        this.type = type;
        return this;
        }

    /**
        * Get type
    * @return type
    **/
      @ApiModelProperty(example = "HOWTO", required = true, value = "")
    
    public TypeEnum getType() {
        return type;
    }


    public void setType(TypeEnum type) {
        this.type = type;
    }


        public DocumentDTO summary(String summary) {
        
        this.summary = summary;
        return this;
        }

    /**
        * Get summary
    * @return summary
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "Summary of Calculator Documentation", value = "")
    
    public String getSummary() {
        return summary;
    }


    public void setSummary(String summary) {
        this.summary = summary;
    }


        public DocumentDTO sourceType(SourceTypeEnum sourceType) {
        
        this.sourceType = sourceType;
        return this;
        }

    /**
        * Get sourceType
    * @return sourceType
    **/
      @ApiModelProperty(example = "INLINE", required = true, value = "")
    
    public SourceTypeEnum getSourceType() {
        return sourceType;
    }


    public void setSourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }


        public DocumentDTO sourceUrl(String sourceUrl) {
        
        this.sourceUrl = sourceUrl;
        return this;
        }

    /**
        * Get sourceUrl
    * @return sourceUrl
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
    
    public String getSourceUrl() {
        return sourceUrl;
    }


    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }


        public DocumentDTO otherTypeName(String otherTypeName) {
        
        this.otherTypeName = otherTypeName;
        return this;
        }

    /**
        * Get otherTypeName
    * @return otherTypeName
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
    
    public String getOtherTypeName() {
        return otherTypeName;
    }


    public void setOtherTypeName(String otherTypeName) {
        this.otherTypeName = otherTypeName;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
        return true;
        }
        if (o == null || getClass() != o.getClass()) {
        return false;
        }
            DocumentDTO document = (DocumentDTO) o;
            return Objects.equals(this.documentId, document.documentId) &&
            Objects.equals(this.name, document.name) &&
            Objects.equals(this.type, document.type) &&
            Objects.equals(this.summary, document.summary) &&
            Objects.equals(this.sourceType, document.sourceType) &&
            Objects.equals(this.sourceUrl, document.sourceUrl) &&
            Objects.equals(this.otherTypeName, document.otherTypeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(documentId, name, type, summary, sourceType, sourceUrl, otherTypeName);
    }


@Override
public String toString() {
StringBuilder sb = new StringBuilder();
sb.append("class DocumentDTO {\n");
    sb.append("    documentId: ").append(toIndentedString(documentId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("    sourceType: ").append(toIndentedString(sourceType)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    otherTypeName: ").append(toIndentedString(otherTypeName)).append("\n");
sb.append("}");
return sb.toString();
}

/**
* Convert the given object to string with each line indented by 4 spaces
* (except the first line).
*/
private String toIndentedString(Object o) {
if (o == null) {
return "null";
}
return o.toString().replace("\n", "\n    ");
}

}

