/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;

public class SubscriptionsApi {
    private ApiClient localVarApiClient;

    public SubscriptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call subscriptionsGetCall(String apiId, String applicationId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("apiId", apiId));
        }
        if (applicationId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("applicationId", applicationId));
        }
        if (groupId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("groupId", groupId));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call subscriptionsGetValidateBeforeCall(String apiId, String applicationId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.subscriptionsGetCall(apiId, applicationId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch, _callback);
        return localVarCall;
    }

    public SubscriptionListDTO subscriptionsGet(String apiId, String applicationId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch) throws ApiException {
        ApiResponse<SubscriptionListDTO> localVarResp = this.subscriptionsGetWithHttpInfo(apiId, applicationId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<SubscriptionListDTO> subscriptionsGetWithHttpInfo(String apiId, String applicationId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.subscriptionsGetValidateBeforeCall(apiId, applicationId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<SubscriptionListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call subscriptionsGetAsync(String apiId, String applicationId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch, ApiCallback<SubscriptionListDTO> _callback) throws ApiException {
        Call localVarCall = this.subscriptionsGetValidateBeforeCall(apiId, applicationId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call subscriptionsMultiplePostCall(List<SubscriptionDTO> subscriptionDTO, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        List<SubscriptionDTO> localVarPostBody = subscriptionDTO;
        String localVarPath = "/subscriptions/multiple";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call subscriptionsMultiplePostValidateBeforeCall(List<SubscriptionDTO> subscriptionDTO, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        if (subscriptionDTO == null) {
            throw new ApiException("Missing the required parameter 'subscriptionDTO' when calling subscriptionsMultiplePost(Async)");
        }
        Call localVarCall = this.subscriptionsMultiplePostCall(subscriptionDTO, xWSO2Tenant, _callback);
        return localVarCall;
    }

    public List<SubscriptionDTO> subscriptionsMultiplePost(List<SubscriptionDTO> subscriptionDTO, String xWSO2Tenant) throws ApiException {
        ApiResponse<List<SubscriptionDTO>> localVarResp = this.subscriptionsMultiplePostWithHttpInfo(subscriptionDTO, xWSO2Tenant);
        return localVarResp.getData();
    }

    public ApiResponse<List<SubscriptionDTO>> subscriptionsMultiplePostWithHttpInfo(List<SubscriptionDTO> subscriptionDTO, String xWSO2Tenant) throws ApiException {
        Call localVarCall = this.subscriptionsMultiplePostValidateBeforeCall(subscriptionDTO, xWSO2Tenant, null);
        Type localVarReturnType = new TypeToken<List<SubscriptionDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call subscriptionsMultiplePostAsync(List<SubscriptionDTO> subscriptionDTO, String xWSO2Tenant, ApiCallback<List<SubscriptionDTO>> _callback) throws ApiException {
        Call localVarCall = this.subscriptionsMultiplePostValidateBeforeCall(subscriptionDTO, xWSO2Tenant, _callback);
        Type localVarReturnType = new TypeToken<List<SubscriptionDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call subscriptionsPostCall(SubscriptionDTO subscriptionDTO, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        SubscriptionDTO localVarPostBody = subscriptionDTO;
        String localVarPath = "/subscriptions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call subscriptionsPostValidateBeforeCall(SubscriptionDTO subscriptionDTO, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        if (subscriptionDTO == null) {
            throw new ApiException("Missing the required parameter 'subscriptionDTO' when calling subscriptionsPost(Async)");
        }
        Call localVarCall = this.subscriptionsPostCall(subscriptionDTO, xWSO2Tenant, _callback);
        return localVarCall;
    }

    public SubscriptionDTO subscriptionsPost(SubscriptionDTO subscriptionDTO, String xWSO2Tenant) throws ApiException {
        ApiResponse<SubscriptionDTO> localVarResp = this.subscriptionsPostWithHttpInfo(subscriptionDTO, xWSO2Tenant);
        return localVarResp.getData();
    }

    public ApiResponse<SubscriptionDTO> subscriptionsPostWithHttpInfo(SubscriptionDTO subscriptionDTO, String xWSO2Tenant) throws ApiException {
        Call localVarCall = this.subscriptionsPostValidateBeforeCall(subscriptionDTO, xWSO2Tenant, null);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call subscriptionsPostAsync(SubscriptionDTO subscriptionDTO, String xWSO2Tenant, ApiCallback<SubscriptionDTO> _callback) throws ApiException {
        Call localVarCall = this.subscriptionsPostValidateBeforeCall(subscriptionDTO, xWSO2Tenant, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call subscriptionsSubscriptionIdDeleteCall(String subscriptionId, String ifMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions/{subscriptionId}".replaceAll("\\{subscriptionId\\}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call subscriptionsSubscriptionIdDeleteValidateBeforeCall(String subscriptionId, String ifMatch, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling subscriptionsSubscriptionIdDelete(Async)");
        }
        Call localVarCall = this.subscriptionsSubscriptionIdDeleteCall(subscriptionId, ifMatch, _callback);
        return localVarCall;
    }

    public void subscriptionsSubscriptionIdDelete(String subscriptionId, String ifMatch) throws ApiException {
        this.subscriptionsSubscriptionIdDeleteWithHttpInfo(subscriptionId, ifMatch);
    }

    public ApiResponse<Void> subscriptionsSubscriptionIdDeleteWithHttpInfo(String subscriptionId, String ifMatch) throws ApiException {
        Call localVarCall = this.subscriptionsSubscriptionIdDeleteValidateBeforeCall(subscriptionId, ifMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call subscriptionsSubscriptionIdDeleteAsync(String subscriptionId, String ifMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.subscriptionsSubscriptionIdDeleteValidateBeforeCall(subscriptionId, ifMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call subscriptionsSubscriptionIdGetCall(String subscriptionId, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions/{subscriptionId}".replaceAll("\\{subscriptionId\\}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call subscriptionsSubscriptionIdGetValidateBeforeCall(String subscriptionId, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling subscriptionsSubscriptionIdGet(Async)");
        }
        Call localVarCall = this.subscriptionsSubscriptionIdGetCall(subscriptionId, ifNoneMatch, _callback);
        return localVarCall;
    }

    public SubscriptionDTO subscriptionsSubscriptionIdGet(String subscriptionId, String ifNoneMatch) throws ApiException {
        ApiResponse<SubscriptionDTO> localVarResp = this.subscriptionsSubscriptionIdGetWithHttpInfo(subscriptionId, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<SubscriptionDTO> subscriptionsSubscriptionIdGetWithHttpInfo(String subscriptionId, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.subscriptionsSubscriptionIdGetValidateBeforeCall(subscriptionId, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call subscriptionsSubscriptionIdGetAsync(String subscriptionId, String ifNoneMatch, ApiCallback<SubscriptionDTO> _callback) throws ApiException {
        Call localVarCall = this.subscriptionsSubscriptionIdGetValidateBeforeCall(subscriptionId, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call subscriptionsSubscriptionIdPutCall(String subscriptionId, SubscriptionDTO subscriptionDTO, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        SubscriptionDTO localVarPostBody = subscriptionDTO;
        String localVarPath = "/subscriptions/{subscriptionId}".replaceAll("\\{subscriptionId\\}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call subscriptionsSubscriptionIdPutValidateBeforeCall(String subscriptionId, SubscriptionDTO subscriptionDTO, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling subscriptionsSubscriptionIdPut(Async)");
        }
        if (subscriptionDTO == null) {
            throw new ApiException("Missing the required parameter 'subscriptionDTO' when calling subscriptionsSubscriptionIdPut(Async)");
        }
        Call localVarCall = this.subscriptionsSubscriptionIdPutCall(subscriptionId, subscriptionDTO, xWSO2Tenant, _callback);
        return localVarCall;
    }

    public SubscriptionDTO subscriptionsSubscriptionIdPut(String subscriptionId, SubscriptionDTO subscriptionDTO, String xWSO2Tenant) throws ApiException {
        ApiResponse<SubscriptionDTO> localVarResp = this.subscriptionsSubscriptionIdPutWithHttpInfo(subscriptionId, subscriptionDTO, xWSO2Tenant);
        return localVarResp.getData();
    }

    public ApiResponse<SubscriptionDTO> subscriptionsSubscriptionIdPutWithHttpInfo(String subscriptionId, SubscriptionDTO subscriptionDTO, String xWSO2Tenant) throws ApiException {
        Call localVarCall = this.subscriptionsSubscriptionIdPutValidateBeforeCall(subscriptionId, subscriptionDTO, xWSO2Tenant, null);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call subscriptionsSubscriptionIdPutAsync(String subscriptionId, SubscriptionDTO subscriptionDTO, String xWSO2Tenant, ApiCallback<SubscriptionDTO> _callback) throws ApiException {
        Call localVarCall = this.subscriptionsSubscriptionIdPutValidateBeforeCall(subscriptionId, subscriptionDTO, xWSO2Tenant, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

