/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ApplicationKeyGenerateRequestDTO {
    public static final String SERIALIZED_NAME_KEY_TYPE = "keyType";
    @SerializedName(value="keyType")
    private KeyTypeEnum keyType;
    public static final String SERIALIZED_NAME_KEY_MANAGER = "keyManager";
    @SerializedName(value="keyManager")
    private String keyManager;
    public static final String SERIALIZED_NAME_GRANT_TYPES_TO_BE_SUPPORTED = "grantTypesToBeSupported";
    @SerializedName(value="grantTypesToBeSupported")
    private List<String> grantTypesToBeSupported = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CALLBACK_URL = "callbackUrl";
    @SerializedName(value="callbackUrl")
    private String callbackUrl;
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    private List<String> scopes = null;
    public static final String SERIALIZED_NAME_VALIDITY_TIME = "validityTime";
    @SerializedName(value="validityTime")
    private String validityTime;
    public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
    @SerializedName(value="clientId")
    private String clientId;
    public static final String SERIALIZED_NAME_CLIENT_SECRET = "clientSecret";
    @SerializedName(value="clientSecret")
    private String clientSecret;
    public static final String SERIALIZED_NAME_ADDITIONAL_PROPERTIES = "additionalProperties";
    @SerializedName(value="additionalProperties")
    private Object additionalProperties;

    public ApplicationKeyGenerateRequestDTO keyType(KeyTypeEnum keyType) {
        this.keyType = keyType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public KeyTypeEnum getKeyType() {
        return this.keyType;
    }

    public void setKeyType(KeyTypeEnum keyType) {
        this.keyType = keyType;
    }

    public ApplicationKeyGenerateRequestDTO keyManager(String keyManager) {
        this.keyManager = keyManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Resident Key Manager", value="key Manager to Generate Keys")
    public String getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(String keyManager) {
        this.keyManager = keyManager;
    }

    public ApplicationKeyGenerateRequestDTO grantTypesToBeSupported(List<String> grantTypesToBeSupported) {
        this.grantTypesToBeSupported = grantTypesToBeSupported;
        return this;
    }

    @ApiModelProperty(example="[\"password\",\"client_credentials\"]", required=true, value="Grant types that should be supported by the application")
    public List<String> getGrantTypesToBeSupported() {
        return this.grantTypesToBeSupported;
    }

    public void setGrantTypesToBeSupported(List<String> grantTypesToBeSupported) {
        this.grantTypesToBeSupported = grantTypesToBeSupported;
    }

    public ApplicationKeyGenerateRequestDTO callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="http://sample.com/callback/url", value="Callback URL")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public ApplicationKeyGenerateRequestDTO scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"am_application_scope\",\"default\"]", value="Allowed scopes for the access token")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public ApplicationKeyGenerateRequestDTO validityTime(String validityTime) {
        this.validityTime = validityTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3600", value="")
    public String getValidityTime() {
        return this.validityTime;
    }

    public void setValidityTime(String validityTime) {
        this.validityTime = validityTime;
    }

    public ApplicationKeyGenerateRequestDTO clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="sZzoeSCI_vL2cjSXZQmsmV8JEyga", value="Client ID for generating access token.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ApplicationKeyGenerateRequestDTO clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="nrs3YAP4htxnz_DqpvGhf9Um04oa", value="Client secret for generating access token. This is given together with the client Id.")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public ApplicationKeyGenerateRequestDTO additionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{}", value="Additional properties needed.")
    public Object getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationKeyGenerateRequestDTO applicationKeyGenerateRequest = (ApplicationKeyGenerateRequestDTO)o;
        return Objects.equals((Object)this.keyType, (Object)applicationKeyGenerateRequest.keyType) && Objects.equals(this.keyManager, applicationKeyGenerateRequest.keyManager) && Objects.equals(this.grantTypesToBeSupported, applicationKeyGenerateRequest.grantTypesToBeSupported) && Objects.equals(this.callbackUrl, applicationKeyGenerateRequest.callbackUrl) && Objects.equals(this.scopes, applicationKeyGenerateRequest.scopes) && Objects.equals(this.validityTime, applicationKeyGenerateRequest.validityTime) && Objects.equals(this.clientId, applicationKeyGenerateRequest.clientId) && Objects.equals(this.clientSecret, applicationKeyGenerateRequest.clientSecret) && Objects.equals(this.additionalProperties, applicationKeyGenerateRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyType, this.keyManager, this.grantTypesToBeSupported, this.callbackUrl, this.scopes, this.validityTime, this.clientId, this.clientSecret, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationKeyGenerateRequestDTO {\n");
        sb.append("    keyType: ").append(this.toIndentedString((Object)this.keyType)).append("\n");
        sb.append("    keyManager: ").append(this.toIndentedString(this.keyManager)).append("\n");
        sb.append("    grantTypesToBeSupported: ").append(this.toIndentedString(this.grantTypesToBeSupported)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    validityTime: ").append(this.toIndentedString(this.validityTime)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KeyTypeEnum {
        PRODUCTION("PRODUCTION"),
        SANDBOX("SANDBOX");

        private String value;

        private KeyTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KeyTypeEnum fromValue(String value) {
            for (KeyTypeEnum b : KeyTypeEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<KeyTypeEnum> {
            public void write(JsonWriter jsonWriter, KeyTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KeyTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KeyTypeEnum.fromValue(value);
            }
        }
    }
}

