/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.DocumentListDTO;

public class ApiDocumentsApi {
    private ApiClient localVarApiClient;

    public ApiDocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiDocumentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call apisApiIdDocumentsDocumentIdContentGetCall(String apiId, String documentId, String xWSO2Tenant, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents/{documentId}/content".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call apisApiIdDocumentsDocumentIdContentGetValidateBeforeCall(String apiId, String documentId, String xWSO2Tenant, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdDocumentsDocumentIdContentGet(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apisApiIdDocumentsDocumentIdContentGet(Async)");
        }
        Call localVarCall = this.apisApiIdDocumentsDocumentIdContentGetCall(apiId, documentId, xWSO2Tenant, ifNoneMatch, _callback);
        return localVarCall;
    }

    public void apisApiIdDocumentsDocumentIdContentGet(String apiId, String documentId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        this.apisApiIdDocumentsDocumentIdContentGetWithHttpInfo(apiId, documentId, xWSO2Tenant, ifNoneMatch);
    }

    public ApiResponse<Void> apisApiIdDocumentsDocumentIdContentGetWithHttpInfo(String apiId, String documentId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.apisApiIdDocumentsDocumentIdContentGetValidateBeforeCall(apiId, documentId, xWSO2Tenant, ifNoneMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call apisApiIdDocumentsDocumentIdContentGetAsync(String apiId, String documentId, String xWSO2Tenant, String ifNoneMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.apisApiIdDocumentsDocumentIdContentGetValidateBeforeCall(apiId, documentId, xWSO2Tenant, ifNoneMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call apisApiIdDocumentsDocumentIdGetCall(String apiId, String documentId, String xWSO2Tenant, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents/{documentId}".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.localVarApiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call apisApiIdDocumentsDocumentIdGetValidateBeforeCall(String apiId, String documentId, String xWSO2Tenant, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdDocumentsDocumentIdGet(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apisApiIdDocumentsDocumentIdGet(Async)");
        }
        Call localVarCall = this.apisApiIdDocumentsDocumentIdGetCall(apiId, documentId, xWSO2Tenant, ifNoneMatch, _callback);
        return localVarCall;
    }

    public DocumentDTO apisApiIdDocumentsDocumentIdGet(String apiId, String documentId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        ApiResponse<DocumentDTO> localVarResp = this.apisApiIdDocumentsDocumentIdGetWithHttpInfo(apiId, documentId, xWSO2Tenant, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentDTO> apisApiIdDocumentsDocumentIdGetWithHttpInfo(String apiId, String documentId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.apisApiIdDocumentsDocumentIdGetValidateBeforeCall(apiId, documentId, xWSO2Tenant, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call apisApiIdDocumentsDocumentIdGetAsync(String apiId, String documentId, String xWSO2Tenant, String ifNoneMatch, ApiCallback<DocumentDTO> _callback) throws ApiException {
        Call localVarCall = this.apisApiIdDocumentsDocumentIdGetValidateBeforeCall(apiId, documentId, xWSO2Tenant, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<DocumentDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call apisApiIdDocumentsGetCall(String apiId, Integer limit, Integer offset, String xWSO2Tenant, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call apisApiIdDocumentsGetValidateBeforeCall(String apiId, Integer limit, Integer offset, String xWSO2Tenant, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdDocumentsGet(Async)");
        }
        Call localVarCall = this.apisApiIdDocumentsGetCall(apiId, limit, offset, xWSO2Tenant, ifNoneMatch, _callback);
        return localVarCall;
    }

    public DocumentListDTO apisApiIdDocumentsGet(String apiId, Integer limit, Integer offset, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        ApiResponse<DocumentListDTO> localVarResp = this.apisApiIdDocumentsGetWithHttpInfo(apiId, limit, offset, xWSO2Tenant, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DocumentListDTO> apisApiIdDocumentsGetWithHttpInfo(String apiId, Integer limit, Integer offset, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.apisApiIdDocumentsGetValidateBeforeCall(apiId, limit, offset, xWSO2Tenant, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<DocumentListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call apisApiIdDocumentsGetAsync(String apiId, Integer limit, Integer offset, String xWSO2Tenant, String ifNoneMatch, ApiCallback<DocumentListDTO> _callback) throws ApiException {
        Call localVarCall = this.apisApiIdDocumentsGetValidateBeforeCall(apiId, limit, offset, xWSO2Tenant, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<DocumentListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

