/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationTokenDTO;

public class ApplicationKeyDTO {
    public static final String SERIALIZED_NAME_KEY_MAPPING_ID = "keyMappingId";
    @SerializedName(value="keyMappingId")
    private String keyMappingId;
    public static final String SERIALIZED_NAME_KEY_MANAGER = "keyManager";
    @SerializedName(value="keyManager")
    private String keyManager;
    public static final String SERIALIZED_NAME_CONSUMER_KEY = "consumerKey";
    @SerializedName(value="consumerKey")
    private String consumerKey;
    public static final String SERIALIZED_NAME_CONSUMER_SECRET = "consumerSecret";
    @SerializedName(value="consumerSecret")
    private String consumerSecret;
    public static final String SERIALIZED_NAME_SUPPORTED_GRANT_TYPES = "supportedGrantTypes";
    @SerializedName(value="supportedGrantTypes")
    private List<String> supportedGrantTypes = null;
    public static final String SERIALIZED_NAME_CALLBACK_URL = "callbackUrl";
    @SerializedName(value="callbackUrl")
    private String callbackUrl;
    public static final String SERIALIZED_NAME_KEY_STATE = "keyState";
    @SerializedName(value="keyState")
    private String keyState;
    public static final String SERIALIZED_NAME_KEY_TYPE = "keyType";
    @SerializedName(value="keyType")
    private KeyTypeEnum keyType;
    public static final String SERIALIZED_NAME_MODE = "mode";
    @SerializedName(value="mode")
    private ModeEnum mode;
    public static final String SERIALIZED_NAME_GROUP_ID = "groupId";
    @SerializedName(value="groupId")
    private String groupId;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private ApplicationTokenDTO token;
    public static final String SERIALIZED_NAME_ADDITIONAL_PROPERTIES = "additionalProperties";
    @SerializedName(value="additionalProperties")
    private Object additionalProperties;

    public ApplicationKeyDTO keyMappingId(String keyMappingId) {
        this.keyMappingId = keyMappingId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="92ab520c-8847-427a-a921-3ed19b15aad7", value="Key Manager Mapping UUID")
    public String getKeyMappingId() {
        return this.keyMappingId;
    }

    public void setKeyMappingId(String keyMappingId) {
        this.keyMappingId = keyMappingId;
    }

    public ApplicationKeyDTO keyManager(String keyManager) {
        this.keyManager = keyManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Resident Key Manager", value="Key Manager Name")
    public String getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(String keyManager) {
        this.keyManager = keyManager;
    }

    public ApplicationKeyDTO consumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="vYDoc9s7IgAFdkSyNDaswBX7ejoa", value="Consumer key of the application")
    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public ApplicationKeyDTO consumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="TIDlOFkpzB7WjufO3OJUhy1fsvAa", value="Consumer secret of the application")
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public ApplicationKeyDTO supportedGrantTypes(List<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"client_credentials\",\"password\"]", value="The grant types that are supported by the application")
    public List<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public void setSupportedGrantTypes(List<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
    }

    public ApplicationKeyDTO callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="http://sample.com/callback/url", value="Callback URL")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public ApplicationKeyDTO keyState(String keyState) {
        this.keyState = keyState;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="APPROVED", value="Describes the state of the key generation.")
    public String getKeyState() {
        return this.keyState;
    }

    public void setKeyState(String keyState) {
        this.keyState = keyState;
    }

    public ApplicationKeyDTO keyType(KeyTypeEnum keyType) {
        this.keyType = keyType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PRODUCTION", value="Describes to which endpoint the key belongs")
    public KeyTypeEnum getKeyType() {
        return this.keyType;
    }

    public void setKeyType(KeyTypeEnum keyType) {
        this.keyType = keyType;
    }

    public ApplicationKeyDTO mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CREATED", value="Describe the which mode Application Mapped.")
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public ApplicationKeyDTO groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="Application group id (if any).")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public ApplicationKeyDTO token(ApplicationTokenDTO token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ApplicationTokenDTO getToken() {
        return this.token;
    }

    public void setToken(ApplicationTokenDTO token) {
        this.token = token;
    }

    public ApplicationKeyDTO additionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="additionalProperties (if any).")
    public Object getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationKeyDTO applicationKey = (ApplicationKeyDTO)o;
        return Objects.equals(this.keyMappingId, applicationKey.keyMappingId) && Objects.equals(this.keyManager, applicationKey.keyManager) && Objects.equals(this.consumerKey, applicationKey.consumerKey) && Objects.equals(this.consumerSecret, applicationKey.consumerSecret) && Objects.equals(this.supportedGrantTypes, applicationKey.supportedGrantTypes) && Objects.equals(this.callbackUrl, applicationKey.callbackUrl) && Objects.equals(this.keyState, applicationKey.keyState) && Objects.equals((Object)this.keyType, (Object)applicationKey.keyType) && Objects.equals((Object)this.mode, (Object)applicationKey.mode) && Objects.equals(this.groupId, applicationKey.groupId) && Objects.equals(this.token, applicationKey.token) && Objects.equals(this.additionalProperties, applicationKey.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyMappingId, this.keyManager, this.consumerKey, this.consumerSecret, this.supportedGrantTypes, this.callbackUrl, this.keyState, this.keyType, this.mode, this.groupId, this.token, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationKeyDTO {\n");
        sb.append("    keyMappingId: ").append(this.toIndentedString(this.keyMappingId)).append("\n");
        sb.append("    keyManager: ").append(this.toIndentedString(this.keyManager)).append("\n");
        sb.append("    consumerKey: ").append(this.toIndentedString(this.consumerKey)).append("\n");
        sb.append("    consumerSecret: ").append(this.toIndentedString(this.consumerSecret)).append("\n");
        sb.append("    supportedGrantTypes: ").append(this.toIndentedString(this.supportedGrantTypes)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    keyState: ").append(this.toIndentedString(this.keyState)).append("\n");
        sb.append("    keyType: ").append(this.toIndentedString((Object)this.keyType)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ModeEnum {
        MAPPED("MAPPED"),
        CREATED("CREATED");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ModeEnum> {
            public void write(JsonWriter jsonWriter, ModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ModeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KeyTypeEnum {
        PRODUCTION("PRODUCTION"),
        SANDBOX("SANDBOX");

        private String value;

        private KeyTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KeyTypeEnum fromValue(String value) {
            for (KeyTypeEnum b : KeyTypeEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<KeyTypeEnum> {
            public void write(JsonWriter jsonWriter, KeyTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KeyTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KeyTypeEnum.fromValue(value);
            }
        }
    }
}

