/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.v1.dto.RatingDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.RatingListDTO;

public class RatingsApi {
    private ApiClient localVarApiClient;

    public RatingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RatingsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call apisApiIdRatingsGetCall(String apiId, Integer limit, Integer offset, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/ratings".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call apisApiIdRatingsGetValidateBeforeCall(String apiId, Integer limit, Integer offset, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdRatingsGet(Async)");
        }
        Call localVarCall = this.apisApiIdRatingsGetCall(apiId, limit, offset, xWSO2Tenant, _callback);
        return localVarCall;
    }

    public RatingListDTO apisApiIdRatingsGet(String apiId, Integer limit, Integer offset, String xWSO2Tenant) throws ApiException {
        ApiResponse<RatingListDTO> localVarResp = this.apisApiIdRatingsGetWithHttpInfo(apiId, limit, offset, xWSO2Tenant);
        return localVarResp.getData();
    }

    public ApiResponse<RatingListDTO> apisApiIdRatingsGetWithHttpInfo(String apiId, Integer limit, Integer offset, String xWSO2Tenant) throws ApiException {
        Call localVarCall = this.apisApiIdRatingsGetValidateBeforeCall(apiId, limit, offset, xWSO2Tenant, null);
        Type localVarReturnType = new TypeToken<RatingListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call apisApiIdRatingsGetAsync(String apiId, Integer limit, Integer offset, String xWSO2Tenant, ApiCallback<RatingListDTO> _callback) throws ApiException {
        Call localVarCall = this.apisApiIdRatingsGetValidateBeforeCall(apiId, limit, offset, xWSO2Tenant, _callback);
        Type localVarReturnType = new TypeToken<RatingListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call apisApiIdUserRatingDeleteCall(String apiId, String xWSO2Tenant, String ifMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/user-rating".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call apisApiIdUserRatingDeleteValidateBeforeCall(String apiId, String xWSO2Tenant, String ifMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdUserRatingDelete(Async)");
        }
        Call localVarCall = this.apisApiIdUserRatingDeleteCall(apiId, xWSO2Tenant, ifMatch, _callback);
        return localVarCall;
    }

    public void apisApiIdUserRatingDelete(String apiId, String xWSO2Tenant, String ifMatch) throws ApiException {
        this.apisApiIdUserRatingDeleteWithHttpInfo(apiId, xWSO2Tenant, ifMatch);
    }

    public ApiResponse<Void> apisApiIdUserRatingDeleteWithHttpInfo(String apiId, String xWSO2Tenant, String ifMatch) throws ApiException {
        Call localVarCall = this.apisApiIdUserRatingDeleteValidateBeforeCall(apiId, xWSO2Tenant, ifMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call apisApiIdUserRatingDeleteAsync(String apiId, String xWSO2Tenant, String ifMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.apisApiIdUserRatingDeleteValidateBeforeCall(apiId, xWSO2Tenant, ifMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call apisApiIdUserRatingGetCall(String apiId, String xWSO2Tenant, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/user-rating".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call apisApiIdUserRatingGetValidateBeforeCall(String apiId, String xWSO2Tenant, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdUserRatingGet(Async)");
        }
        Call localVarCall = this.apisApiIdUserRatingGetCall(apiId, xWSO2Tenant, ifNoneMatch, _callback);
        return localVarCall;
    }

    public RatingDTO apisApiIdUserRatingGet(String apiId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        ApiResponse<RatingDTO> localVarResp = this.apisApiIdUserRatingGetWithHttpInfo(apiId, xWSO2Tenant, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<RatingDTO> apisApiIdUserRatingGetWithHttpInfo(String apiId, String xWSO2Tenant, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.apisApiIdUserRatingGetValidateBeforeCall(apiId, xWSO2Tenant, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<RatingDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call apisApiIdUserRatingGetAsync(String apiId, String xWSO2Tenant, String ifNoneMatch, ApiCallback<RatingDTO> _callback) throws ApiException {
        Call localVarCall = this.apisApiIdUserRatingGetValidateBeforeCall(apiId, xWSO2Tenant, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<RatingDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call apisApiIdUserRatingPutCall(String apiId, RatingDTO ratingDTO, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        RatingDTO localVarPostBody = ratingDTO;
        String localVarPath = "/apis/{apiId}/user-rating".replaceAll("\\{apiId\\}", this.localVarApiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call apisApiIdUserRatingPutValidateBeforeCall(String apiId, RatingDTO ratingDTO, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdUserRatingPut(Async)");
        }
        if (ratingDTO == null) {
            throw new ApiException("Missing the required parameter 'ratingDTO' when calling apisApiIdUserRatingPut(Async)");
        }
        Call localVarCall = this.apisApiIdUserRatingPutCall(apiId, ratingDTO, xWSO2Tenant, _callback);
        return localVarCall;
    }

    public RatingDTO apisApiIdUserRatingPut(String apiId, RatingDTO ratingDTO, String xWSO2Tenant) throws ApiException {
        ApiResponse<RatingDTO> localVarResp = this.apisApiIdUserRatingPutWithHttpInfo(apiId, ratingDTO, xWSO2Tenant);
        return localVarResp.getData();
    }

    public ApiResponse<RatingDTO> apisApiIdUserRatingPutWithHttpInfo(String apiId, RatingDTO ratingDTO, String xWSO2Tenant) throws ApiException {
        Call localVarCall = this.apisApiIdUserRatingPutValidateBeforeCall(apiId, ratingDTO, xWSO2Tenant, null);
        Type localVarReturnType = new TypeToken<RatingDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call apisApiIdUserRatingPutAsync(String apiId, RatingDTO ratingDTO, String xWSO2Tenant, ApiCallback<RatingDTO> _callback) throws ApiException {
        Call localVarCall = this.apisApiIdUserRatingPutValidateBeforeCall(apiId, ratingDTO, xWSO2Tenant, _callback);
        Type localVarReturnType = new TypeToken<RatingDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

