/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.wso2.am.integration.clients.store.api.v1.dto.MonetizationInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ThrottlingPolicyPermissionInfoDTO;

public class ThrottlingPolicyDTO {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_POLICY_LEVEL = "policyLevel";
    @SerializedName(value="policyLevel")
    private PolicyLevelEnum policyLevel;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private Map<String, String> attributes = null;
    public static final String SERIALIZED_NAME_REQUEST_COUNT = "requestCount";
    @SerializedName(value="requestCount")
    private Long requestCount;
    public static final String SERIALIZED_NAME_DATA_UNIT = "dataUnit";
    @SerializedName(value="dataUnit")
    private String dataUnit;
    public static final String SERIALIZED_NAME_UNIT_TIME = "unitTime";
    @SerializedName(value="unitTime")
    private Long unitTime;
    public static final String SERIALIZED_NAME_TIME_UNIT = "timeUnit";
    @SerializedName(value="timeUnit")
    private String timeUnit;
    public static final String SERIALIZED_NAME_RATE_LIMIT_COUNT = "rateLimitCount";
    @SerializedName(value="rateLimitCount")
    private Integer rateLimitCount = 0;
    public static final String SERIALIZED_NAME_RATE_LIMIT_TIME_UNIT = "rateLimitTimeUnit";
    @SerializedName(value="rateLimitTimeUnit")
    private String rateLimitTimeUnit;
    public static final String SERIALIZED_NAME_QUOTA_POLICY_TYPE = "quotaPolicyType";
    @SerializedName(value="quotaPolicyType")
    private QuotaPolicyTypeEnum quotaPolicyType;
    public static final String SERIALIZED_NAME_TIER_PLAN = "tierPlan";
    @SerializedName(value="tierPlan")
    private TierPlanEnum tierPlan;
    public static final String SERIALIZED_NAME_STOP_ON_QUOTA_REACH = "stopOnQuotaReach";
    @SerializedName(value="stopOnQuotaReach")
    private Boolean stopOnQuotaReach;
    public static final String SERIALIZED_NAME_MONETIZATION_ATTRIBUTES = "monetizationAttributes";
    @SerializedName(value="monetizationAttributes")
    private MonetizationInfoDTO monetizationAttributes;
    public static final String SERIALIZED_NAME_THROTTLING_POLICY_PERMISSIONS = "throttlingPolicyPermissions";
    @SerializedName(value="throttlingPolicyPermissions")
    private ThrottlingPolicyPermissionInfoDTO throttlingPolicyPermissions;

    public ThrottlingPolicyDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Platinum", required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ThrottlingPolicyDTO description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Allows 50 request(s) per minute.", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ThrottlingPolicyDTO policyLevel(PolicyLevelEnum policyLevel) {
        this.policyLevel = policyLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="subscription", value="")
    public PolicyLevelEnum getPolicyLevel() {
        return this.policyLevel;
    }

    public void setPolicyLevel(PolicyLevelEnum policyLevel) {
        this.policyLevel = policyLevel;
    }

    public ThrottlingPolicyDTO attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{}", value="Custom attributes added to the throttling policy ")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ThrottlingPolicyDTO requestCount(Long requestCount) {
        this.requestCount = requestCount;
        return this;
    }

    @ApiModelProperty(example="50", required=true, value="Maximum number of requests which can be sent within a provided unit time ")
    public Long getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(Long requestCount) {
        this.requestCount = requestCount;
    }

    public ThrottlingPolicyDTO dataUnit(String dataUnit) {
        this.dataUnit = dataUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="KB", value="Unit of data allowed to be transfered. Allowed values are \"KB\", \"MB\" and \"GB\" ")
    public String getDataUnit() {
        return this.dataUnit;
    }

    public void setDataUnit(String dataUnit) {
        this.dataUnit = dataUnit;
    }

    public ThrottlingPolicyDTO unitTime(Long unitTime) {
        this.unitTime = unitTime;
        return this;
    }

    @ApiModelProperty(example="60000", required=true, value="")
    public Long getUnitTime() {
        return this.unitTime;
    }

    public void setUnitTime(Long unitTime) {
        this.unitTime = unitTime;
    }

    public ThrottlingPolicyDTO timeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="min", value="")
    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public ThrottlingPolicyDTO rateLimitCount(Integer rateLimitCount) {
        this.rateLimitCount = rateLimitCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Burst control request count")
    public Integer getRateLimitCount() {
        return this.rateLimitCount;
    }

    public void setRateLimitCount(Integer rateLimitCount) {
        this.rateLimitCount = rateLimitCount;
    }

    public ThrottlingPolicyDTO rateLimitTimeUnit(String rateLimitTimeUnit) {
        this.rateLimitTimeUnit = rateLimitTimeUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="min", value="Burst control time unit")
    public String getRateLimitTimeUnit() {
        return this.rateLimitTimeUnit;
    }

    public void setRateLimitTimeUnit(String rateLimitTimeUnit) {
        this.rateLimitTimeUnit = rateLimitTimeUnit;
    }

    public ThrottlingPolicyDTO quotaPolicyType(QuotaPolicyTypeEnum quotaPolicyType) {
        this.quotaPolicyType = quotaPolicyType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="REQUESTCOUNT", value="Default quota limit type")
    public QuotaPolicyTypeEnum getQuotaPolicyType() {
        return this.quotaPolicyType;
    }

    public void setQuotaPolicyType(QuotaPolicyTypeEnum quotaPolicyType) {
        this.quotaPolicyType = quotaPolicyType;
    }

    public ThrottlingPolicyDTO tierPlan(TierPlanEnum tierPlan) {
        this.tierPlan = tierPlan;
        return this;
    }

    @ApiModelProperty(example="FREE", required=true, value="This attribute declares whether this tier is available under commercial or free ")
    public TierPlanEnum getTierPlan() {
        return this.tierPlan;
    }

    public void setTierPlan(TierPlanEnum tierPlan) {
        this.tierPlan = tierPlan;
    }

    public ThrottlingPolicyDTO stopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="If this attribute is set to false, you are capabale of sending requests even if the request count exceeded within a unit time ")
    public Boolean isStopOnQuotaReach() {
        return this.stopOnQuotaReach;
    }

    public void setStopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
    }

    public ThrottlingPolicyDTO monetizationAttributes(MonetizationInfoDTO monetizationAttributes) {
        this.monetizationAttributes = monetizationAttributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MonetizationInfoDTO getMonetizationAttributes() {
        return this.monetizationAttributes;
    }

    public void setMonetizationAttributes(MonetizationInfoDTO monetizationAttributes) {
        this.monetizationAttributes = monetizationAttributes;
    }

    public ThrottlingPolicyDTO throttlingPolicyPermissions(ThrottlingPolicyPermissionInfoDTO throttlingPolicyPermissions) {
        this.throttlingPolicyPermissions = throttlingPolicyPermissions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ThrottlingPolicyPermissionInfoDTO getThrottlingPolicyPermissions() {
        return this.throttlingPolicyPermissions;
    }

    public void setThrottlingPolicyPermissions(ThrottlingPolicyPermissionInfoDTO throttlingPolicyPermissions) {
        this.throttlingPolicyPermissions = throttlingPolicyPermissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThrottlingPolicyDTO throttlingPolicy = (ThrottlingPolicyDTO)o;
        return Objects.equals(this.name, throttlingPolicy.name) && Objects.equals(this.description, throttlingPolicy.description) && Objects.equals((Object)this.policyLevel, (Object)throttlingPolicy.policyLevel) && Objects.equals(this.attributes, throttlingPolicy.attributes) && Objects.equals(this.requestCount, throttlingPolicy.requestCount) && Objects.equals(this.dataUnit, throttlingPolicy.dataUnit) && Objects.equals(this.unitTime, throttlingPolicy.unitTime) && Objects.equals(this.timeUnit, throttlingPolicy.timeUnit) && Objects.equals(this.rateLimitCount, throttlingPolicy.rateLimitCount) && Objects.equals(this.rateLimitTimeUnit, throttlingPolicy.rateLimitTimeUnit) && Objects.equals((Object)this.quotaPolicyType, (Object)throttlingPolicy.quotaPolicyType) && Objects.equals((Object)this.tierPlan, (Object)throttlingPolicy.tierPlan) && Objects.equals(this.stopOnQuotaReach, throttlingPolicy.stopOnQuotaReach) && Objects.equals(this.monetizationAttributes, throttlingPolicy.monetizationAttributes) && Objects.equals(this.throttlingPolicyPermissions, throttlingPolicy.throttlingPolicyPermissions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.policyLevel, this.attributes, this.requestCount, this.dataUnit, this.unitTime, this.timeUnit, this.rateLimitCount, this.rateLimitTimeUnit, this.quotaPolicyType, this.tierPlan, this.stopOnQuotaReach, this.monetizationAttributes, this.throttlingPolicyPermissions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThrottlingPolicyDTO {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    policyLevel: ").append(this.toIndentedString((Object)this.policyLevel)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    requestCount: ").append(this.toIndentedString(this.requestCount)).append("\n");
        sb.append("    dataUnit: ").append(this.toIndentedString(this.dataUnit)).append("\n");
        sb.append("    unitTime: ").append(this.toIndentedString(this.unitTime)).append("\n");
        sb.append("    timeUnit: ").append(this.toIndentedString(this.timeUnit)).append("\n");
        sb.append("    rateLimitCount: ").append(this.toIndentedString(this.rateLimitCount)).append("\n");
        sb.append("    rateLimitTimeUnit: ").append(this.toIndentedString(this.rateLimitTimeUnit)).append("\n");
        sb.append("    quotaPolicyType: ").append(this.toIndentedString((Object)this.quotaPolicyType)).append("\n");
        sb.append("    tierPlan: ").append(this.toIndentedString((Object)this.tierPlan)).append("\n");
        sb.append("    stopOnQuotaReach: ").append(this.toIndentedString(this.stopOnQuotaReach)).append("\n");
        sb.append("    monetizationAttributes: ").append(this.toIndentedString(this.monetizationAttributes)).append("\n");
        sb.append("    throttlingPolicyPermissions: ").append(this.toIndentedString(this.throttlingPolicyPermissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TierPlanEnum {
        FREE("FREE"),
        COMMERCIAL("COMMERCIAL");

        private String value;

        private TierPlanEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TierPlanEnum fromValue(String value) {
            for (TierPlanEnum b : TierPlanEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TierPlanEnum> {
            public void write(JsonWriter jsonWriter, TierPlanEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TierPlanEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TierPlanEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum QuotaPolicyTypeEnum {
        REQUESTCOUNT("REQUESTCOUNT"),
        BANDWIDTHVOLUME("BANDWIDTHVOLUME");

        private String value;

        private QuotaPolicyTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static QuotaPolicyTypeEnum fromValue(String value) {
            for (QuotaPolicyTypeEnum b : QuotaPolicyTypeEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<QuotaPolicyTypeEnum> {
            public void write(JsonWriter jsonWriter, QuotaPolicyTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public QuotaPolicyTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return QuotaPolicyTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PolicyLevelEnum {
        APPLICATION("application"),
        SUBSCRIPTION("subscription");

        private String value;

        private PolicyLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PolicyLevelEnum fromValue(String value) {
            for (PolicyLevelEnum b : PolicyLevelEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PolicyLevelEnum> {
            public void write(JsonWriter jsonWriter, PolicyLevelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PolicyLevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PolicyLevelEnum.fromValue(value);
            }
        }
    }
}

