/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class WorkflowResponseDTO {
    public static final String SERIALIZED_NAME_WORKFLOW_STATUS = "workflowStatus";
    @SerializedName(value="workflowStatus")
    private WorkflowStatusEnum workflowStatus;
    public static final String SERIALIZED_NAME_JSON_PAYLOAD = "jsonPayload";
    @SerializedName(value="jsonPayload")
    private String jsonPayload;

    public WorkflowResponseDTO workflowStatus(WorkflowStatusEnum workflowStatus) {
        this.workflowStatus = workflowStatus;
        return this;
    }

    @ApiModelProperty(example="APPROVED", required=true, value="This attribute declares whether this workflow task is approved or rejected. ")
    public WorkflowStatusEnum getWorkflowStatus() {
        return this.workflowStatus;
    }

    public void setWorkflowStatus(WorkflowStatusEnum workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    public WorkflowResponseDTO jsonPayload(String jsonPayload) {
        this.jsonPayload = jsonPayload;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Attributes that returned after the workflow execution ")
    public String getJsonPayload() {
        return this.jsonPayload;
    }

    public void setJsonPayload(String jsonPayload) {
        this.jsonPayload = jsonPayload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowResponseDTO workflowResponse = (WorkflowResponseDTO)o;
        return Objects.equals((Object)this.workflowStatus, (Object)workflowResponse.workflowStatus) && Objects.equals(this.jsonPayload, workflowResponse.jsonPayload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.workflowStatus, this.jsonPayload});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowResponseDTO {\n");
        sb.append("    workflowStatus: ").append(this.toIndentedString((Object)this.workflowStatus)).append("\n");
        sb.append("    jsonPayload: ").append(this.toIndentedString(this.jsonPayload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WorkflowStatusEnum {
        CREATED("CREATED"),
        APPROVED("APPROVED"),
        REJECTED("REJECTED"),
        REGISTERED("REGISTERED");

        private String value;

        private WorkflowStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WorkflowStatusEnum fromValue(String value) {
            for (WorkflowStatusEnum b : WorkflowStatusEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<WorkflowStatusEnum> {
            public void write(JsonWriter jsonWriter, WorkflowStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WorkflowStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WorkflowStatusEnum.fromValue(value);
            }
        }
    }
}

