/*
 * WSO2 API Manager - Developer Portal
 * This document specifies a **RESTful API** for WSO2 **API Manager** - **Developer Portal**. Please see [full OpenAPI Specification](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.7.206/components/apimgt/org.wso2.carbon.apimgt.rest.api.store.v1/src/main/resources/devportal-api.yaml) of the API which is written using [OAS 3.0](http://swagger.io/) specification.  # Authentication The Developer Portal REST API is protected using OAuth2 and access control is achieved through scopes. Before you start invoking the API, you need to obtain an access token with the required scopes. This guide will walk you through the steps that you will need to follow to obtain an access token. First you need to obtain the consumer key/secret key pair by calling the dynamic client registration (DCR) endpoint. You can add your preferred grant types in the payload. A Sample payload is shown below. ```   {   \"callbackUrl\":\"www.google.lk\",   \"clientName\":\"rest_api_devportal\",   \"owner\":\"admin\",   \"grantType\":\"client_credentials password refresh_token\",   \"saasApp\":true   } ``` Create a file (payload.json) with the above sample payload, and use the cURL shown below to invoke the DCR endpoint. Authorization header of this should contain the base64 encoded admin username and password. **Format of the request** ```   curl -X POST -H \"Authorization: Basic Base64(admin_username:admin_password)\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://<host>:<servlet_port>/client-registration/v0.17/register ``` **Sample request** ```   curl -X POST -H \"Authorization: Basic YWRtaW46YWRtaW4=\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://localhost:9443/client-registration/v0.17/register ``` Following is a sample response after invoking the above curl. ``` { \"clientId\": \"fOCi4vNJ59PpHucC2CAYfYuADdMa\", \"clientName\": \"rest_api_devportal\", \"callBackURL\": \"www.google.lk\", \"clientSecret\": \"a4FwHlq0iCIKVs2MPIIDnepZnYMa\", \"isSaasApplication\": true, \"appOwner\": \"admin\", \"jsonString\": \"{\\\"grant_types\\\":\\\"client_credentials password refresh_token\\\",\\\"redirect_uris\\\":\\\"www.google.lk\\\",\\\"client_name\\\":\\\"rest_api_devportal\\\"}\", \"jsonAppAttribute\": \"{}\", \"tokenType\": null } ``` Next you must use the above client id and secret to obtain the access token. We will be using the password grant type for this, you can use any grant type you desire. You also need to add the proper **scope** when getting the access token. All possible scopes for devportal REST API can be viewed in **OAuth2 Security** section of this document and scope for each resource is given in **authorization** section of resource documentation. Following is the format of the request if you are using the password grant type. ``` curl -k -d \"grant_type=password&username=<admin_username>&password=<admin_password>&scope=<scopes separated by space>\" \\ -H \"Authorization: Basic base64(cliet_id:client_secret)\" \\ https://<host>:<servlet_port>/oauth2/token ``` **Sample request** ``` curl https://localhost:9443/oauth2/token -k \\ -H \"Authorization: Basic Zk9DaTR2Tko1OVBwSHVjQzJDQVlmWXVBRGRNYTphNEZ3SGxxMGlDSUtWczJNUElJRG5lcFpuWU1h\" \\ -d \"grant_type=password&username=admin&password=admin&scope=apim:subscribe apim:api_key\" ``` Shown below is a sample response to the above request. ``` { \"access_token\": \"e79bda48-3406-3178-acce-f6e4dbdcbb12\", \"refresh_token\": \"a757795d-e69f-38b8-bd85-9aded677a97c\", \"scope\": \"apim:subscribe apim:api_key\", \"token_type\": \"Bearer\", \"expires_in\": 3600 } ``` Now you have a valid access token, which you can use to invoke an API. Navigate through the API descriptions to find the required API, obtain an access token as described above and invoke the API with the authentication header. If you use a different authentication mechanism, this process may change.  # Try out in Postman If you want to try-out the embedded postman collection with \"Run in Postman\" option, please follow the guidelines listed below. * All of the OAuth2 secured endpoints have been configured with an Authorization Bearer header with a parameterized access token. Before invoking any REST API resource make sure you run the `Register DCR Application` and `Generate Access Token` requests to fetch an access token with all required scopes. * Make sure you have an API Manager instance up and running. * Update the `basepath` parameter to match the hostname and port of the APIM instance.  [![Run in Postman](https://run.pstmn.io/button.svg)](https://app.getpostman.com/run-collection/5bc0161b8aa7e701d7bf) 
 *
 * The version of the OpenAPI document: v3
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.store.api.v1;

import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.ProgressRequestBody;
import org.wso2.am.integration.clients.store.api.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.wso2.am.integration.clients.store.api.v1.dto.AdditionalSubscriptionInfoListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ErrorDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.WorkflowResponseDTO;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubscriptionsApi {
    private ApiClient localVarApiClient;

    public SubscriptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getAdditionalInfoOfAPISubscriptions
     * @param apiId **API ID** consisting of the **UUID** of the API.  (required)
     * @param groupId Application Group Id  (optional)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param offset Starting point within the complete list of items qualified.  (optional, default to 0)
     * @param limit Maximum size of resource array to return.  (optional, default to 25)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Types and fields returned successfully.  </td><td>  * Content-Type - The content of the body.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. Retrieving types and fields failed.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAdditionalInfoOfAPISubscriptionsCall(String apiId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/subscriptions/{apiId}/additionalInfo"
            .replaceAll("\\{" + "apiId" + "\\}", localVarApiClient.escapeString(apiId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (groupId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("groupId", groupId));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", localVarApiClient.parameterToString(xWSO2Tenant));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAdditionalInfoOfAPISubscriptionsValidateBeforeCall(String apiId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'apiId' is set
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling getAdditionalInfoOfAPISubscriptions(Async)");
        }
        

        okhttp3.Call localVarCall = getAdditionalInfoOfAPISubscriptionsCall(apiId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get Additional Information of subscriptions attached to an API.
     * This operation can be used to retrieve all additional Information of subscriptions attached to an API by providing the API id. 
     * @param apiId **API ID** consisting of the **UUID** of the API.  (required)
     * @param groupId Application Group Id  (optional)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param offset Starting point within the complete list of items qualified.  (optional, default to 0)
     * @param limit Maximum size of resource array to return.  (optional, default to 25)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @return AdditionalSubscriptionInfoListDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Types and fields returned successfully.  </td><td>  * Content-Type - The content of the body.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. Retrieving types and fields failed.  </td><td>  -  </td></tr>
     </table>
     */
    public AdditionalSubscriptionInfoListDTO getAdditionalInfoOfAPISubscriptions(String apiId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch) throws ApiException {
        ApiResponse<AdditionalSubscriptionInfoListDTO> localVarResp = getAdditionalInfoOfAPISubscriptionsWithHttpInfo(apiId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get Additional Information of subscriptions attached to an API.
     * This operation can be used to retrieve all additional Information of subscriptions attached to an API by providing the API id. 
     * @param apiId **API ID** consisting of the **UUID** of the API.  (required)
     * @param groupId Application Group Id  (optional)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param offset Starting point within the complete list of items qualified.  (optional, default to 0)
     * @param limit Maximum size of resource array to return.  (optional, default to 25)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @return ApiResponse&lt;AdditionalSubscriptionInfoListDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Types and fields returned successfully.  </td><td>  * Content-Type - The content of the body.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. Retrieving types and fields failed.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AdditionalSubscriptionInfoListDTO> getAdditionalInfoOfAPISubscriptionsWithHttpInfo(String apiId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getAdditionalInfoOfAPISubscriptionsValidateBeforeCall(apiId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<AdditionalSubscriptionInfoListDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Additional Information of subscriptions attached to an API. (asynchronously)
     * This operation can be used to retrieve all additional Information of subscriptions attached to an API by providing the API id. 
     * @param apiId **API ID** consisting of the **UUID** of the API.  (required)
     * @param groupId Application Group Id  (optional)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param offset Starting point within the complete list of items qualified.  (optional, default to 0)
     * @param limit Maximum size of resource array to return.  (optional, default to 25)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Types and fields returned successfully.  </td><td>  * Content-Type - The content of the body.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. Retrieving types and fields failed.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAdditionalInfoOfAPISubscriptionsAsync(String apiId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch, final ApiCallback<AdditionalSubscriptionInfoListDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAdditionalInfoOfAPISubscriptionsValidateBeforeCall(apiId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<AdditionalSubscriptionInfoListDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscriptionsGet
     * @param apiId **API ID** consisting of the **UUID** of the API.  (optional)
     * @param applicationId **Application Identifier** consisting of the UUID of the Application.  (optional)
     * @param groupId Application Group Id  (optional)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param offset Starting point within the complete list of items qualified.  (optional, default to 0)
     * @param limit Maximum size of resource array to return.  (optional, default to 25)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Subscription list returned.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests.  <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> Not Acceptable. The requested media type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsGetCall(String apiId, String applicationId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/subscriptions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("apiId", apiId));
        }

        if (applicationId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("applicationId", applicationId));
        }

        if (groupId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("groupId", groupId));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", localVarApiClient.parameterToString(xWSO2Tenant));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscriptionsGetValidateBeforeCall(String apiId, String applicationId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = subscriptionsGetCall(apiId, applicationId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get All Subscriptions 
     * This operation can be used to retrieve a list of subscriptions of the user associated with the provided access token. This operation is capable of  1. Retrieving applications which are subscibed to a specific API. &#x60;GET https://localhost:9443/api/am/devportal/v2/subscriptions?apiId&#x3D;c43a325c-260b-4302-81cb-768eafaa3aed&#x60;  2. Retrieving APIs which are subscribed by a specific application. &#x60;GET https://localhost:9443/api/am/devportal/v2/subscriptions?applicationId&#x3D;c43a325c-260b-4302-81cb-768eafaa3aed&#x60;  **IMPORTANT:** * It is mandatory to provide either **apiId** or **applicationId**. 
     * @param apiId **API ID** consisting of the **UUID** of the API.  (optional)
     * @param applicationId **Application Identifier** consisting of the UUID of the Application.  (optional)
     * @param groupId Application Group Id  (optional)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param offset Starting point within the complete list of items qualified.  (optional, default to 0)
     * @param limit Maximum size of resource array to return.  (optional, default to 25)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @return SubscriptionListDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Subscription list returned.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests.  <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> Not Acceptable. The requested media type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public SubscriptionListDTO subscriptionsGet(String apiId, String applicationId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch) throws ApiException {
        ApiResponse<SubscriptionListDTO> localVarResp = subscriptionsGetWithHttpInfo(apiId, applicationId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get All Subscriptions 
     * This operation can be used to retrieve a list of subscriptions of the user associated with the provided access token. This operation is capable of  1. Retrieving applications which are subscibed to a specific API. &#x60;GET https://localhost:9443/api/am/devportal/v2/subscriptions?apiId&#x3D;c43a325c-260b-4302-81cb-768eafaa3aed&#x60;  2. Retrieving APIs which are subscribed by a specific application. &#x60;GET https://localhost:9443/api/am/devportal/v2/subscriptions?applicationId&#x3D;c43a325c-260b-4302-81cb-768eafaa3aed&#x60;  **IMPORTANT:** * It is mandatory to provide either **apiId** or **applicationId**. 
     * @param apiId **API ID** consisting of the **UUID** of the API.  (optional)
     * @param applicationId **Application Identifier** consisting of the UUID of the Application.  (optional)
     * @param groupId Application Group Id  (optional)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param offset Starting point within the complete list of items qualified.  (optional, default to 0)
     * @param limit Maximum size of resource array to return.  (optional, default to 25)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @return ApiResponse&lt;SubscriptionListDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Subscription list returned.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests.  <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> Not Acceptable. The requested media type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SubscriptionListDTO> subscriptionsGetWithHttpInfo(String apiId, String applicationId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = subscriptionsGetValidateBeforeCall(apiId, applicationId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<SubscriptionListDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get All Subscriptions  (asynchronously)
     * This operation can be used to retrieve a list of subscriptions of the user associated with the provided access token. This operation is capable of  1. Retrieving applications which are subscibed to a specific API. &#x60;GET https://localhost:9443/api/am/devportal/v2/subscriptions?apiId&#x3D;c43a325c-260b-4302-81cb-768eafaa3aed&#x60;  2. Retrieving APIs which are subscribed by a specific application. &#x60;GET https://localhost:9443/api/am/devportal/v2/subscriptions?applicationId&#x3D;c43a325c-260b-4302-81cb-768eafaa3aed&#x60;  **IMPORTANT:** * It is mandatory to provide either **apiId** or **applicationId**. 
     * @param apiId **API ID** consisting of the **UUID** of the API.  (optional)
     * @param applicationId **Application Identifier** consisting of the UUID of the Application.  (optional)
     * @param groupId Application Group Id  (optional)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param offset Starting point within the complete list of items qualified.  (optional, default to 0)
     * @param limit Maximum size of resource array to return.  (optional, default to 25)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Subscription list returned.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests.  <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> Not Acceptable. The requested media type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsGetAsync(String apiId, String applicationId, String groupId, String xWSO2Tenant, Integer offset, Integer limit, String ifNoneMatch, final ApiCallback<SubscriptionListDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscriptionsGetValidateBeforeCall(apiId, applicationId, groupId, xWSO2Tenant, offset, limit, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionListDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscriptionsMultiplePost
     * @param subscriptionDTO Subscription objects that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Successful response with the newly created objects as entity in the body.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type. The entity of the request was not in a supported format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsMultiplePostCall(List<SubscriptionDTO> subscriptionDTO, String xWSO2Tenant, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = subscriptionDTO;

        // create path and map variables
        String localVarPath = "/subscriptions/multiple";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", localVarApiClient.parameterToString(xWSO2Tenant));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscriptionsMultiplePostValidateBeforeCall(List<SubscriptionDTO> subscriptionDTO, String xWSO2Tenant, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'subscriptionDTO' is set
        if (subscriptionDTO == null) {
            throw new ApiException("Missing the required parameter 'subscriptionDTO' when calling subscriptionsMultiplePost(Async)");
        }
        

        okhttp3.Call localVarCall = subscriptionsMultiplePostCall(subscriptionDTO, xWSO2Tenant, _callback);
        return localVarCall;

    }

    /**
     * Add New Subscriptions 
     * This operation can be used to add a new subscriptions providing the ids of the APIs and the applications. 
     * @param subscriptionDTO Subscription objects that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @return List&lt;SubscriptionDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Successful response with the newly created objects as entity in the body.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type. The entity of the request was not in a supported format. </td><td>  -  </td></tr>
     </table>
     */
    public List<SubscriptionDTO> subscriptionsMultiplePost(List<SubscriptionDTO> subscriptionDTO, String xWSO2Tenant) throws ApiException {
        ApiResponse<List<SubscriptionDTO>> localVarResp = subscriptionsMultiplePostWithHttpInfo(subscriptionDTO, xWSO2Tenant);
        return localVarResp.getData();
    }

    /**
     * Add New Subscriptions 
     * This operation can be used to add a new subscriptions providing the ids of the APIs and the applications. 
     * @param subscriptionDTO Subscription objects that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @return ApiResponse&lt;List&lt;SubscriptionDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Successful response with the newly created objects as entity in the body.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type. The entity of the request was not in a supported format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<SubscriptionDTO>> subscriptionsMultiplePostWithHttpInfo(List<SubscriptionDTO> subscriptionDTO, String xWSO2Tenant) throws ApiException {
        okhttp3.Call localVarCall = subscriptionsMultiplePostValidateBeforeCall(subscriptionDTO, xWSO2Tenant, null);
        Type localVarReturnType = new TypeToken<List<SubscriptionDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Add New Subscriptions  (asynchronously)
     * This operation can be used to add a new subscriptions providing the ids of the APIs and the applications. 
     * @param subscriptionDTO Subscription objects that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Successful response with the newly created objects as entity in the body.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests (Will be supported in future).  <br>  * Content-Type - The content type of the body.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type. The entity of the request was not in a supported format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsMultiplePostAsync(List<SubscriptionDTO> subscriptionDTO, String xWSO2Tenant, final ApiCallback<List<SubscriptionDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscriptionsMultiplePostValidateBeforeCall(subscriptionDTO, xWSO2Tenant, _callback);
        Type localVarReturnType = new TypeToken<List<SubscriptionDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscriptionsPost
     * @param subscriptionDTO Subscription object that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created. Successful response with the newly created object as entity in the body. Location header contains URL of newly created entity.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional request.  <br>  * Location - Location to the newly created subscription.  <br>  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the newly created subscription.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type. The entity of the request was not in a supported format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsPostCall(SubscriptionDTO subscriptionDTO, String xWSO2Tenant, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = subscriptionDTO;

        // create path and map variables
        String localVarPath = "/subscriptions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", localVarApiClient.parameterToString(xWSO2Tenant));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscriptionsPostValidateBeforeCall(SubscriptionDTO subscriptionDTO, String xWSO2Tenant, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'subscriptionDTO' is set
        if (subscriptionDTO == null) {
            throw new ApiException("Missing the required parameter 'subscriptionDTO' when calling subscriptionsPost(Async)");
        }
        

        okhttp3.Call localVarCall = subscriptionsPostCall(subscriptionDTO, xWSO2Tenant, _callback);
        return localVarCall;

    }

    /**
     * Add a New Subscription 
     * This operation can be used to add a new subscription providing the id of the API and the application. 
     * @param subscriptionDTO Subscription object that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @return SubscriptionDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created. Successful response with the newly created object as entity in the body. Location header contains URL of newly created entity.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional request.  <br>  * Location - Location to the newly created subscription.  <br>  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the newly created subscription.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type. The entity of the request was not in a supported format. </td><td>  -  </td></tr>
     </table>
     */
    public SubscriptionDTO subscriptionsPost(SubscriptionDTO subscriptionDTO, String xWSO2Tenant) throws ApiException {
        ApiResponse<SubscriptionDTO> localVarResp = subscriptionsPostWithHttpInfo(subscriptionDTO, xWSO2Tenant);
        return localVarResp.getData();
    }

    /**
     * Add a New Subscription 
     * This operation can be used to add a new subscription providing the id of the API and the application. 
     * @param subscriptionDTO Subscription object that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @return ApiResponse&lt;SubscriptionDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created. Successful response with the newly created object as entity in the body. Location header contains URL of newly created entity.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional request.  <br>  * Location - Location to the newly created subscription.  <br>  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the newly created subscription.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type. The entity of the request was not in a supported format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SubscriptionDTO> subscriptionsPostWithHttpInfo(SubscriptionDTO subscriptionDTO, String xWSO2Tenant) throws ApiException {
        okhttp3.Call localVarCall = subscriptionsPostValidateBeforeCall(subscriptionDTO, xWSO2Tenant, null);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Add a New Subscription  (asynchronously)
     * This operation can be used to add a new subscription providing the id of the API and the application. 
     * @param subscriptionDTO Subscription object that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created. Successful response with the newly created object as entity in the body. Location header contains URL of newly created entity.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional request.  <br>  * Location - Location to the newly created subscription.  <br>  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the newly created subscription.  <br>  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported Media Type. The entity of the request was not in a supported format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsPostAsync(SubscriptionDTO subscriptionDTO, String xWSO2Tenant, final ApiCallback<SubscriptionDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscriptionsPostValidateBeforeCall(subscriptionDTO, xWSO2Tenant, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscriptionsSubscriptionIdDelete
     * @param subscriptionId Subscription Id  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Resource successfully deleted.  </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the existing subscription.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsSubscriptionIdDeleteCall(String subscriptionId, String ifMatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/subscriptions/{subscriptionId}"
            .replaceAll("\\{" + "subscriptionId" + "\\}", localVarApiClient.escapeString(subscriptionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", localVarApiClient.parameterToString(ifMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscriptionsSubscriptionIdDeleteValidateBeforeCall(String subscriptionId, String ifMatch, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'subscriptionId' is set
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling subscriptionsSubscriptionIdDelete(Async)");
        }
        

        okhttp3.Call localVarCall = subscriptionsSubscriptionIdDeleteCall(subscriptionId, ifMatch, _callback);
        return localVarCall;

    }

    /**
     * Remove a Subscription 
     * This operation can be used to remove a subscription. 
     * @param subscriptionId Subscription Id  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Resource successfully deleted.  </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the existing subscription.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public void subscriptionsSubscriptionIdDelete(String subscriptionId, String ifMatch) throws ApiException {
        subscriptionsSubscriptionIdDeleteWithHttpInfo(subscriptionId, ifMatch);
    }

    /**
     * Remove a Subscription 
     * This operation can be used to remove a subscription. 
     * @param subscriptionId Subscription Id  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Resource successfully deleted.  </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the existing subscription.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> subscriptionsSubscriptionIdDeleteWithHttpInfo(String subscriptionId, String ifMatch) throws ApiException {
        okhttp3.Call localVarCall = subscriptionsSubscriptionIdDeleteValidateBeforeCall(subscriptionId, ifMatch, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Remove a Subscription  (asynchronously)
     * This operation can be used to remove a subscription. 
     * @param subscriptionId Subscription Id  (required)
     * @param ifMatch Validator for conditional requests; based on ETag.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Resource successfully deleted.  </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the existing subscription.  <br>  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> Precondition Failed. The request has not been performed because one of the preconditions is not met. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsSubscriptionIdDeleteAsync(String subscriptionId, String ifMatch, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscriptionsSubscriptionIdDeleteValidateBeforeCall(subscriptionId, ifMatch, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscriptionsSubscriptionIdGet
     * @param subscriptionId Subscription Id  (required)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Subscription returned  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests. <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional reuquests. <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsSubscriptionIdGetCall(String subscriptionId, String ifNoneMatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/subscriptions/{subscriptionId}"
            .replaceAll("\\{" + "subscriptionId" + "\\}", localVarApiClient.escapeString(subscriptionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscriptionsSubscriptionIdGetValidateBeforeCall(String subscriptionId, String ifNoneMatch, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'subscriptionId' is set
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling subscriptionsSubscriptionIdGet(Async)");
        }
        

        okhttp3.Call localVarCall = subscriptionsSubscriptionIdGetCall(subscriptionId, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get Details of a Subscription 
     * This operation can be used to get details of a single subscription. 
     * @param subscriptionId Subscription Id  (required)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @return SubscriptionDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Subscription returned  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests. <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional reuquests. <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public SubscriptionDTO subscriptionsSubscriptionIdGet(String subscriptionId, String ifNoneMatch) throws ApiException {
        ApiResponse<SubscriptionDTO> localVarResp = subscriptionsSubscriptionIdGetWithHttpInfo(subscriptionId, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get Details of a Subscription 
     * This operation can be used to get details of a single subscription. 
     * @param subscriptionId Subscription Id  (required)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @return ApiResponse&lt;SubscriptionDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Subscription returned  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests. <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional reuquests. <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SubscriptionDTO> subscriptionsSubscriptionIdGetWithHttpInfo(String subscriptionId, String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = subscriptionsSubscriptionIdGetValidateBeforeCall(subscriptionId, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Details of a Subscription  (asynchronously)
     * This operation can be used to get details of a single subscription. 
     * @param subscriptionId Subscription Id  (required)
     * @param ifNoneMatch Validator for conditional requests; based on the ETag of the formerly retrieved variant of the resourec.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK. Subscription returned  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional requests. <br>  * Last-Modified - Date and time the resource has been modifed the last time. Used by caches, or in conditional reuquests. <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. The specified resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsSubscriptionIdGetAsync(String subscriptionId, String ifNoneMatch, final ApiCallback<SubscriptionDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscriptionsSubscriptionIdGetValidateBeforeCall(subscriptionId, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscriptionsSubscriptionIdPut
     * @param subscriptionId Subscription Id  (required)
     * @param subscriptionDTO Subscription object that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Subscription Updated. Successful response with the updated object as entity in the body. Location header contains URL of newly updates entity.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional request.  <br>  * Location - Location to the updated subscription.  <br>  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the updated subscription.  <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. Requested Subscription does not exist.  </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported media type. The entity of the request was in a not supported format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsSubscriptionIdPutCall(String subscriptionId, SubscriptionDTO subscriptionDTO, String xWSO2Tenant, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = subscriptionDTO;

        // create path and map variables
        String localVarPath = "/subscriptions/{subscriptionId}"
            .replaceAll("\\{" + "subscriptionId" + "\\}", localVarApiClient.escapeString(subscriptionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", localVarApiClient.parameterToString(xWSO2Tenant));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscriptionsSubscriptionIdPutValidateBeforeCall(String subscriptionId, SubscriptionDTO subscriptionDTO, String xWSO2Tenant, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'subscriptionId' is set
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling subscriptionsSubscriptionIdPut(Async)");
        }
        
        // verify the required parameter 'subscriptionDTO' is set
        if (subscriptionDTO == null) {
            throw new ApiException("Missing the required parameter 'subscriptionDTO' when calling subscriptionsSubscriptionIdPut(Async)");
        }
        

        okhttp3.Call localVarCall = subscriptionsSubscriptionIdPutCall(subscriptionId, subscriptionDTO, xWSO2Tenant, _callback);
        return localVarCall;

    }

    /**
     * Update Existing Subscription 
     * This operation can be used to update a subscription providing the subscription id, api id, application Id, status and updated throttling policy tier. 
     * @param subscriptionId Subscription Id  (required)
     * @param subscriptionDTO Subscription object that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @return SubscriptionDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Subscription Updated. Successful response with the updated object as entity in the body. Location header contains URL of newly updates entity.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional request.  <br>  * Location - Location to the updated subscription.  <br>  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the updated subscription.  <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. Requested Subscription does not exist.  </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported media type. The entity of the request was in a not supported format.  </td><td>  -  </td></tr>
     </table>
     */
    public SubscriptionDTO subscriptionsSubscriptionIdPut(String subscriptionId, SubscriptionDTO subscriptionDTO, String xWSO2Tenant) throws ApiException {
        ApiResponse<SubscriptionDTO> localVarResp = subscriptionsSubscriptionIdPutWithHttpInfo(subscriptionId, subscriptionDTO, xWSO2Tenant);
        return localVarResp.getData();
    }

    /**
     * Update Existing Subscription 
     * This operation can be used to update a subscription providing the subscription id, api id, application Id, status and updated throttling policy tier. 
     * @param subscriptionId Subscription Id  (required)
     * @param subscriptionDTO Subscription object that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @return ApiResponse&lt;SubscriptionDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Subscription Updated. Successful response with the updated object as entity in the body. Location header contains URL of newly updates entity.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional request.  <br>  * Location - Location to the updated subscription.  <br>  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the updated subscription.  <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. Requested Subscription does not exist.  </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported media type. The entity of the request was in a not supported format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SubscriptionDTO> subscriptionsSubscriptionIdPutWithHttpInfo(String subscriptionId, SubscriptionDTO subscriptionDTO, String xWSO2Tenant) throws ApiException {
        okhttp3.Call localVarCall = subscriptionsSubscriptionIdPutValidateBeforeCall(subscriptionId, subscriptionDTO, xWSO2Tenant, null);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update Existing Subscription  (asynchronously)
     * This operation can be used to update a subscription providing the subscription id, api id, application Id, status and updated throttling policy tier. 
     * @param subscriptionId Subscription Id  (required)
     * @param subscriptionDTO Subscription object that should to be added  (required)
     * @param xWSO2Tenant For cross-tenant invocations, this is used to specify the tenant domain, where the resource need to be   retrieved from.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Subscription Updated. Successful response with the updated object as entity in the body. Location header contains URL of newly updates entity.  </td><td>  * ETag - Entity Tag of the response resource. Used by caches, or in conditional request.  <br>  * Location - Location to the updated subscription.  <br>  </td></tr>
        <tr><td> 202 </td><td> Accepted. The request has been accepted.  </td><td>  * Location - Location of the updated subscription.  <br>  </td></tr>
        <tr><td> 304 </td><td> Not Modified. Empty body because the client has already the latest version of the requested resource.  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. Invalid request or validation error. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. Requested Subscription does not exist.  </td><td>  -  </td></tr>
        <tr><td> 415 </td><td> Unsupported media type. The entity of the request was in a not supported format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call subscriptionsSubscriptionIdPutAsync(String subscriptionId, SubscriptionDTO subscriptionDTO, String xWSO2Tenant, final ApiCallback<SubscriptionDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscriptionsSubscriptionIdPutValidateBeforeCall(subscriptionId, subscriptionDTO, xWSO2Tenant, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
