/*
 * WSO2 API Manager - Developer Portal
 * This document specifies a **RESTful API** for WSO2 **API Manager** - **Developer Portal**. Please see [full OpenAPI Specification](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.7.206/components/apimgt/org.wso2.carbon.apimgt.rest.api.store.v1/src/main/resources/devportal-api.yaml) of the API which is written using [OAS 3.0](http://swagger.io/) specification.  # Authentication The Developer Portal REST API is protected using OAuth2 and access control is achieved through scopes. Before you start invoking the API, you need to obtain an access token with the required scopes. This guide will walk you through the steps that you will need to follow to obtain an access token. First you need to obtain the consumer key/secret key pair by calling the dynamic client registration (DCR) endpoint. You can add your preferred grant types in the payload. A Sample payload is shown below. ```   {   \"callbackUrl\":\"www.google.lk\",   \"clientName\":\"rest_api_devportal\",   \"owner\":\"admin\",   \"grantType\":\"client_credentials password refresh_token\",   \"saasApp\":true   } ``` Create a file (payload.json) with the above sample payload, and use the cURL shown below to invoke the DCR endpoint. Authorization header of this should contain the base64 encoded admin username and password. **Format of the request** ```   curl -X POST -H \"Authorization: Basic Base64(admin_username:admin_password)\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://<host>:<servlet_port>/client-registration/v0.17/register ``` **Sample request** ```   curl -X POST -H \"Authorization: Basic YWRtaW46YWRtaW4=\" -H \"Content-Type: application/json\"   \\ -d @payload.json https://localhost:9443/client-registration/v0.17/register ``` Following is a sample response after invoking the above curl. ``` { \"clientId\": \"fOCi4vNJ59PpHucC2CAYfYuADdMa\", \"clientName\": \"rest_api_devportal\", \"callBackURL\": \"www.google.lk\", \"clientSecret\": \"a4FwHlq0iCIKVs2MPIIDnepZnYMa\", \"isSaasApplication\": true, \"appOwner\": \"admin\", \"jsonString\": \"{\\\"grant_types\\\":\\\"client_credentials password refresh_token\\\",\\\"redirect_uris\\\":\\\"www.google.lk\\\",\\\"client_name\\\":\\\"rest_api_devportal\\\"}\", \"jsonAppAttribute\": \"{}\", \"tokenType\": null } ``` Next you must use the above client id and secret to obtain the access token. We will be using the password grant type for this, you can use any grant type you desire. You also need to add the proper **scope** when getting the access token. All possible scopes for devportal REST API can be viewed in **OAuth2 Security** section of this document and scope for each resource is given in **authorization** section of resource documentation. Following is the format of the request if you are using the password grant type. ``` curl -k -d \"grant_type=password&username=<admin_username>&password=<admin_password>&scope=<scopes separated by space>\" \\ -H \"Authorization: Basic base64(cliet_id:client_secret)\" \\ https://<host>:<servlet_port>/oauth2/token ``` **Sample request** ``` curl https://localhost:9443/oauth2/token -k \\ -H \"Authorization: Basic Zk9DaTR2Tko1OVBwSHVjQzJDQVlmWXVBRGRNYTphNEZ3SGxxMGlDSUtWczJNUElJRG5lcFpuWU1h\" \\ -d \"grant_type=password&username=admin&password=admin&scope=apim:subscribe apim:api_key\" ``` Shown below is a sample response to the above request. ``` { \"access_token\": \"e79bda48-3406-3178-acce-f6e4dbdcbb12\", \"refresh_token\": \"a757795d-e69f-38b8-bd85-9aded677a97c\", \"scope\": \"apim:subscribe apim:api_key\", \"token_type\": \"Bearer\", \"expires_in\": 3600 } ``` Now you have a valid access token, which you can use to invoke an API. Navigate through the API descriptions to find the required API, obtain an access token as described above and invoke the API with the authentication header. If you use a different authentication mechanism, this process may change.  # Try out in Postman If you want to try-out the embedded postman collection with \"Run in Postman\" option, please follow the guidelines listed below. * All of the OAuth2 secured endpoints have been configured with an Authorization Bearer header with a parameterized access token. Before invoking any REST API resource make sure you run the `Register DCR Application` and `Generate Access Token` requests to fetch an access token with all required scopes. * Make sure you have an API Manager instance up and running. * Update the `basepath` parameter to match the hostname and port of the APIM instance.  [![Run in Postman](https://run.pstmn.io/button.svg)](https://app.getpostman.com/run-collection/5bc0161b8aa7e701d7bf) 
 *
 * The version of the OpenAPI document: v3
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.store.api.v1.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.wso2.am.integration.clients.store.api.v1.dto.PaginationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.RatingDTO;
import com.fasterxml.jackson.annotation.JsonCreator;
/**
* RatingListDTO
*/

public class RatingListDTO {
        public static final String SERIALIZED_NAME_AVG_RATING = "avgRating";
        @SerializedName(SERIALIZED_NAME_AVG_RATING)
            private String avgRating;

        public static final String SERIALIZED_NAME_USER_RATING = "userRating";
        @SerializedName(SERIALIZED_NAME_USER_RATING)
            private Integer userRating;

        public static final String SERIALIZED_NAME_COUNT = "count";
        @SerializedName(SERIALIZED_NAME_COUNT)
            private Integer count;

        public static final String SERIALIZED_NAME_LIST = "list";
        @SerializedName(SERIALIZED_NAME_LIST)
            private List<RatingDTO> list = null;

        public static final String SERIALIZED_NAME_PAGINATION = "pagination";
        @SerializedName(SERIALIZED_NAME_PAGINATION)
            private PaginationDTO pagination;


        public RatingListDTO avgRating(String avgRating) {
        
        this.avgRating = avgRating;
        return this;
        }

    /**
        * Average Rating of the API 
    * @return avgRating
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "4", value = "Average Rating of the API ")
    
    public String getAvgRating() {
        return avgRating;
    }


    public void setAvgRating(String avgRating) {
        this.avgRating = avgRating;
    }


        public RatingListDTO userRating(Integer userRating) {
        
        this.userRating = userRating;
        return this;
        }

    /**
        * Rating given by the user 
    * @return userRating
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "4", value = "Rating given by the user ")
    
    public Integer getUserRating() {
        return userRating;
    }


    public void setUserRating(Integer userRating) {
        this.userRating = userRating;
    }


        public RatingListDTO count(Integer count) {
        
        this.count = count;
        return this;
        }

    /**
        * Number of Subscriber Ratings returned. 
    * @return count
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(example = "1", value = "Number of Subscriber Ratings returned. ")
    
    public Integer getCount() {
        return count;
    }


    public void setCount(Integer count) {
        this.count = count;
    }


        public RatingListDTO list(List<RatingDTO> list) {
        
        this.list = list;
        return this;
        }

    /**
        * Get list
    * @return list
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
    
    public List<RatingDTO> getList() {
        return list;
    }


    public void setList(List<RatingDTO> list) {
        this.list = list;
    }


        public RatingListDTO pagination(PaginationDTO pagination) {
        
        this.pagination = pagination;
        return this;
        }

    /**
        * Get pagination
    * @return pagination
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
    
    public PaginationDTO getPagination() {
        return pagination;
    }


    public void setPagination(PaginationDTO pagination) {
        this.pagination = pagination;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
        return true;
        }
        if (o == null || getClass() != o.getClass()) {
        return false;
        }
            RatingListDTO ratingList = (RatingListDTO) o;
            return Objects.equals(this.avgRating, ratingList.avgRating) &&
            Objects.equals(this.userRating, ratingList.userRating) &&
            Objects.equals(this.count, ratingList.count) &&
            Objects.equals(this.list, ratingList.list) &&
            Objects.equals(this.pagination, ratingList.pagination);
    }

    @Override
    public int hashCode() {
        return Objects.hash(avgRating, userRating, count, list, pagination);
    }


@Override
public String toString() {
StringBuilder sb = new StringBuilder();
sb.append("class RatingListDTO {\n");
    sb.append("    avgRating: ").append(toIndentedString(avgRating)).append("\n");
    sb.append("    userRating: ").append(toIndentedString(userRating)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    list: ").append(toIndentedString(list)).append("\n");
    sb.append("    pagination: ").append(toIndentedString(pagination)).append("\n");
sb.append("}");
return sb.toString();
}

/**
* Convert the given object to string with each line indented by 4 spaces
* (except the first line).
*/
private String toIndentedString(Object o) {
if (o == null) {
return "null";
}
return o.toString().replace("\n", "\n    ");
}

}

