/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class AdvertiseInfoDTO {
    public static final String SERIALIZED_NAME_ADVERTISED = "advertised";
    @SerializedName(value="advertised")
    private Boolean advertised;
    public static final String SERIALIZED_NAME_ORIGINAL_DEV_PORTAL_URL = "originalDevPortalUrl";
    @SerializedName(value="originalDevPortalUrl")
    private String originalDevPortalUrl;
    public static final String SERIALIZED_NAME_API_OWNER = "apiOwner";
    @SerializedName(value="apiOwner")
    private String apiOwner;
    public static final String SERIALIZED_NAME_VENDOR = "vendor";
    @SerializedName(value="vendor")
    private VendorEnum vendor = VendorEnum.WSO2;

    public AdvertiseInfoDTO advertised(Boolean advertised) {
        this.advertised = advertised;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="")
    public Boolean isAdvertised() {
        return this.advertised;
    }

    public void setAdvertised(Boolean advertised) {
        this.advertised = advertised;
    }

    public AdvertiseInfoDTO originalDevPortalUrl(String originalDevPortalUrl) {
        this.originalDevPortalUrl = originalDevPortalUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://localhost:9443/devportal", value="")
    public String getOriginalDevPortalUrl() {
        return this.originalDevPortalUrl;
    }

    public void setOriginalDevPortalUrl(String originalDevPortalUrl) {
        this.originalDevPortalUrl = originalDevPortalUrl;
    }

    public AdvertiseInfoDTO apiOwner(String apiOwner) {
        this.apiOwner = apiOwner;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="admin", value="")
    public String getApiOwner() {
        return this.apiOwner;
    }

    public void setApiOwner(String apiOwner) {
        this.apiOwner = apiOwner;
    }

    public AdvertiseInfoDTO vendor(VendorEnum vendor) {
        this.vendor = vendor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VendorEnum getVendor() {
        return this.vendor;
    }

    public void setVendor(VendorEnum vendor) {
        this.vendor = vendor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvertiseInfoDTO advertiseInfo = (AdvertiseInfoDTO)o;
        return Objects.equals(this.advertised, advertiseInfo.advertised) && Objects.equals(this.originalDevPortalUrl, advertiseInfo.originalDevPortalUrl) && Objects.equals(this.apiOwner, advertiseInfo.apiOwner) && Objects.equals((Object)this.vendor, (Object)advertiseInfo.vendor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.advertised, this.originalDevPortalUrl, this.apiOwner, this.vendor});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdvertiseInfoDTO {\n");
        sb.append("    advertised: ").append(this.toIndentedString(this.advertised)).append("\n");
        sb.append("    originalDevPortalUrl: ").append(this.toIndentedString(this.originalDevPortalUrl)).append("\n");
        sb.append("    apiOwner: ").append(this.toIndentedString(this.apiOwner)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString((Object)this.vendor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VendorEnum {
        WSO2("WSO2"),
        AWS("AWS");

        private String value;

        private VendorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VendorEnum fromValue(String value) {
            for (VendorEnum b : VendorEnum.values()) {
                if (!b.name().equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VendorEnum> {
            public void write(JsonWriter jsonWriter, VendorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VendorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VendorEnum.fromValue(value);
            }
        }
    }
}

