/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.store.api.v1;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.wso2.am.integration.clients.store.api.ApiCallback;
import org.wso2.am.integration.clients.store.api.ApiClient;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.Configuration;
import org.wso2.am.integration.clients.store.api.Pair;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationThrottleResetDTO;

public class ApplicationsApi {
    private ApiClient localVarApiClient;

    public ApplicationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call applicationsApplicationIdDeleteCall(String applicationId, String ifMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications/{applicationId}".replaceAll("\\{applicationId\\}", this.localVarApiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applicationsApplicationIdDeleteValidateBeforeCall(String applicationId, String ifMatch, ApiCallback _callback) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdDelete(Async)");
        }
        Call localVarCall = this.applicationsApplicationIdDeleteCall(applicationId, ifMatch, _callback);
        return localVarCall;
    }

    public void applicationsApplicationIdDelete(String applicationId, String ifMatch) throws ApiException {
        this.applicationsApplicationIdDeleteWithHttpInfo(applicationId, ifMatch);
    }

    public ApiResponse<Void> applicationsApplicationIdDeleteWithHttpInfo(String applicationId, String ifMatch) throws ApiException {
        Call localVarCall = this.applicationsApplicationIdDeleteValidateBeforeCall(applicationId, ifMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call applicationsApplicationIdDeleteAsync(String applicationId, String ifMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.applicationsApplicationIdDeleteValidateBeforeCall(applicationId, ifMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call applicationsApplicationIdGetCall(String applicationId, String ifNoneMatch, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications/{applicationId}".replaceAll("\\{applicationId\\}", this.localVarApiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.localVarApiClient.parameterToString(xWSO2Tenant));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applicationsApplicationIdGetValidateBeforeCall(String applicationId, String ifNoneMatch, String xWSO2Tenant, ApiCallback _callback) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdGet(Async)");
        }
        Call localVarCall = this.applicationsApplicationIdGetCall(applicationId, ifNoneMatch, xWSO2Tenant, _callback);
        return localVarCall;
    }

    public ApplicationDTO applicationsApplicationIdGet(String applicationId, String ifNoneMatch, String xWSO2Tenant) throws ApiException {
        ApiResponse<ApplicationDTO> localVarResp = this.applicationsApplicationIdGetWithHttpInfo(applicationId, ifNoneMatch, xWSO2Tenant);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationDTO> applicationsApplicationIdGetWithHttpInfo(String applicationId, String ifNoneMatch, String xWSO2Tenant) throws ApiException {
        Call localVarCall = this.applicationsApplicationIdGetValidateBeforeCall(applicationId, ifNoneMatch, xWSO2Tenant, null);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call applicationsApplicationIdGetAsync(String applicationId, String ifNoneMatch, String xWSO2Tenant, ApiCallback<ApplicationDTO> _callback) throws ApiException {
        Call localVarCall = this.applicationsApplicationIdGetValidateBeforeCall(applicationId, ifNoneMatch, xWSO2Tenant, _callback);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call applicationsApplicationIdPutCall(String applicationId, ApplicationDTO applicationDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        ApplicationDTO localVarPostBody = applicationDTO;
        String localVarPath = "/applications/{applicationId}".replaceAll("\\{applicationId\\}", this.localVarApiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applicationsApplicationIdPutValidateBeforeCall(String applicationId, ApplicationDTO applicationDTO, String ifMatch, ApiCallback _callback) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdPut(Async)");
        }
        if (applicationDTO == null) {
            throw new ApiException("Missing the required parameter 'applicationDTO' when calling applicationsApplicationIdPut(Async)");
        }
        Call localVarCall = this.applicationsApplicationIdPutCall(applicationId, applicationDTO, ifMatch, _callback);
        return localVarCall;
    }

    public ApplicationDTO applicationsApplicationIdPut(String applicationId, ApplicationDTO applicationDTO, String ifMatch) throws ApiException {
        ApiResponse<ApplicationDTO> localVarResp = this.applicationsApplicationIdPutWithHttpInfo(applicationId, applicationDTO, ifMatch);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationDTO> applicationsApplicationIdPutWithHttpInfo(String applicationId, ApplicationDTO applicationDTO, String ifMatch) throws ApiException {
        Call localVarCall = this.applicationsApplicationIdPutValidateBeforeCall(applicationId, applicationDTO, ifMatch, null);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call applicationsApplicationIdPutAsync(String applicationId, ApplicationDTO applicationDTO, String ifMatch, ApiCallback<ApplicationDTO> _callback) throws ApiException {
        Call localVarCall = this.applicationsApplicationIdPutValidateBeforeCall(applicationId, applicationDTO, ifMatch, _callback);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call applicationsApplicationIdResetThrottlePolicyPostCall(String applicationId, ApplicationThrottleResetDTO applicationThrottleResetDTO, ApiCallback _callback) throws ApiException {
        ApplicationThrottleResetDTO localVarPostBody = applicationThrottleResetDTO;
        String localVarPath = "/applications/{applicationId}/reset-throttle-policy".replaceAll("\\{applicationId\\}", this.localVarApiClient.escapeString(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applicationsApplicationIdResetThrottlePolicyPostValidateBeforeCall(String applicationId, ApplicationThrottleResetDTO applicationThrottleResetDTO, ApiCallback _callback) throws ApiException {
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling applicationsApplicationIdResetThrottlePolicyPost(Async)");
        }
        if (applicationThrottleResetDTO == null) {
            throw new ApiException("Missing the required parameter 'applicationThrottleResetDTO' when calling applicationsApplicationIdResetThrottlePolicyPost(Async)");
        }
        Call localVarCall = this.applicationsApplicationIdResetThrottlePolicyPostCall(applicationId, applicationThrottleResetDTO, _callback);
        return localVarCall;
    }

    public void applicationsApplicationIdResetThrottlePolicyPost(String applicationId, ApplicationThrottleResetDTO applicationThrottleResetDTO) throws ApiException {
        this.applicationsApplicationIdResetThrottlePolicyPostWithHttpInfo(applicationId, applicationThrottleResetDTO);
    }

    public ApiResponse<Void> applicationsApplicationIdResetThrottlePolicyPostWithHttpInfo(String applicationId, ApplicationThrottleResetDTO applicationThrottleResetDTO) throws ApiException {
        Call localVarCall = this.applicationsApplicationIdResetThrottlePolicyPostValidateBeforeCall(applicationId, applicationThrottleResetDTO, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call applicationsApplicationIdResetThrottlePolicyPostAsync(String applicationId, ApplicationThrottleResetDTO applicationThrottleResetDTO, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.applicationsApplicationIdResetThrottlePolicyPostValidateBeforeCall(applicationId, applicationThrottleResetDTO, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call applicationsGetCall(String groupId, String query, String sortBy, String sortOrder, Integer limit, Integer offset, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (groupId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("groupId", groupId));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applicationsGetValidateBeforeCall(String groupId, String query, String sortBy, String sortOrder, Integer limit, Integer offset, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.applicationsGetCall(groupId, query, sortBy, sortOrder, limit, offset, ifNoneMatch, _callback);
        return localVarCall;
    }

    public ApplicationListDTO applicationsGet(String groupId, String query, String sortBy, String sortOrder, Integer limit, Integer offset, String ifNoneMatch) throws ApiException {
        ApiResponse<ApplicationListDTO> localVarResp = this.applicationsGetWithHttpInfo(groupId, query, sortBy, sortOrder, limit, offset, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationListDTO> applicationsGetWithHttpInfo(String groupId, String query, String sortBy, String sortOrder, Integer limit, Integer offset, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.applicationsGetValidateBeforeCall(groupId, query, sortBy, sortOrder, limit, offset, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<ApplicationListDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call applicationsGetAsync(String groupId, String query, String sortBy, String sortOrder, Integer limit, Integer offset, String ifNoneMatch, ApiCallback<ApplicationListDTO> _callback) throws ApiException {
        Call localVarCall = this.applicationsGetValidateBeforeCall(groupId, query, sortBy, sortOrder, limit, offset, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<ApplicationListDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call applicationsPostCall(ApplicationDTO applicationDTO, ApiCallback _callback) throws ApiException {
        ApplicationDTO localVarPostBody = applicationDTO;
        String localVarPath = "/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applicationsPostValidateBeforeCall(ApplicationDTO applicationDTO, ApiCallback _callback) throws ApiException {
        if (applicationDTO == null) {
            throw new ApiException("Missing the required parameter 'applicationDTO' when calling applicationsPost(Async)");
        }
        Call localVarCall = this.applicationsPostCall(applicationDTO, _callback);
        return localVarCall;
    }

    public ApplicationDTO applicationsPost(ApplicationDTO applicationDTO) throws ApiException {
        ApiResponse<ApplicationDTO> localVarResp = this.applicationsPostWithHttpInfo(applicationDTO);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationDTO> applicationsPostWithHttpInfo(ApplicationDTO applicationDTO) throws ApiException {
        Call localVarCall = this.applicationsPostValidateBeforeCall(applicationDTO, null);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call applicationsPostAsync(ApplicationDTO applicationDTO, ApiCallback<ApplicationDTO> _callback) throws ApiException {
        Call localVarCall = this.applicationsPostValidateBeforeCall(applicationDTO, _callback);
        Type localVarReturnType = new TypeToken<ApplicationDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

