/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.base;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Matcher;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIMURLBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;

public class APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIMIntegrationBaseTest.class);
    protected AutomationContext storeContext;
    protected AutomationContext publisherContext;
    protected AutomationContext keyManagerContext;
    protected AutomationContext gatewayContextMgt;
    protected AutomationContext gatewayContextWrk;
    protected AutomationContext backEndServer;
    protected OMElement synapseConfiguration;
    protected APIMTestCaseUtils apimTestCaseUtils;
    protected TestUserMode userMode;
    protected String executionMode;
    protected APIMURLBean storeUrls;
    protected APIMURLBean publisherUrls;
    protected APIMURLBean gatewayUrlsMgt;
    protected APIMURLBean gatewayUrlsWrk;
    protected APIMURLBean keyMangerUrl;
    protected APIMURLBean backEndServerUrl;
    protected User user;
    private static final long WAIT_TIME = 90000L;

    protected void init() throws APIManagerIntegrationTestException {
        this.userMode = TestUserMode.SUPER_TENANT_ADMIN;
        this.init(this.userMode);
    }

    protected void init(TestUserMode userMode) throws APIManagerIntegrationTestException {
        this.apimTestCaseUtils = new APIMTestCaseUtils();
        try {
            this.storeContext = new AutomationContext("APIM", "store", userMode);
            this.storeUrls = new APIMURLBean(this.storeContext.getContextUrls());
            this.publisherContext = new AutomationContext("APIM", "publisher", userMode);
            this.publisherUrls = new APIMURLBean(this.publisherContext.getContextUrls());
            this.gatewayContextMgt = new AutomationContext("APIM", "gateway-mgt", userMode);
            this.gatewayUrlsMgt = new APIMURLBean(this.gatewayContextMgt.getContextUrls());
            this.gatewayContextWrk = new AutomationContext("APIM", "gateway-wrk", userMode);
            this.gatewayUrlsWrk = new APIMURLBean(this.gatewayContextWrk.getContextUrls());
            this.keyManagerContext = new AutomationContext("APIM", "keyManager", userMode);
            this.keyMangerUrl = new APIMURLBean(this.keyManagerContext.getContextUrls());
            this.backEndServer = new AutomationContext("APIM", "backend-server", userMode);
            this.backEndServerUrl = new APIMURLBean(this.backEndServer.getContextUrls());
            this.executionMode = this.gatewayContextMgt.getConfigurationValue("//executionEnvironment/text()");
            this.user = this.storeContext.getContextTenant().getContextUser();
        }
        catch (XPathExpressionException e) {
            log.error((Object)"APIM test environment initialization failed", (Throwable)e);
            throw new APIManagerIntegrationTestException("APIM test environment initialization failed", e);
        }
    }

    protected void init(String domainKey, String userKey) throws APIManagerIntegrationTestException {
        try {
            this.storeContext = new AutomationContext("APIM", "store", domainKey, userKey);
            this.storeUrls = new APIMURLBean(this.storeContext.getContextUrls());
            this.publisherContext = new AutomationContext("APIM", "publisher", domainKey, userKey);
            this.publisherUrls = new APIMURLBean(this.publisherContext.getContextUrls());
            this.gatewayContextMgt = new AutomationContext("APIM", "gateway-mgt", domainKey, userKey);
            this.gatewayUrlsMgt = new APIMURLBean(this.gatewayContextMgt.getContextUrls());
            this.gatewayContextWrk = new AutomationContext("APIM", "gateway-wrk", domainKey, userKey);
            this.gatewayUrlsWrk = new APIMURLBean(this.gatewayContextWrk.getContextUrls());
            this.keyManagerContext = new AutomationContext("APIM", "keyManager", domainKey, userKey);
            this.keyMangerUrl = new APIMURLBean(this.keyManagerContext.getContextUrls());
            this.backEndServer = new AutomationContext("APIM", "backend-server", domainKey, userKey);
            this.backEndServerUrl = new APIMURLBean(this.backEndServer.getContextUrls());
            this.user = this.storeContext.getContextTenant().getContextUser();
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Init failed", (Throwable)e);
            throw new APIManagerIntegrationTestException("APIM test environment initialization failed", e);
        }
    }

    protected void loadSynapseConfigurationFromClasspath(String relativeFilePath, AutomationContext automationContext, String sessionCookie) throws APIManagerIntegrationTestException {
        relativeFilePath = relativeFilePath.replaceAll("[\\\\/]", Matcher.quoteReplacement(File.separator));
        try {
            OMElement synapseConfig = APIMTestCaseUtils.loadResource(relativeFilePath);
            this.updateSynapseConfiguration(synapseConfig, automationContext, sessionCookie);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"synapse config loading issue", (Throwable)e);
            throw new APIManagerIntegrationTestException("synapse config loading issue", e);
        }
        catch (XMLStreamException e) {
            log.error((Object)"synapse config loading issue", (Throwable)e);
            throw new APIManagerIntegrationTestException("synapse config loading issue", e);
        }
    }

    protected String createSession(AutomationContext automationContext) throws APIManagerIntegrationTestException {
        try {
            LoginLogoutClient loginLogoutClient = new LoginLogoutClient(automationContext);
            return loginLogoutClient.login();
        }
        catch (Exception e) {
            log.error((Object)"session creation error", (Throwable)e);
            throw new APIManagerIntegrationTestException("session creation error", e);
        }
    }

    protected String getAMResourceLocation() {
        return FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "AM";
    }

    protected void updateSynapseConfiguration(OMElement synapseConfig, AutomationContext automationContext, String sessionCookie) throws APIManagerIntegrationTestException {
        if (this.synapseConfiguration == null) {
            this.synapseConfiguration = synapseConfig;
        } else {
            Iterator itr = synapseConfig.cloneOMElement().getChildElements();
            while (itr.hasNext()) {
                this.synapseConfiguration.addChild((OMNode)itr.next());
            }
        }
        try {
            APIMTestCaseUtils.updateSynapseConfiguration(synapseConfig, automationContext.getContextUrls().getBackEndUrl(), sessionCookie);
        }
        catch (Exception e) {
            log.error((Object)"synapse config  upload error", (Throwable)e);
            throw new APIManagerIntegrationTestException("synapse config  upload error", e);
        }
    }

    protected String getStoreURLHttp() {
        return this.storeUrls.getWebAppURLHttp();
    }

    protected String getStoreURLHttps() {
        return this.storeUrls.getWebAppURLHttps();
    }

    protected String getPublisherURLHttp() {
        return this.publisherUrls.getWebAppURLHttp();
    }

    protected String getPublisherURLHttps() {
        return this.publisherUrls.getWebAppURLHttps();
    }

    protected String getGatewayMgtURLHttp() {
        return this.gatewayUrlsMgt.getWebAppURLHttp();
    }

    protected String getGatewayMgtBackendURLHttps() {
        return this.gatewayUrlsMgt.getWebAppURLHttp();
    }

    protected String getGatewayMgtURLHttps() {
        return this.gatewayUrlsMgt.getWebAppURLHttps();
    }

    protected String getGatewayURLHttp() {
        return this.gatewayUrlsWrk.getWebAppURLHttp();
    }

    protected String getGatewayURLNhttp() {
        return this.gatewayUrlsWrk.getWebAppURLNhttp();
    }

    protected String getKeyManagerURLHttp() {
        return this.keyMangerUrl.getWebAppURLHttp();
    }

    protected String getKeyManagerURLHttps() throws XPathExpressionException {
        return this.keyManagerContext.getContextUrls().getBackEndUrl().replace("/services", "");
    }

    protected String getAPIInvocationURLHttp(String apiContext) throws XPathExpressionException {
        return this.gatewayContextWrk.getContextUrls().getServiceUrl().replace("/services", "") + "/" + apiContext;
    }

    protected String getAPIInvocationURLHttp(String apiContext, String version) throws XPathExpressionException {
        return this.gatewayContextWrk.getContextUrls().getServiceUrl().replace("/services", "") + "/" + apiContext + "/" + version;
    }

    protected String getAPIInvocationURLHttps(String apiContext) throws XPathExpressionException {
        return this.gatewayContextWrk.getContextUrls().getSecureServiceUrl() + "/" + apiContext;
    }

    protected String getBackendEndServiceEndPointHttp(String serviceName) {
        return this.backEndServerUrl.getWebAppURLHttp() + serviceName;
    }

    protected String getBackendEndServiceEndPointHttps(String serviceName) {
        return this.backEndServerUrl.getWebAppURLHttps() + serviceName;
    }

    protected void cleanUp() throws Exception {
        APIStoreRestClient apiStore = new APIStoreRestClient(this.getStoreURLHttp());
        apiStore.login(this.user.getUserName(), this.user.getPassword());
        APIPublisherRestClient publisherRestClient = new APIPublisherRestClient(this.getPublisherURLHttp());
        publisherRestClient.login(this.user.getUserName(), this.user.getPassword());
        HttpResponse subscriptionDataResponse = apiStore.getAllSubscriptions();
        this.verifyResponse(subscriptionDataResponse);
        JSONObject jsonSubscription = new JSONObject(subscriptionDataResponse.getData());
        if (!jsonSubscription.getBoolean("error")) {
            JSONObject jsonSubscriptionsObject = jsonSubscription.getJSONObject("subscriptions");
            JSONArray jsonApplicationsArray = jsonSubscriptionsObject.getJSONArray("applications");
            for (int i = 0; i < jsonApplicationsArray.length(); ++i) {
                JSONObject appObject = jsonApplicationsArray.getJSONObject(i);
                int id = appObject.getInt("id");
                JSONArray subscribedAPIJSONArray = appObject.getJSONArray("subscriptions");
                for (int j = 0; j < subscribedAPIJSONArray.length(); ++j) {
                    JSONObject subscribedAPI = subscribedAPIJSONArray.getJSONObject(j);
                    this.verifyResponse(apiStore.removeAPISubscription(subscribedAPI.getString("name"), subscribedAPI.getString("version"), subscribedAPI.getString("provider"), String.valueOf(id)));
                }
            }
        }
        String applicationData = apiStore.getAllApplications().getData();
        JSONObject jsonApplicationData = new JSONObject(applicationData);
        JSONArray applicationArray = jsonApplicationData.getJSONArray("applications");
        for (int i = 0; i < applicationArray.length(); ++i) {
            JSONObject jsonApplication = applicationArray.getJSONObject(i);
            if (jsonApplication.getString("name").equals("DefaultApplication")) continue;
            this.verifyResponse(apiStore.removeApplication(jsonApplication.getString("name")));
        }
        String apiData = apiStore.getAPI().getData();
        JSONObject jsonAPIData = new JSONObject(apiData);
        JSONArray jsonAPIArray = jsonAPIData.getJSONArray("apis");
        for (int i = 0; i < jsonAPIArray.length(); ++i) {
            JSONObject api = jsonAPIArray.getJSONObject(i);
            publisherRestClient.deleteAPI(api.getString("name"), api.getString("version"), this.user.getUserName());
        }
    }

    protected void verifyResponse(HttpResponse httpResponse) throws JSONException {
        Assert.assertNotNull((Object)httpResponse, (String)"Response object is null");
        log.info((Object)("Response Code : " + httpResponse.getResponseCode()));
        log.info((Object)("Response Message : " + httpResponse.getData()));
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        JSONObject responseData = new JSONObject(httpResponse.getData());
        Assert.assertFalse((boolean)responseData.getBoolean("error"), (String)("Error message received " + httpResponse.getData()));
    }

    protected void waitForAPIDeploymentSync(String apiProvider, String apiName, String apiVersion, String expectedResponse) throws XPathExpressionException {
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + 90000L;
        if (this.executionMode.equalsIgnoreCase(String.valueOf(ExecutionEnvironment.PLATFORM))) {
            while (waitTime > System.currentTimeMillis()) {
                HttpResponse response = null;
                try {
                    response = HttpRequestUtil.sendGetRequest((String)(this.getGatewayURLHttp() + "APIStatusMonitor/api_status/api-data/" + apiProvider + "--" + apiName + ":v" + apiVersion), null);
                }
                catch (IOException ignored) {
                    log.warn((Object)("WebAPP: APIStatusMonitor not yet deployed or API :" + apiName + " not yet deployed " + " with provider: " + apiProvider));
                }
                log.info((Object)("WAIT for availability of API :" + apiName + " with version: " + apiVersion + " with provider: " + apiProvider + " with expected response : " + expectedResponse));
                if (response == null) continue;
                if (response.getData().contains(expectedResponse)) {
                    log.info((Object)("API :" + apiName + " with version: " + apiVersion + " with expected response " + expectedResponse + " found"));
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ignored) {}
            }
        }
    }

    protected void waitForAPIUnDeploymentSync(String apiProvider, String apiName, String apiVersion, String expectedResponse) throws IOException, XPathExpressionException {
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + 90000L;
        if (this.executionMode.equalsIgnoreCase(String.valueOf(ExecutionEnvironment.PLATFORM))) {
            while (waitTime > System.currentTimeMillis()) {
                HttpResponse response = HttpRequestUtil.sendGetRequest((String)(this.getGatewayURLHttp() + "APIStatusMonitor/api_status/api-data/" + apiProvider + "--" + apiName + ":v" + apiVersion), null);
                log.info((Object)("WAIT for meta data sync of API :" + apiName + " with version: " + apiVersion + " with provider: " + apiProvider + " without entry : " + expectedResponse));
                if (!response.getData().contains(expectedResponse)) {
                    log.info((Object)("API :" + apiName + " with version: " + apiVersion + " with expected response " + expectedResponse + " not found"));
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ignored) {}
            }
        }
    }
}

