/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.clients;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIDesignBean;
import org.wso2.am.integration.test.utils.bean.APIImplementationBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.AddDocumentRequestBean;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIPublisherRestClient {
    private static final Log log = LogFactory.getLog(APIPublisherRestClient.class);
    private String backendURL;
    private static final String URL_SUFFIX = "publisher/site/blocks";
    private Map<String, String> requestHeaders = new HashMap<String, String>();

    public APIPublisherRestClient(String backendURL) {
        this.backendURL = backendURL;
        if (this.requestHeaders.get("Content-Type") == null) {
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        }
    }

    public HttpResponse login(String userName, String password) throws APIManagerIntegrationTestException {
        HttpResponse response;
        log.info((Object)("Login to Publisher " + this.backendURL + " as the user " + userName));
        try {
            response = HttpRequestUtil.doPost((URL)new URL(this.backendURL + URL_SUFFIX + "/user/login/ajax/login.jag"), (String)("action=login&username=" + userName + "&password=" + password + ""), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to login to the publisher ", e);
        }
        String session = this.getSession(response.getHeaders());
        if (session == null) {
            throw new APIManagerIntegrationTestException("No session cookie found with response");
        }
        this.setSession(session);
        return response;
    }

    public HttpResponse logout() throws APIManagerIntegrationTestException {
        try {
            return HttpRequestUtil.doGet((String)(this.backendURL + URL_SUFFIX + "/user/login/ajax/login.jag?action=logout"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Failed to logout from publisher ", e);
        }
    }

    public HttpResponse addAPI(APIRequest apiRequest) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + URL_SUFFIX + "/item-add/ajax/add.jag"), (String)apiRequest.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to add API ", e);
        }
    }

    public HttpResponse copyAPI(String provider, String apiName, String oldVersion, String newVersion, String isDefaultVersion) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + URL_SUFFIX + "/overview/ajax/overview.jag"), (String)("action=createNewAPI&provider=" + provider + "&apiName=" + apiName + "&version=" + oldVersion + "&newVersion=" + newVersion + "&isDefaultVersion=" + isDefaultVersion), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable copy API - " + apiName, e);
        }
    }

    public HttpResponse updateAPI(APIRequest apiRequest) throws Exception {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + URL_SUFFIX + "/item-add/ajax/add.jag"), (String)apiRequest.generateRequestParameters("updateAPI"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update API ", e);
        }
    }

    public HttpResponse changeAPILifeCycleStatus(APILifeCycleStateRequest updateRequest) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "publisher/site/blocks/life-cycles/ajax/life-cycles.jag"), (String)updateRequest.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update API ", e);
        }
    }

    public HttpResponse getAPI(String apiName, String provider) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "publisher/site/blocks/listing/ajax/item-list.jag"), (String)("action=getAPI&name=" + apiName + "&version=1.0.0&provider=" + provider + ""), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get API " + apiName, e);
        }
    }

    public HttpResponse deleteAPI(String apiName, String version, String provider) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "publisher/site/blocks/item-add/ajax/remove.jag"), (String)("action=removeAPI&name=" + apiName + "&version=" + version + "&provider=" + provider), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get API - " + apiName, e);
        }
    }

    private String getSession(Map<String, String> responseHeaders) {
        return responseHeaders.get("Set-Cookie");
    }

    private String setSession(String session) {
        return this.requestHeaders.put("Cookie", session);
    }

    private void checkAuthentication() throws APIManagerIntegrationTestException {
        if (this.requestHeaders.get("Cookie") == null) {
            throw new APIManagerIntegrationTestException("No Session Cookie found. Please login first");
        }
    }

    public HttpResponse removeDocumentation(String apiName, String version, String provider, String docName, String docType) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "publisher/site/blocks/documentation/ajax/docs.jag"), (String)("action=removeDocumentation&provider=" + provider + "&apiName=" + apiName + "&version=" + version + "&docName=" + docName + "&docType=" + docType), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to remove document from API - " + apiName, e);
        }
    }

    public HttpResponse revokeAccessToken(String accessToken, String consumerKey, String authUser) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "publisher/site/blocks/tokens/ajax/revokeToken.jag"), (String)("action=revokeAccessToken&accessToken=" + accessToken + "&authUser=" + authUser + "&consumerKey=" + consumerKey), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to revoke access token", e);
        }
    }

    public HttpResponse updatePermissions(String tierName, String permissionType, String roles) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "publisher/site/blocks/tiers/ajax/tiers.jag"), (String)("action=updatePermissions&tierName=" + tierName + "&permissiontype=" + permissionType + "&roles=" + roles), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update permission ", e);
        }
    }

    public HttpResponse updateResourceOfAPI(String provider, String apiName, String version, String swaggerRes) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "publisher/site/blocks/item-design/ajax/add.jag"), (String)("action=manage&provider=" + provider + "&name=" + apiName + "&version=" + version + "&swagger=" + swaggerRes), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update resource of API - " + apiName, e);
        }
    }

    public HttpResponse getAPI(String apiName, String provider, String version) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "publisher/site/blocks/listing/ajax/item-list.jag"), (String)("action=getAPI&name=" + apiName + "&version=" + version + "&provider=" + provider + ""), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve API information - " + apiName, e);
        }
    }

    public HttpResponse checkValidEndpoint(String type, String endpointUrl, String providerName, String apiName, String apiVersion) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "publisher/site/blocks/item-add/ajax/add.jag"), (String)("action=isURLValid&type=" + type + "&url=" + endpointUrl + "&providerName=" + providerName + "&apiName=" + apiName + "&apiVersion=" + apiVersion), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Check for valid endpoint fails for " + endpointUrl, e);
        }
    }

    public HttpResponse changeAPILifeCycleStatusToPublish(APIIdentifier apiIdentifier, boolean isRequireReSubscription) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            APILifeCycleStateRequest publishUpdateRequest = new APILifeCycleStateRequest(apiIdentifier.getApiName(), apiIdentifier.getProviderName(), APILifeCycleState.PUBLISHED);
            publishUpdateRequest.setVersion(apiIdentifier.getVersion());
            String requestParameters = publishUpdateRequest.generateRequestParameters();
            if (isRequireReSubscription) {
                requestParameters = requestParameters + "&requireResubscription=true";
            }
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/site/blocks/life-cycles/ajax/life-cycles.jag"), (String)requestParameters, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when change he lifecycle to publish", e);
        }
    }

    public HttpResponse getApi(String apiName, String provider, String version) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/site/blocks/listing/ajax/item-list.jag"), (String)("action=getAPI&name=" + apiName + "&version=" + version + "&provider=" + provider + ""), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving a API", e);
        }
    }

    public HttpResponse getTierPermissionsPage() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doGet((String)(this.backendURL + "/publisher/site/pages/tiers.jag"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the Tier Permissions page", e);
        }
    }

    public HttpResponse getAPIManagePage(String apiName, String provider, String version) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doGet((String)(this.backendURL + "/publisher/manage?name=" + apiName + "&version=" + version + "&provider=" + provider), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the API Manage page", e);
        }
    }

    public HttpResponse getAPIInformationPage(String apiName, String provider, String version) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            HttpResponse resp = HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/info"), (String)("name=" + apiName + "&version=" + version + "&provider=" + provider), this.requestHeaders);
            return resp;
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the API Information page", e);
        }
    }

    public HttpResponse addDocument(String apiName, String version, String provider, String docName, String docType, String sourceType, String docUrl, String summary, String docLocation, String mimeType, String newType) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "publisher/site/blocks/documentation/ajax/docs.jag"), (String)("action=addDocumentation&provider=" + provider + "&apiName=" + apiName + "&version=" + version + "&docName=" + docName + "&docType=" + docType + "&sourceType=" + sourceType + "&docUrl=" + docUrl + "&summary=" + summary + "&docLocation=" + docLocation + "&mimeType=" + mimeType + "&newType=" + newType), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Adding document to a API", e);
        }
    }

    public HttpResponse addDocument(String apiName, String version, String provider, String docName, String docType, String sourceType, String docUrl, String summary, String docLocation) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/site/blocks/documentation/ajax/docs.jag"), (String)("action=addDocumentation&provider=" + provider + "&apiName=" + apiName + "&version=" + version + "&docName=" + docName + "&docType=" + docType + "&sourceType=" + sourceType + "&docUrl=" + docUrl + "=&summary=" + summary + "&docLocation=" + docLocation), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Adding document to a API", e);
        }
    }

    public HttpResponse addDocument(AddDocumentRequestBean addDocRequestBean) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/site/blocks/documentation/ajax/docs.jag"), (String)("action=addDocumentation&provider=" + addDocRequestBean.getApiProvider() + "&apiName=" + addDocRequestBean.getApiName() + "&version=" + addDocRequestBean.getApiVersion() + "&docName=" + addDocRequestBean.getDocName() + "&docType=" + addDocRequestBean.getDocType() + "&sourceType=" + addDocRequestBean.getDocSourceType() + "&docUrl=" + addDocRequestBean.getDocUrl() + "=&summary=" + addDocRequestBean.getDocSummary() + "&docLocation=" + addDocRequestBean.getDocLocation() + "&mimeType=" + addDocRequestBean.getMimeType() + "&optionsRadios=" + addDocRequestBean.getDocType() + "&optionsRadios1=" + addDocRequestBean.getDocSourceType()), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Adding document to a API", e);
        }
    }

    public HttpResponse getAllAPIs() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doGet((String)(this.backendURL + "/publisher/site/blocks/listing/ajax/item-list.jag?action=getAllAPIs"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Retrieve the All APIs available for the user in Publisher", e);
        }
    }

    public HttpResponse addAPI(APICreationRequestBean creationRequestBean) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/site/blocks/item-add/ajax/add.jag"), (String)creationRequestBean.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Adding the New API ", e);
        }
    }

    public HttpResponse updateAPI(APICreationRequestBean creationRequestBean) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/site/blocks/item-add/ajax/add.jag"), (String)creationRequestBean.generateRequestParameters("updateAPI"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when Retrieve the All APIs available for the user in Publisher", e);
        }
    }

    public HttpResponse designAPI(APIDesignBean designBean) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/site/blocks/item-design/ajax/add.jag"), (String)designBean.generateRequestParameters("design"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to design API ", e);
        }
    }

    public HttpResponse implement(APIImplementationBean implementationBean) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/site/blocks/item-design/ajax/add.jag?"), (String)implementationBean.generateRequestParameters("implement"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to prototype API ", e);
        }
    }

    public HttpResponse getAPIImplementPage(String apiName, String provider, String version) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doGet((String)(this.backendURL + "/publisher/prototype?name=" + apiName + "&version=" + version + "&provider=" + provider), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the API Implement page", e);
        }
    }

    public HttpResponse checkValidAPIName(String apiName) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/site/blocks/item-add/ajax/add.jag"), (String)("action=isAPINameExist&apiName=" + apiName), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exeption when adding a new API with existing API name", e);
        }
    }

    public HttpResponse getTiers() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/site/blocks/item-add/ajax/add.jag"), (String)"action=getTiers", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the Tier Permissions page", e);
        }
    }

    public HttpResponse validateRoles(String role) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/publisher/site/blocks/item-add/ajax/add.jag"), (String)("action=validateRoles&roles=" + role), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Exception when retrieving the Tier Permissions page", e);
        }
    }
}

