/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.monitor.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.integration.test.utils.monitor.utils.WireMonitorServer;

class WireMonitor
extends Thread {
    private Log log = LogFactory.getLog(WireMonitor.class);
    private int port;
    private ServerSocket providerSocket;
    private Socket connection = null;
    private WireMonitorServer trigger;

    @Override
    public void run() {
        OutputStream out = null;
        InputStream in = null;
        try {
            int ch;
            this.providerSocket = new ServerSocket(this.port, 10);
            this.log.info((Object)"Waiting for connection");
            this.connection = this.providerSocket.accept();
            this.log.info((Object)("Connection received from " + this.connection.getInetAddress().getHostName()));
            in = this.connection.getInputStream();
            StringBuilder buffer = new StringBuilder();
            StringBuffer headerBuffer = new StringBuffer();
            Long time = System.currentTimeMillis();
            int contentLength = -1;
            while ((ch = in.read()) != 1) {
                buffer.append((char)ch);
                if (contentLength == -1 && buffer.toString().endsWith("\r\n\r\n")) {
                    headerBuffer = new StringBuffer(buffer.toString());
                    if (buffer.toString().contains("Content-Length")) {
                        String headers = buffer.toString();
                        String contentLengthHeader = headers.substring(headers.indexOf("Content-Length:"));
                        contentLengthHeader = contentLengthHeader.substring(0, contentLengthHeader.indexOf("\r\n"));
                        contentLength = Integer.parseInt(contentLengthHeader.split(":")[1].trim());
                        buffer.setLength(0);
                    }
                }
                if (buffer.toString().length() != contentLength && System.currentTimeMillis() <= time + (long)this.trigger.READ_TIME_OUT && !buffer.toString().contains("</soapenv:Envelope>")) continue;
            }
            this.trigger.response = headerBuffer.toString() + buffer.toString();
            this.trigger.setFinished(true);
            out = this.connection.getOutputStream();
            out.write("HTTP/1.1 202 Accepted\r\n\r\n".getBytes(Charset.defaultCharset()));
            out.flush();
        }
        catch (IOException ioException) {
            throw new IllegalStateException("wire monitor error occurred", ioException);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.log.warn((Object)"Stream close exception", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.log.warn((Object)"Stream close exception", (Throwable)e);
                }
            }
            try {
                this.connection.close();
                this.providerSocket.close();
            }
            catch (IOException e) {
                this.log.warn((Object)"Error closing provide socket or connection");
            }
        }
    }

    public WireMonitor(int listenPort, WireMonitorServer trigger) {
        this.port = listenPort;
        this.trigger = trigger;
    }
}

