/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.webapp;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class WebAppDeploymentUtil {
    private static Log log = LogFactory.getLog(WebAppDeploymentUtil.class);
    private static int WEB_APP_DEPLOYMENT_DELAY = 90000;

    public static boolean isWebApplicationDeployed(String backEndUrl, String sessionCookie, String webAppFileName) throws APIManagerIntegrationTestException {
        long time;
        WebAppAdminClient webAppAdminClient;
        log.info((Object)("waiting " + WEB_APP_DEPLOYMENT_DELAY + " millis for Service deployment " + webAppFileName));
        try {
            webAppAdminClient = new WebAppAdminClient(backEndUrl, sessionCookie);
        }
        catch (AxisFault axisFault) {
            throw new APIManagerIntegrationTestException("AxisFault Exception occurs when creating the WebAppAdminClient object ", axisFault);
        }
        String webAppName = webAppFileName + ".war";
        boolean isWebAppDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)WEB_APP_DEPLOYMENT_DELAY) {
            List faultyWebAppList;
            List webAppList;
            try {
                webAppList = webAppAdminClient.getWebAppList(webAppFileName);
                faultyWebAppList = webAppAdminClient.getFaultyWebAppList(webAppFileName);
            }
            catch (RemoteException e) {
                throw new APIManagerIntegrationTestException("RemoteException occurs while retrieving the web app list from WebAppAdminClient.", e);
            }
            for (String faultWebAppName : faultyWebAppList) {
                if (!webAppName.equalsIgnoreCase(faultWebAppName)) continue;
                isWebAppDeployed = false;
                log.info((Object)(webAppFileName + "- Web Application is faulty"));
                return isWebAppDeployed;
            }
            for (String name : webAppList) {
                if (!webAppName.equalsIgnoreCase(name)) continue;
                isWebAppDeployed = true;
                log.info((Object)(webAppFileName + " Web Application deployed in " + time + " millis"));
                return isWebAppDeployed;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {
                log.warn((Object)"InterruptedException occurs while waiting sleep for 500 milliseconds");
            }
        }
        return isWebAppDeployed;
    }

    public static void isMonitoringAppDeployed(String webAppURL) {
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + (long)WEB_APP_DEPLOYMENT_DELAY;
        HttpResponse response = null;
        while (waitTime > System.currentTimeMillis()) {
            try {
                response = HttpRequestUtil.sendGetRequest((String)(webAppURL + "/" + "APIStatusMonitor" + "/web_app_status/webapp-info/" + "APIStatusMonitor" + ".war"), null);
            }
            catch (IOException ignore) {
                log.info((Object)"WAIT for webapp deployment  :APIStatusMonitor with expected response : \"isWebAppExists\":true");
            }
            if (response == null) continue;
            if (response.getData().contains("\"isWebAppExists\":true")) {
                log.info((Object)"WEB_APP :APIStatusMonitor found");
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {}
        }
    }
}

