/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.bean;

import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.AbstractRequest;

public class APIRequest
extends AbstractRequest {
    private static final Log log = LogFactory.getLog(APIRequest.class);
    private String name;
    private String context;
    private JSONObject endpoint;
    private String visibility = "public";
    private String version = "1.0.0";
    private String description = "description";
    private String endpointType = "nonsecured";
    private String http_checked = "http";
    private String https_checked = "https";
    private String tags = "tags";
    private String tier = "Silver";
    private String thumbUrl = "";
    private String tiersCollection = "Gold";
    private String type = "http";
    private String resourceCount = "0";
    private String resourceMethod = "GET,POST,PUT,PATCH,DELETE,HEAD";
    private String resourceMethodAuthType = "Application & Application User,Application & Application User";
    private String resourceMethodThrottlingTier = "Unlimited,Unlimited";
    private String uriTemplate = "/*";
    private String roles = "";
    private String wsdl = "";
    private String default_version = "";
    private String default_version_checked = "";
    private String sandbox = "";
    private String provider = "admin";
    private JSONObject corsConfiguration;
    private String environment = "Production and Sandbox";
    private String apiTier = "";
    private String accessControl;
    private String accessControlRoles;

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getSandbox() {
        return this.sandbox;
    }

    public void setSandbox(String sandbox) {
        this.sandbox = sandbox;
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public APIRequest(String apiName, String context, URL endpointUrl) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        try {
            this.endpoint = new JSONObject("{\"production_endpoints\":{\"url\":\"" + endpointUrl + "\",\"config\":null},\"endpoint_type\":\"" + "http" + "\"}");
            this.corsConfiguration = new JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException e) {
            log.error((Object)"JSON construct error", (Throwable)e);
            throw new APIManagerIntegrationTestException("JSON construct error", e);
        }
    }

    public APIRequest(String apiName, String context, URI productionEndpointUri, URI sandboxEndpointUri) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        try {
            this.endpoint = new JSONObject("{\"production_endpoints\":{\"url\":\"" + productionEndpointUri + "\",\"config\":null}, \"sandbox_endpoints\":{\"url\":\"" + sandboxEndpointUri + "\",\"config\":null},\"endpoint_type\":\"" + productionEndpointUri.getScheme() + "\"}");
            this.corsConfiguration = new JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException e) {
            log.error((Object)"JSON construct error", (Throwable)e);
            throw new APIManagerIntegrationTestException("JSON construct error", e);
        }
    }

    public APIRequest(String apiName, String context, URL productionEndpointUrl, URL sandboxEndpointUrl) throws APIManagerIntegrationTestException {
        this.name = apiName;
        this.context = context;
        try {
            this.endpoint = new JSONObject("{\"production_endpoints\":{\"url\":\"" + productionEndpointUrl + "\",\"config\":null}, \"sandbox_endpoints\":{\"url\":\"" + sandboxEndpointUrl + "\",\"config\":null},\"endpoint_type\":\"" + productionEndpointUrl.getProtocol() + "\"}");
            this.corsConfiguration = new JSONObject("{\"corsConfigurationEnabled\" : false, \"accessControlAllowOrigins\" : [\"*\"], \"accessControlAllowCredentials\" : true, \"accessControlAllowHeaders\" : [\"Access-Control-Allow-Origin\", \"authorization\", \"Content-Type\"], \"accessControlAllowMethods\" : [\"POST\", \"PATCH\", \"GET\", \"DELETE\", \"OPTIONS\", \"PUT\"]}");
        }
        catch (JSONException e) {
            log.error((Object)"JSON construct error", (Throwable)e);
            throw new APIManagerIntegrationTestException("JSON construct error", e);
        }
    }

    @Override
    public void setAction() {
        this.setAction("addAPI");
    }

    @Override
    public void setAction(String action) {
        super.setAction(action);
    }

    @Override
    public void init() {
        this.addParameter("name", this.name);
        this.addParameter("context", this.context);
        this.addParameter("endpoint_config", this.endpoint.toString());
        this.addParameter("provider", this.getProvider());
        this.addParameter("visibility", this.getVisibility());
        this.addParameter("accessControl", this.getAccessControl());
        this.addParameter("accessControlRoles", this.getAccessControlRoles());
        this.addParameter("version", this.getVersion());
        this.addParameter("description", this.getDescription());
        this.addParameter("endpointType", this.getEndpointType());
        this.addParameter("http_checked", this.getHttp_checked());
        this.addParameter("https_checked", this.getHttps_checked());
        this.addParameter("tags", this.getTags());
        this.addParameter("tier", this.getTier());
        this.addParameter("thumbUrl", this.getThumbUrl());
        this.addParameter("tiersCollection", this.getTiersCollection());
        this.addParameter("type", this.getType());
        this.addParameter("resourceCount", this.getResourceCount());
        this.addParameter("resourceMethod-0", this.getResourceMethod());
        this.addParameter("resourceMethodAuthType-0", this.getResourceMethodAuthType());
        this.addParameter("resourceMethodThrottlingTier-0", this.getResourceMethodThrottlingTier());
        this.addParameter("uriTemplate-0", this.getUriTemplate());
        this.addParameter("default_version", this.getDefault_version());
        this.addParameter("default_version_checked", this.getDefault_version_checked());
        this.addParameter("environments", this.getEnvironment());
        this.addParameter("corsConfiguration", this.getCorsConfiguration().toString());
        this.addParameter("apiTier", this.getApiTier());
        if (this.roles.length() > 1) {
            this.addParameter("roles", this.getRoles());
        }
        if (this.wsdl.length() > 1) {
            this.addParameter("wsdl", this.getWsdl());
        }
        if (this.sandbox.length() > 1) {
            this.addParameter("sandbox", this.getSandbox());
        }
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getName() {
        return this.name;
    }

    public JSONObject getEndpointConfig() {
        return this.endpoint;
    }

    public String getContext() {
        return this.context;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEndpointType() {
        return this.endpointType;
    }

    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    public String getHttp_checked() {
        return this.http_checked;
    }

    public void setHttp_checked(String http_checked) {
        this.http_checked = http_checked;
    }

    public String getHttps_checked() {
        return this.https_checked;
    }

    public void setHttps_checked(String https_checked) {
        this.https_checked = https_checked;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getTier() {
        return this.tier;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public String getTiersCollection() {
        return this.tiersCollection;
    }

    public void setTiersCollection(String tiersCollection) {
        this.tiersCollection = tiersCollection;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getResourceCount() {
        return this.resourceCount;
    }

    public void setResourceCount(String resourceCount) {
        this.resourceCount = resourceCount;
    }

    public String getResourceMethod() {
        return this.resourceMethod;
    }

    public void setResourceMethod(String resourceMethod) {
        this.resourceMethod = resourceMethod;
    }

    public String getResourceMethodAuthType() {
        return this.resourceMethodAuthType;
    }

    public void setResourceMethodAuthType(String resourceMethodAuthType) {
        this.resourceMethodAuthType = resourceMethodAuthType;
    }

    public String getResourceMethodThrottlingTier() {
        return this.resourceMethodThrottlingTier;
    }

    public void setResourceMethodThrottlingTier(String resourceMethodThrottlingTier) {
        this.resourceMethodThrottlingTier = resourceMethodThrottlingTier;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public String getDefault_version() {
        return this.default_version;
    }

    public void setDefault_version(String default_version) {
        this.default_version = default_version;
    }

    public String getDefault_version_checked() {
        return this.default_version_checked;
    }

    public void setDefault_version_checked(String default_version_checked) {
        this.default_version_checked = default_version_checked;
    }

    public JSONObject getCorsConfiguration() {
        return this.corsConfiguration;
    }

    public void setCorsConfiguration(JSONObject corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    public String getApiTier() {
        return this.apiTier;
    }

    public void setApiTier(String apiTier) {
        this.apiTier = apiTier;
    }

    public String getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(String accessControl) {
        this.accessControl = accessControl;
    }

    public String getAccessControlRoles() {
        return this.accessControlRoles;
    }

    public void setAccessControlRoles(String accessControlRoles) {
        this.accessControlRoles = accessControlRoles;
    }
}

