/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.http;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class HttpRequestUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse sendGetRequest(String endpoint, String requestParameters) throws IOException {
        if (endpoint.startsWith("http://")) {
            String urlStr = endpoint;
            if (requestParameters != null && requestParameters.length() > 0) {
                urlStr = urlStr + "?" + requestParameters;
            }
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setReadTimeout(10000);
            conn.connect();
            StringBuilder sb = new StringBuilder();
            BufferedReader rd = null;
            try {
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
            }
            return new HttpResponse(sb.toString(), conn.getResponseCode());
        }
        return null;
    }

    public static void sendPostRequest(Reader data, URL endpoint, Writer output) throws Exception {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support POST??", e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
            OutputStream out = urlConnection.getOutputStream();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpRequestUtil.pipe(data, writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new Exception("IOException while posting data", e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            InputStream in = urlConnection.getInputStream();
            try {
                InputStreamReader reader = new InputStreamReader(in);
                HttpRequestUtil.pipe(reader, output);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new Exception("IOException while reading response", e);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doPost(URL endpoint, String body) throws Exception {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support POST??", e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            OutputStream out = urlConnection.getOutputStream();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                writer.write(body);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new Exception("IOException while posting data", e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            StringBuilder sb = new StringBuilder();
            BufferedReader rd = null;
            try {
                String line;
                rd = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (FileNotFoundException line) {
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
            }
            Iterator<String> itr = urlConnection.getHeaderFields().keySet().iterator();
            HashMap<String, String> headers = new HashMap<String, String>();
            while (itr.hasNext()) {
                String key = itr.next();
                if (key == null) continue;
                headers.put(key, urlConnection.getHeaderField(key));
            }
            HttpResponse httpResponse = new HttpResponse(sb.toString(), urlConnection.getResponseCode(), headers);
            return httpResponse;
        }
        catch (IOException e) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doPost(URL endpoint, String postBody, Map<String, String> headers) throws Exception {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support POST??", e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            if (headers != null && headers.size() > 0) {
                for (String string : headers.keySet()) {
                    if (string == null) continue;
                    urlConnection.setRequestProperty(string, headers.get(string));
                }
                for (String key : headers.keySet()) {
                    urlConnection.setRequestProperty(key, headers.get(key));
                }
            }
            OutputStream out = urlConnection.getOutputStream();
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(out, "UTF-8");
                outputStreamWriter.write(postBody);
                ((Writer)outputStreamWriter).close();
            }
            catch (IOException iOException) {
                throw new Exception("IOException while posting data", iOException);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader rd = null;
            try {
                String line;
                rd = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                while ((line = rd.readLine()) != null) {
                    stringBuilder.append(line);
                }
            }
            catch (FileNotFoundException line) {
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
            }
            Iterator<String> itr = urlConnection.getHeaderFields().keySet().iterator();
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            while (itr.hasNext()) {
                String key = itr.next();
                if (key == null) continue;
                responseHeaders.put(key, urlConnection.getHeaderField(key));
            }
            HttpResponse httpResponse = new HttpResponse(stringBuilder.toString(), urlConnection.getResponseCode(), responseHeaders);
            return httpResponse;
        }
        catch (IOException e) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpResponse doGet(String endpoint, Map<String, String> headers) throws IOException {
        HttpResponse httpResponse;
        BufferedReader bufferedReader;
        if (!endpoint.startsWith("http://")) return null;
        URL url = new URL(endpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setDoOutput(true);
        conn.setReadTimeout(30000);
        if (headers != null && headers.size() > 0) {
            for (String string : headers.keySet()) {
                if (string == null) continue;
                conn.setRequestProperty(string, headers.get(string));
            }
            for (String key : headers.keySet()) {
                conn.setRequestProperty(key, headers.get(key));
            }
        }
        conn.connect();
        StringBuilder sb = new StringBuilder();
        BufferedReader bufferedReader2 = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            httpResponse = new HttpResponse(sb.toString(), conn.getResponseCode());
            httpResponse.setResponseMessage(conn.getResponseMessage());
            if (bufferedReader == null) return httpResponse;
        }
        catch (IOException ignored) {
            BufferedReader bufferedReader3;
            try {
                String line;
                bufferedReader3 = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                while ((line = bufferedReader3.readLine()) != null) {
                    sb.append(line);
                }
                httpResponse = new HttpResponse(sb.toString(), conn.getResponseCode());
                httpResponse.setResponseMessage(conn.getResponseMessage());
                if (bufferedReader3 == null) return httpResponse;
            }
            catch (Throwable throwable) {
                if (bufferedReader2 == null) throw throwable;
                bufferedReader2.close();
                throw throwable;
            }
            bufferedReader3.close();
            return httpResponse;
        }
        bufferedReader.close();
        return httpResponse;
    }

    public static void sendPostRequest(Reader data, URL endpoint, Writer output, String contentType) throws Exception {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support POST??", e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", contentType);
            OutputStream out = urlConnection.getOutputStream();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpRequestUtil.pipe(data, writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new Exception("IOException while posting data", e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            InputStream in = urlConnection.getInputStream();
            try {
                InputStreamReader reader = new InputStreamReader(in);
                HttpRequestUtil.pipe(reader, output);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new Exception("IOException while reading response", e);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static void sendPutRequest(Reader data, URL endpoint, Writer output, String contentType) throws Exception {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("PUT");
            }
            catch (ProtocolException e) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support PUT??" + e.getMessage(), e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", contentType);
            OutputStream out = urlConnection.getOutputStream();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpRequestUtil.pipe(data, writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new Exception("IOException while posting data" + e.getMessage(), e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            InputStream in = urlConnection.getInputStream();
            try {
                InputStreamReader reader = new InputStreamReader(in);
                HttpRequestUtil.pipe(reader, output);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new Exception("IOException while reading response" + e.getMessage(), e);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e.getMessage(), e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doPut(URL endpoint, String putBody, Map<String, String> headers) throws Exception {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("PUT");
            }
            catch (ProtocolException e) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support PUT??", e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            if (headers != null && headers.size() > 0) {
                for (String string : headers.keySet()) {
                    if (string == null) continue;
                    urlConnection.setRequestProperty(string, headers.get(string));
                }
                for (String key : headers.keySet()) {
                    urlConnection.setRequestProperty(key, headers.get(key));
                }
            }
            OutputStream out = urlConnection.getOutputStream();
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(out, "UTF-8");
                outputStreamWriter.write(putBody);
                ((Writer)outputStreamWriter).close();
            }
            catch (IOException iOException) {
                throw new Exception("IOException while putting data", iOException);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader rd = null;
            try {
                String line;
                rd = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                while ((line = rd.readLine()) != null) {
                    stringBuilder.append(line);
                }
            }
            catch (FileNotFoundException line) {
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
            }
            Iterator<String> itr = urlConnection.getHeaderFields().keySet().iterator();
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            while (itr.hasNext()) {
                String key = itr.next();
                if (key == null) continue;
                responseHeaders.put(key, urlConnection.getHeaderField(key));
            }
            HttpResponse httpResponse = new HttpResponse(stringBuilder.toString(), urlConnection.getResponseCode(), responseHeaders);
            return httpResponse;
        }
        catch (IOException e) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e.getMessage(), e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static int sendDeleteRequest(URL endpoint, String contentType) throws Exception {
        int responseCode;
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("DELETE");
            }
            catch (ProtocolException var33) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support DELETE?? " + var33.getMessage(), var33);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setRequestProperty("Content-type", contentType);
            responseCode = urlConnection.getResponseCode();
        }
        catch (IOException var36) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + var36.getMessage(), var36);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return responseCode;
    }

    public static int doDelete(URL endpoint, Map<String, String> headers) throws Exception {
        int responseCode;
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("DELETE");
            }
            catch (ProtocolException var33) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support DELETE?? " + var33.getMessage(), var33);
            }
            urlConnection.setDoOutput(true);
            if (headers != null && headers.size() > 0) {
                for (String key : headers.keySet()) {
                    if (key == null) continue;
                    urlConnection.setRequestProperty(key, headers.get(key));
                }
                for (String key : headers.keySet()) {
                    urlConnection.setRequestProperty(key, headers.get(key));
                }
            }
            responseCode = urlConnection.getResponseCode();
        }
        catch (IOException var36) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + var36.getMessage(), var36);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return responseCode;
    }

    private static void pipe(Reader reader, Writer writer) throws IOException {
        int read;
        char[] buf = new char[1024];
        while ((read = reader.read(buf)) >= 0) {
            writer.write(buf, 0, read);
        }
        writer.flush();
    }
}

