/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.clients;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.extensions.servers.httpserver.SimpleHttpClient;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class APIStoreRestClient {
    private static final Log log = LogFactory.getLog(APIStoreRestClient.class);
    private String backendURL;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private static final long WAIT_TIME = 90000L;

    public APIStoreRestClient(String backendURL) {
        this.backendURL = backendURL;
        if (this.requestHeaders.get("Content-Type") == null) {
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse login(String userName, String password) throws APIManagerIntegrationTestException {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response;
        log.info((Object)("Login to Store " + this.backendURL + " as the user " + userName));
        ArrayList<NameValuePair> urlParameters = new ArrayList<NameValuePair>();
        urlParameters.add((NameValuePair)new BasicNameValuePair("action", "login"));
        urlParameters.add((NameValuePair)new BasicNameValuePair("username", userName));
        urlParameters.add((NameValuePair)new BasicNameValuePair("password", password));
        try {
            response = HTTPSClientUtils.doPost(this.backendURL + "store/site/blocks/user/login/ajax/login.jag", this.requestHeaders, urlParameters);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to login to the store app ", e);
        }
        String session = this.getSession(response.getHeaders());
        if (session == null) {
            throw new APIManagerIntegrationTestException("No session cookie found with response");
        }
        this.setSession(session);
        return response;
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse subscribe(SubscriptionRequest subscriptionRequest) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-add/ajax/subscription-add.jag"), subscriptionRequest.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Subscription to api fails. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse subscribe(SubscriptionRequest subscriptionRequest, String action) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-add/ajax/subscription-add.jag"), subscriptionRequest.generateRequestParameters(action), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Subscription to api fails. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse generateApplicationKey(APPKeyRequestGenerator generateAppKeyRequest) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            org.wso2.carbon.automation.test.utils.http.client.HttpResponse responseApp = this.getAllApplications();
            String appId = this.getApplicationId(responseApp.getData(), generateAppKeyRequest.getApplication());
            generateAppKeyRequest.setAppId(appId);
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-add/ajax/subscription-add.jag"), generateAppKeyRequest.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Key generation fails. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse generateApplicationKeyById(APPKeyRequestGenerator generateAppKeyRequest) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-add/ajax/subscription-add.jag"), generateAppKeyRequest.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Key generation fails. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAPI() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/api/listing/ajax/list.jag?action=getAllPublishedAPIs"), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve API information. Error: " + e.getMessage(), e);
        }
    }

    private String getSession(Map<String, String> responseHeaders) {
        return responseHeaders.get("Set-Cookie");
    }

    private String setSession(String session) {
        return this.requestHeaders.put("Cookie", session);
    }

    public String getSession() {
        return this.requestHeaders.get("Cookie");
    }

    private void checkAuthentication() throws APIManagerIntegrationTestException {
        if (this.requestHeaders.get("Cookie") == null) {
            throw new APIManagerIntegrationTestException("No Session Cookie found. Please login first");
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse generateUserAccessKey(String consumeKey, String consumerSecret, String messageBody, URL tokenEndpointURL) throws APIManagerIntegrationTestException {
        try {
            HashMap<String, String> authenticationRequestHeaders = new HashMap<String, String>();
            String basicAuthHeader = consumeKey + ":" + consumerSecret;
            byte[] encodedBytes = Base64.encodeBase64((byte[])basicAuthHeader.getBytes("UTF-8"));
            authenticationRequestHeaders.put("Authorization", "Basic " + new String(encodedBytes, "UTF-8"));
            return HTTPSClientUtils.doPost(tokenEndpointURL, messageBody, authenticationRequestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to generate API access token. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAllPublishedAPIs() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/api/listing/ajax/list.jag?action=getAllPublishedAPIs", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get retrieve all published APIs. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAllApplications() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/application/application-list/ajax/application-list.jag?action=getApplications", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve all applications. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getApplicationById(int applicationId) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/application/application-list/ajax/application-list.jag?action=getApplicationById&appId=" + applicationId, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve all applications. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getPublishedAPIsByApplication(String applicationName) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/subscription/subscription-list/ajax/subscription-list.jag?action=getSubscriptionByApplication&app=" + applicationName, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve the application -  " + applicationName + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getPublishedAPIsByApplicationId(String applicationName, int applicationId) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/subscription/subscription-list/ajax/subscription-list.jag?action=getSubscriptionForApplicationById&app=" + applicationName + "&appId=" + applicationId, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve the application -  " + applicationName + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse addRatingToAPI(String apiName, String version, String provider, String rating) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/api/api-info/ajax/api-info.jag?action=addRating&name=" + apiName + "&version=" + version + "&provider=" + provider + "&rating=" + rating, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to rate API -  " + apiName + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse removeRatingFromAPI(String apiName, String version, String provider) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/api/api-info/ajax/api-info.jag?action=removeRating&name=" + apiName + "&version=" + version + "&provider=" + provider, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to remove rating of API -  " + apiName + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse isRatingActivated() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/api/api-info/ajax/api-info.jag?action=isRatingActivated", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Rating status cannot be retrieved. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAllDocumentationOfAPI(String apiName, String version, String provider) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/api/listing/ajax/list.jag?action=getAllDocumentationOfApi&name=" + apiName + "&version=" + version + "&provider=" + provider, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve documentation for - " + apiName + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getApiEndpointUrls(String apiName, String version, String provider) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/api/api-info/ajax/api-info.jag?action=getAPIEndpointURLs&name=" + apiName + "&version=" + version + "&provider=" + provider, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve documentation for - " + apiName + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAllPaginatedPublishedAPIs(String tenant, String start, String end) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/api/listing/ajax/list.jag?action=getAllPaginatedPublishedAPIs&tenant=" + tenant + "&start=" + start + "&end=" + end, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve paginated published APIs for tenant - " + tenant + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse cleanUpApplicationRegistrationByApplicationId(int applicationId, String applicationName) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            String requestData = "action=cleanUpApplicationRegistrationByApplicationId&appId=" + applicationId + "&applicationName=" + applicationName + "&keyType=PRODUCTION";
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-add/ajax/subscription-add.jag?" + requestData), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to cleanup application - " + applicationName + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAllPaginatedPublishedAPIs(String tenant, int start, int end) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/api/listing/ajax/list.jag?action=getAllPaginatedPublishedAPIs&tenant=" + tenant + "&start=" + start + "&end=" + end, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve paginated published APIs for tenant - " + tenant + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAllPublishedAPIs(String tenant) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/api/listing/ajax/list.jag?action=getAllPublishedAPIs&tenant=" + tenant), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to retrieve published APIs for tenant - " + tenant + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse addApplication(String application, String tier, String callbackUrl, String description) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/application/application-add/ajax/application-add.jag?action=addApplication&tier=" + tier + "&callbackUrl=" + callbackUrl + "&description=" + description + "&application=" + application), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to add application - " + application + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse addApplicationWithGroup(String application, String tier, String callbackUrl, String description, String groupId) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/application/application-add/ajax/application-add.jag?action=addApplication&tier=" + tier + "&callbackUrl=" + callbackUrl + "&description=" + description + "&application=" + application + "&groupId=" + groupId), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to add application - " + application + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse addApplicationWithTokenType(String application, String tier, String callbackUrl, String description, String tokenType) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/application/application-add/ajax/application-add.jag?action=addApplication&tier=" + tier + "&callbackUrl=" + callbackUrl + "&description=" + description + "&application=" + application + "&tokenType=" + tokenType), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to add application - " + application + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getApplications() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/application/application-list/ajax/application-list.jag?action=getApplications"), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get applications. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse removeApplication(String application) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/application/application-remove/ajax/application-remove.jag?action=removeApplication&application=" + application), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to remove application - " + application + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse removeApplicationById(int applicationId) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/application/application-remove/ajax/application-remove.jag?action=removeApplicationById&appId=" + applicationId), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to remove application - " + applicationId + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse updateApplication(String applicationOld, String applicationNew, String callbackUrlNew, String descriptionNew, String tier) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/application/application-update/ajax/application-update.jag?action=updateApplication&applicationOld=" + applicationOld + "&applicationNew=" + applicationNew + "&callbackUrlNew=" + callbackUrlNew + "&descriptionNew=" + descriptionNew + "&tier=" + tier), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update application - " + applicationOld + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse updateApplicationById(int applicationId, String applicationOld, String applicationNew, String callbackUrlNew, String descriptionNew, String tier) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/application/application-update/ajax/application-update.jag?action=updateApplicationById&applicationOld=" + applicationOld + "&applicationNew=" + applicationNew + "&appId=" + applicationId + "&callbackUrlNew=" + callbackUrlNew + "&descriptionNew=" + descriptionNew + "&tier=" + tier), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update application - " + applicationOld + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse updateClientApplication(String application, String keyType, String authorizedDomains, String retryAfterFailure, String jsonParams, String callbackUrl) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/store/site/blocks/subscription/subscription-add/ajax/subscription-add.jag?action=updateClientApplication&application=" + application + "&keytype=" + keyType + "&authorizedDomains=" + authorizedDomains + "&retryAfterFailure=" + retryAfterFailure + "&jsonParams=" + URLEncoder.encode(jsonParams, "UTF-8") + "&callbackUrl=" + callbackUrl), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update application - " + application + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse updateClientApplicationById(int applicationId, String application, String keyType, String authorizedDomains, String retryAfterFailure, String jsonParams, String callbackUrl) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/store/site/blocks/subscription/subscription-add/ajax/subscription-add.jag?action=updateClientApplicationByAppId&appId=" + applicationId + "&application=" + application + "&keytype=" + keyType + "&authorizedDomains=" + authorizedDomains + "&retryAfterFailure=" + retryAfterFailure + "&jsonParams=" + URLEncoder.encode(jsonParams, "UTF-8") + "&callbackUrl=" + callbackUrl), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to update application - " + application + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse regenerateConsumerSecret(String clientId) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/store/site/blocks/subscription/subscription-add/ajax/subscription-add.jag?action=regenerateConsumerSecret&clientId=" + clientId), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to regenerate consumer secrete.  Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAllSubscriptions() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-list/ajax/subscription-list.jag?action=getAllSubscriptions"), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get all subscriptions. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAllSubscriptionsOfApplication() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-list/ajax/subscription-list.jag?action=getAllSubscriptionsOfApplication"), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get all subscriptions. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAllSubscriptionsOfApplication(String selectedApplication) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-list/ajax/subscription-list.jag?action=getAllSubscriptionsOfApplication&selectedApp=" + selectedApplication), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get all subscriptions. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getSubscribedAPIs(String applicationName) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-list/ajax/subscription-list.jag?action=getAllSubscriptions&selectedApp=" + applicationName), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get all subscribed APIs. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getSubscribedAPIs(String applicationName, String domain) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-list/ajax/subscription-list.jag?action=getAllSubscriptions&selectedApp=" + applicationName + "&tenant=" + domain), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get all subscribed APIs. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse removeAPISubscription(String API2, String version, String provider, String applicationId) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-remove/ajax/subscription-remove.jag?action=removeSubscription&name=" + API2 + "&version=" + version + "&provider=" + provider + "&applicationId=" + applicationId), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get all subscriptions. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse removeAPISubscriptionByApplicationName(String API2, String version, String provider, String applicationName) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/subscription/subscription-remove/ajax/subscription-remove.jag?action=removeSubscription&name=" + API2 + "&version=" + version + "&provider=" + provider + "&applicationName=" + applicationName), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get all subscriptions. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse removeAPISubscriptionByName(String API2, String version, String provider, String appName) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            org.wso2.carbon.automation.test.utils.http.client.HttpResponse responseApp = this.getAllApplications();
            String appId = this.getApplicationId(responseApp.getData(), appName);
            return this.removeAPISubscription(API2, version, provider, appId);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to remove subscriptions API:" + API2 + " Version: " + version + "Provider: " + provider + "App Name: " + appName + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAllTags() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/tag/tag-cloud/ajax/list.jag?action=getAllTags"), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get all tags. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse addComment(String apiName, String version, String provider, String comment) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/comment/comment-add/ajax/comment-add.jag?action=addComment&name=" + apiName + "&version=" + version + "&provider=" + provider + "&comment=" + comment), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable add a comment in to API - " + apiName + ". Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse isCommentActivated() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/comment/comment-add/ajax/comment-add.jag?action=isCommentActivated", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Failed to get comment activation status. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getRecentlyAddedAPIs(String tenant, String limit) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/api/recently-added/ajax/list.jag?action=getRecentlyAddedAPIs&tenant=" + tenant + "&limit=" + limit), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Failed to get recently added APIs from tenant - " + tenant + ". Error: " + e.getMessage(), e);
        }
    }

    private String getApplicationId(String jsonStringOfApplications, String applicationName) throws APIManagerIntegrationTestException {
        String applicationId = null;
        try {
            JSONObject obj = new JSONObject(jsonStringOfApplications);
            JSONArray arr = obj.getJSONArray("applications");
            for (int i = 0; i < arr.length(); ++i) {
                String appName = arr.getJSONObject(i).getString("name");
                if (!applicationName.equals(appName)) continue;
                applicationId = arr.getJSONObject(i).getString("id");
            }
        }
        catch (JSONException e) {
            throw new APIManagerIntegrationTestException("getting application Id failed. Error: " + e.getMessage(), e);
        }
        return applicationId;
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAPIPageFilteredWithTags(String apiTag) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "/store/apis/list?tag=" + apiTag + "&tenant=carbon.super", this.requestHeaders);
        }
        catch (IOException ex) {
            throw new APIManagerIntegrationTestException("Exception when get APO page filtered by tag. Error: " + ex.getMessage(), ex);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse subscribeToAPI(SubscriptionRequest subscriptionRequest) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "/store/site/blocks/subscription/subscription-add/ajax/subscription-add.jag"), subscriptionRequest.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception ex) {
            throw new APIManagerIntegrationTestException("Exception when Subscribing to a API. Error: " + ex.getMessage(), ex);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getAPIListFromStoreAsAnonymousUser(String tenantDomain) throws APIManagerIntegrationTestException {
        try {
            org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse = HTTPSClientUtils.doGet(this.backendURL + "store/site/blocks/api/recently-added/ajax/list.jag?action=getRecentlyAddedAPIs&tenant=" + tenantDomain, new HashMap<String, String>());
            if (new JSONObject(httpResponse.getData()).getBoolean("error")) {
                throw new APIManagerIntegrationTestException("Error when getting API list as AsAnonymousUser");
            }
            return httpResponse;
        }
        catch (IOException ioE) {
            throw new APIManagerIntegrationTestException("Exception when retrieve the API list as anonymous user. Error: " + ioE.getMessage(), ioE);
        }
        catch (JSONException e) {
            throw new APIManagerIntegrationTestException("Response message is not JSON Response. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse logout() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/user/login/ajax/login.jag"), "action=logout", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Error in store app logout. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse signUp(String userName, String password, String firstName, String lastName, String email) throws APIManagerIntegrationTestException {
        try {
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/user/sign-up/ajax/user-add.jag"), "action=addUser&username=" + userName + "&password=" + password + "&allFieldsValues=" + firstName + "|" + lastName + "|" + email, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Error in user sign up. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse signUpforTenant(String userName, String password, String claims) throws APIManagerIntegrationTestException {
        try {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
            return HttpRequestUtil.doPost((URL)new URL(this.backendURL + "/store/site/blocks/user/sign-up/ajax/user-add.jag?tenant=wso2.com"), (String)("action=addUser&username=" + userName + "&password=" + password + "&allFieldsValues=" + claims), requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Error in user sign up. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse signUpWithOrganization(String userName, String password, String firstName, String lastName, String email, String organization) throws APIManagerIntegrationTestException {
        try {
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/user/sign-up/ajax/user-add.jag"), "action=addUser&username=" + userName + "&password=" + password + "&allFieldsValues=" + firstName + "|" + lastName + "|" + organization + "|" + email, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Error in user sign up. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getPrototypedAPI(String tenant) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doGet(this.backendURL + "store/site/pages/list-prototyped-apis.jag?tenant=" + tenant, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get prototype APIs. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse searchPaginateAPIs(String tenant, String start, String end, String searchTerm) throws Exception {
        this.checkAuthentication();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = HTTPSClientUtils.doPost(new URL(this.backendURL + "/store/site/blocks/search/api-search/ajax/search.jag?"), "action=searchAPIs&tenant=" + tenant + "&start=" + start + "&end=" + end + "&query=" + searchTerm, this.requestHeaders);
        if (response.getResponseCode() == 200) {
            return response;
        }
        throw new Exception("Get API Information failed> " + response.getData());
    }

    public void waitForSwaggerDocument(String userName, String apiName, String apiVersion, String expectedResponse, String executionMode) throws IOException, XPathExpressionException {
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + 90000L;
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = null;
        if (executionMode.equalsIgnoreCase(String.valueOf(ExecutionEnvironment.PLATFORM))) {
            while (waitTime > System.currentTimeMillis()) {
                log.info((Object)("WAIT for swagger document of API :" + apiName + " with version: " + apiVersion + " user :" + userName + " with expected response : " + expectedResponse));
                try {
                    response = this.getSwaggerDocument(userName, apiName, apiVersion, executionMode);
                }
                catch (APIManagerIntegrationTestException aPIManagerIntegrationTestException) {
                    // empty catch block
                }
                if (response != null) {
                    if (!response.getData().contains(expectedResponse)) continue;
                    log.info((Object)("API :" + apiName + " with version: " + apiVersion + " with expected response " + expectedResponse + " found"));
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getSwaggerDocument(String userName, String apiName, String apiVersion, String executionMode) throws APIManagerIntegrationTestException {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = null;
        if (executionMode.equalsIgnoreCase(String.valueOf(ExecutionEnvironment.PLATFORM))) {
            try {
                this.checkAuthentication();
                String tenant = MultitenantUtils.getTenantDomain((String)userName);
                response = HTTPSClientUtils.doGet(this.backendURL + "store/api-docs/" + tenant + "/" + apiName + "/" + apiVersion, null);
            }
            catch (IOException ex) {
                throw new APIManagerIntegrationTestException("Exception when get APO page filtered by tag. Error: " + ex.getMessage(), ex);
            }
        }
        return response;
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse getApplicationPage() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/pages/applications.jag"), "", this.requestHeaders);
        }
        catch (APIManagerIntegrationTestException e) {
            throw new APIManagerIntegrationTestException("No Session Cookie found. Please login first. Error: " + e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            throw new APIManagerIntegrationTestException("Unable to get application page, URL is not valid. Error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to get application page. Error: " + e.getMessage(), e);
        }
    }

    public HttpResponse generateSDKUpdated(String sdkLanguage, String apiName, String apiVersion, String apiProvider, String tenant) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            SimpleHttpClient httpClient = new SimpleHttpClient();
            String restURL = this.backendURL + "store/site/blocks/sdk/ajax/sdk-create.jag?action=generateSDK&apiName=" + apiName + "&apiVersion=" + apiVersion + "&tenant=" + tenant + "&language=java";
            return httpClient.doGet(restURL, this.requestHeaders);
        }
        catch (IOException e) {
            throw new APIManagerIntegrationTestException("Error in generating SDK for API : " + apiName + " API version : " + apiVersion + " Error : " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse changePassword(String username, String currentPassword, String newPassword) throws APIManagerIntegrationTestException {
        try {
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/user/user-info/ajax/user-info.jag?action=changePassword&username=" + username + "&currentPassword=" + currentPassword + "&newPassword=" + newPassword), "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to change password. Error: " + e.getMessage(), e);
        }
    }

    public org.wso2.carbon.automation.test.utils.http.client.HttpResponse addApplicationWithCustomAttributes(String application, String tier, String callbackUrl, String description, String applicationAttributes) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            String urlAppAttributes = URLEncoder.encode(applicationAttributes, "UTF-8");
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "store/site/blocks/application/application-add/ajax/application-add.jag?action=addApplication&tier=" + tier + "&callbackUrl=" + callbackUrl + "&description=" + description + "&application=" + application + "&applicationAttributes=" + urlAppAttributes), "", this.requestHeaders);
        }
        catch (IOException e) {
            String message = "Unable to add application - " + application + " with custom attributes. Error: " + e.getMessage();
            log.error((Object)message);
            throw new APIManagerIntegrationTestException(message, e);
        }
    }
}

