/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.impl;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.v1.ApIsApi;
import org.wso2.am.integration.clients.publisher.api.v1.ApiAuditApi;
import org.wso2.am.integration.clients.publisher.api.v1.ApiDocumentsApi;
import org.wso2.am.integration.clients.publisher.api.v1.ApiLifecycleApi;
import org.wso2.am.integration.clients.publisher.api.v1.ApiProductsApi;
import org.wso2.am.integration.clients.publisher.api.v1.ClientCertificatesApi;
import org.wso2.am.integration.clients.publisher.api.v1.EndpointCertificatesApi;
import org.wso2.am.integration.clients.publisher.api.v1.GraphQlSchemaApi;
import org.wso2.am.integration.clients.publisher.api.v1.GraphQlSchemaIndividualApi;
import org.wso2.am.integration.clients.publisher.api.v1.RolesApi;
import org.wso2.am.integration.clients.publisher.api.v1.SubscriptionsApi;
import org.wso2.am.integration.clients.publisher.api.v1.ThrottlingPoliciesApi;
import org.wso2.am.integration.clients.publisher.api.v1.UnifiedSearchApi;
import org.wso2.am.integration.clients.publisher.api.v1.ValidationApi;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIBusinessInformationDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APICorsConfigurationDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIEndpointSecurityDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ApiEndpointValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertMetadataDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ClientCertMetadataDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLSchemaDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.LifecycleHistoryDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.LifecycleStateDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.OpenAPIDefinitionValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SearchResultListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ThrottlingPolicyListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.WorkflowResponseDTO;
import org.wso2.am.integration.test.ClientAuthenticator;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class RestAPIPublisherImpl {
    public ApIsApi apIsApi = new ApIsApi();
    private ApiProductsApi apiProductsApi = new ApiProductsApi();
    public ApiDocumentsApi apiDocumentsApi = new ApiDocumentsApi();
    public ThrottlingPoliciesApi throttlingPoliciesApi = new ThrottlingPoliciesApi();
    public ClientCertificatesApi clientCertificatesApi = new ClientCertificatesApi();
    public EndpointCertificatesApi endpointCertificatesApi = new EndpointCertificatesApi();
    public GraphQlSchemaApi graphQlSchemaApi = new GraphQlSchemaApi();
    public GraphQlSchemaIndividualApi graphQlSchemaIndividualApi = new GraphQlSchemaIndividualApi();
    public ApiLifecycleApi apiLifecycleApi = new ApiLifecycleApi();
    public RolesApi rolesApi = new RolesApi();
    public ValidationApi validationApi = new ValidationApi();
    public SubscriptionsApi subscriptionsApi = new SubscriptionsApi();
    public ApiAuditApi apiAuditApi = new ApiAuditApi();
    public UnifiedSearchApi unifiedSearchApi = new UnifiedSearchApi();
    public ApiClient apiPublisherClient = new ApiClient();
    public static final String appName = "Integration_Test_App_Publisher";
    public static final String callBackURL = "test.com";
    public static final String tokenScope = "Production";
    public static final String appOwner = "admin";
    public static final String grantType = "password";
    public static final String username = "admin";
    public static final String password = "admin";
    public String tenantDomain;

    @Deprecated
    public RestAPIPublisherImpl() {
        this("admin", "admin", "", "https://localhost:9943");
    }

    public RestAPIPublisherImpl(String username, String password, String tenantDomain, String publisherURL) {
        String tokenURL = publisherURL + "oauth2/token";
        String dcrURL = publisherURL + "client-registration/v0.16/register";
        String accessToken = ClientAuthenticator.getAccessToken("openid apim:api_view apim:api_create apim:api_delete apim:api_publish apim:subscription_view apim:subscription_block apim:external_services_discover apim:threat_protection_policy_create apim:threat_protection_policy_manage apim:document_create apim:document_manage apim:mediation_policy_view apim:mediation_policy_create apim:mediation_policy_manage apim:client_certificates_view apim:client_certificates_add apim:client_certificates_update apim:ep_certificates_view apim:ep_certificates_add apim:ep_certificates_update apim:publisher_settings apim:pub_alert_manage", appName, callBackURL, tokenScope, "admin", grantType, dcrURL, username, password, tenantDomain, tokenURL);
        this.apiPublisherClient.addDefaultHeader("Authorization", "Bearer " + accessToken);
        this.apiPublisherClient.setBasePath(publisherURL + "api/am/publisher/v1");
        this.apIsApi.setApiClient(this.apiPublisherClient);
        this.apiProductsApi.setApiClient(this.apiPublisherClient);
        this.graphQlSchemaApi.setApiClient(this.apiPublisherClient);
        this.graphQlSchemaIndividualApi.setApiClient(this.apiPublisherClient);
        this.apiDocumentsApi.setApiClient(this.apiPublisherClient);
        this.throttlingPoliciesApi.setApiClient(this.apiPublisherClient);
        this.apiLifecycleApi.setApiClient(this.apiPublisherClient);
        this.rolesApi.setApiClient(this.apiPublisherClient);
        this.validationApi.setApiClient(this.apiPublisherClient);
        this.clientCertificatesApi.setApiClient(this.apiPublisherClient);
        this.subscriptionsApi.setApiClient(this.apiPublisherClient);
        this.apiAuditApi.setApiClient(this.apiPublisherClient);
        this.unifiedSearchApi.setApiClient(this.apiPublisherClient);
        this.tenantDomain = tenantDomain;
    }

    public HttpResponse addAPI(APIRequest apiRequest) throws ApiException {
        String osVersion = "v3";
        APIDTO apidto = this.addAPI(apiRequest, osVersion);
        HttpResponse response = null;
        if (apidto != null && StringUtils.isNotEmpty((String)apidto.getId())) {
            response = new HttpResponse(apidto.getId(), 201);
        }
        return response;
    }

    public APIDTO addAPI(APIRequest apiRequest, String osVersion) throws ApiException {
        APIDTO apidto;
        ArrayList<String> roleList;
        APIDTO body = new APIDTO();
        body.setName(apiRequest.getName());
        body.setContext(apiRequest.getContext());
        body.setVersion(apiRequest.getVersion());
        if (apiRequest.getVisibility() != null) {
            body.setVisibility(APIDTO.VisibilityEnum.valueOf((String)apiRequest.getVisibility().toUpperCase()));
            if (APIDTO.VisibilityEnum.RESTRICTED.getValue().equalsIgnoreCase(apiRequest.getVisibility()) && StringUtils.isNotEmpty((String)apiRequest.getRoles())) {
                roleList = new ArrayList<String>(Arrays.asList(apiRequest.getRoles().split(" , ")));
                body.setVisibleRoles(roleList);
            }
        } else {
            body.setVisibility(APIDTO.VisibilityEnum.PUBLIC);
        }
        if (apiRequest.getAccessControl() != null) {
            body.setAccessControl(APIDTO.AccessControlEnum.valueOf((String)apiRequest.getAccessControl().toUpperCase()));
            if (APIDTO.AccessControlEnum.RESTRICTED.getValue().equalsIgnoreCase(apiRequest.getAccessControl()) && StringUtils.isNotEmpty((String)apiRequest.getAccessControlRoles())) {
                roleList = new ArrayList<String>(Arrays.asList(apiRequest.getAccessControlRoles().split(" , ")));
                body.setAccessControlRoles(roleList);
            }
        } else {
            body.setAccessControl(APIDTO.AccessControlEnum.NONE);
        }
        body.setDescription(apiRequest.getDescription());
        body.setProvider(apiRequest.getProvider());
        ArrayList<String> transports = new ArrayList<String>();
        if ("http".equals(apiRequest.getHttp_checked())) {
            transports.add("http");
        }
        if ("https".equals(apiRequest.getHttps_checked())) {
            transports.add("https");
        }
        body.setTransport(transports);
        body.isDefaultVersion(Boolean.valueOf(false));
        body.setCacheTimeout(Integer.valueOf(100));
        ArrayList<String> gatewayEnvironments = new ArrayList<String>();
        gatewayEnvironments.add(apiRequest.getEnvironment());
        body.setGatewayEnvironments(gatewayEnvironments);
        if (apiRequest.getOperationsDTOS() != null) {
            body.setOperations(apiRequest.getOperationsDTOS());
        } else {
            ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
            APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
            apiOperationsDTO.setVerb("GET");
            apiOperationsDTO.setTarget("/*");
            apiOperationsDTO.setAuthType("Application & Application User");
            apiOperationsDTO.setThrottlingPolicy("Unlimited");
            operations.add(apiOperationsDTO);
            body.setOperations(operations);
        }
        body.setMediationPolicies(apiRequest.getMediationPolicies());
        body.setBusinessInformation((Object)new APIBusinessInformationDTO());
        body.setCorsConfiguration(new APICorsConfigurationDTO());
        body.setTags(Arrays.asList(apiRequest.getTags().split(",")));
        body.setEndpointConfig((Object)apiRequest.getEndpointConfig());
        body.setSecurityScheme(apiRequest.getSecurityScheme());
        body.setType(APIDTO.TypeEnum.fromValue((String)apiRequest.getType()));
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Unlimited");
        body.setPolicies(Arrays.asList(apiRequest.getTiersCollection().split(",")));
        body.isDefaultVersion(Boolean.valueOf(apiRequest.getDefault_version_checked()));
        try {
            ApiResponse httpInfo = this.apIsApi.apisPostWithHttpInfo(body, osVersion);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
            apidto = (APIDTO)httpInfo.getData();
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        return apidto;
    }

    public APIDTO addAPI(APIDTO apidto, String osVersion) throws ApiException {
        ApiResponse httpInfo = this.apIsApi.apisPostWithHttpInfo(apidto, osVersion);
        Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
        return (APIDTO)httpInfo.getData();
    }

    public String createNewAPIVersion(String newVersion, String apiId, boolean defaultVersion) throws ApiException {
        String apiLocation = (String)((List)this.apIsApi.apisCopyApiPostWithHttpInfo(newVersion, apiId, Boolean.valueOf(defaultVersion)).getHeaders().get("Location")).get(0);
        String[] splitValues = apiLocation.split("/");
        return splitValues[splitValues.length - 1];
    }

    private String getJsonContent(String fileName) throws IOException {
        if (StringUtils.isNotEmpty((String)fileName)) {
            return IOUtils.toString((InputStream)RestAPIPublisherImpl.class.getClassLoader().getResourceAsStream(fileName), (String)StandardCharsets.UTF_8.name());
        }
        return null;
    }

    public HttpResponse changeAPILifeCycleStatus(String apiId, String action, String lifecycleChecklist) throws ApiException {
        WorkflowResponseDTO workflowResponseDTO = this.apiLifecycleApi.apisChangeLifecyclePost(action, apiId, lifecycleChecklist, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)workflowResponseDTO.getLifecycleState().getState())) {
            response = new HttpResponse(workflowResponseDTO.getLifecycleState().getState(), 200);
        }
        return response;
    }

    public WorkflowResponseDTO changeAPILifeCycleStatus(String apiId, String action) throws ApiException {
        ApiResponse workflowResponseDTOApiResponse = this.apiLifecycleApi.apisChangeLifecyclePostWithHttpInfo(action, apiId, null, null);
        Assert.assertEquals((int)200, (int)workflowResponseDTOApiResponse.getStatusCode());
        return (WorkflowResponseDTO)workflowResponseDTOApiResponse.getData();
    }

    public void deprecateAPI(String apiId) throws ApiException {
        this.apiLifecycleApi.apisChangeLifecyclePost("Deprecate", apiId, null, null);
    }

    public void deployPrototypeAPI(String apiId) throws ApiException {
        this.apiLifecycleApi.apisChangeLifecyclePost("Deploy as a Prototype", apiId, null, null);
    }

    public void blockAPI(String apiId) throws ApiException {
        this.apiLifecycleApi.apisChangeLifecyclePost("Block", apiId, null, null);
    }

    public HttpResponse getLifecycleStatus(String apiId) throws ApiException {
        LifecycleStateDTO lifecycleStateDTO = this.apiLifecycleApi.apisApiIdLifecycleStateGet(apiId, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)lifecycleStateDTO.getState())) {
            response = new HttpResponse(lifecycleStateDTO.getState(), 200);
        }
        return response;
    }

    public LifecycleStateDTO getLifecycleStatusDTO(String apiId) throws ApiException {
        ApiResponse apiResponse = this.apiLifecycleApi.apisApiIdLifecycleStateGetWithHttpInfo(apiId, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
        return (LifecycleStateDTO)apiResponse.getData();
    }

    public LifecycleHistoryDTO getLifecycleHistory(String apiId) throws ApiException {
        ApiResponse apiResponse = this.apiLifecycleApi.apisApiIdLifecycleHistoryGetWithHttpInfo(apiId, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
        return (LifecycleHistoryDTO)apiResponse.getData();
    }

    public HttpResponse copyAPI(String newVersion, String apiId, Boolean isDefault) throws ApiException {
        APIDTO apiDto = this.apIsApi.apisCopyApiPost(newVersion, apiId, isDefault);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)apiDto.getId())) {
            response = new HttpResponse(apiDto.getId(), 200);
        }
        return response;
    }

    public APIDTO copyAPIWithReturnDTO(String newVersion, String apiId, Boolean isDefault) throws ApiException {
        ApiResponse response = this.apIsApi.apisCopyApiPostWithHttpInfo(newVersion, apiId, isDefault);
        Assert.assertEquals((int)201, (int)response.getStatusCode());
        return (APIDTO)response.getData();
    }

    public HttpResponse updateAPI(APIRequest apiRequest, String apiId) throws ApiException {
        APIDTO apidto;
        ArrayList<String> roleList;
        APIDTO body = new APIDTO();
        body.setName(apiRequest.getName());
        body.setContext(apiRequest.getContext());
        body.setVersion(apiRequest.getVersion());
        if (apiRequest.getVisibility() != null) {
            body.setVisibility(APIDTO.VisibilityEnum.valueOf((String)apiRequest.getVisibility().toUpperCase()));
            if (APIDTO.VisibilityEnum.RESTRICTED.getValue().equalsIgnoreCase(apiRequest.getVisibility()) && StringUtils.isNotEmpty((String)apiRequest.getRoles())) {
                roleList = new ArrayList<String>(Arrays.asList(apiRequest.getRoles().split(" , ")));
                body.setVisibleRoles(roleList);
            }
        } else {
            body.setVisibility(APIDTO.VisibilityEnum.PUBLIC);
        }
        if (apiRequest.getAccessControl() != null) {
            body.setAccessControl(APIDTO.AccessControlEnum.valueOf((String)apiRequest.getAccessControl().toUpperCase()));
            if (APIDTO.AccessControlEnum.RESTRICTED.getValue().equalsIgnoreCase(apiRequest.getAccessControl()) && StringUtils.isNotEmpty((String)apiRequest.getAccessControlRoles())) {
                roleList = new ArrayList<String>(Arrays.asList(apiRequest.getAccessControlRoles().split(" , ")));
                body.setAccessControlRoles(roleList);
            }
        } else {
            body.setAccessControl(APIDTO.AccessControlEnum.NONE);
        }
        body.setDescription(apiRequest.getDescription());
        body.setProvider(apiRequest.getProvider());
        ArrayList<String> transports = new ArrayList<String>();
        if ("http".equals(apiRequest.getHttp_checked())) {
            transports.add("http");
        }
        if ("https".equals(apiRequest.getHttps_checked())) {
            transports.add("https");
        }
        body.setTransport(transports);
        body.isDefaultVersion(Boolean.valueOf(false));
        body.setCacheTimeout(Integer.valueOf(100));
        ArrayList<String> gatewayEnvironments = new ArrayList<String>();
        gatewayEnvironments.add(apiRequest.getEnvironment());
        body.setGatewayEnvironments(gatewayEnvironments);
        body.setMediationPolicies(apiRequest.getMediationPolicies());
        if (apiRequest.getOperationsDTOS() != null) {
            body.setOperations(apiRequest.getOperationsDTOS());
        } else {
            ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
            APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
            apiOperationsDTO.setVerb("GET");
            apiOperationsDTO.setTarget("/*");
            apiOperationsDTO.setAuthType("Application & Application User");
            apiOperationsDTO.setThrottlingPolicy("Unlimited");
            operations.add(apiOperationsDTO);
            body.setOperations(operations);
        }
        body.setBusinessInformation((Object)new APIBusinessInformationDTO());
        body.setCorsConfiguration(new APICorsConfigurationDTO());
        body.setTags(Arrays.asList(apiRequest.getTags().split(",")));
        body.setEndpointConfig((Object)apiRequest.getEndpointConfig());
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Unlimited");
        body.setPolicies(Arrays.asList(apiRequest.getTiersCollection().split(",")));
        try {
            apidto = this.apIsApi.apisApiIdPut(apiId, body, null);
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)apidto.getId())) {
            response = new HttpResponse(apidto.getId(), 200);
        }
        return response;
    }

    public APIDTO updateAPI(APIDTO apidto, String apiId) throws ApiException {
        ApiResponse apiDtoApiResponse = this.apIsApi.apisApiIdPutWithHttpInfo(apiId, apidto, null);
        Assert.assertEquals((int)200, (int)apiDtoApiResponse.getStatusCode());
        return (APIDTO)apiDtoApiResponse.getData();
    }

    public HttpResponse getAPI(String apiId) throws ApiException {
        APIDTO apidto = null;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            apidto = this.apIsApi.apisApiIdGet(apiId, null, null);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (StringUtils.isNotEmpty((String)apidto.getId())) {
            response = new HttpResponse(gson.toJson((Object)apidto), 200);
        }
        return response;
    }

    public HttpResponse deleteAPI(String apiId) throws ApiException {
        ApiResponse deleteResponse = this.apIsApi.apisApiIdDeleteWithHttpInfo(apiId, null);
        HttpResponse response = null;
        if (deleteResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully deleted the API", 200);
        }
        return response;
    }

    public void deleteAPIByID(String apiId) throws ApiException {
        if (apiId == null) {
            return;
        }
        ApiResponse deleteResponse = this.apIsApi.apisApiIdDeleteWithHttpInfo(apiId, null);
        Assert.assertEquals((int)200, (int)deleteResponse.getStatusCode());
    }

    public HttpResponse removeDocumentation(String apiId, String docId) throws ApiException {
        ApiResponse deleteResponse = this.apiDocumentsApi.apisApiIdDocumentsDocumentIdDeleteWithHttpInfo(apiId, docId, null);
        HttpResponse response = null;
        if (deleteResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully removed the documentation", 200);
        }
        return response;
    }

    public HttpResponse revokeAccessToken(String accessToken, String consumerKey, String authUser) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse updatePermissions(String tierName, String permissionType, String roles) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse updateResourceOfAPI(String apiId, String api) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse checkValidEndpoint(String endpointUrl, String apiId) throws APIManagerIntegrationTestException, ApiException {
        ApiEndpointValidationResponseDTO validationResponseDTO = this.validationApi.validateEndpoint(endpointUrl, endpointUrl);
        HttpResponse response = null;
        if (validationResponseDTO.getStatusCode() == 200) {
            response = new HttpResponse(validationResponseDTO.getStatusMessage(), 200);
        }
        return response;
    }

    public HttpResponse changeAPILifeCycleStatusToPublish(String apiId, boolean isRequireReSubscription) throws ApiException {
        ApiResponse responseDTOApiResponse = this.apiLifecycleApi.apisChangeLifecyclePostWithHttpInfo("Publish", apiId, "Re-Subscription:" + isRequireReSubscription, null);
        HttpResponse response = null;
        if (responseDTOApiResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully changed the lifecycle of the API", 200);
        }
        return response;
    }

    public HttpResponse getTierPermissionsPage() throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse addDocument(String apiId, DocumentDTO body) throws ApiException {
        DocumentDTO doc = this.apiDocumentsApi.apisApiIdDocumentsPost(apiId, body, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)doc.getDocumentId())) {
            response = new HttpResponse(doc.getDocumentId(), 200);
        }
        return response;
    }

    public HttpResponse addContentDocument(String apiId, String docId, String docContent) throws ApiException {
        DocumentDTO doc = this.apiDocumentsApi.apisApiIdDocumentsDocumentIdContentPost(apiId, docId, null, docContent, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)doc.getDocumentId())) {
            response = new HttpResponse("Successfully created the documentation", 200);
        }
        return response;
    }

    public HttpResponse updateContentDocument(String apiId, String docId, File docContent) throws ApiException {
        DocumentDTO doc = this.apiDocumentsApi.apisApiIdDocumentsDocumentIdContentPost(apiId, docId, docContent, null, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)doc.getDocumentId())) {
            response = new HttpResponse("Successfully update the documentation", 200);
        }
        return response;
    }

    public HttpResponse updateDocument(String apiId, String docId, DocumentDTO documentDTO) throws ApiException {
        DocumentDTO doc = this.apiDocumentsApi.apisApiIdDocumentsDocumentIdPut(apiId, docId, documentDTO, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)doc.getDocumentId())) {
            response = new HttpResponse("Successfully created the documentation", 200);
        }
        return response;
    }

    public DocumentListDTO getDocuments(String apiId) throws ApiException {
        ApiResponse apiResponse = this.apiDocumentsApi.apisApiIdDocumentsGetWithHttpInfo(apiId, null, null, null);
        Assert.assertEquals((int)200, (int)apiResponse.getStatusCode());
        return (DocumentListDTO)apiResponse.getData();
    }

    public HttpResponse getDocumentContent(String apiId, String documentId) throws ApiException {
        ApiResponse apiResponse = this.apiDocumentsApi.apisApiIdDocumentsDocumentIdContentGetWithHttpInfo(apiId, documentId, null);
        HttpResponse response = null;
        if (apiResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully retrieved the Document content", 200);
        }
        return response;
    }

    public HttpResponse deleteDocument(String apiId, String documentId) throws ApiException {
        ApiResponse deleteResponse = this.apiDocumentsApi.apisApiIdDocumentsDocumentIdDeleteWithHttpInfo(apiId, documentId, null);
        HttpResponse response = null;
        if (deleteResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully deleted the Document", 200);
        }
        return response;
    }

    public APIListDTO getAllAPIs() throws APIManagerIntegrationTestException, ApiException {
        APIListDTO apis = this.apIsApi.apisGet(null, null, null, null, null, null, null);
        if (apis.getCount() > 0) {
            return apis;
        }
        return null;
    }

    public SearchResultListDTO searchAPIs(String query) throws ApiException {
        ApiResponse searchResponse = this.unifiedSearchApi.searchGetWithHttpInfo(null, null, query, null);
        Assert.assertEquals((int)200, (int)searchResponse.getStatusCode());
        return (SearchResultListDTO)searchResponse.getData();
    }

    public APIListDTO getAPIs(int offset, int limit) throws ApiException {
        ApiResponse apiResponse = this.apIsApi.apisGetWithHttpInfo(Integer.valueOf(limit), Integer.valueOf(offset), this.tenantDomain, null, null, Boolean.valueOf(false), null);
        Assert.assertEquals((int)200, (int)apiResponse.getStatusCode());
        return (APIListDTO)apiResponse.getData();
    }

    public HttpResponse uploadEndpointCertificate(File certificate, String alias, String endpoint) throws ApiException {
        CertMetadataDTO certificateDTO = this.endpointCertificatesApi.endpointCertificatesPost(certificate, alias, endpoint);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)certificateDTO.getAlias())) {
            response = new HttpResponse("Successfully uploaded the certificate", 200);
        }
        return response;
    }

    public ThrottlingPolicyListDTO getTiers(String policyLevel) throws ApiException {
        ThrottlingPolicyListDTO policies = this.throttlingPoliciesApi.getAllThrottlingPolicies(policyLevel, null, null, null);
        if (policies.getCount() > 0) {
            return policies;
        }
        return null;
    }

    public ApiResponse<Void> validateRoles(String roleId) throws ApiException {
        String encodedRoleName = Base64.getUrlEncoder().encodeToString(roleId.getBytes());
        return this.rolesApi.validateSystemRoleWithHttpInfo(encodedRoleName);
    }

    public String getSwaggerByID(String apiId) throws ApiException {
        ApiResponse response = this.apIsApi.apisApiIdSwaggerGetWithHttpInfo(apiId, null);
        Assert.assertEquals((int)200, (int)response.getStatusCode());
        return (String)response.getData();
    }

    public String updateSwagger(String apiId, String definition) throws ApiException {
        ApiResponse apiResponse = this.apIsApi.apisApiIdSwaggerPutWithHttpInfo(apiId, definition, null, null, null);
        Assert.assertEquals((int)200, (int)apiResponse.getStatusCode());
        return (String)apiResponse.getData();
    }

    public OpenAPIDefinitionValidationResponseDTO validateOASDefinition(File oasDefinition) throws ApiException {
        ApiResponse response = this.validationApi.validateOpenAPIDefinitionWithHttpInfo(null, oasDefinition, Boolean.valueOf(false));
        Assert.assertEquals((int)200, (int)response.getStatusCode());
        return (OpenAPIDefinitionValidationResponseDTO)response.getData();
    }

    public APIDTO getAPIByID(String apiId, String tenantDomain) throws ApiException {
        ApiResponse apiDtoApiResponse = this.apIsApi.apisApiIdGetWithHttpInfo(apiId, tenantDomain, null);
        Assert.assertEquals((int)200, (int)apiDtoApiResponse.getStatusCode());
        return (APIDTO)apiDtoApiResponse.getData();
    }

    public APIDTO importOASDefinition(File file, String properties) throws ApiException {
        ApiResponse apiDtoApiResponse = this.apIsApi.importOpenAPIDefinitionWithHttpInfo(file, null, properties);
        Assert.assertEquals((int)201, (int)apiDtoApiResponse.getStatusCode());
        return (APIDTO)apiDtoApiResponse.getData();
    }

    public GraphQLValidationResponseDTO validateGraphqlSchemaDefinition(File schemaDefinition) throws ApiException {
        ApiResponse response = this.validationApi.apisValidateGraphqlSchemaPostWithHttpInfo(schemaDefinition);
        Assert.assertEquals((int)200, (int)response.getStatusCode());
        return (GraphQLValidationResponseDTO)response.getData();
    }

    public APIDTO importGraphqlSchemaDefinition(File file, String properties) throws ApiException {
        ApiResponse apiDtoApiResponse = this.apIsApi.apisImportGraphqlSchemaPostWithHttpInfo("GRAPHQL", file, properties, null);
        Assert.assertEquals((int)201, (int)apiDtoApiResponse.getStatusCode());
        return (APIDTO)apiDtoApiResponse.getData();
    }

    public GraphQLSchemaDTO getGraphqlSchemaDefinition(String apiId) throws ApiException {
        ApiResponse schemaDefinitionDTO = this.graphQlSchemaIndividualApi.apisApiIdGraphqlSchemaGetWithHttpInfo(apiId, "application/json", null);
        Assert.assertEquals((int)200, (int)schemaDefinitionDTO.getStatusCode());
        return (GraphQLSchemaDTO)schemaDefinitionDTO.getData();
    }

    public void updateGraphqlSchemaDefinition(String apiId, String schemaDefinition) throws ApiException {
        ApiResponse schemaDefinitionDTO = this.graphQlSchemaApi.apisApiIdGraphqlSchemaPutWithHttpInfo(apiId, schemaDefinition, null);
        Assert.assertEquals((int)200, (int)schemaDefinitionDTO.getStatusCode());
    }

    public APIDTO addAPI(APICreationRequestBean apiCreationRequestBean) throws ApiException {
        APIDTO body = new APIDTO();
        body.setName(apiCreationRequestBean.getName());
        body.setContext(apiCreationRequestBean.getContext());
        body.setVersion(apiCreationRequestBean.getVersion());
        if (apiCreationRequestBean.getVisibility() != null) {
            body.setVisibility(APIDTO.VisibilityEnum.valueOf((String)apiCreationRequestBean.getVisibility().toUpperCase()));
            if (APIDTO.VisibilityEnum.RESTRICTED.getValue().equalsIgnoreCase(apiCreationRequestBean.getVisibility()) && StringUtils.isNotEmpty((String)apiCreationRequestBean.getRoles())) {
                ArrayList<String> roleList = new ArrayList<String>(Arrays.asList(apiCreationRequestBean.getRoles().split(" , ")));
                body.setVisibleRoles(roleList);
            }
        } else {
            body.setVisibility(APIDTO.VisibilityEnum.PUBLIC);
        }
        body.setDescription(apiCreationRequestBean.getDescription());
        body.setProvider(apiCreationRequestBean.getProvider());
        body.setTransport((List)new ArrayList<String>(){
            {
                this.add("http");
                this.add("https");
            }
        });
        body.isDefaultVersion(Boolean.valueOf(false));
        body.setCacheTimeout(Integer.valueOf(100));
        ArrayList<String> gatewayEnvironments = new ArrayList<String>();
        gatewayEnvironments.add(apiCreationRequestBean.getEnvironment());
        body.setGatewayEnvironments(gatewayEnvironments);
        ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
        for (APIResourceBean resourceBean : apiCreationRequestBean.getResourceBeanList()) {
            APIOperationsDTO dto = new APIOperationsDTO();
            dto.setTarget(resourceBean.getUriTemplate());
            dto.setAuthType(resourceBean.getResourceMethodAuthType());
            dto.setVerb(resourceBean.getResourceMethod());
            dto.setThrottlingPolicy(resourceBean.getResourceMethodThrottlingTier());
            operations.add(dto);
        }
        body.setOperations(operations);
        body.setBusinessInformation((Object)new APIBusinessInformationDTO());
        body.setCorsConfiguration(new APICorsConfigurationDTO());
        body.setTags(Arrays.asList(apiCreationRequestBean.getTags().split(",")));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"endpoint_type", (Object)"http");
        JSONObject sandUrl = new JSONObject();
        sandUrl.put((Object)"url", (Object)apiCreationRequestBean.getEndpointUrl().toString());
        jsonObject.put((Object)"sandbox_endpoints", (Object)sandUrl);
        jsonObject.put((Object)"production_endpoints", (Object)sandUrl);
        body.setEndpointConfig((Object)jsonObject);
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Unlimited");
        if (apiCreationRequestBean.getSubPolicyCollection() != null) {
            String[] tiers;
            for (String tier : tiers = apiCreationRequestBean.getSubPolicyCollection().split(",")) {
                tierList.add(tier);
            }
        }
        body.setPolicies(tierList);
        if (APIEndpointSecurityDTO.TypeEnum.BASIC.getValue().equalsIgnoreCase(apiCreationRequestBean.getEndpointType())) {
            APIEndpointSecurityDTO dto = new APIEndpointSecurityDTO();
            dto.setUsername(apiCreationRequestBean.getEpUsername());
            dto.setPassword(apiCreationRequestBean.getEpPassword());
            dto.setType(APIEndpointSecurityDTO.TypeEnum.BASIC);
            body.setEndpointSecurity(dto);
        }
        ApiResponse httpInfo = this.apIsApi.apisPostWithHttpInfo(body, "v3");
        Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
        return (APIDTO)httpInfo.getData();
    }

    public HttpResponse uploadCertificate(File certificate, String alias, String apiId, String tier) throws ApiException {
        ClientCertMetadataDTO certificateDTO = this.clientCertificatesApi.apisApiIdClientCertificatesPost(certificate, alias, apiId, tier);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)certificateDTO.getAlias())) {
            response = new HttpResponse("Successfully uploaded the certificate", 200);
        }
        return response;
    }

    public APIDTO updateAPI(APIDTO apidto) throws ApiException {
        ApiResponse response = this.apIsApi.apisApiIdPutWithHttpInfo(apidto.getId(), apidto, null);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        return (APIDTO)response.getData();
    }

    public SubscriptionListDTO getSubscriptionByAPIID(String apiID) throws ApiException {
        ApiResponse apiResponse = this.subscriptionsApi.subscriptionsGetWithHttpInfo(apiID, Integer.valueOf(10), Integer.valueOf(0), null, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
        return (SubscriptionListDTO)apiResponse.getData();
    }

    public APIProductListDTO getAllApiProducts() throws ApiException {
        ApiResponse apiResponse = this.apiProductsApi.apiProductsGetWithHttpInfo(null, null, null, null, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
        return (APIProductListDTO)apiResponse.getData();
    }

    public APIProductDTO getApiProduct(String apiProductId) throws ApiException {
        ApiResponse apiResponse = this.apiProductsApi.apiProductsApiProductIdGetWithHttpInfo(apiProductId, null, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
        return (APIProductDTO)apiResponse.getData();
    }

    public APIProductDTO addApiProduct(APIProductDTO apiProductDTO) throws ApiException {
        ApiResponse apiResponse = this.apiProductsApi.apiProductsPostWithHttpInfo(apiProductDTO);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)201);
        return (APIProductDTO)apiResponse.getData();
    }

    public void deleteApiProduct(String apiProductId) throws ApiException {
        ApiResponse apiResponse = this.apiProductsApi.apiProductsApiProductIdDeleteWithHttpInfo(apiProductId, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
    }

    public HttpResponse getAuditApi(String apiId) throws ApiException {
        HttpResponse response = null;
        ApiResponse auditReportResponse = this.apiAuditApi.apisApiIdAuditapiGetWithHttpInfo(apiId, "application/json");
        if (auditReportResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully audited the report", 200);
        }
        return response;
    }
}

