/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils;

import java.io.IOException;
import java.rmi.RemoteException;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.wso2.am.admin.clients.client.utils.AuthenticateStub;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.user.mgt.stub.UserAdminStub;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;
import org.wso2.carbon.user.mgt.stub.types.carbon.ClaimValue;

public class UserManagementUtils {
    private static UserAdminStub userAdminStub;
    private static final String serviceName = "UserAdmin";
    private static final Log log;

    public static void addUser(String userName, String password, String backendURL, String[] roleList, String adminUsername, String adminPassword, String email) throws RemoteException, UserAdminUserAdminException {
        String endPoint = backendURL + serviceName;
        userAdminStub = new UserAdminStub(endPoint);
        AuthenticateStub.authenticateStub((String)adminUsername, (String)adminPassword, (Stub)userAdminStub);
        ClaimValue claimValue = new ClaimValue();
        claimValue.setClaimURI("email");
        claimValue.setValue(email);
        ClaimValue[] claims = new ClaimValue[]{claimValue};
        userAdminStub.addUser(userName, password, roleList, claims, null);
    }

    public static void signupUser(String userName, String password, String firstName, String organization) throws IOException, APIManagerIntegrationTestException {
        CloseableHttpClient client = HTTPSClientUtils.getHttpsClient();
        HttpPost postRequest = new HttpPost("https://localhost:9943/api/identity/user/v1.0/me");
        postRequest.addHeader("Authorization", "Basic " + APIMTestCaseUtils.encodeCredentials("admin", "admin".toCharArray()));
        postRequest.addHeader("Content-Type", "application/json");
        StringEntity payload = new StringEntity("{\"user\":{\"username\": \"" + userName + "\", \"password\": \"" + password + "\",\"claims\": [{\"uri\": \"http://wso2.org/claims/givenname\",\"value\": \"" + firstName + "\" },{\"uri\": \"http://wso2.org/claims/organization\",\"value\": \"" + organization + "\"}]}, \"properties\": []}");
        postRequest.setEntity((HttpEntity)payload);
        CloseableHttpResponse response = client.execute((HttpUriRequest)postRequest);
        if (response.getStatusLine().getStatusCode() != 201) {
            log.error((Object)("Error occurred in self sing up a new user with user name " + userName));
            throw new APIManagerIntegrationTestException("Error occurred in self sign-up a new user. Expected response code 201, but returned " + response.getStatusLine().getStatusCode());
        }
    }

    public static void signupUser(String userName, String password, String firstName, String organization, String email) throws IOException, APIManagerIntegrationTestException {
        CloseableHttpClient client = HTTPSClientUtils.getHttpsClient();
        HttpPost postRequest = new HttpPost("https://localhost:9943/api/identity/user/v1.0/me");
        postRequest.addHeader("Authorization", "Basic " + APIMTestCaseUtils.encodeCredentials("admin", "admin".toCharArray()));
        postRequest.addHeader("Content-Type", "application/json");
        StringEntity payload = new StringEntity("{\"user\":{\"username\": \"" + userName + "\", \"password\": \"" + password + "\",\"claims\": [{\"uri\": \"http://wso2.org/claims/givenname\",\"value\": \"" + firstName + "\" },{\"uri\": \"http://wso2.org/claims/emailaddress\",\"value\": \"" + email + "\" },{\"uri\": \"http://wso2.org/claims/organization\",\"value\": \"" + organization + "\"}]}, \"properties\": []}");
        postRequest.setEntity((HttpEntity)payload);
        CloseableHttpResponse response = client.execute((HttpUriRequest)postRequest);
        if (response.getStatusLine().getStatusCode() != 201) {
            log.error((Object)("Error occurred in self sing up a new user with user name " + userName));
            throw new APIManagerIntegrationTestException("Error occurred in self sign-up a new user. Expected response code 201, but returned " + response.getStatusLine().getStatusCode());
        }
    }

    static {
        log = LogFactory.getLog(UserManagementUtils.class);
    }
}

