/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.clients;

import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTierRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AdminDashboardRestClient {
    private static final Log log = LogFactory.getLog(AdminDashboardRestClient.class);
    private String backendURL;
    private Map<String, String> requestHeaders = new HashMap<String, String>();

    public AdminDashboardRestClient(String backendURL) {
        this.backendURL = backendURL;
        if (this.requestHeaders.get("Content-Type") == null) {
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        }
    }

    public HttpResponse login(String userName, String password) throws APIManagerIntegrationTestException {
        HttpResponse response;
        log.info((Object)("Login to Admin Portal " + this.backendURL + " as the user " + userName));
        try {
            response = HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/user/login/ajax/login.jag"), "action=login&username=" + userName + "&password=" + password + "", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Unable to login to the store app ", e);
        }
        String session = this.getSession(response.getHeaders());
        if (session == null) {
            throw new APIManagerIntegrationTestException("No session cookie found with response");
        }
        this.setSession(session);
        return response;
    }

    public HttpResponse addTier(APIThrottlingTierRequest throttlingTierRequest) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/tier/edit/ajax/tier-edit.jag"), throttlingTierRequest.generateRequestParameters(), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Add new tier failed", e);
        }
    }

    public HttpResponse addThrottlingPolicy(String throttlingPolicyJSON) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            this.requestHeaders.put("Accept", "application/json, text/javascript");
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/policy/resource/policy-add/ajax/policy-operations.jag"), "action=addApiPolicy&apiPolicy=" + URLEncoder.encode(throttlingPolicyJSON, "UTF-8"), this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Add new policy failed", e);
        }
    }

    public HttpResponse addApplicationPolicyWithBandwidthType(String name, int bandwidth, String bandwidthUnit, int defaultUnitTime, String defaultTimeUnit) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            this.requestHeaders.put("Accept", "application/json, text/javascript");
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/policy/app/edit/ajax/app-policy-edit.jag"), "action=add&policyName=" + name + "&description=&defaultQuotaPolicy=bandwidthVolume&defaultRequestCount=&defaultBandwidth=" + bandwidth + "&defaultBandwidthUnit=" + bandwidthUnit + "&defaultUnitTime=" + defaultUnitTime + "&defaultTimeUnit=" + defaultTimeUnit + "&stopOnQuotaReach=false&attributes=%5B%5D", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Add new policy failed", e);
        }
    }

    public HttpResponse addSubscriptionPolicyWithBandwidthType(String name, int bandwidth, String bandwidthUnit, int defaultUnitTime, String defaultTimeUnit, boolean stopOnQuotaReach, int rateLimit, String rateLimitTimeUnit) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            this.requestHeaders.put("Accept", "application/json, text/javascript");
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/policy/subscription/edit/ajax/subscription-policy-edit.jag"), "action=add&policyName=" + name + "&description=&defaultQuotaPolicy=bandwidthVolume&defaultRequestCount=&defaultBandwidth=" + bandwidth + "&defaultBandwidthUnit=" + bandwidthUnit + "&defaultUnitTime=" + defaultUnitTime + "&defaultTimeUnit=" + defaultTimeUnit + "&rateLimitCount=" + rateLimit + "&rateLimitTimeUnit=" + rateLimitTimeUnit + "&stopOnQuotaReach=" + stopOnQuotaReach + "&tierPlan=FREE&monetizationPlan=FixedRate&fixedRate=&billingCycle=week&pricePerRequest=&currencyType=&permissionType=allow&roles=Internal%2Feveryone&attributes=%5B%5D", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Add new policy failed", e);
        }
    }

    public HttpResponse deleteSubscriptionPolicy(String name) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            this.requestHeaders.put("Accept", "application/json, text/javascript");
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/policy/subscription/manage/ajax/subscription-policy-manage.jag"), "action=deleteSubscriptionPolicy&policy=" + name, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Delete subscription policy failed", e);
        }
    }

    public HttpResponse deleteAPIPolicy(String name) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            this.requestHeaders.put("Accept", "application/json, text/javascript");
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/policy/resource/policy-list/ajax/api-policy-manage.jag"), "action=deleteAPIPolicy&policy=" + name, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Delete subscription policy failed", e);
        }
    }

    public HttpResponse deleteApplicationPolicy(String name) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            this.requestHeaders.put("Accept", "application/json, text/javascript");
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/policy/app/manage/ajax/app-policy-manage.jag"), "action=deleteAppPolicy&policy=" + name, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Delete subscription policy failed", e);
        }
    }

    public HttpResponse deleteTier(String tierName) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/tier/manage/ajax/tier-manage.jag"), "action=deleteTier&tier=" + tierName, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Delete tier failed", e);
        }
    }

    public HttpResponse getAllTiers() throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/tier/manage/ajax/tier-manage.jag"), "action=getAllTiers", this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Get all tiers failed", e);
        }
    }

    public HttpResponse getapplicationsByTenantId(String search, String start, String draw, String offset, String columnId, String sortOrder) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/application-owner/get-applications/ajax/get-applications.jag"), "action=getApplicationsByTenantIdWithPagination&start=" + start + "&length=" + offset + "&search[value]=" + search + "&draw=" + draw + "&order[0][column]=" + columnId + "&order[0][dir]=" + sortOrder, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Get all applications with pagination failed", e);
        }
    }

    public HttpResponse updateApplicationOwner(String newOwner, String oldOwner, String uuid, String appName) throws APIManagerIntegrationTestException {
        try {
            this.checkAuthentication();
            return HTTPSClientUtils.doPost(new URL(this.backendURL + "admin/site/blocks/application-owner/change-owner/ajax/change-owner.jag"), "action=changeOwner&newOwner=" + newOwner + "&oldOwner=" + oldOwner + "&applicationUuid=" + uuid + "&applicationName=" + appName, this.requestHeaders);
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException("Updating application owner failed", e);
        }
    }

    private String getSession(Map<String, String> responseHeaders) {
        return responseHeaders.get("Set-Cookie");
    }

    private String setSession(String session) {
        return this.requestHeaders.put("Cookie", session);
    }

    private void checkAuthentication() throws APIManagerIntegrationTestException {
        if (this.requestHeaders.get("Cookie") == null) {
            throw new APIManagerIntegrationTestException("No Session Cookie found. Please login first");
        }
    }
}

