/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.impl;

import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.KeyManagerCollectionApi;
import org.wso2.am.integration.clients.admin.api.KeyManagerIndividualApi;
import org.wso2.am.integration.clients.admin.api.SettingsApi;
import org.wso2.am.integration.clients.admin.api.dto.KeyManagerDTO;
import org.wso2.am.integration.clients.admin.api.dto.KeyManagerListDTO;
import org.wso2.am.integration.clients.admin.api.dto.SettingsDTO;
import org.wso2.am.integration.test.ClientAuthenticator;

public class RestAPIAdminImpl {
    public ApiClient apiAdminClient = new ApiClient();
    private KeyManagerCollectionApi keyManagerCollectionApi = new KeyManagerCollectionApi();
    private KeyManagerIndividualApi keyManagerIndividualApi = new KeyManagerIndividualApi();
    private SettingsApi settingsApi = new SettingsApi();
    public static final String appName = "Integration_Test_App_Admin";
    public static final String callBackURL = "test.com";
    public static final String tokenScope = "Production";
    public static final String appOwner = "admin";
    public static final String grantType = "password";
    public static final String username = "admin";
    public static final String password = "admin";
    public String tenantDomain;

    public RestAPIAdminImpl(String username, String password, String tenantDomain, String adminURl) {
        String tokenURL = adminURl + "oauth2/token";
        String dcrURL = adminURl + "client-registration/v0.16/register";
        String accessToken = ClientAuthenticator.getAccessToken("openid apim:admin_operations", appName, callBackURL, tokenScope, "admin", grantType, dcrURL, username, password, tenantDomain, tokenURL);
        this.apiAdminClient.addDefaultHeader("Authorization", "Bearer " + accessToken);
        this.apiAdminClient.setBasePath(adminURl + "api/am/admin/v1");
        this.apiAdminClient.setDebugging(true);
        this.keyManagerCollectionApi.setApiClient(this.apiAdminClient);
        this.keyManagerIndividualApi.setApiClient(this.apiAdminClient);
        this.settingsApi.setApiClient(this.apiAdminClient);
        this.tenantDomain = tenantDomain;
    }

    public ApiResponse<KeyManagerDTO> addKeyManager(KeyManagerDTO keyManagerDTO) throws ApiException {
        return this.keyManagerCollectionApi.keyManagersPostWithHttpInfo(keyManagerDTO);
    }

    public KeyManagerListDTO getKeyManagers() throws ApiException {
        return this.keyManagerCollectionApi.keyManagersGet();
    }

    public KeyManagerDTO getKeyManager(String uuid) throws ApiException {
        return this.keyManagerIndividualApi.keyManagersKeyManagerIdGet(uuid);
    }

    public KeyManagerDTO updateKeyManager(String uuid, KeyManagerDTO keyManagerDTO) throws ApiException {
        return this.keyManagerIndividualApi.keyManagersKeyManagerIdPut(uuid, keyManagerDTO);
    }

    public void deleteKeyManager(String uuid) throws ApiException {
        this.keyManagerIndividualApi.keyManagersKeyManagerIdDelete(uuid);
    }

    public SettingsDTO getSettings() throws ApiException {
        return this.settingsApi.settingsGet();
    }
}

