/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.bean;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.AbstractRequest;

public class APIImplementationBean
extends AbstractRequest {
    private static final Log log = LogFactory.getLog(APICreationRequestBean.class);
    private String implementMethod = "endpoint";
    private JSONObject endpoint;
    private String name = "";
    private String version = "";
    private String provider = "";
    private String swagger = "";

    public APIImplementationBean(String name, String version, String provider, URL prototypeEndpointUrl) throws Exception {
        this.name = name;
        this.version = version;
        this.provider = provider;
        try {
            this.endpoint = new JSONObject("{\"production_endpoints\":{\"url\":\"" + prototypeEndpointUrl + "\",\"config\":null},\"endpoint_type\":\"" + prototypeEndpointUrl.getProtocol() + "\",\"implementation_status\":\"prototyped\"}");
        }
        catch (JSONException e) {
            log.error((Object)"JSON construct error", (Throwable)e);
            throw new APIManagerIntegrationTestException(" Error When constructing the end point url JSON", e);
        }
    }

    @Override
    public void setAction() {
        this.setAction("implement");
    }

    @Override
    public void setAction(String action) {
        super.setAction(action);
    }

    @Override
    public void init() {
        this.addParameter("implementation_methods", this.implementMethod);
        this.addParameter("endpoint_config", this.endpoint.toString());
        this.addParameter("name", this.name);
        this.addParameter("version", this.version);
        this.addParameter("provider", this.provider);
        this.addParameter("swagger", this.swagger);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getSwagger() {
        return this.swagger;
    }

    public void setSwagger(String swagger) {
        this.swagger = swagger;
    }

    public String getImplementMethod() {
        return this.implementMethod;
    }

    public void setImplementMethod(String implementMethod) {
        this.implementMethod = implementMethod;
    }
}

