/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.generic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.wso2.am.admin.clients.endpoint.EndPointAdminClient;
import org.wso2.am.admin.clients.localentry.LocalEntriesAdminClient;
import org.wso2.am.admin.clients.mediation.MessageProcessorClient;
import org.wso2.am.admin.clients.mediation.MessageStoreAdminClient;
import org.wso2.am.admin.clients.mediation.PriorityMediationAdminClient;
import org.wso2.am.admin.clients.proxy.admin.ProxyServiceAdminClient;
import org.wso2.am.admin.clients.rest.api.RestApiAdminClient;
import org.wso2.am.admin.clients.sequences.SequenceAdminServiceClient;
import org.wso2.am.admin.clients.service.mgt.ServiceAdminClient;
import org.wso2.am.admin.clients.tasks.TaskAdminClient;
import org.wso2.am.admin.clients.template.EndpointTemplateAdminServiceClient;
import org.wso2.am.admin.clients.template.SequenceTemplateAdminServiceClient;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIBean;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.endpoint.stub.types.EndpointAdminEndpointAdminException;
import org.wso2.carbon.localentry.stub.types.LocalEntryAdminException;
import org.wso2.carbon.message.store.stub.Exception;
import org.wso2.carbon.proxyadmin.stub.ProxyServiceAdminProxyAdminException;
import org.wso2.carbon.rest.api.stub.RestApiAdminAPIException;
import org.wso2.carbon.sequences.stub.types.SequenceEditorException;
import org.wso2.carbon.task.stub.TaskManagementException;

public class APIMTestCaseUtils {
    private static final Log log = LogFactory.getLog(APIMTestCaseUtils.class);
    private static int SERVICE_DEPLOYMENT_DELAY = TestConfigurationProvider.getServiceDeploymentDelay();
    private static final String PROXY = "proxy";
    private static final String LOCAL_ENTRY = "localEntry";
    private static final String ENDPOINT = "endpoint";
    private static final String SEQUENCE = "sequence";
    private static final String MESSAGE_STORE = "messageStore";
    private static final String MESSAGE_PROCESSOR = "messageProcessor";
    private static final String TEMPLATE = "template";
    private static final String API = "api";
    private static final String PRIORITY_EXECUTOR = "priorityExecutor";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String VERSION = "version";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMElement loadResource(String path) throws FileNotFoundException, XMLStreamException {
        OMElement documentElement = null;
        FileInputStream inputStream = null;
        XMLStreamReader parser = null;
        StAXOMBuilder builder = null;
        path = TestConfigurationProvider.getResourceLocation() + path;
        File file = new File(path);
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
                parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                builder = new StAXOMBuilder(parser);
                documentElement = builder.getDocumentElement().cloneOMElement();
            }
            finally {
                if (builder != null) {
                    builder.close();
                }
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new FileNotFoundException("File Not Exist at " + path);
        return documentElement;
    }

    public static void updateSynapseConfiguration(OMElement synapseConfig, String backendURL, String sessionCookie) throws java.lang.Exception {
        ProxyServiceAdminClient proxyAdmin = new ProxyServiceAdminClient(backendURL, sessionCookie);
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backendURL, sessionCookie);
        SequenceAdminServiceClient sequenceAdminClient = new SequenceAdminServiceClient(backendURL, sessionCookie);
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backendURL, sessionCookie);
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backendURL, sessionCookie);
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backendURL, sessionCookie);
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backendURL, sessionCookie);
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backendURL, sessionCookie);
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backendURL, sessionCookie);
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backendURL, sessionCookie);
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backendURL, sessionCookie);
        APIMTestCaseUtils.checkLocalEntries(synapseConfig, backendURL, sessionCookie, localEntryAdminServiceClient);
        APIMTestCaseUtils.checkEndPoints(synapseConfig, backendURL, sessionCookie, endPointAdminClient);
        APIMTestCaseUtils.checkSequences(synapseConfig, backendURL, sessionCookie, sequenceAdminClient);
        APIMTestCaseUtils.checkProxies(synapseConfig, backendURL, sessionCookie, proxyAdmin, adminServiceService);
        APIMTestCaseUtils.checkMessageStores(synapseConfig, backendURL, sessionCookie, messageStoreAdminClient);
        APIMTestCaseUtils.checkMessageProcessors(synapseConfig, backendURL, sessionCookie, messageProcessorClient);
        APIMTestCaseUtils.checkTemplates(synapseConfig, backendURL, sessionCookie, endpointTemplateAdminServiceClient, sequenceTemplateAdminServiceClient);
        APIMTestCaseUtils.checkAPIs(synapseConfig, backendURL, sessionCookie, apiAdminClient);
        APIMTestCaseUtils.checkPriorityExecutors(synapseConfig, backendURL, sessionCookie, priorityMediationAdminClient);
        Thread.sleep(1000L);
        APIMTestCaseUtils.verifySynapseDeployment(synapseConfig, backendURL, sessionCookie);
        log.info((Object)"Synapse configuration  Deployed");
    }

    private static void checkPriorityExecutors(OMElement synapseConfig, String backendURL, String sessionCookie, PriorityMediationAdminClient priorityMediationAdminClient) throws RemoteException {
        Iterator priorityExecutorList = synapseConfig.getChildrenWithLocalName(PRIORITY_EXECUTOR);
        while (priorityExecutorList.hasNext()) {
            OMElement executor = (OMElement)priorityExecutorList.next();
            String executorName = executor.getAttributeValue(new QName(NAME));
            if (ArrayUtils.contains((Object[])priorityMediationAdminClient.getExecutorList(), (Object)executorName)) {
                priorityMediationAdminClient.remove(executorName);
                Assert.assertTrue((boolean)APIMTestCaseUtils.isPriorityExecutorUnDeployed(backendURL, sessionCookie, executorName), (String)(executorName + " Priority Executor undeployment failed"));
            }
            priorityMediationAdminClient.addPriorityMediator(executorName, executor);
            log.info((Object)(executorName + " Priority Executor Uploaded"));
        }
    }

    private static void checkAPIs(OMElement synapseConfig, String backendURL, String sessionCookie, RestApiAdminClient apiAdminClient) throws RestApiAdminAPIException, RemoteException {
        Iterator apiElements = synapseConfig.getChildrenWithLocalName(API);
        while (apiElements.hasNext()) {
            OMElement api = (OMElement)apiElements.next();
            String apiName = api.getAttributeValue(new QName(NAME));
            if (ArrayUtils.contains((Object[])apiAdminClient.getApiNames(), (Object)apiName)) {
                apiAdminClient.deleteApi(apiName);
                Assert.assertTrue((boolean)APIMTestCaseUtils.isApiUnDeployed(backendURL, sessionCookie, apiName), (String)(apiName + " Api undeployment failed"));
            }
            apiAdminClient.add(api);
            log.info((Object)(apiName + " API Uploaded"));
        }
    }

    private static void checkTemplates(OMElement synapseConfig, String backendURL, String sessionCookie, EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient, SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient) throws RemoteException, EndpointAdminEndpointAdminException {
        Iterator templates = synapseConfig.getChildrenWithLocalName(TEMPLATE);
        while (templates.hasNext()) {
            OMElement template = (OMElement)templates.next();
            String templateName = template.getAttributeValue(new QName(NAME));
            if (template.getFirstChildWithName(new QName(template.getNamespace().getNamespaceURI(), SEQUENCE)) != null) {
                if (ArrayUtils.contains((Object[])sequenceTemplateAdminServiceClient.getSequenceTemplates(), (Object)templateName)) {
                    sequenceTemplateAdminServiceClient.deleteTemplate(templateName);
                    Assert.assertTrue((boolean)APIMTestCaseUtils.isSequenceTemplateUnDeployed(backendURL, sessionCookie, templateName), (String)(templateName + " Sequence Template undeployment failed"));
                }
                sequenceTemplateAdminServiceClient.addSequenceTemplate(template);
            } else {
                if (ArrayUtils.contains((Object[])endpointTemplateAdminServiceClient.getEndpointTemplates(), (Object)templateName)) {
                    endpointTemplateAdminServiceClient.deleteEndpointTemplate(templateName);
                    Assert.assertTrue((boolean)APIMTestCaseUtils.isEndpointTemplateUnDeployed(backendURL, sessionCookie, templateName), (String)(templateName + " Endpoint Template undeployment failed"));
                }
                endpointTemplateAdminServiceClient.addEndpointTemplate(template);
            }
            log.info((Object)(templateName + " Template Uploaded"));
        }
    }

    private static void checkMessageProcessors(OMElement synapseConfig, String backendURL, String sessionCookie, MessageProcessorClient messageProcessorClient) throws RemoteException, SequenceEditorException {
        Iterator messageProcessors = synapseConfig.getChildrenWithLocalName(MESSAGE_PROCESSOR);
        while (messageProcessors.hasNext()) {
            OMElement messageProcessor = (OMElement)messageProcessors.next();
            String mProcessor = messageProcessor.getAttributeValue(new QName(NAME));
            if (ArrayUtils.contains((Object[])messageProcessorClient.getMessageProcessorNames(), (Object)mProcessor)) {
                messageProcessorClient.deleteMessageProcessor(mProcessor);
                Assert.assertTrue((boolean)APIMTestCaseUtils.isMessageProcessorUnDeployed(backendURL, sessionCookie, mProcessor), (String)(mProcessor + " Message Processor undeployment failed"));
            }
            messageProcessorClient.addMessageProcessor(messageProcessor);
            log.info((Object)(mProcessor + " Message Processor Uploaded"));
        }
    }

    private static void checkMessageStores(OMElement synapseConfig, String backendURL, String sessionCookie, MessageStoreAdminClient messageStoreAdminClient) throws RemoteException, SequenceEditorException, Exception {
        Iterator messageStores = synapseConfig.getChildrenWithLocalName(MESSAGE_STORE);
        while (messageStores.hasNext()) {
            OMElement messageStore = (OMElement)messageStores.next();
            String mStore = messageStore.getAttributeValue(new QName(NAME));
            if (ArrayUtils.contains((Object[])messageStoreAdminClient.getMessageStores(), (Object)mStore)) {
                messageStoreAdminClient.deleteMessageStore(mStore);
                Assert.assertTrue((boolean)APIMTestCaseUtils.isMessageStoreUnDeployed(backendURL, sessionCookie, mStore), (String)(mStore + " Message Store undeployment failed"));
            }
            messageStoreAdminClient.addMessageStore(messageStore);
            log.info((Object)(mStore + " Message Store Uploaded"));
        }
    }

    private static void checkProxies(OMElement synapseConfig, String backendURL, String sessionCookie, ProxyServiceAdminClient proxyAdmin, ServiceAdminClient adminServiceService) throws java.lang.Exception {
        Iterator proxies = synapseConfig.getChildrenWithLocalName(PROXY);
        while (proxies.hasNext()) {
            OMElement proxy = (OMElement)proxies.next();
            String proxyName = proxy.getAttributeValue(new QName(NAME));
            if (adminServiceService.isServiceExists(proxyName)) {
                proxyAdmin.deleteProxy(proxyName);
                Assert.assertTrue((boolean)APIMTestCaseUtils.isProxyUnDeployed(backendURL, sessionCookie, proxyName), (String)(proxyName + " Undeployment failed"));
            }
            proxyAdmin.addProxyService(proxy);
            log.info((Object)(proxyName + " Proxy Uploaded"));
        }
    }

    private static void checkSequences(OMElement synapseConfig, String backendURL, String sessionCookie, SequenceAdminServiceClient sequenceAdminClient) throws SequenceEditorException, RemoteException {
        Iterator sequences = synapseConfig.getChildrenWithLocalName(SEQUENCE);
        while (sequences.hasNext()) {
            OMElement sequence = (OMElement)sequences.next();
            String sqn = sequence.getAttributeValue(new QName(NAME));
            boolean isSequenceExist = ArrayUtils.contains((Object[])sequenceAdminClient.getSequences(), (Object)sqn);
            if (("main".equalsIgnoreCase(sqn) || "fault".equalsIgnoreCase(sqn)) && isSequenceExist) {
                sequenceAdminClient.updateSequence(sequence);
            } else {
                if (isSequenceExist) {
                    sequenceAdminClient.deleteSequence(sqn);
                    Assert.assertTrue((boolean)APIMTestCaseUtils.isSequenceUnDeployed(backendURL, sessionCookie, sqn), (String)(sqn + " Sequence undeployment failed"));
                }
                sequenceAdminClient.addSequence(sequence);
            }
            log.info((Object)(sqn + " Sequence Uploaded"));
        }
    }

    private static void checkEndPoints(OMElement synapseConfig, String backendURL, String sessionCookie, EndPointAdminClient endPointAdminClient) throws EndpointAdminEndpointAdminException, IOException, XMLStreamException {
        Iterator endpoints = synapseConfig.getChildrenWithLocalName(ENDPOINT);
        while (endpoints.hasNext()) {
            OMElement endpoint = (OMElement)endpoints.next();
            String ep = endpoint.getAttributeValue(new QName(NAME));
            if (ArrayUtils.contains((Object[])endPointAdminClient.getEndpointNames(), (Object)ep)) {
                Assert.assertTrue((boolean)endPointAdminClient.deleteEndpoint(ep), (String)(ep + " Endpoint deletion failed"));
                Assert.assertTrue((boolean)APIMTestCaseUtils.isEndpointUnDeployed(backendURL, sessionCookie, ep), (String)(ep + " Endpoint undeployment failed"));
            }
            Assert.assertTrue((boolean)endPointAdminClient.addEndPoint(endpoint), (String)(ep + " Endpoint addition failed"));
            log.info((Object)(ep + " Endpoint Uploaded"));
        }
    }

    private static void checkLocalEntries(OMElement synapseConfig, String backendURL, String sessionCookie, LocalEntriesAdminClient localEntryAdminServiceClient) throws LocalEntryAdminException, RemoteException {
        Iterator localEntries = synapseConfig.getChildrenWithLocalName(LOCAL_ENTRY);
        while (localEntries.hasNext()) {
            OMElement localEntry = (OMElement)localEntries.next();
            String le = localEntry.getAttributeValue(new QName(KEY));
            if (ArrayUtils.contains((Object[])localEntryAdminServiceClient.getEntryNames(), (Object)le)) {
                Assert.assertTrue((boolean)localEntryAdminServiceClient.deleteLocalEntry(le), (String)(le + " Local Entry deletion failed"));
                Assert.assertTrue((boolean)APIMTestCaseUtils.isLocalEntryUnDeployed(backendURL, sessionCookie, le), (String)(le + " Local Entry undeployment failed"));
            }
            Assert.assertTrue((boolean)localEntryAdminServiceClient.addLocalEntry(localEntry), (String)(le + " Local Entry addition failed"));
            log.info((Object)(le + " LocalEntry Uploaded"));
        }
    }

    public static void addProxyService(String backEndUrl, String sessionCookie, OMElement proxyConfig) throws java.lang.Exception {
        ProxyServiceAdminClient proxyAdmin = new ProxyServiceAdminClient(backEndUrl, sessionCookie);
        proxyAdmin.addProxyService(proxyConfig);
        String proxyName = proxyConfig.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isProxyDeployed(backEndUrl, sessionCookie, proxyName), (String)"Proxy Deployment failed or time out");
    }

    public static void addEndpoint(String backEndUrl, String sessionCookie, OMElement endpointConfig) throws java.lang.Exception {
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backEndUrl, sessionCookie);
        endPointAdminClient.addEndPoint(endpointConfig);
        String ep = endpointConfig.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isEndpointDeployed(backEndUrl, sessionCookie, ep), (String)(ep + "Endpoint deployment not found or time out"));
    }

    public static void addLocalEntry(String backEndUrl, String sessionCookie, OMElement localEntryConfig) throws java.lang.Exception {
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backEndUrl, sessionCookie);
        boolean value = localEntryAdminServiceClient.addLocalEntry(localEntryConfig);
        Assert.assertTrue((boolean)value, (String)"LocalEntry Addition failed");
        if (value) {
            String le = localEntryConfig.getAttributeValue(new QName(KEY));
            Assert.assertTrue((boolean)APIMTestCaseUtils.isLocalEntryDeployed(backEndUrl, sessionCookie, le), (String)(le + "LocalEntry deployment not found or time out"));
        }
    }

    public static void addSequence(String backEndUrl, String sessionCookie, OMElement sequenceConfig) throws java.lang.Exception {
        SequenceAdminServiceClient sequenceAdminClient = new SequenceAdminServiceClient(backEndUrl, sessionCookie);
        sequenceAdminClient.addSequence(sequenceConfig);
        String sqn = sequenceConfig.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isSequenceDeployed(backEndUrl, sessionCookie, sqn), (String)(sqn + "Sequence deployment not found or time out"));
    }

    public static void addMessageStore(String backEndUrl, String sessionCookie, OMElement messageStore) throws java.lang.Exception {
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backEndUrl, sessionCookie);
        messageStoreAdminClient.addMessageStore(messageStore);
        String mStoreName = messageStore.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isMessageStoreDeployed(backEndUrl, sessionCookie, mStoreName), (String)"Message Store Deployment failed");
    }

    public static void addMessageProcessor(String backEndUrl, String sessionCookie, OMElement messageProcessor) throws java.lang.Exception {
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backEndUrl, sessionCookie);
        messageProcessorClient.addMessageProcessor(messageProcessor);
        String mProcessorName = messageProcessor.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isMessageProcessorDeployed(backEndUrl, sessionCookie, mProcessorName), (String)"Message Processor deployment failed");
    }

    public static void addSequenceTemplate(String backEndUrl, String sessionCookie, OMElement sequenceTemplate) throws RemoteException {
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backEndUrl, sessionCookie);
        sequenceTemplateAdminServiceClient.addSequenceTemplate(sequenceTemplate);
        String seqTmpName = sequenceTemplate.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isSequenceTemplateDeployed(backEndUrl, sessionCookie, seqTmpName), (String)"Sequence Template deployment failed");
    }

    public static void addEndpointTemplate(String backEndUrl, String sessionCookie, OMElement endpointTemplate) throws RemoteException {
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backEndUrl, sessionCookie);
        endpointTemplateAdminServiceClient.addEndpointTemplate(endpointTemplate);
        String endpointTmpName = endpointTemplate.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isEndpointTemplateDeployed(backEndUrl, sessionCookie, endpointTmpName), (String)"Endpoint Template deployment failed");
    }

    public static void addAPI(String backEndUrl, String sessionCookie, OMElement api) throws RemoteException, RestApiAdminAPIException {
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backEndUrl, sessionCookie);
        apiAdminClient.add(api);
        String apiName = api.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isApiDeployed(backEndUrl, sessionCookie, apiName), (String)"Rest Api deployment failed");
    }

    public static void addPriorityExecutor(String backEndUrl, String sessionCookie, OMElement priorityExecutor) throws RemoteException {
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backEndUrl, sessionCookie);
        String executorName = priorityExecutor.getAttributeValue(new QName(NAME));
        priorityMediationAdminClient.addPriorityMediator(executorName, priorityExecutor);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isPriorityExecutorDeployed(backEndUrl, sessionCookie, executorName), (String)"Priority Executor deployment failed");
    }

    public static void addScheduleTask(String backEndUrl, String sessionCookie, OMElement taskDescription) throws TaskManagementException, RemoteException {
        TaskAdminClient taskAdminClient = new TaskAdminClient(backEndUrl, sessionCookie);
        taskAdminClient.addTask(taskDescription);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isScheduleTaskDeployed(backEndUrl, sessionCookie, taskDescription.getAttributeValue(new QName(NAME))), (String)"ScheduleTask deployment failed");
    }

    public static boolean isProxyDeployed(String backEndUrl, String sessionCookie, String proxyName) throws RemoteException {
        long time;
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Proxy deployment " + proxyName));
        boolean isServiceDeployed = false;
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (adminServiceService.isServiceExists(proxyName)) {
                isServiceDeployed = true;
                log.info((Object)(proxyName + " Proxy Deployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceDeployed;
    }

    public static boolean isEndpointDeployed(String backEndUrl, String sessionCookie, String endpointName) throws EndpointAdminEndpointAdminException, RemoteException {
        long time;
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Endpoint " + endpointName));
        boolean isEndpointExist = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] endpoints = endPointAdminClient.getEndpointNames();
            if (endpoints != null && endpoints.length > 0) {
                for (String endpoint : endpoints) {
                    if (!endpointName.equals(endpoint)) continue;
                    isEndpointExist = true;
                    log.info((Object)(endpointName + " Endpoint Found in " + time + " millis"));
                    break;
                }
            }
            if (isEndpointExist) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isEndpointExist;
    }

    public static boolean isMessageProcessorDeployed(String backEndUrl, String sessionCookie, String messageProcessorName) throws SequenceEditorException, RemoteException {
        long time;
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Message Processor " + messageProcessorName));
        boolean isMessageStoreExist = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] messageProcessors = messageProcessorClient.getMessageProcessorNames();
            if (messageProcessors != null && messageProcessors.length > 0) {
                for (String mp : messageProcessors) {
                    if (!mp.equals(messageProcessorName)) continue;
                    isMessageStoreExist = true;
                    log.info((Object)(messageProcessorName + " Message Processor Found in " + time + " millis"));
                    break;
                }
            }
            if (isMessageStoreExist) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isMessageStoreExist;
    }

    public static boolean isSequenceDeployed(String backEndUrl, String sessionCookie, String sequenceName) throws SequenceEditorException, RemoteException {
        long time;
        SequenceAdminServiceClient sequenceAdminServiceClient = new SequenceAdminServiceClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Sequence " + sequenceName));
        boolean isSequenceExist = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] sequences = sequenceAdminServiceClient.getSequences();
            if (sequences != null && sequences.length > 0) {
                for (String sequence : sequences) {
                    if (!sequence.equals(sequenceName)) continue;
                    isSequenceExist = true;
                    log.info((Object)(sequenceName + " Sequence Found in " + time + " millis"));
                    break;
                }
            }
            if (isSequenceExist) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isSequenceExist;
    }

    public static boolean isMessageStoreDeployed(String backEndUrl, String sessionCookie, String messageStoreName) throws SequenceEditorException, RemoteException {
        long time;
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Message Store " + messageStoreName));
        boolean isMessageStoreExist = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] messageStores = messageStoreAdminClient.getMessageStores();
            if (messageStores != null && messageStores.length > 0) {
                for (String ms : messageStores) {
                    if (!ms.equals(messageStoreName)) continue;
                    isMessageStoreExist = true;
                    log.info((Object)(messageStoreName + " Message Store Found in " + time + " millis"));
                    break;
                }
            }
            if (isMessageStoreExist) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isMessageStoreExist;
    }

    public static boolean isSequenceTemplateDeployed(String backEndUrl, String sessionCookie, String sequenceTemplateName) throws RemoteException {
        long time;
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Sequence Template " + sequenceTemplateName));
        boolean isSequenceTmpFound = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] templates = sequenceTemplateAdminServiceClient.getSequenceTemplates();
            if (templates != null && templates.length > 0) {
                for (String tmpl : templates) {
                    if (!tmpl.equals(sequenceTemplateName)) continue;
                    isSequenceTmpFound = true;
                    log.info((Object)(sequenceTemplateName + " Sequence Template Found in " + time + " millis"));
                    break;
                }
            }
            if (isSequenceTmpFound) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isSequenceTmpFound;
    }

    public static boolean isEndpointTemplateDeployed(String backEndUrl, String sessionCookie, String endpointTemplateName) throws RemoteException {
        long time;
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Endpoint Template " + endpointTemplateName));
        boolean isEndpointTmpFound = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] templates = endpointTemplateAdminServiceClient.getEndpointTemplates();
            if (templates != null && templates.length > 0) {
                for (String tmpl : templates) {
                    if (!tmpl.equals(endpointTemplateName)) continue;
                    isEndpointTmpFound = true;
                    log.info((Object)(endpointTemplateName + " Endpoint Template Found in " + time + " millis"));
                    break;
                }
            }
            if (isEndpointTmpFound) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isEndpointTmpFound;
    }

    public static boolean isApiDeployed(String backEndUrl, String sessionCookie, String apiName) throws RemoteException, RestApiAdminAPIException {
        long time;
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for API " + apiName));
        boolean isApiFound = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] apiList = apiAdminClient.getApiNames();
            if (apiList != null && apiList.length > 0) {
                for (String restApi : apiList) {
                    if (!restApi.equals(apiName)) continue;
                    isApiFound = true;
                    log.info((Object)(apiName + " API Found in " + time + " millis"));
                    break;
                }
            }
            if (isApiFound) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isApiFound;
    }

    public static boolean isPriorityExecutorDeployed(String backEndUrl, String sessionCookie, String executorName) throws RemoteException {
        long time;
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Priority Executor " + executorName));
        boolean isExecutorFound = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] executorList = priorityMediationAdminClient.getExecutorList();
            if (executorList != null && executorList.length > 0) {
                for (String executor : executorList) {
                    if (!executor.equals(executorName)) continue;
                    isExecutorFound = true;
                    log.info((Object)(executorName + " Priority Executor Found in " + time + " millis"));
                    break;
                }
            }
            if (isExecutorFound) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isExecutorFound;
    }

    public static boolean isScheduleTaskDeployed(String backEndUrl, String sessionCookie, String taskName) throws RemoteException, TaskManagementException {
        long time;
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Task deployment " + taskName));
        boolean isTaskDeployed = false;
        TaskAdminClient taskAdminClient = new TaskAdminClient(backEndUrl, sessionCookie);
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (taskAdminClient.getScheduleTaskList().contains(taskName)) {
                isTaskDeployed = true;
                log.info((Object)(taskName + " Task Deployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isTaskDeployed;
    }

    public static boolean isProxyServiceExist(String backEndUrl, String sessionCookie, String proxyName) throws RemoteException {
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        return adminServiceService.isServiceExists(proxyName);
    }

    public static boolean isLocalEntryExist(String backEndUrl, String sessionCookie, String localEntryName) throws LocalEntryAdminException, RemoteException {
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backEndUrl, sessionCookie);
        Object[] localEntries = localEntryAdminServiceClient.getEntryNames();
        if (localEntries == null || localEntries.length == 0) {
            return false;
        }
        return ArrayUtils.contains((Object[])localEntries, (Object)localEntryName);
    }

    public static boolean isSequenceExist(String backEndUrl, String sessionCookie, String sequenceName) throws SequenceEditorException, RemoteException {
        SequenceAdminServiceClient sequenceAdminServiceClient = new SequenceAdminServiceClient(backEndUrl, sessionCookie);
        Object[] sequences = sequenceAdminServiceClient.getSequences();
        if (sequences == null || sequences.length == 0) {
            return false;
        }
        return ArrayUtils.contains((Object[])sequences, (Object)sequenceName);
    }

    public static boolean isEndpointExist(String backEndUrl, String sessionCookie, String endpointName) throws EndpointAdminEndpointAdminException, RemoteException {
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backEndUrl, sessionCookie);
        Object[] endpoints = endPointAdminClient.getEndpointNames();
        if (endpoints == null || endpoints.length == 0) {
            return false;
        }
        return ArrayUtils.contains((Object[])endpoints, (Object)endpointName);
    }

    public static boolean isMessageStoreExist(String backEndUrl, String sessionCookie, String messageProcessor) throws RemoteException {
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])messageStoreAdminClient.getMessageStores(), (Object)messageProcessor);
    }

    public static boolean isMessageProcessorExist(String backEndUrl, String sessionCookie, String messageProcessor) throws RemoteException {
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])messageProcessorClient.getMessageProcessorNames(), (Object)messageProcessor);
    }

    public static boolean isSequenceTemplateExist(String backEndUrl, String sessionCookie, String sequenceTemplate) throws RemoteException {
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])sequenceTemplateAdminServiceClient.getSequenceTemplates(), (Object)sequenceTemplate);
    }

    public static boolean isEndpointTemplateExist(String backEndUrl, String sessionCookie, String endpointTemplate) throws RemoteException {
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])endpointTemplateAdminServiceClient.getEndpointTemplates(), (Object)endpointTemplate);
    }

    public static boolean isApiExist(String backEndUrl, String sessionCookie, String apiName) throws RemoteException, RestApiAdminAPIException {
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])apiAdminClient.getApiNames(), (Object)apiName);
    }

    public static boolean isPriorityExecutorExist(String backEndUrl, String sessionCookie, String priorityExecutorName) throws RemoteException {
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])priorityMediationAdminClient.getExecutorList(), (Object)priorityExecutorName);
    }

    public static boolean isScheduleTaskExist(String backEndUrl, String sessionCookie, String taskName) throws RemoteException, TaskManagementException {
        TaskAdminClient taskAdminClient = new TaskAdminClient(backEndUrl, sessionCookie);
        return taskAdminClient.getScheduleTaskList().contains(taskName);
    }

    public static void deleteProxyService(String backEndUrl, String sessionCookie, String proxyServiceName) throws ProxyServiceAdminProxyAdminException, RemoteException {
        ProxyServiceAdminClient proxyAdmin = new ProxyServiceAdminClient(backEndUrl, sessionCookie);
        proxyAdmin.deleteProxy(proxyServiceName);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isProxyUnDeployed(backEndUrl, sessionCookie, proxyServiceName), (String)"Proxy service undeployment failed");
    }

    public static void deleteLocalEntry(String backEndUrl, String sessionCookie, String localEntryName) throws LocalEntryAdminException, RemoteException {
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backEndUrl, sessionCookie);
        Assert.assertTrue((boolean)localEntryAdminServiceClient.deleteLocalEntry(localEntryName), (String)"LocalEntry Deletion failed");
        Assert.assertTrue((boolean)APIMTestCaseUtils.isLocalEntryUnDeployed(backEndUrl, sessionCookie, localEntryName), (String)"LocalEntry undeployment failed");
    }

    public static void deleteEndpoint(String backEndUrl, String sessionCookie, String endpointName) throws EndpointAdminEndpointAdminException, RemoteException {
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backEndUrl, sessionCookie);
        Assert.assertTrue((boolean)endPointAdminClient.deleteEndpoint(endpointName), (String)"Endpoint deletion failed");
        Assert.assertTrue((boolean)APIMTestCaseUtils.isEndpointUnDeployed(backEndUrl, sessionCookie, endpointName), (String)"Endpoint undeployment failed");
    }

    public static void deleteSequence(String backEndUrl, String sessionCookie, String sequenceName) throws SequenceEditorException, RemoteException {
        SequenceAdminServiceClient sequenceAdminServiceClient = new SequenceAdminServiceClient(backEndUrl, sessionCookie);
        sequenceAdminServiceClient.deleteSequence(sequenceName);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isSequenceUnDeployed(backEndUrl, sessionCookie, sequenceName), (String)"Sequence undeployment failed");
    }

    public static void deleteMessageStore(String backEndUrl, String sessionCookie, String messageStore) throws RemoteException, SequenceEditorException {
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backEndUrl, sessionCookie);
        messageStoreAdminClient.deleteMessageStore(messageStore);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isMessageStoreUnDeployed(backEndUrl, sessionCookie, messageStore), (String)"Message Store undeployment failed");
    }

    public static void deleteMessageProcessor(String backEndUrl, String sessionCookie, String messageProcessor) throws RemoteException, SequenceEditorException {
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backEndUrl, sessionCookie);
        messageProcessorClient.deleteMessageProcessor(messageProcessor);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isMessageProcessorUnDeployed(backEndUrl, sessionCookie, messageProcessor), (String)"Message Processor undeployment failed");
    }

    public static void deleteEndpointTemplate(String backEndUrl, String sessionCookie, String endpointTemplate) throws RemoteException, SequenceEditorException, EndpointAdminEndpointAdminException {
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backEndUrl, sessionCookie);
        endpointTemplateAdminServiceClient.deleteEndpointTemplate(endpointTemplate);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isEndpointTemplateUnDeployed(backEndUrl, sessionCookie, endpointTemplate), (String)"Endpoint Template undeployment failed");
    }

    public static void deleteSequenceTemplate(String backEndUrl, String sessionCookie, String sequenceTemplateName) throws RemoteException, SequenceEditorException, EndpointAdminEndpointAdminException {
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backEndUrl, sessionCookie);
        sequenceTemplateAdminServiceClient.deleteTemplate(sequenceTemplateName);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isSequenceTemplateUnDeployed(backEndUrl, sessionCookie, sequenceTemplateName), (String)"Sequence Template undeployment failed");
    }

    public static void deleteApi(String backEndUrl, String sessionCookie, String apiName) throws RemoteException, RestApiAdminAPIException {
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backEndUrl, sessionCookie);
        apiAdminClient.deleteApi(apiName);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isApiUnDeployed(backEndUrl, sessionCookie, apiName), (String)"API undeployment failed");
    }

    public static void deletePriorityExecutor(String backEndUrl, String sessionCookie, String executorName) throws RemoteException {
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backEndUrl, sessionCookie);
        priorityMediationAdminClient.remove(executorName);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isPriorityExecutorUnDeployed(backEndUrl, sessionCookie, executorName), (String)"Priority Executor undeployment failed");
    }

    public static void deleteScheduleTask(String backEndUrl, String sessionCookie, String taskName, String group) throws TaskManagementException, RemoteException {
        TaskAdminClient taskAdminClient = new TaskAdminClient(backEndUrl, sessionCookie);
        taskAdminClient.deleteTask(taskName, group);
        Assert.assertTrue((boolean)APIMTestCaseUtils.isScheduleTaskUnDeployed(backEndUrl, sessionCookie, taskName), (String)"ScheduleTask deployment failed");
    }

    public static boolean isProxyUnDeployed(String backEndUrl, String sessionCookie, String proxyName) throws RemoteException {
        long time;
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Proxy undeployment"));
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        boolean isServiceDeleted = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (!adminServiceService.isServiceExists(proxyName)) {
                isServiceDeleted = true;
                log.info((Object)(proxyName + " Proxy undeployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceDeleted;
    }

    public static boolean isMessageStoreUnDeployed(String backEndUrl, String sessionCookie, String messageStoreName) throws SequenceEditorException, RemoteException {
        long time;
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Message Store " + messageStoreName));
        boolean isMessageStoreDeleted = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] mStores = messageStoreAdminClient.getMessageStores();
            if (!ArrayUtils.contains((Object[])mStores, (Object)messageStoreName)) {
                isMessageStoreDeleted = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isMessageStoreDeleted;
    }

    public static boolean isMessageProcessorUnDeployed(String backEndUrl, String sessionCookie, String messageProcessorName) throws SequenceEditorException, RemoteException {
        long time;
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Message Processor " + messageProcessorName));
        boolean isMessageProcessorDeleted = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] mProcessors = messageProcessorClient.getMessageProcessorNames();
            if (!ArrayUtils.contains((Object[])mProcessors, (Object)messageProcessorName)) {
                isMessageProcessorDeleted = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isMessageProcessorDeleted;
    }

    public static boolean isLocalEntryDeployed(String backEndUrl, String sessionCookie, String localEntryName) throws LocalEntryAdminException, RemoteException {
        long time;
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for LocalEntry " + localEntryName));
        boolean isLocalEntryExist = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] localEntries = localEntryAdminServiceClient.getEntryNames();
            if (localEntries != null && localEntries.length > 0) {
                for (String localEntry : localEntries) {
                    if (!localEntryName.equals(localEntry)) continue;
                    isLocalEntryExist = true;
                    log.info((Object)(localEntryName + " LocalEntry Found in " + time + " millis"));
                    break;
                }
            }
            if (isLocalEntryExist) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isLocalEntryExist;
    }

    public static boolean isLocalEntryUnDeployed(String backEndUrl, String sessionCookie, String localEntryName) throws LocalEntryAdminException, RemoteException {
        long time;
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment LocalEntry " + localEntryName));
        boolean isLocalEntryUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] localEntries = localEntryAdminServiceClient.getEntryNames();
            if (!ArrayUtils.contains((Object[])localEntries, (Object)localEntryName)) {
                isLocalEntryUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isLocalEntryUnDeployed;
    }

    public static boolean isSequenceUnDeployed(String backEndUrl, String sessionCookie, String sequenceName) throws SequenceEditorException, RemoteException {
        long time;
        SequenceAdminServiceClient sequenceAdminServiceClient = new SequenceAdminServiceClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Sequence " + sequenceName));
        boolean isSequenceUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] sequences = sequenceAdminServiceClient.getSequences();
            if (!ArrayUtils.contains((Object[])sequences, (Object)sequenceName)) {
                isSequenceUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isSequenceUnDeployed;
    }

    public static boolean isEndpointUnDeployed(String backEndUrl, String sessionCookie, String endpointName) throws EndpointAdminEndpointAdminException, RemoteException {
        long time;
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Endpoint " + endpointName));
        boolean isEndpointUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] endpoints = endPointAdminClient.getEndpointNames();
            if (!ArrayUtils.contains((Object[])endpoints, (Object)endpointName)) {
                isEndpointUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isEndpointUnDeployed;
    }

    public static boolean isEndpointTemplateUnDeployed(String backEndUrl, String sessionCookie, String endpointTemplateName) throws EndpointAdminEndpointAdminException, RemoteException {
        long time;
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Endpoint Template " + endpointTemplateName));
        boolean isEndpointTemplateUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] endpointTemplates = endpointTemplateAdminServiceClient.getEndpointTemplates();
            if (!ArrayUtils.contains((Object[])endpointTemplates, (Object)endpointTemplateName)) {
                isEndpointTemplateUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isEndpointTemplateUnDeployed;
    }

    public static boolean isSequenceTemplateUnDeployed(String backEndUrl, String sessionCookie, String sequenceTemplateName) throws EndpointAdminEndpointAdminException, RemoteException {
        long time;
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Sequence Template " + sequenceTemplateName));
        boolean isSequenceTemplateUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] sequenceTemplates = sequenceTemplateAdminServiceClient.getSequenceTemplates();
            if (!ArrayUtils.contains((Object[])sequenceTemplates, (Object)sequenceTemplateName)) {
                isSequenceTemplateUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isSequenceTemplateUnDeployed;
    }

    public static boolean isApiUnDeployed(String backEndUrl, String sessionCookie, String apiName) throws RemoteException, RestApiAdminAPIException {
        long time;
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment API " + apiName));
        boolean isApiUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] apiList = apiAdminClient.getApiNames();
            if (!ArrayUtils.contains((Object[])apiList, (Object)apiName)) {
                isApiUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isApiUnDeployed;
    }

    public static boolean isPriorityExecutorUnDeployed(String backEndUrl, String sessionCookie, String executorName) throws RemoteException {
        long time;
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backEndUrl, sessionCookie);
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Priority Executor " + executorName));
        boolean isExecutorUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] executorList = priorityMediationAdminClient.getExecutorList();
            if (!ArrayUtils.contains((Object[])executorList, (Object)executorName)) {
                isExecutorUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isExecutorUnDeployed;
    }

    public static boolean isScheduleTaskUnDeployed(String backEndUrl, String sessionCookie, String taskName) throws RemoteException, TaskManagementException {
        long time;
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Task Undeployment " + taskName));
        boolean isTaskUnDeployed = false;
        TaskAdminClient taskAdminClient = new TaskAdminClient(backEndUrl, sessionCookie);
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (!taskAdminClient.getScheduleTaskList().contains(taskName)) {
                isTaskUnDeployed = true;
                log.info((Object)(taskName + " Task UnDeployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isTaskUnDeployed;
    }

    public static void verifySynapseDeployment(OMElement synapseConfig, String backendURL, String sessionCookie) throws LocalEntryAdminException, RemoteException, EndpointAdminEndpointAdminException, SequenceEditorException, RestApiAdminAPIException {
        Iterator localEntries = synapseConfig.getChildrenWithLocalName(LOCAL_ENTRY);
        while (localEntries.hasNext()) {
            OMElement leOM = (OMElement)localEntries.next();
            String le = leOM.getAttributeValue(new QName(KEY));
            Assert.assertTrue((boolean)APIMTestCaseUtils.isLocalEntryDeployed(backendURL, sessionCookie, le), (String)(le + " LocalEntry deployment not found or time out"));
        }
        Iterator endpoints = synapseConfig.getChildrenWithLocalName(ENDPOINT);
        while (endpoints.hasNext()) {
            OMElement epOM = (OMElement)endpoints.next();
            String ep = epOM.getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)APIMTestCaseUtils.isEndpointDeployed(backendURL, sessionCookie, ep), (String)(ep + " Endpoint deployment not found or time out"));
        }
        Iterator sequences = synapseConfig.getChildrenWithLocalName(SEQUENCE);
        while (sequences.hasNext()) {
            OMElement sqnOM = (OMElement)sequences.next();
            String sqn = sqnOM.getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)APIMTestCaseUtils.isSequenceDeployed(backendURL, sessionCookie, sqn), (String)(sqn + " Sequence deployment not found or time out"));
        }
        Iterator proxies = synapseConfig.getChildrenWithLocalName(PROXY);
        while (proxies.hasNext()) {
            OMElement proxyOM = (OMElement)proxies.next();
            String proxy = proxyOM.getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)APIMTestCaseUtils.isProxyDeployed(backendURL, sessionCookie, proxy), (String)(proxy + " Proxy Deployment not found or time out"));
        }
        Iterator messageStores = synapseConfig.getChildrenWithLocalName(MESSAGE_STORE);
        while (messageStores.hasNext()) {
            OMElement mStoreOM = (OMElement)messageStores.next();
            String mStore = mStoreOM.getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)APIMTestCaseUtils.isMessageStoreDeployed(backendURL, sessionCookie, mStore), (String)(mStore + " Message Store Deployment not found or time out"));
        }
        Iterator messageProcessor = synapseConfig.getChildrenWithLocalName(MESSAGE_PROCESSOR);
        while (messageProcessor.hasNext()) {
            OMElement mProcessorOM = (OMElement)messageProcessor.next();
            String mProcessor = mProcessorOM.getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)APIMTestCaseUtils.isMessageProcessorDeployed(backendURL, sessionCookie, mProcessor), (String)(mProcessor + " Message Processor Deployment not found or time out"));
        }
        Iterator templates = synapseConfig.getChildrenWithLocalName(TEMPLATE);
        while (templates.hasNext()) {
            OMElement template = (OMElement)templates.next();
            String templateName = template.getAttributeValue(new QName(NAME));
            if (template.getFirstChildWithName(new QName(template.getNamespace().getNamespaceURI(), SEQUENCE)) != null) {
                Assert.assertTrue((boolean)APIMTestCaseUtils.isSequenceTemplateDeployed(backendURL, sessionCookie, templateName), (String)(templateName + " Sequence Template Deployment not found or time out"));
            } else {
                Assert.assertTrue((boolean)APIMTestCaseUtils.isEndpointTemplateDeployed(backendURL, sessionCookie, templateName), (String)(templateName + " Endpoint Template Deployment not found or time out"));
            }
            log.info((Object)"Template Uploaded");
        }
        Iterator apiList = synapseConfig.getChildrenWithLocalName(API);
        while (apiList.hasNext()) {
            OMElement api = (OMElement)apiList.next();
            String apiName = api.getAttributeValue(new QName(NAME));
            String version = api.getAttributeValue(new QName(VERSION));
            if (version != null && !version.equals("")) {
                apiName = apiName + ":v" + version;
            }
            Assert.assertTrue((boolean)APIMTestCaseUtils.isApiDeployed(backendURL, sessionCookie, apiName), (String)(apiName + " API Deployment not found or time out"));
        }
        Iterator executorList = synapseConfig.getChildrenWithLocalName(PRIORITY_EXECUTOR);
        while (executorList.hasNext()) {
            OMElement executorNameOM = (OMElement)executorList.next();
            String executorName = executorNameOM.getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)APIMTestCaseUtils.isPriorityExecutorDeployed(backendURL, sessionCookie, executorName), (String)(executorName + " Priority Executor Deployment not found or time out"));
        }
    }

    public static APIBean getAPIBeanFromHttpResponse(HttpResponse httpResponse) throws APIManagerIntegrationTestException {
        APIBean apiBean;
        try {
            JSONObject jsonObject = new JSONObject(httpResponse.getData());
            String APIName = ((JSONObject)jsonObject.get(API)).getString(NAME);
            String APIVersion = ((JSONObject)jsonObject.get(API)).getString(VERSION);
            String APIProvider = ((JSONObject)jsonObject.get(API)).getString("provider");
            APIIdentifier identifier = new APIIdentifier(APIProvider, APIName, APIVersion);
            apiBean = new APIBean(identifier);
            apiBean.setContext(((JSONObject)jsonObject.get(API)).getString("context"));
            apiBean.setDescription(((JSONObject)jsonObject.get(API)).getString("description"));
            apiBean.setWsdlUrl(((JSONObject)jsonObject.get(API)).getString("wsdl"));
            apiBean.setTags(((JSONObject)jsonObject.get(API)).getString("tags"));
            apiBean.setAvailableTiers(((JSONObject)jsonObject.get(API)).getString("availableTiers"));
            apiBean.setThumbnailUrl(((JSONObject)jsonObject.get(API)).getString("thumb"));
            apiBean.setSandboxUrl(((JSONObject)jsonObject.get(API)).getString("sandbox"));
            apiBean.setBusinessOwner(((JSONObject)jsonObject.get(API)).getString("bizOwner"));
            apiBean.setBusinessOwnerEmail(((JSONObject)jsonObject.get(API)).getString("bizOwnerMail"));
            apiBean.setTechnicalOwner(((JSONObject)jsonObject.get(API)).getString("techOwner"));
            apiBean.setTechnicalOwnerEmail(((JSONObject)jsonObject.get(API)).getString("techOwnerMail"));
            apiBean.setWadlUrl(((JSONObject)jsonObject.get(API)).getString("wadl"));
            apiBean.setVisibility(((JSONObject)jsonObject.get(API)).getString("visibility"));
            apiBean.setVisibleRoles(((JSONObject)jsonObject.get(API)).getString("roles"));
            apiBean.setEndpointUTUsername(((JSONObject)jsonObject.get(API)).getString("epUsername"));
            apiBean.setEndpointUTPassword(((JSONObject)jsonObject.get(API)).getString("epPassword"));
            apiBean.setEndpointSecured(Boolean.getBoolean(((JSONObject)jsonObject.get(API)).getString("endpointTypeSecured")));
            apiBean.setTransports(((JSONObject)jsonObject.get(API)).getString("transport_http"));
            apiBean.setTransports(((JSONObject)jsonObject.get(API)).getString("transport_https"));
            apiBean.setInSequence(((JSONObject)jsonObject.get(API)).getString("inSequence"));
            apiBean.setOutSequence(((JSONObject)jsonObject.get(API)).getString("outSequence"));
            apiBean.setAvailableTiers(((JSONObject)jsonObject.get(API)).getString("availableTiersDisplayNames"));
        }
        catch (JSONException e) {
            throw new APIManagerIntegrationTestException("Generating APIBen instance fails ", e);
        }
        return apiBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendGetRequest(String url, String accessToken) throws XPathExpressionException, IOException {
        URL urlAPI = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)urlAPI.openConnection();
        conn.setRequestMethod("GET");
        conn.setDoOutput(true);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("Authorization", "Bearer " + accessToken);
        conn.connect();
        StringBuilder sb = new StringBuilder();
        try (BufferedReader rd = null;){
            String line;
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
            HttpResponse httpResponse = new HttpResponse(sb.toString(), conn.getResponseCode());
            httpResponse.setResponseMessage(conn.getResponseMessage());
        }
    }

    public static String getDecodedJWT(String jwt) throws UnsupportedEncodingException {
        String[] jwtTokenArray = jwt.split(Pattern.quote("."));
        byte[] jwtByteArray = Base64.decodeBase64((byte[])jwtTokenArray[1].getBytes("UTF-8"));
        return new String(jwtByteArray, "UTF-8");
    }

    public static String getJWTAssertion(String jwt) throws UnsupportedEncodingException {
        String[] jwtTokenArray = jwt.split(Pattern.quote("."));
        return jwtTokenArray[0].trim() + "." + jwtTokenArray[1].trim();
    }

    public static boolean isJwtSignatureValid(String jwtAssertion, byte[] jwtSignature, String jsonHeader) throws UnsupportedEncodingException {
        KeyStore keyStore = null;
        String thumbPrint = null;
        String signatureAlgorithm = null;
        JSONObject jsonHeaderObject = null;
        try {
            jsonHeaderObject = new JSONObject(jsonHeader);
            thumbPrint = new String(Base64.decodeBase64((byte[])jsonHeaderObject.get("x5t").toString().getBytes()));
            signatureAlgorithm = (String)jsonHeaderObject.get("alg");
        }
        catch (JSONException e) {
            log.error((Object)("Error while parsing json" + (Object)((Object)e)));
        }
        signatureAlgorithm = "RS256".equals(signatureAlgorithm) ? "SHA256withRSA" : ("RS515".equals(signatureAlgorithm) ? "SHA512withRSA" : ("RS384".equals(signatureAlgorithm) ? "SHA384withRSA" : "SHA256withRSA"));
        if (jwtAssertion != null && jwtSignature != null && thumbPrint != null) {
            try {
                String trustStore = TestConfigurationProvider.getTrustStoreLocation();
                String trustStorePassword = TestConfigurationProvider.getTrustStorePassword();
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(new FileInputStream(trustStore), trustStorePassword.toCharArray());
                String alias = APIMTestCaseUtils.getAliasForX509CertThumb(thumbPrint.getBytes(), keyStore);
                Certificate certificate = keyStore.getCertificate(alias);
                Signature signature = Signature.getInstance(signatureAlgorithm);
                signature.initVerify(certificate);
                signature.update(jwtAssertion.getBytes());
                return signature.verify(jwtSignature);
            }
            catch (java.lang.Exception e) {
                log.error((Object)"Error occurred while validating signature", (Throwable)e);
                return false;
            }
        }
        log.debug((Object)"JWT Signature is empty");
        return false;
    }

    public static String getDecodedJWTHeader(String jwt) throws UnsupportedEncodingException {
        String[] jwtTokenArray = jwt.split(Pattern.quote("."));
        byte[] jwtByteArray = Base64.decodeBase64((byte[])jwtTokenArray[0].getBytes("UTF-8"));
        return new String(jwtByteArray, "UTF-8");
    }

    public static byte[] getDecodedJWTSignature(String jwt) throws UnsupportedEncodingException {
        String[] jwtTokenArray = jwt.split(Pattern.quote("."));
        return Base64.decodeBase64((byte[])jwtTokenArray[2].getBytes());
    }

    public static byte[] getDecodedURLSafeJWTSignature(String jwt) throws UnsupportedEncodingException {
        String[] jwtTokenArray = jwt.split(Pattern.quote("."));
        return APIMTestCaseUtils.decode(jwtTokenArray[2]);
    }

    public static byte[] decode(String stringToBeDecodedArg) throws UnsupportedEncodingException {
        String stringToBeDecoded = stringToBeDecodedArg;
        stringToBeDecoded = stringToBeDecoded.replaceAll("-", "+");
        stringToBeDecoded = stringToBeDecoded.replaceAll("_", "/");
        switch (stringToBeDecoded.length() % 4) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                stringToBeDecoded = stringToBeDecoded + "==";
                break;
            }
            case 3: {
                stringToBeDecoded = stringToBeDecoded + "=";
            }
        }
        return Base64.decodeBase64((byte[])stringToBeDecoded.getBytes("UTF-8"));
    }

    public static String getDecodedURLSafeJWT(String jwt) throws UnsupportedEncodingException {
        String[] jwtTokenArray = jwt.split(Pattern.quote("."));
        byte[] jwtByteArray = APIMTestCaseUtils.decode(jwtTokenArray[1]);
        return new String(jwtByteArray, "UTF-8");
    }

    public static String getDecodedURLSafeJWTHeader(String jwt) throws UnsupportedEncodingException {
        String[] jwtTokenArray = jwt.split(Pattern.quote("."));
        byte[] jwtByteArray = APIMTestCaseUtils.decode(jwtTokenArray[0]);
        return new String(jwtByteArray, "UTF-8");
    }

    public static List<APIIdentifier> getAPIIdentifierListFromHttpResponse(HttpResponse httpResponse) throws APIManagerIntegrationTestException {
        ArrayList<APIIdentifier> apiIdentifierList = new ArrayList<APIIdentifier>();
        if (httpResponse.getData() != null && !httpResponse.getData().equals("")) {
            try {
                JSONObject jsonRootObject = new JSONObject(httpResponse.getData());
                if (jsonRootObject.has("apis")) {
                    JSONArray jsonArray = jsonRootObject.getJSONArray("apis");
                    for (int index = 0; index < jsonArray.length(); ++index) {
                        JSONObject jsonObject = (JSONObject)jsonArray.get(index);
                        String APIName = jsonObject.getString(NAME);
                        String APIVersion = jsonObject.getString(VERSION);
                        String APIProvider = jsonObject.getString("provider");
                        apiIdentifierList.add(new APIIdentifier(APIProvider, APIName, APIVersion));
                    }
                } else if (jsonRootObject.has(API)) {
                    String APIName = jsonRootObject.getJSONObject(API).getString(NAME);
                    String APIVersion = jsonRootObject.getJSONObject(API).getString(VERSION);
                    String APIProvider = jsonRootObject.getJSONObject(API).getString("provider");
                    apiIdentifierList.add(new APIIdentifier(APIProvider, APIName, APIVersion));
                }
            }
            catch (JSONException e) {
                log.error((Object)("Error when extraction data from JSON" + e.getMessage()));
                throw new APIManagerIntegrationTestException("Error when extraction data from JSON", e);
            }
        }
        return apiIdentifierList;
    }

    public static List<APIIdentifier> getAPIIdentifierListFromHttpResponse(org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO apiListDTO) {
        if (apiListDTO == null) {
            return Collections.emptyList();
        }
        ArrayList<APIIdentifier> apiIdentifierList = new ArrayList<APIIdentifier>();
        for (APIInfoDTO apiInfoDTO : apiListDTO.getList()) {
            apiIdentifierList.add(new APIIdentifier(apiInfoDTO.getProvider(), apiInfoDTO.getName(), apiInfoDTO.getVersion()));
        }
        return apiIdentifierList;
    }

    public static List<APIIdentifier> getAPIIdentifierListFromHttpResponse(APIListDTO apiListDTO) {
        if (apiListDTO == null) {
            return Collections.emptyList();
        }
        ArrayList<APIIdentifier> apiIdentifierList = new ArrayList<APIIdentifier>();
        for (org.wso2.am.integration.clients.store.api.v1.dto.APIInfoDTO apiInfoDTO : apiListDTO.getList()) {
            apiIdentifierList.add(new APIIdentifier(apiInfoDTO.getProvider(), apiInfoDTO.getName(), apiInfoDTO.getVersion()));
        }
        return apiIdentifierList;
    }

    public static boolean isAPIAvailable(APIIdentifier apiIdentifierToCheck, List<APIIdentifier> apiIdentifierList) {
        boolean isFound = false;
        for (APIIdentifier apiIdentifier : apiIdentifierList) {
            if (!apiIdentifier.getApiName().equals(apiIdentifierToCheck.getApiName()) || !apiIdentifier.getVersion().equals(apiIdentifierToCheck.getVersion()) || !apiIdentifier.getProviderName().equals(apiIdentifierToCheck.getProviderName())) continue;
            isFound = true;
            break;
        }
        return isFound;
    }

    public static String getPayloadForPasswordGrant(String username, String password) {
        return "grant_type=password&username=" + username + "&password=" + password;
    }

    private static String getAliasForX509CertThumb(byte[] thumb, KeyStore keyStore) {
        Certificate cert = null;
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate[] certs = keyStore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = keyStore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                } else {
                    cert = certs[0];
                }
                sha.update(cert.getEncoded());
                byte[] data = sha.digest();
                if (!new String(thumb).equals(APIMTestCaseUtils.hexify(data))) continue;
                return alias;
            }
        }
        catch (java.lang.Exception e) {
            log.error((Object)"Error while getting the alias", (Throwable)e);
        }
        return null;
    }

    private static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            buf.append(hexDigits[(aByte & 0xF0) >> 4]);
            buf.append(hexDigits[aByte & 0xF]);
        }
        return buf.toString();
    }

    public static boolean isAPIAvailable(APIIdentifier apiIdentifier, org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO apiListDTO) {
        boolean isFound = false;
        if (apiListDTO != null) {
            for (APIInfoDTO api : apiListDTO.getList()) {
                if (!apiIdentifier.getName().equals(api.getName()) || !apiIdentifier.getVersion().equals(api.getVersion()) || !apiIdentifier.getProviderName().equals(api.getProvider())) continue;
                isFound = true;
                break;
            }
        }
        return isFound;
    }

    public static boolean isAPIAvailableInStore(APIIdentifier apiIdentifier, APIListDTO apiListDTO) {
        boolean isFound = false;
        if (apiListDTO != null) {
            for (org.wso2.am.integration.clients.store.api.v1.dto.APIInfoDTO api : apiListDTO.getList()) {
                if (!apiIdentifier.getName().equals(api.getName()) || !apiIdentifier.getVersion().equals(api.getVersion()) || !apiIdentifier.getProviderName().equals(api.getProvider())) continue;
                isFound = true;
                break;
            }
        }
        return isFound;
    }

    public static String encodeCredentials(String user, char[] pass) {
        StringBuilder builder = new StringBuilder(user).append(':').append(pass);
        String cred = builder.toString();
        byte[] encodedBytes = Base64.encodeBase64((byte[])cred.getBytes());
        return new String(encodedBytes);
    }
}

