/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.wso2.am.integration.test.utils.http.HttpRequestUtil;

public class HTTPSClientUtils {
    private static Log log = LogFactory.getLog(HttpRequestUtil.class);

    public static org.wso2.carbon.automation.test.utils.http.client.HttpResponse doGet(String url, Map<String, String> headers) throws IOException {
        CloseableHttpClient httpClient = HTTPSClientUtils.getHttpsClient();
        HttpResponse response = HTTPSClientUtils.sendGetRequest(httpClient, url, headers);
        return HTTPSClientUtils.constructResponse(response);
    }

    public static org.wso2.carbon.automation.test.utils.http.client.HttpResponse doPost(String url, Map<String, String> headers, List<NameValuePair> urlParameters) throws IOException {
        CloseableHttpClient httpClient = HTTPSClientUtils.getHttpsClient();
        HttpResponse response = HTTPSClientUtils.sendPOSTMessage(httpClient, url, headers, urlParameters);
        return HTTPSClientUtils.constructResponse(response);
    }

    public static org.wso2.carbon.automation.test.utils.http.client.HttpResponse doMutulSSLGet(String path, String url, Map<String, String> headers) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        CloseableHttpClient httpClient = HTTPSClientUtils.getMutualSSLHttpsClient(path);
        HttpResponse response = HTTPSClientUtils.sendGetRequest(httpClient, url, headers);
        return HTTPSClientUtils.constructResponse(response);
    }

    public static org.wso2.carbon.automation.test.utils.http.client.HttpResponse doPost(String url, Map<String, String> headers, String payload) throws IOException {
        CloseableHttpClient httpClient = HTTPSClientUtils.getHttpsClient();
        HttpResponse response = HTTPSClientUtils.sendPOSTMessage(httpClient, url, headers, payload);
        return HTTPSClientUtils.constructResponse(response);
    }

    public static org.wso2.carbon.automation.test.utils.http.client.HttpResponse doPut(String url, Map<String, String> headers, String payload) throws IOException {
        CloseableHttpClient httpClient = HTTPSClientUtils.getHttpsClient();
        HttpResponse response = HTTPSClientUtils.sendPUTMessage(httpClient, url, headers, payload);
        return HTTPSClientUtils.constructResponse(response);
    }

    public static org.wso2.carbon.automation.test.utils.http.client.HttpResponse doPost(URL url, Map<String, String> headers, String json) throws IOException {
        CloseableHttpClient httpClient = HTTPSClientUtils.getHttpsClient();
        HttpResponse response = HTTPSClientUtils.sendPOSTMessage(httpClient, url.toString(), headers, json);
        return HTTPSClientUtils.constructResponse(response);
    }

    public static org.wso2.carbon.automation.test.utils.http.client.HttpResponse doPost(URL url, String urlParams, Map<String, String> headers) throws IOException {
        ArrayList<NameValuePair> urlParameters = new ArrayList<NameValuePair>();
        if (urlParams != null && urlParams.contains("=")) {
            String[] paramList;
            for (String pair : paramList = urlParams.split("&")) {
                if (!pair.contains("=")) continue;
                String[] pairList = pair.split("=");
                String key = pairList[0];
                String value = pairList.length > 1 ? pairList[1] : "";
                urlParameters.add((NameValuePair)new BasicNameValuePair(key, URLDecoder.decode(value, "UTF-8")));
            }
        }
        return HTTPSClientUtils.doPost(url.toString(), headers, urlParameters);
    }

    public static CloseableHttpClient getHttpsClient() {
        int timeout = 7;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 10000).setConnectionRequestTimeout(timeout * 10000).setSocketTimeout(timeout * 10000).build();
        CloseableHttpClient httpClient = HttpClients.custom().disableRedirectHandling().setDefaultRequestConfig(config).setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER).build();
        return httpClient;
    }

    private static CloseableHttpClient getMutualSSLHttpsClient(String keyStorePath) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException {
        int timeout = 7;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 10000).setConnectionRequestTimeout(timeout * 10000).setSocketTimeout(timeout * 10000).build();
        KeyStore trustStore = KeyStore.getInstance("JKS");
        try (InputStream is = Files.newInputStream(Paths.get(keyStorePath, new String[0]), new OpenOption[0]);){
            trustStore.load(is, "password".toCharArray());
        }
        catch (IOException | CertificateException e) {
            log.error((Object)"Error while loading keystore", (Throwable)e);
        }
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).loadKeyMaterial(trustStore, "password".toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).disableRedirectHandling().setDefaultRequestConfig(config).setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER).build();
    }

    private static HttpResponse sendGetRequest(CloseableHttpClient httpClient, String url, Map<String, String> headers) throws IOException {
        HttpGet request = new HttpGet(url);
        if (headers != null) {
            for (Map.Entry<String, String> head : headers.entrySet()) {
                request.addHeader(head.getKey(), head.getValue());
            }
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    private static HttpResponse sendPOSTMessage(CloseableHttpClient httpClient, String url, Map<String, String> headers, List<NameValuePair> urlParameters) throws IOException {
        HttpPost post = new HttpPost(url);
        if (headers != null) {
            for (Map.Entry<String, String> head : headers.entrySet()) {
                post.addHeader(head.getKey(), head.getValue());
            }
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
        return httpClient.execute((HttpUriRequest)post);
    }

    private static HttpResponse sendPOSTMessage(CloseableHttpClient httpClient, String url, Map<String, String> headers, String body) throws IOException {
        HttpPost post = new HttpPost(url);
        if (headers != null) {
            for (Map.Entry<String, String> head : headers.entrySet()) {
                post.addHeader(head.getKey(), head.getValue());
            }
        }
        post.setEntity((HttpEntity)new StringEntity(body));
        return httpClient.execute((HttpUriRequest)post);
    }

    private static HttpResponse sendPUTMessage(CloseableHttpClient httpClient, String url, Map<String, String> headers, String body) throws IOException {
        HttpPut put = new HttpPut(url);
        if (headers != null) {
            for (Map.Entry<String, String> head : headers.entrySet()) {
                put.addHeader(head.getKey(), head.getValue());
            }
        }
        put.setEntity((HttpEntity)new StringEntity(body));
        return httpClient.execute((HttpUriRequest)put);
    }

    private static org.wso2.carbon.automation.test.utils.http.client.HttpResponse constructResponse(HttpResponse response) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        String body = HTTPSClientUtils.getResponseBody(response);
        Header[] headers = response.getAllHeaders();
        HashMap<String, String> heads = new HashMap<String, String>();
        for (Header header : headers) {
            heads.put(header.getName(), header.getValue());
        }
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse res = new org.wso2.carbon.automation.test.utils.http.client.HttpResponse(body, code, heads);
        return res;
    }

    public static String getResponseBody(HttpResponse response) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
        StringBuffer sb = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            sb.append(line);
        }
        rd.close();
        return sb.toString();
    }
}

