/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.impl;

import com.google.gson.Gson;
import org.apache.commons.lang.StringUtils;
import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.AdvancedPolicyCollectionApi;
import org.wso2.am.integration.clients.admin.api.AdvancedPolicyIndividualApi;
import org.wso2.am.integration.clients.admin.api.ApplicationApi;
import org.wso2.am.integration.clients.admin.api.ApplicationCollectionApi;
import org.wso2.am.integration.clients.admin.api.ApplicationPolicyCollectionApi;
import org.wso2.am.integration.clients.admin.api.ApplicationPolicyIndividualApi;
import org.wso2.am.integration.clients.admin.api.CustomRulesCollectionApi;
import org.wso2.am.integration.clients.admin.api.CustomRulesIndividualApi;
import org.wso2.am.integration.clients.admin.api.KeyManagerCollectionApi;
import org.wso2.am.integration.clients.admin.api.KeyManagerIndividualApi;
import org.wso2.am.integration.clients.admin.api.LabelApi;
import org.wso2.am.integration.clients.admin.api.LabelCollectionApi;
import org.wso2.am.integration.clients.admin.api.SettingsApi;
import org.wso2.am.integration.clients.admin.api.SubscriptionPolicyCollectionApi;
import org.wso2.am.integration.clients.admin.api.SubscriptionPolicyIndividualApi;
import org.wso2.am.integration.clients.admin.api.WorkflowCollectionApi;
import org.wso2.am.integration.clients.admin.api.WorkflowsIndividualApi;
import org.wso2.am.integration.clients.admin.api.dto.AdvancedThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationListDTO;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.CustomRuleDTO;
import org.wso2.am.integration.clients.admin.api.dto.KeyManagerDTO;
import org.wso2.am.integration.clients.admin.api.dto.KeyManagerListDTO;
import org.wso2.am.integration.clients.admin.api.dto.LabelDTO;
import org.wso2.am.integration.clients.admin.api.dto.LabelListDTO;
import org.wso2.am.integration.clients.admin.api.dto.SettingsDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.WorkflowDTO;
import org.wso2.am.integration.clients.admin.api.dto.WorkflowInfoDTO;
import org.wso2.am.integration.clients.admin.api.dto.WorkflowListDTO;
import org.wso2.am.integration.test.ClientAuthenticator;
import org.wso2.am.integration.test.HttpResponse;

public class RestAPIAdminImpl {
    public ApiClient apiAdminClient = new ApiClient();
    private KeyManagerCollectionApi keyManagerCollectionApi = new KeyManagerCollectionApi();
    private KeyManagerIndividualApi keyManagerIndividualApi = new KeyManagerIndividualApi();
    public WorkflowCollectionApi workflowCollectionApi = new WorkflowCollectionApi();
    public WorkflowsIndividualApi workflowsIndividualApi = new WorkflowsIndividualApi();
    private SettingsApi settingsApi = new SettingsApi();
    private ApplicationPolicyIndividualApi applicationPolicyIndividualApi = new ApplicationPolicyIndividualApi();
    public ApplicationPolicyCollectionApi applicationPolicyCollectionApi = new ApplicationPolicyCollectionApi();
    private SubscriptionPolicyIndividualApi subscriptionPolicyIndividualApi = new SubscriptionPolicyIndividualApi();
    private SubscriptionPolicyCollectionApi subscriptionPolicyCollectionApi = new SubscriptionPolicyCollectionApi();
    private CustomRulesIndividualApi customRulesIndividualApi = new CustomRulesIndividualApi();
    private CustomRulesCollectionApi customRulesCollectionApi = new CustomRulesCollectionApi();
    private AdvancedPolicyIndividualApi advancedPolicyIndividualApi = new AdvancedPolicyIndividualApi();
    private AdvancedPolicyCollectionApi advancedPolicyCollectionApi = new AdvancedPolicyCollectionApi();
    private ApplicationCollectionApi applicationCollectionApi = new ApplicationCollectionApi();
    private ApplicationApi applicationApi = new ApplicationApi();
    private LabelApi labelApi = new LabelApi();
    private LabelCollectionApi labelCollectionApi = new LabelCollectionApi();
    public static final String appName = "Integration_Test_App_Admin";
    public static final String callBackURL = "test.com";
    public static final String tokenScope = "Production";
    public static final String appOwner = "admin";
    public static final String grantType = "password";
    public static final String username = "admin";
    public static final String password = "admin";
    public String tenantDomain;

    public RestAPIAdminImpl(String username, String password, String tenantDomain, String adminURl) {
        String tokenURL = adminURl + "oauth2/token";
        String dcrURL = adminURl + "client-registration/v0.17/register";
        String scopeList = "openid  apim:admin apim:tier_view apim:tier_manage apim:bl_view apim:bl_manage apim:mediation_policy_view apim:mediation_policy_create apim:app_owner_change apim:app_import_export apim:api_import_export apim:api_product_import_export apim:label_manage apim:label_read apim:monetization_usage_publish apim:api_workflow_approve apim:bot_data apim:tenantInfo apim:tenant_theme_manage apim:admin_operations apim:admin_settings apim:admin_alert_manage apim:api_workflow_view apim:api_workflow_approveapim:admin_operationapim:scope_manage";
        String accessToken = ClientAuthenticator.getAccessToken(scopeList, appName, callBackURL, tokenScope, "admin", grantType, dcrURL, username, password, tenantDomain, tokenURL);
        this.apiAdminClient.addDefaultHeader("Authorization", "Bearer " + accessToken);
        this.apiAdminClient.setBasePath(adminURl + "api/am/admin/v1");
        this.apiAdminClient.setDebugging(true);
        this.apiAdminClient.setReadTimeout(600000);
        this.apiAdminClient.setConnectTimeout(600000);
        this.apiAdminClient.setWriteTimeout(600000);
        this.keyManagerCollectionApi.setApiClient(this.apiAdminClient);
        this.keyManagerIndividualApi.setApiClient(this.apiAdminClient);
        this.settingsApi.setApiClient(this.apiAdminClient);
        this.applicationPolicyIndividualApi.setApiClient(this.apiAdminClient);
        this.applicationPolicyCollectionApi.setApiClient(this.apiAdminClient);
        this.subscriptionPolicyIndividualApi.setApiClient(this.apiAdminClient);
        this.subscriptionPolicyCollectionApi.setApiClient(this.apiAdminClient);
        this.customRulesIndividualApi.setApiClient(this.apiAdminClient);
        this.customRulesCollectionApi.setApiClient(this.apiAdminClient);
        this.advancedPolicyIndividualApi.setApiClient(this.apiAdminClient);
        this.advancedPolicyCollectionApi.setApiClient(this.apiAdminClient);
        this.applicationCollectionApi.setApiClient(this.apiAdminClient);
        this.applicationApi.setApiClient(this.apiAdminClient);
        this.labelApi.setApiClient(this.apiAdminClient);
        this.labelCollectionApi.setApiClient(this.apiAdminClient);
        this.workflowCollectionApi.setApiClient(this.apiAdminClient);
        this.workflowsIndividualApi.setApiClient(this.apiAdminClient);
        this.tenantDomain = tenantDomain;
    }

    public ApiResponse<KeyManagerDTO> addKeyManager(KeyManagerDTO keyManagerDTO) throws ApiException {
        return this.keyManagerCollectionApi.keyManagersPostWithHttpInfo(keyManagerDTO);
    }

    public KeyManagerListDTO getKeyManagers() throws ApiException {
        return this.keyManagerCollectionApi.keyManagersGet();
    }

    public KeyManagerDTO getKeyManager(String uuid) throws ApiException {
        return this.keyManagerIndividualApi.keyManagersKeyManagerIdGet(uuid);
    }

    public KeyManagerDTO updateKeyManager(String uuid, KeyManagerDTO keyManagerDTO) throws ApiException {
        return this.keyManagerIndividualApi.keyManagersKeyManagerIdPut(uuid, keyManagerDTO);
    }

    public void deleteKeyManager(String uuid) throws ApiException {
        this.keyManagerIndividualApi.keyManagersKeyManagerIdDelete(uuid);
    }

    public SettingsDTO getSettings() throws ApiException {
        return this.settingsApi.settingsGet();
    }

    public ApiResponse<ApplicationThrottlePolicyDTO> addApplicationThrottlingPolicy(ApplicationThrottlePolicyDTO applicationThrottlePolicyDTO) throws ApiException {
        return this.applicationPolicyCollectionApi.throttlingPoliciesApplicationPostWithHttpInfo(applicationThrottlePolicyDTO, "application/json");
    }

    public ApiResponse<ApplicationThrottlePolicyDTO> getApplicationThrottlingPolicy(String policyId) throws ApiException {
        return this.applicationPolicyIndividualApi.throttlingPoliciesApplicationPolicyIdGetWithHttpInfo(policyId, null, null);
    }

    public ApiResponse<ApplicationThrottlePolicyDTO> updateApplicationThrottlingPolicy(String policyId, ApplicationThrottlePolicyDTO applicationThrottlePolicyDTO) throws ApiException {
        return this.applicationPolicyIndividualApi.throttlingPoliciesApplicationPolicyIdPutWithHttpInfo(policyId, applicationThrottlePolicyDTO, "application/json", null, null);
    }

    public ApiResponse<Void> deleteApplicationThrottlingPolicy(String policyId) throws ApiException {
        return this.applicationPolicyIndividualApi.throttlingPoliciesApplicationPolicyIdDeleteWithHttpInfo(policyId, null, null);
    }

    public ApiResponse<SubscriptionThrottlePolicyDTO> addSubscriptionThrottlingPolicy(SubscriptionThrottlePolicyDTO subscriptionThrottlePolicyDTO) throws ApiException {
        return this.subscriptionPolicyCollectionApi.throttlingPoliciesSubscriptionPostWithHttpInfo(subscriptionThrottlePolicyDTO, "application/json");
    }

    public ApiResponse<SubscriptionThrottlePolicyDTO> getSubscriptionThrottlingPolicy(String policyId) throws ApiException {
        return this.subscriptionPolicyIndividualApi.throttlingPoliciesSubscriptionPolicyIdGetWithHttpInfo(policyId, null, null);
    }

    public ApiResponse<SubscriptionThrottlePolicyDTO> updateSubscriptionThrottlingPolicy(String policyId, SubscriptionThrottlePolicyDTO subscriptionThrottlePolicyDTO) throws ApiException {
        return this.subscriptionPolicyIndividualApi.throttlingPoliciesSubscriptionPolicyIdPutWithHttpInfo(policyId, subscriptionThrottlePolicyDTO, "application/json", null, null);
    }

    public ApiResponse<Void> deleteSubscriptionThrottlingPolicy(String policyId) throws ApiException {
        return this.subscriptionPolicyIndividualApi.throttlingPoliciesSubscriptionPolicyIdDeleteWithHttpInfo(policyId, null, null);
    }

    public ApiResponse<CustomRuleDTO> addCustomThrottlingPolicy(CustomRuleDTO customRuleDTO) throws ApiException {
        return this.customRulesCollectionApi.throttlingPoliciesCustomPostWithHttpInfo(customRuleDTO, "application/json");
    }

    public ApiResponse<CustomRuleDTO> getCustomThrottlingPolicy(String policyId) throws ApiException {
        return this.customRulesIndividualApi.throttlingPoliciesCustomRuleIdGetWithHttpInfo(policyId, null, null);
    }

    public ApiResponse<CustomRuleDTO> updateCustomThrottlingPolicy(String policyId, CustomRuleDTO customRuleDTO) throws ApiException {
        return this.customRulesIndividualApi.throttlingPoliciesCustomRuleIdPutWithHttpInfo(policyId, customRuleDTO, "application/json", null, null);
    }

    public ApiResponse<Void> deleteCustomThrottlingPolicy(String policyId) throws ApiException {
        return this.customRulesIndividualApi.throttlingPoliciesCustomRuleIdDeleteWithHttpInfo(policyId, null, null);
    }

    public ApiResponse<AdvancedThrottlePolicyDTO> addAdvancedThrottlingPolicy(AdvancedThrottlePolicyDTO advancedThrottlePolicyDTO) throws ApiException {
        return this.advancedPolicyCollectionApi.throttlingPoliciesAdvancedPostWithHttpInfo(advancedThrottlePolicyDTO, "application/json");
    }

    public ApiResponse<AdvancedThrottlePolicyDTO> getAdvancedThrottlingPolicy(String policyId) throws ApiException {
        return this.advancedPolicyIndividualApi.throttlingPoliciesAdvancedPolicyIdGetWithHttpInfo(policyId, null, null);
    }

    public ApiResponse<AdvancedThrottlePolicyDTO> updateAdvancedThrottlingPolicy(String policyId, AdvancedThrottlePolicyDTO advancedThrottlePolicyDTO) throws ApiException {
        return this.advancedPolicyIndividualApi.throttlingPoliciesAdvancedPolicyIdPutWithHttpInfo(policyId, advancedThrottlePolicyDTO, "application/json", null, null);
    }

    public ApiResponse<Void> deleteAdvancedThrottlingPolicy(String policyId) throws ApiException {
        return this.advancedPolicyIndividualApi.throttlingPoliciesAdvancedPolicyIdDeleteWithHttpInfo(policyId, null, null);
    }

    public ApiResponse<LabelDTO> addLabel(LabelDTO labelDTO) throws ApiException {
        return this.labelApi.labelsPostWithHttpInfo(labelDTO);
    }

    public ApiResponse<LabelListDTO> getLabels() throws ApiException {
        return this.labelCollectionApi.labelsGetWithHttpInfo();
    }

    public ApiResponse<LabelDTO> updateLabel(String labelId, LabelDTO labelDTO) throws ApiException {
        return this.labelApi.labelsLabelIdPutWithHttpInfo(labelId, labelDTO);
    }

    public ApiResponse<Void> deleteLabel(String labelId) throws ApiException {
        return this.labelApi.labelsLabelIdDeleteWithHttpInfo(labelId, null, null);
    }

    public ApiResponse<ApplicationListDTO> getApplications(String user, Integer limit, Integer offset, String appTenantDomain) throws ApiException {
        return this.applicationCollectionApi.applicationsGetWithHttpInfo(user, limit, offset, null, null, appTenantDomain);
    }

    public ApiResponse<Void> changeApplicationOwner(String newOwner, String applicationId) throws ApiException {
        return this.applicationApi.applicationsApplicationIdChangeOwnerPostWithHttpInfo(newOwner, applicationId);
    }

    public HttpResponse getWorkflowByExternalWorkflowReference(String externalWorkflowRef) throws ApiException {
        WorkflowInfoDTO workflowInfodto = null;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            workflowInfodto = this.workflowsIndividualApi.workflowsExternalWorkflowRefGet(externalWorkflowRef, null);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (StringUtils.isNotEmpty((String)workflowInfodto.getReferenceId())) {
            response = new HttpResponse(gson.toJson((Object)workflowInfodto), 200);
        }
        return response;
    }

    public HttpResponse getWorkflows(String workflowType) throws ApiException {
        WorkflowListDTO workflowListdto = null;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            workflowListdto = this.workflowCollectionApi.workflowsGet(null, null, null, null, workflowType);
            response = new HttpResponse(gson.toJson((Object)workflowListdto), 200);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        return response;
    }

    public HttpResponse updateWorkflowStatus(String workflowReferenceId) throws ApiException {
        WorkflowDTO workflowdto = null;
        HttpResponse response = null;
        Gson gson = new Gson();
        WorkflowDTO body = new WorkflowDTO();
        WorkflowDTO.StatusEnum status = (WorkflowDTO.StatusEnum)WorkflowDTO.StatusEnum.valueOf(WorkflowDTO.StatusEnum.class, (String)"APPROVED");
        body.setStatus(status);
        body.setDescription("Approve workflow request.");
        try {
            workflowdto = this.workflowsIndividualApi.workflowsUpdateWorkflowStatusPost(workflowReferenceId, body);
            response = new HttpResponse(gson.toJson((Object)workflowdto), 200);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        return response;
    }
}

