/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.utils.base;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.wso2.am.admin.clients.application.ApplicationManagementClient;
import org.wso2.am.admin.clients.claim.ClaimMetaDataMgtAdminClient;
import org.wso2.am.admin.clients.oauth.OAuthAdminServiceClient;
import org.wso2.am.admin.clients.user.RemoteUserStoreManagerServiceClient;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.impl.RestAPIAdminImpl;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIMURLBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.clients.AdminDashboardRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HttpRequestUtil;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.TenantManagementServiceClient;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;
import org.wso2.carbon.tenant.mgt.stub.beans.xsd.TenantInfoBean;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIMIntegrationBaseTest.class);
    protected AutomationContext storeContext;
    protected AutomationContext publisherContext;
    protected AutomationContext keyManagerContext;
    protected AutomationContext gatewayContextMgt;
    protected AutomationContext gatewayContextWrk;
    protected AutomationContext backEndServer;
    protected AutomationContext superTenantKeyManagerContext;
    protected AutomationContext adminContext;
    protected OMElement synapseConfiguration;
    protected APIMTestCaseUtils apimTestCaseUtils;
    protected TestUserMode userMode;
    protected String executionMode;
    protected APIMURLBean storeUrls;
    protected APIMURLBean publisherUrls;
    protected APIMURLBean gatewayUrlsMgt;
    protected APIMURLBean gatewayUrlsWrk;
    protected APIMURLBean keyMangerUrl;
    protected APIMURLBean backEndServerUrl;
    protected APIMURLBean adminUrls;
    protected User user;
    private static final long WAIT_TIME = 45000L;
    protected APIPublisherRestClient apiPublisher;
    protected APIStoreRestClient apiStore;
    protected AdminDashboardRestClient apiAdmin;
    protected RestAPIPublisherImpl restAPIPublisher;
    protected RestAPIStoreImpl restAPIStore;
    protected RestAPIAdminImpl restAPIAdmin;
    protected UserManagementClient userManagementClient;
    protected RemoteUserStoreManagerServiceClient remoteUserStoreManagerServiceClient;
    protected ClaimMetaDataMgtAdminClient remoteClaimMetaDataMgtAdminClient;
    protected OAuthAdminServiceClient oAuthAdminServiceClient;
    protected ApplicationManagementClient applicationManagementClient;
    protected TenantManagementServiceClient tenantManagementServiceClient;
    protected String publisherURLHttp;
    protected String publisherURLHttps;
    protected String adminURLHttp;
    protected String adminURLHttps;
    protected String keyManagerHTTPSURL;
    protected String gatewayHTTPSURL;
    protected String storeURLHttp;
    protected String storeURLHttps;
    protected String keymanagerSessionCookie;
    protected String keymanagerSuperTenantSessionCookie;
    protected final int inboundWebSocketPort = 9099;
    protected final int portOffset = 500;

    protected void init() throws APIManagerIntegrationTestException {
        this.userMode = TestUserMode.SUPER_TENANT_ADMIN;
        this.init(this.userMode);
    }

    protected void init(TestUserMode userMode) throws APIManagerIntegrationTestException {
        this.apimTestCaseUtils = new APIMTestCaseUtils();
        try {
            this.storeContext = new AutomationContext("APIM", "store-old", userMode);
            this.storeUrls = new APIMURLBean(this.storeContext.getContextUrls());
            this.adminContext = new AutomationContext("APIM", "publisher-old", userMode);
            this.adminUrls = new APIMURLBean(this.adminContext.getContextUrls());
            this.publisherContext = new AutomationContext("APIM", "publisher-old", userMode);
            this.publisherUrls = new APIMURLBean(this.publisherContext.getContextUrls());
            this.gatewayContextMgt = new AutomationContext("APIM", "gateway-mgt", userMode);
            this.gatewayUrlsMgt = new APIMURLBean(this.gatewayContextMgt.getContextUrls());
            this.gatewayContextWrk = new AutomationContext("APIM", "gateway-wrk", userMode);
            this.gatewayUrlsWrk = new APIMURLBean(this.gatewayContextWrk.getContextUrls());
            this.keyManagerContext = new AutomationContext("APIM", "keyManager", userMode);
            this.keyMangerUrl = new APIMURLBean(this.keyManagerContext.getContextUrls());
            this.backEndServer = new AutomationContext("APIM", "backend-server", userMode);
            this.backEndServerUrl = new APIMURLBean(this.backEndServer.getContextUrls());
            this.executionMode = this.gatewayContextMgt.getConfigurationValue("//executionEnvironment/text()");
            this.user = this.storeContext.getContextTenant().getContextUser();
            this.superTenantKeyManagerContext = new AutomationContext("APIM", "keyManager", TestUserMode.SUPER_TENANT_ADMIN);
            this.keymanagerSessionCookie = this.createSession(this.keyManagerContext);
            this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
            this.publisherURLHttps = this.publisherUrls.getWebAppURLHttps();
            this.keyManagerHTTPSURL = this.keyMangerUrl.getWebAppURLHttps();
            this.gatewayHTTPSURL = this.gatewayUrlsWrk.getWebAppURLNhttps();
            this.adminURLHttps = this.adminUrls.getWebAppURLHttps();
            this.adminURLHttp = this.adminUrls.getWebAppURLHttps();
            this.storeURLHttp = this.storeUrls.getWebAppURLHttp();
            this.storeURLHttps = this.storeUrls.getWebAppURLHttps();
            this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
            this.apiStore = new APIStoreRestClient(this.storeURLHttp);
            this.apiAdmin = new AdminDashboardRestClient(this.adminURLHttp);
            this.restAPIPublisher = new RestAPIPublisherImpl(this.publisherContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.publisherContext.getContextTenant().getContextUser().getPassword(), this.publisherContext.getContextTenant().getDomain(), this.publisherURLHttps);
            this.restAPIStore = new RestAPIStoreImpl(this.storeContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.storeContext.getContextTenant().getContextUser().getPassword(), this.storeContext.getContextTenant().getDomain(), this.storeURLHttps);
            this.restAPIAdmin = new RestAPIAdminImpl(this.publisherContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.publisherContext.getContextTenant().getContextUser().getPassword(), this.publisherContext.getContextTenant().getDomain(), this.publisherURLHttps);
            try {
                this.keymanagerSuperTenantSessionCookie = new LoginLogoutClient(this.superTenantKeyManagerContext).login();
                this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keymanagerSessionCookie);
                this.remoteUserStoreManagerServiceClient = new RemoteUserStoreManagerServiceClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keymanagerSessionCookie);
                this.tenantManagementServiceClient = new TenantManagementServiceClient(this.superTenantKeyManagerContext.getContextUrls().getBackEndUrl(), this.keymanagerSuperTenantSessionCookie);
                this.remoteClaimMetaDataMgtAdminClient = new ClaimMetaDataMgtAdminClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keymanagerSessionCookie);
                this.oAuthAdminServiceClient = new OAuthAdminServiceClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keymanagerSessionCookie);
                this.applicationManagementClient = new ApplicationManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keymanagerSessionCookie);
            }
            catch (Exception e) {
                throw new APIManagerIntegrationTestException(e.getMessage(), e);
            }
        }
        catch (XPathExpressionException e) {
            log.error((Object)"APIM test environment initialization failed", (Throwable)e);
            throw new APIManagerIntegrationTestException("APIM test environment initialization failed", e);
        }
    }

    protected void init(String domainKey, String userKey) throws APIManagerIntegrationTestException {
        try {
            this.storeContext = new AutomationContext("APIM", "store-old", domainKey, userKey);
            this.storeUrls = new APIMURLBean(this.storeContext.getContextUrls());
            this.publisherContext = new AutomationContext("APIM", "publisher-old", domainKey, userKey);
            this.publisherUrls = new APIMURLBean(this.publisherContext.getContextUrls());
            this.gatewayContextMgt = new AutomationContext("APIM", "gateway-mgt", domainKey, userKey);
            this.gatewayUrlsMgt = new APIMURLBean(this.gatewayContextMgt.getContextUrls());
            this.gatewayContextWrk = new AutomationContext("APIM", "gateway-wrk", domainKey, userKey);
            this.gatewayUrlsWrk = new APIMURLBean(this.gatewayContextWrk.getContextUrls());
            this.keyManagerContext = new AutomationContext("APIM", "keyManager", domainKey, userKey);
            this.keyMangerUrl = new APIMURLBean(this.keyManagerContext.getContextUrls());
            this.backEndServer = new AutomationContext("APIM", "backend-server", domainKey, userKey);
            this.backEndServerUrl = new APIMURLBean(this.backEndServer.getContextUrls());
            this.user = this.storeContext.getContextTenant().getContextUser();
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Init failed", (Throwable)e);
            throw new APIManagerIntegrationTestException("APIM test environment initialization failed", e);
        }
    }

    protected void loadSynapseConfigurationFromClasspath(String relativeFilePath, AutomationContext automationContext, String sessionCookie) throws APIManagerIntegrationTestException {
        relativeFilePath = relativeFilePath.replaceAll("[\\\\/]", Matcher.quoteReplacement(File.separator));
        try {
            OMElement synapseConfig = APIMTestCaseUtils.loadResource(relativeFilePath);
            this.updateSynapseConfiguration(synapseConfig, automationContext, sessionCookie);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"synapse config loading issue", (Throwable)e);
            throw new APIManagerIntegrationTestException("synapse config loading issue", e);
        }
        catch (XMLStreamException e) {
            log.error((Object)"synapse config loading issue", (Throwable)e);
            throw new APIManagerIntegrationTestException("synapse config loading issue", e);
        }
    }

    protected String createSession(AutomationContext automationContext) throws APIManagerIntegrationTestException {
        try {
            LoginLogoutClient loginLogoutClient = new LoginLogoutClient(automationContext);
            return loginLogoutClient.login();
        }
        catch (Exception e) {
            log.error((Object)"session creation error", (Throwable)e);
            throw new APIManagerIntegrationTestException("session creation error", e);
        }
    }

    protected String getAMResourceLocation() {
        return FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "AM";
    }

    protected void updateSynapseConfiguration(OMElement synapseConfig, AutomationContext automationContext, String sessionCookie) throws APIManagerIntegrationTestException {
        if (this.synapseConfiguration == null) {
            this.synapseConfiguration = synapseConfig;
        } else {
            Iterator itr = synapseConfig.cloneOMElement().getChildElements();
            while (itr.hasNext()) {
                this.synapseConfiguration.addChild((OMNode)itr.next());
            }
        }
        try {
            APIMTestCaseUtils.updateSynapseConfiguration(synapseConfig, automationContext.getContextUrls().getBackEndUrl(), sessionCookie);
        }
        catch (Exception e) {
            log.error((Object)"synapse config  upload error", (Throwable)e);
            throw new APIManagerIntegrationTestException("synapse config  upload error", e);
        }
    }

    protected String getStoreURLHttp() {
        return this.storeUrls.getWebAppURLHttp();
    }

    protected String getStoreURLHttps() {
        return this.storeUrls.getWebAppURLHttps();
    }

    protected String getPublisherURLHttp() {
        return this.publisherUrls.getWebAppURLHttp();
    }

    protected String getPublisherURLHttps() {
        return this.publisherUrls.getWebAppURLHttps();
    }

    protected String getGatewayMgtURLHttp() {
        return this.gatewayUrlsMgt.getWebAppURLHttp();
    }

    protected String getGatewayMgtBackendURLHttps() {
        return this.gatewayUrlsMgt.getWebAppURLHttp();
    }

    protected String getGatewayMgtURLHttps() {
        return this.gatewayUrlsMgt.getWebAppURLHttps();
    }

    protected String getGatewayURLHttp() {
        return this.gatewayUrlsWrk.getWebAppURLHttp();
    }

    protected String getGatewayURLNhttp() {
        return this.gatewayUrlsWrk.getWebAppURLNhttp();
    }

    protected String getGatewayURLHttps() {
        return this.gatewayUrlsWrk.getWebAppURLHttps();
    }

    protected String getGatewayURLNhttps() {
        return this.gatewayUrlsWrk.getWebAppURLNhttps();
    }

    protected String getKeyManagerURLHttp() {
        return this.keyMangerUrl.getWebAppURLHttp();
    }

    protected String getKeyManagerURLHttps() throws XPathExpressionException {
        return this.keyManagerContext.getContextUrls().getBackEndUrl().replace("/services", "");
    }

    protected String getAPIInvocationURLHttp(String apiContext) throws XPathExpressionException {
        return this.gatewayContextWrk.getContextUrls().getServiceUrl().replace("/services", "") + "/" + apiContext;
    }

    protected String getAPIInvocationURLHttp(String apiContext, String version) throws XPathExpressionException {
        return this.gatewayContextWrk.getContextUrls().getServiceUrl().replace("/services", "") + "/" + apiContext + "/" + version;
    }

    protected String getAPIInvocationURLHttps(String apiContext, String version) throws XPathExpressionException {
        return this.gatewayContextWrk.getContextUrls().getSecureServiceUrl().replace("/services", "") + "/" + apiContext + "/" + version;
    }

    protected String getWebSocketAPIInvocationURL(String apiContext, String version) throws XPathExpressionException {
        String url = this.gatewayContextWrk.getContextUrls().getServiceUrl().replace("/services", "").replace("http", "ws");
        url = url.substring(0, url.lastIndexOf(":") + 1) + 9599 + "/" + apiContext + "/" + version;
        return url;
    }

    protected String getWebSocketTenantAPIInvocationURL(String apiContext, String version, String tenantDomain) throws XPathExpressionException {
        String url = this.gatewayContextWrk.getContextUrls().getServiceUrl().replace("/services", "").replace("http", "ws");
        url = url.substring(0, url.lastIndexOf(":") + 1) + 9599 + "/t/" + tenantDomain + "/" + apiContext + "/" + version;
        return url;
    }

    protected String getAPIInvocationURLHttps(String apiContext) throws XPathExpressionException {
        return this.gatewayContextWrk.getContextUrls().getSecureServiceUrl().replace("/services", "") + "/" + apiContext;
    }

    protected String getBackendEndServiceEndPointHttp(String serviceName) {
        return this.backEndServerUrl.getWebAppURLHttp() + serviceName;
    }

    protected String getBackendEndServiceEndPointHttps(String serviceName) {
        return this.backEndServerUrl.getWebAppURLHttps() + serviceName;
    }

    protected String getSuperTenantAPIInvocationURLHttp(String apiContext, String version) throws XPathExpressionException {
        return this.gatewayContextWrk.getContextUrls().getServiceUrl().replace("/services", "").replace("/t/" + this.user.getUserDomain(), "") + "/" + apiContext + "/" + version;
    }

    protected void cleanUp() throws Exception {
        APIListDTO apiListDTO;
        ApplicationListDTO applicationListDTO = this.restAPIStore.getAllApps();
        for (ApplicationInfoDTO applicationInfoDTO : applicationListDTO.getList()) {
            SubscriptionListDTO subsDTO = this.restAPIStore.getAllSubscriptionsOfApplication(applicationInfoDTO.getApplicationId());
            if (subsDTO != null) {
                for (SubscriptionDTO subscriptionDTO : subsDTO.getList()) {
                    this.restAPIStore.removeSubscription(subscriptionDTO.getSubscriptionId());
                }
            }
            if ("DefaultApplication".equals(applicationInfoDTO.getName())) continue;
            this.restAPIStore.deleteApplication(applicationInfoDTO.getApplicationId());
        }
        APIProductListDTO allApiProducts = this.restAPIPublisher.getAllApiProducts();
        List apiProductListDTO = allApiProducts.getList();
        if (apiProductListDTO != null) {
            for (APIProductInfoDTO apiProductInfoDTO : apiProductListDTO) {
                this.restAPIPublisher.deleteApiProduct(apiProductInfoDTO.getId());
            }
        }
        if ((apiListDTO = this.restAPIPublisher.getAllAPIs()) != null) {
            for (APIInfoDTO apiInfoDTO : apiListDTO.getList()) {
                this.restAPIPublisher.deleteAPI(apiInfoDTO.getId());
            }
        }
    }

    protected void verifyResponse(HttpResponse httpResponse) throws JSONException {
        Assert.assertNotNull((Object)httpResponse, (String)"Response object is null");
        log.info((Object)("Response Code : " + httpResponse.getResponseCode()));
        log.info((Object)("Response Message : " + httpResponse.getData()));
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        JSONObject responseData = new JSONObject(httpResponse.getData());
        Assert.assertFalse((boolean)responseData.getBoolean("error"), (String)("Error message received " + httpResponse.getData()));
    }

    protected void waitForAPIDeployment() {
        try {
            if (this.executionMode.equalsIgnoreCase(String.valueOf(ExecutionEnvironment.PLATFORM))) {
                Thread.sleep(45000L);
            } else {
                Thread.sleep(15000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void waitForAPIDeploymentSync(String apiProvider, String apiName, String apiVersion, String expectedResponse) throws APIManagerIntegrationTestException, XPathExpressionException {
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + 45000L;
        String colonSeparatedHeader = this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName() + ":" + this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword();
        String authorizationHeader = "Basic " + new String(Base64.encodeBase64((byte[])colonSeparatedHeader.getBytes()));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", authorizationHeader);
        String tenantIdentifier = this.getTenantIdentifier(apiProvider);
        while (waitTime > System.currentTimeMillis()) {
            HttpResponse response = null;
            try {
                response = HttpRequestUtil.doGet(this.getGatewayURLHttp() + "APIStatusMonitor/apiInformation/api/" + tenantIdentifier + apiName + "/" + apiVersion, headerMap);
            }
            catch (IOException ignored) {
                log.warn((Object)("WebAPP: APIStatusMonitor not yet deployed or API :" + apiName + " not yet deployed  with provider: " + apiProvider));
            }
            log.info((Object)("WAIT for availability of API: " + apiName + " with version: " + apiVersion + " with provider: " + apiProvider + " with Tenant Identifier: " + tenantIdentifier + " with expected response : " + expectedResponse));
            if (response == null) continue;
            log.info((Object)("Data: " + response.getData()));
            if (response.getData().contains(expectedResponse)) {
                log.info((Object)("API :" + apiName + " with version: " + apiVersion + " with expected response " + expectedResponse + " found"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void waitForAPIUnDeploymentSync(String apiProvider, String apiName, String apiVersion, String expectedResponse) throws APIManagerIntegrationTestException {
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + 45000L;
        String tenantIdentifier = this.getTenantIdentifier(apiProvider);
        String colonSeparatedHeader = this.user.getUserName() + ":" + this.user.getPassword();
        String authorizationHeader = "Basic " + Base64.encodeBase64((byte[])colonSeparatedHeader.getBytes()).toString();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", authorizationHeader);
        while (waitTime > System.currentTimeMillis()) {
            HttpResponse response = null;
            try {
                response = HttpRequestUtil.doGet(this.getGatewayURLHttp() + "APIStatusMonitor/apiInformation/api/" + tenantIdentifier + apiName + "/" + apiVersion, headerMap);
            }
            catch (IOException ignored) {
                log.warn((Object)("WebAPP: APIStatusMonitor not yet deployed or API :" + apiName + " not yet deployed  with provider: " + apiProvider));
            }
            log.info((Object)("WAIT for meta data sync of API :" + apiName + " with version: " + apiVersion + " with provider: " + apiProvider + " without entry : " + expectedResponse));
            if (response == null) continue;
            if (!response.getData().contains(expectedResponse)) {
                log.info((Object)("API :" + apiName + " with version: " + apiVersion + " with expected response " + expectedResponse + " not found"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private String getTenantIdentifier(String apiProvider) throws APIManagerIntegrationTestException {
        int tenantId = -1234;
        String providerTenantDomain = MultitenantUtils.getTenantDomain((String)apiProvider);
        try {
            if (!"carbon.super".equals(providerTenantDomain)) {
                this.keymanagerSuperTenantSessionCookie = new LoginLogoutClient(this.superTenantKeyManagerContext).login();
                this.tenantManagementServiceClient = new TenantManagementServiceClient(this.superTenantKeyManagerContext.getContextUrls().getBackEndUrl(), this.keymanagerSuperTenantSessionCookie);
                TenantInfoBean tenant = this.tenantManagementServiceClient.getTenant(providerTenantDomain);
                if (tenant == null) {
                    log.info((Object)("tenant is null: " + providerTenantDomain));
                } else {
                    tenantId = tenant.getTenantId();
                }
                new LoginLogoutClient(this.gatewayContextWrk).login();
            }
        }
        catch (Exception e) {
            throw new APIManagerIntegrationTestException(e.getMessage(), e);
        }
        return providerTenantDomain + "/" + tenantId + "/";
    }

    protected Header pickHeader(Header[] headers, String requiredHeader) {
        if (requiredHeader == null) {
            return null;
        }
        for (Header header : headers) {
            if (!requiredHeader.equals(header.getName())) continue;
            return header;
        }
        return null;
    }

    protected RestAPIPublisherImpl getRestAPIPublisherForUser(String user, String pass, String tenantDomain) {
        return new RestAPIPublisherImpl(user, pass, tenantDomain, this.publisherURLHttps);
    }

    protected RestAPIStoreImpl getRestAPIStoreForUser(String user, String pass, String tenantDomain) {
        return new RestAPIStoreImpl(user, pass, tenantDomain, this.storeURLHttps);
    }

    protected RestAPIStoreImpl getRestAPIStoreForAnonymousUser(String tenantDomain) {
        return new RestAPIStoreImpl(tenantDomain, this.storeURLHttps);
    }

    protected void waitForKeyManagerDeployment(String tenantDomain, String keyManagerName) throws XPathExpressionException, UnsupportedEncodingException {
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + 45000L;
        String colonSeparatedHeader = this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName() + ":" + this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword();
        String authorizationHeader = "Basic " + new String(Base64.encodeBase64((byte[])colonSeparatedHeader.getBytes()));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        keyManagerName = URLEncoder.encode(keyManagerName, "utf8").replaceAll("\\+", "%20");
        headerMap.put("Authorization", authorizationHeader);
        while (waitTime > System.currentTimeMillis()) {
            HttpResponse response = null;
            try {
                response = HttpRequestUtil.doGet(this.getGatewayURLHttp() + "APIStatusMonitor/keyManagerInformation/" + tenantDomain + "/" + keyManagerName, headerMap);
            }
            catch (IOException ignored) {
                log.warn((Object)("WebAPP: APIStatusMonitor not yet deployed or KeyManager :" + keyManagerName + " not yet deployed  in tenantDomain " + tenantDomain));
            }
            log.info((Object)("WAIT for availability of KeyManager: " + keyManagerName + " in tenant Domain : " + tenantDomain));
            if (response == null) continue;
            log.info((Object)("Status Code: " + response.getResponseCode()));
            if (response.getResponseCode() == 200) {
                log.info((Object)("Key Manager :" + keyManagerName + " Exist in tenant" + tenantDomain));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

