/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductBusinessInformationDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIScopeDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ProductAPIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIBusinessInformationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APITiersDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ScopeInfoDTO;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;

public class ApiProductTestHelper {
    private RestAPIPublisherImpl restAPIPublisher;
    private RestAPIStoreImpl restAPIStore;

    public ApiProductTestHelper(RestAPIPublisherImpl restAPIPublisher, RestAPIStoreImpl restAPIStore) {
        this.restAPIPublisher = restAPIPublisher;
        this.restAPIStore = restAPIStore;
    }

    public APIProductDTO createAPIProductInPublisher(String provider, String name, String context, List<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO> apisToBeUsed, List<String> policies) throws org.wso2.am.integration.clients.publisher.api.ApiException {
        List<ProductAPIDTO> resourcesForProduct = this.getResourcesForProduct(apisToBeUsed);
        APIProductDTO apiProductDTO = DtoFactory.createApiProductDTO(provider, name, context, resourcesForProduct, policies);
        APIProductDTO responseData = this.restAPIPublisher.addApiProduct(apiProductDTO);
        List responseResources = responseData.getApis();
        this.verifyAPIProductDto(responseResources, resourcesForProduct);
        Assert.assertEquals((String)responseData.getProvider(), (String)provider);
        Assert.assertEquals((String)responseData.getName(), (String)name);
        if ("carbon.super".equals(this.restAPIPublisher.tenantDomain)) {
            Assert.assertEquals((String)responseData.getContext(), (String)context);
        } else {
            Assert.assertEquals((String)responseData.getContext(), (String)String.format("/t/%s%s", this.restAPIPublisher.tenantDomain, context));
        }
        return responseData;
    }

    private void verifyAPIProductDto(List<ProductAPIDTO> expectedProduct, List<ProductAPIDTO> actualProduct) {
        for (ProductAPIDTO expectedAPI : expectedProduct) {
            ProductAPIDTO actual = null;
            for (ProductAPIDTO actualAPI : actualProduct) {
                if (!expectedAPI.getName().equals(actualAPI.getName())) continue;
                actual = actualAPI;
                break;
            }
            Assert.assertNotNull(actual);
            Assert.assertNotNull((Object)expectedAPI.getOperations());
            Assert.assertNotNull((Object)actual.getOperations());
        }
    }

    public void verfiyApiProductInPublisher(APIProductDTO responseData) throws org.wso2.am.integration.clients.publisher.api.ApiException {
        APIProductListDTO apiProductsList = this.restAPIPublisher.getAllApiProducts();
        List apiProducts = apiProductsList.getList();
        boolean isAPIProductInListing = false;
        int productCount = 0;
        for (APIProductInfoDTO apiProduct : apiProducts) {
            if (!apiProduct.getId().equals(responseData.getId())) continue;
            isAPIProductInListing = true;
            ++productCount;
            this.verifyApiProductInfoWithApiProductDto(apiProduct, responseData);
        }
        Assert.assertTrue((boolean)isAPIProductInListing);
        Assert.assertEquals((int)productCount, (int)1);
        APIProductDTO returnedProduct = this.restAPIPublisher.getApiProduct(responseData.getId());
        this.verifyAPIProductDTOFromPublisher(returnedProduct, responseData);
    }

    private void verifyAPIProductDTOFromPublisher(APIProductDTO returnedProduct, APIProductDTO responseData) {
        Assert.assertEquals((String)returnedProduct.getId(), (String)responseData.getId());
        Assert.assertEquals((String)returnedProduct.getName(), (String)responseData.getName());
        Assert.assertEquals((String)returnedProduct.getContext(), (String)responseData.getContext());
        Assert.assertEquals((String)returnedProduct.getDescription(), (String)responseData.getDescription());
        Assert.assertEquals((String)returnedProduct.getProvider(), (String)responseData.getProvider());
        Assert.assertEquals((Object)returnedProduct.isHasThumbnail(), (Object)responseData.isHasThumbnail());
        Assert.assertEquals((Object)returnedProduct.getState(), (Object)responseData.getState());
        Assert.assertEquals((Object)returnedProduct.isEnableSchemaValidation(), (Object)responseData.isEnableSchemaValidation());
        Assert.assertEquals((Object)returnedProduct.isResponseCachingEnabled(), (Object)responseData.isResponseCachingEnabled());
        Assert.assertEquals((Object)returnedProduct.getCacheTimeout(), (Object)responseData.getCacheTimeout());
        Assert.assertEquals((Object)returnedProduct.getVisibility(), (Object)responseData.getVisibility());
        Assert.assertEquals((Collection)returnedProduct.getVisibleRoles(), (Collection)responseData.getVisibleRoles());
        Assert.assertEquals((Collection)returnedProduct.getVisibleTenants(), (Collection)responseData.getVisibleTenants());
        Assert.assertEquals((Object)returnedProduct.getAccessControl(), (Object)responseData.getAccessControl());
        Assert.assertEquals((Collection)returnedProduct.getAccessControlRoles(), (Collection)responseData.getAccessControlRoles());
        Assert.assertEquals((Collection)returnedProduct.getGatewayEnvironments(), (Collection)responseData.getGatewayEnvironments());
        Assert.assertEquals((Object)returnedProduct.getApiType(), (Object)responseData.getApiType());
        Assert.assertEquals((Collection)returnedProduct.getTransport(), (Collection)responseData.getTransport());
        Assert.assertEquals((Collection)returnedProduct.getTags(), (Collection)responseData.getTags());
        Assert.assertEquals((Collection)returnedProduct.getPolicies(), (Collection)responseData.getPolicies());
        Assert.assertEquals((String)returnedProduct.getApiThrottlingPolicy(), (String)responseData.getApiThrottlingPolicy());
        Assert.assertEquals((String)returnedProduct.getAuthorizationHeader(), (String)responseData.getAuthorizationHeader());
        Assert.assertEquals((Collection)returnedProduct.getSecurityScheme(), (Collection)responseData.getSecurityScheme());
        Assert.assertEquals((Object)returnedProduct.getSubscriptionAvailability(), (Object)responseData.getSubscriptionAvailability());
        Assert.assertEquals((Collection)returnedProduct.getSubscriptionAvailableTenants(), (Collection)responseData.getSubscriptionAvailableTenants());
        Assert.assertEquals((Object)returnedProduct.getAdditionalProperties(), (Object)responseData.getAdditionalProperties());
        Assert.assertEquals((Object)returnedProduct.getMonetization(), (Object)responseData.getMonetization());
        Assert.assertEquals((Object)returnedProduct.getBusinessInformation(), (Object)responseData.getBusinessInformation());
        Assert.assertEquals((Object)returnedProduct.getCorsConfiguration(), (Object)responseData.getCorsConfiguration());
        Assert.assertEquals((String)returnedProduct.getCreatedTime(), (String)responseData.getCreatedTime());
        Assert.assertEquals((String)returnedProduct.getLastUpdatedTime(), (String)responseData.getLastUpdatedTime());
        Assert.assertEquals((Collection)returnedProduct.getScopes(), (Collection)responseData.getScopes());
        this.verifyProductAPIDto(returnedProduct.getApis(), responseData.getApis());
    }

    private void verifyProductAPIDto(List<ProductAPIDTO> actual, List<ProductAPIDTO> expected) {
        for (ProductAPIDTO actualAPI : actual) {
            ProductAPIDTO matchedAPI = null;
            for (ProductAPIDTO expectedAPI : expected) {
                if (!actualAPI.getName().equals(expectedAPI.getName())) continue;
                matchedAPI = expectedAPI;
                break;
            }
            Assert.assertNotNull(matchedAPI);
        }
    }

    private void verifyOperations(List<org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO> actual, List<org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO> expected) {
        Assert.assertEquals((int)actual.size(), (int)expected.size());
        for (org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO actualOperation : actual) {
            org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO matchedOperation = null;
            for (org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO expectedOperation : expected) {
                if (!actualOperation.getTarget().equals(expectedOperation.getTarget()) || !actualOperation.getVerb().equals(expectedOperation.getVerb())) continue;
                matchedOperation = expectedOperation;
                break;
            }
            Assert.assertNotNull(matchedOperation);
            Assert.assertEquals((String)actualOperation.getAuthType(), (String)matchedOperation.getAuthType());
            Assert.assertEquals(new HashSet(actualOperation.getScopes()), new HashSet(matchedOperation.getScopes()));
            Assert.assertEquals(new HashSet(actualOperation.getUsedProductIds()), new HashSet(matchedOperation.getUsedProductIds()));
            Assert.assertEquals((String)actualOperation.getThrottlingPolicy(), (String)matchedOperation.getThrottlingPolicy());
        }
    }

    public APIDTO verifyApiProductInPortal(APIProductDTO apiProductDTO) throws ApiException, InterruptedException {
        APIDTO responseData = this.restAPIStore.getAPI(apiProductDTO.getId());
        this.verifyApiDtoWithApiProduct(responseData, apiProductDTO);
        boolean isAPIProductInListing = false;
        int productCount = 0;
        block0: for (int tries = 0; productCount == 0 && tries < 5; ++tries) {
            APIListDTO apiList = this.restAPIStore.getAllAPIs();
            List apiInfos = apiList.getList();
            for (APIInfoDTO apiInfo : apiInfos) {
                if (!apiInfo.getId().equals(apiProductDTO.getId())) continue;
                isAPIProductInListing = true;
                ++productCount;
                this.verifyApiInfoDtoWithApiProduct(apiInfo, apiProductDTO);
                continue block0;
            }
            if (productCount != 0) continue;
            Thread.sleep(5000L);
        }
        Assert.assertTrue((boolean)isAPIProductInListing);
        Assert.assertEquals((int)productCount, (int)1);
        return responseData;
    }

    private List<ProductAPIDTO> getResourcesForProduct(List<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO> apiDTOs) {
        HashMap<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO, Set<org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO>> selectedApiResourceMapping = new HashMap<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO, Set<org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO>>();
        for (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apiDto : apiDTOs) {
            this.selectOperationsFromAPI(apiDto, selectedApiResourceMapping);
        }
        return this.convertToProductApiResources(selectedApiResourceMapping);
    }

    private void selectOperationsFromAPI(org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apiDto, Map<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO, Set<org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO>> selectedApiResourceMapping) {
        List operations = apiDto.getOperations();
        HashSet selectedOperations = new HashSet();
        selectedApiResourceMapping.put(apiDto, selectedOperations);
        selectedOperations.addAll(operations);
    }

    private List<ProductAPIDTO> convertToProductApiResources(Map<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO, Set<org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO>> selectedResources) {
        ArrayList<ProductAPIDTO> apiResources = new ArrayList<ProductAPIDTO>();
        for (Map.Entry<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO, Set<org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO>> entry : selectedResources.entrySet()) {
            org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apiDto = entry.getKey();
            Set<org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO> operations = entry.getValue();
            apiResources.add(new ProductAPIDTO().apiId(apiDto.getId()).name(apiDto.getName()).operations(new ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO>(operations)));
        }
        return apiResources;
    }

    private void verifyApiProductInfoWithApiProductDto(APIProductInfoDTO apiProductInfoDTO, APIProductDTO apiProductDTO) {
        Assert.assertEquals((String)apiProductInfoDTO.getName(), (String)apiProductDTO.getName());
        Assert.assertEquals((String)apiProductInfoDTO.getProvider(), (String)apiProductDTO.getProvider());
        Assert.assertEquals((String)apiProductInfoDTO.getContext(), (String)apiProductDTO.getContext());
        Assert.assertEquals((String)apiProductInfoDTO.getDescription(), (String)apiProductDTO.getDescription());
        Assert.assertEquals((Object)apiProductInfoDTO.isHasThumbnail(), (Object)apiProductDTO.isHasThumbnail());
        Assert.assertEquals(new HashSet(apiProductInfoDTO.getSecurityScheme()), new HashSet(apiProductDTO.getSecurityScheme()), (String)"Security Scheme does not match");
        Assert.assertEquals((String)apiProductInfoDTO.getState().getValue(), (String)apiProductDTO.getState().getValue());
    }

    private void verifyApiDtoWithApiProduct(APIDTO apiDTO, APIProductDTO apiProductDTO) {
        Assert.assertEquals((String)apiDTO.getId(), (String)apiProductDTO.getId());
        Assert.assertEquals((Object)apiDTO.getAdditionalProperties(), (Object)apiProductDTO.getAdditionalProperties());
        this.verifyBusinessInformation(apiDTO.getBusinessInformation(), apiProductDTO.getBusinessInformation());
        Assert.assertEquals((String)apiDTO.getContext(), (String)apiProductDTO.getContext());
        Assert.assertEquals((String)apiDTO.getDescription(), (String)apiProductDTO.getDescription());
        Assert.assertEquals(new HashSet(apiDTO.getEnvironmentList()), new HashSet(apiProductDTO.getGatewayEnvironments()));
        Assert.assertEquals((String)apiDTO.getLifeCycleStatus(), (String)apiProductDTO.getState().getValue());
        Assert.assertEquals((String)apiDTO.getName(), (String)apiProductDTO.getName());
        this.verifyResources(apiDTO.getOperations(), apiProductDTO.getApis());
        Assert.assertEquals((String)apiDTO.getProvider(), (String)apiProductDTO.getProvider());
        this.verifyScopes(apiDTO.getScopes(), apiProductDTO.getScopes());
        Assert.assertEquals(new HashSet(apiDTO.getSecurityScheme()), new HashSet(apiProductDTO.getSecurityScheme()));
        Assert.assertEquals(new HashSet(apiDTO.getTags()), new HashSet(apiProductDTO.getTags()));
        this.verifyPolicies(apiDTO.getTiers(), apiProductDTO.getPolicies());
        Assert.assertEquals(new HashSet(apiDTO.getTransport()), new HashSet(apiProductDTO.getTransport()));
    }

    private void verifyApiInfoDtoWithApiProduct(APIInfoDTO apiInfo, APIProductDTO apiProductDTO) {
        Assert.assertEquals((String)apiInfo.getContext(), (String)apiProductDTO.getContext());
        Assert.assertEquals((String)apiInfo.getDescription(), (String)apiProductDTO.getDescription());
        Assert.assertEquals((String)apiInfo.getId(), (String)apiProductDTO.getId());
        Assert.assertEquals((String)apiInfo.getLifeCycleStatus(), (String)apiProductDTO.getState().getValue());
        Assert.assertEquals((String)apiInfo.getName(), (String)apiProductDTO.getName());
        Assert.assertEquals((String)apiInfo.getProvider(), (String)apiProductDTO.getProvider());
        Assert.assertEquals(new HashSet(apiInfo.getThrottlingPolicies()), new HashSet(apiProductDTO.getPolicies()));
    }

    private void verifyBusinessInformation(APIBusinessInformationDTO portalBusinessInfo, APIProductBusinessInformationDTO publisherBusinessInfo) {
        Assert.assertEquals((String)portalBusinessInfo.getBusinessOwner(), (String)publisherBusinessInfo.getBusinessOwner());
        Assert.assertEquals((String)portalBusinessInfo.getBusinessOwnerEmail(), (String)publisherBusinessInfo.getBusinessOwnerEmail());
        Assert.assertEquals((String)portalBusinessInfo.getTechnicalOwner(), (String)publisherBusinessInfo.getTechnicalOwner());
        Assert.assertEquals((String)portalBusinessInfo.getTechnicalOwnerEmail(), (String)publisherBusinessInfo.getTechnicalOwnerEmail());
    }

    private void verifyResources(List<APIOperationsDTO> storeAPIOperations, List<ProductAPIDTO> publisherAPIProductOperations) {
        storeAPIOperations.sort((o1, o2) -> {
            if (o1.getTarget().equals(o2.getTarget())) {
                return o1.getVerb().compareTo(o2.getVerb());
            }
            return o1.getTarget().compareTo(o2.getTarget());
        });
        ArrayList productOperations = new ArrayList();
        for (ProductAPIDTO publisherAPIProductOperation : publisherAPIProductOperations) {
            productOperations.addAll(publisherAPIProductOperation.getOperations());
        }
        productOperations.sort((o1, o2) -> {
            if (o1.getTarget().equals(o2.getTarget())) {
                return o1.getVerb().compareTo(o2.getVerb());
            }
            return o1.getTarget().compareTo(o2.getTarget());
        });
        Assert.assertEquals((int)storeAPIOperations.size(), (int)productOperations.size());
        for (int i = 0; i < storeAPIOperations.size(); ++i) {
            APIOperationsDTO apiOperationsDTO = storeAPIOperations.get(i);
            org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO operationsDTO = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO)productOperations.get(i);
            Assert.assertEquals((String)apiOperationsDTO.getTarget(), (String)operationsDTO.getTarget());
            Assert.assertEquals((String)apiOperationsDTO.getVerb(), (String)operationsDTO.getVerb());
        }
    }

    private void verifyScopes(List<ScopeInfoDTO> scopeInfoDTOs, List<APIScopeDTO> apiScopeDTOS) {
        scopeInfoDTOs.sort(Comparator.comparing(ScopeInfoDTO::getName));
        List scopeDTOs = apiScopeDTOS.stream().map(APIScopeDTO::getScope).collect(Collectors.toList());
        scopeDTOs.sort(Comparator.comparing(ScopeDTO::getName));
        Assert.assertEquals((int)scopeInfoDTOs.size(), (int)scopeDTOs.size());
        for (int i = 0; i < scopeInfoDTOs.size(); ++i) {
            ScopeInfoDTO scopeInfoDTO = scopeInfoDTOs.get(i);
            ScopeDTO scopeDTO = (ScopeDTO)scopeDTOs.get(i);
            Assert.assertEquals((String)scopeInfoDTO.getDescription(), (String)scopeDTO.getDescription());
            Assert.assertEquals((String)scopeInfoDTO.getName(), (String)scopeDTO.getName());
            Assert.assertEquals(new HashSet(scopeInfoDTO.getRoles()), new HashSet(scopeDTO.getBindings()));
        }
    }

    private void verifyPolicies(List<APITiersDTO> apiTiersDTOs, List<String> policies) {
        Assert.assertEquals((int)apiTiersDTOs.size(), (int)policies.size());
        apiTiersDTOs.sort(Comparator.comparing(APITiersDTO::getTierName));
        policies.sort(Comparator.naturalOrder());
        for (int i = 0; i < apiTiersDTOs.size(); ++i) {
            APITiersDTO apiTiersDTO = apiTiersDTOs.get(i);
            Assert.assertEquals((String)apiTiersDTO.getTierName(), (String)policies.get(i));
        }
    }
}

