/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIEndpointURLsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APITiersDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIURLsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationTokenDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.WorkflowResponseDTO;
import org.wso2.am.integration.test.impl.InvocationStatusCodes;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ApiTestHelper {
    private static String SWAGGER_FOLDER = "swagger";
    private static String ADDITIONAL_PROPERTIES_FOLDER = "additional-properties";
    private RestAPIPublisherImpl restAPIPublisher;
    private RestAPIStoreImpl restAPIStore;
    private final String resourceLocation;
    private final String tenantDomain;
    private final String keyManagerUrl;
    private final User user;

    public ApiTestHelper(RestAPIPublisherImpl restAPIPublisher, RestAPIStoreImpl restAPIStore, String resourceLocation, String tenantDomain, String keyManagerUrl, User user) {
        this.restAPIPublisher = restAPIPublisher;
        this.restAPIStore = restAPIStore;
        this.resourceLocation = resourceLocation;
        this.tenantDomain = tenantDomain;
        this.keyManagerUrl = keyManagerUrl;
        this.user = user;
    }

    public org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO createApiOne(String backendUrl) throws org.wso2.am.integration.clients.publisher.api.ApiException {
        String swaggerPath = this.resourceLocation + File.separator + SWAGGER_FOLDER + File.separator + "customer-info-api.yaml";
        return this.getApiDTO(backendUrl, swaggerPath);
    }

    public org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO createApiTwo(String backendUrl) throws org.wso2.am.integration.clients.publisher.api.ApiException {
        String swaggerPath = this.resourceLocation + File.separator + SWAGGER_FOLDER + File.separator + "leasing-api.yaml";
        return this.getApiDTO(backendUrl, swaggerPath);
    }

    private org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO getApiDTO(String backendUrl, String swaggerPath) throws org.wso2.am.integration.clients.publisher.api.ApiException {
        File definition = new File(swaggerPath);
        JSONObject endpoints = new JSONObject();
        endpoints.put("url", (Object)backendUrl);
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        String uniqueName = UUID.randomUUID().toString();
        JSONObject apiProperties = new JSONObject();
        apiProperties.put("name", (Object)uniqueName);
        apiProperties.put("context", (Object)("/" + uniqueName));
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.user.getUserName());
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        return this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
    }

    public org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO createRestrictedAccessControlApi(String backendUrl, String role) throws org.wso2.am.integration.clients.publisher.api.ApiException {
        String swaggerPath = this.resourceLocation + File.separator + SWAGGER_FOLDER + File.separator + "customer-info-api.yaml";
        File definition = new File(swaggerPath);
        JSONObject endpoints = new JSONObject();
        endpoints.put("url", (Object)backendUrl);
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("production_endpoints", (Object)endpoints);
        endpointConfig.put("sandbox_endpoints", (Object)endpoints);
        String uniqueName = UUID.randomUUID().toString();
        JSONObject apiProperties = new JSONObject();
        apiProperties.put("name", (Object)uniqueName);
        apiProperties.put("context", (Object)("/" + uniqueName));
        apiProperties.put("version", (Object)"1.0.0");
        apiProperties.put("provider", (Object)this.user.getUserName());
        apiProperties.put("endpointConfig", (Object)endpointConfig);
        apiProperties.put("visibility", (Object)"RESTRICTED");
        apiProperties.put("visibleRoles", Collections.singletonList(role));
        return this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
    }

    public org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO createScopeProtectedApi(String backendUrl, String role, String scope) throws org.wso2.am.integration.clients.publisher.api.ApiException, IOException {
        String swaggerPath = this.resourceLocation + File.separator + SWAGGER_FOLDER + File.separator + "customer-info-api.yaml";
        String additionalPropertiesPath = this.resourceLocation + File.separator + ADDITIONAL_PROPERTIES_FOLDER + File.separator + "scoped-api-properties.json";
        File definition = new File(swaggerPath);
        String content = new String(Files.readAllBytes(Paths.get(additionalPropertiesPath, new String[0])));
        JSONObject apiProperties = new JSONObject(content);
        String uniqueName = UUID.randomUUID().toString();
        apiProperties.put("name", (Object)uniqueName);
        apiProperties.put("context", (Object)("/" + uniqueName));
        apiProperties.put("provider", (Object)this.user.getUserName());
        ((JSONObject)((JSONObject)apiProperties.get("endpointConfig")).get("production_endpoints")).put("url", (Object)backendUrl);
        ((JSONObject)((JSONObject)apiProperties.get("endpointConfig")).get("sandbox_endpoints")).put("url", (Object)backendUrl);
        ((JSONObject)((JSONObject)apiProperties.getJSONArray("scopes").get(0)).get("scope")).put("bindings", Collections.singletonList(role));
        ((JSONObject)((JSONObject)apiProperties.getJSONArray("scopes").get(0)).get("scope")).put("name", (Object)scope);
        ((JSONObject)((JSONObject)apiProperties.getJSONArray("scopes").get(0)).get("scope")).put("description", (Object)scope);
        JSONArray operations = apiProperties.getJSONArray("operations");
        for (int i = 0; i < operations.length(); ++i) {
            ((JSONObject)operations.get(i)).put("scopes", Collections.singletonList(scope));
        }
        return this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
    }

    public org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO createInMediationSequenceApi(String backendUrl) throws IOException, org.wso2.am.integration.clients.publisher.api.ApiException {
        String swaggerPath = this.resourceLocation + File.separator + SWAGGER_FOLDER + File.separator + "customer-info-api.yaml";
        String additionalPropertiesPath = this.resourceLocation + File.separator + ADDITIONAL_PROPERTIES_FOLDER + File.separator + "in-mediation-api-properties.json";
        File definition = new File(swaggerPath);
        String content = new String(Files.readAllBytes(Paths.get(additionalPropertiesPath, new String[0])));
        JSONObject apiProperties = new JSONObject(content);
        String uniqueName = UUID.randomUUID().toString();
        apiProperties.put("name", (Object)uniqueName);
        apiProperties.put("context", (Object)("/" + uniqueName));
        apiProperties.put("provider", (Object)this.user.getUserName());
        ((JSONObject)((JSONObject)apiProperties.get("endpointConfig")).get("production_endpoints")).put("url", (Object)backendUrl);
        ((JSONObject)((JSONObject)apiProperties.get("endpointConfig")).get("sandbox_endpoints")).put("url", (Object)backendUrl);
        return this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
    }

    public org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO createOutMediationSequenceApi(String backendUrl) throws IOException, org.wso2.am.integration.clients.publisher.api.ApiException {
        String swaggerPath = this.resourceLocation + File.separator + SWAGGER_FOLDER + File.separator + "customer-info-api.yaml";
        String additionalPropertiesPath = this.resourceLocation + File.separator + ADDITIONAL_PROPERTIES_FOLDER + File.separator + "out-mediation-api-properties.json";
        File definition = new File(swaggerPath);
        String content = new String(Files.readAllBytes(Paths.get(additionalPropertiesPath, new String[0])));
        JSONObject apiProperties = new JSONObject(content);
        String uniqueName = UUID.randomUUID().toString();
        apiProperties.put("name", (Object)uniqueName);
        apiProperties.put("context", (Object)("/" + uniqueName));
        apiProperties.put("provider", (Object)this.user.getUserName());
        ((JSONObject)((JSONObject)apiProperties.get("endpointConfig")).get("production_endpoints")).put("url", (Object)backendUrl);
        ((JSONObject)((JSONObject)apiProperties.get("endpointConfig")).get("sandbox_endpoints")).put("url", (Object)backendUrl);
        return this.restAPIPublisher.importOASDefinition(definition, apiProperties.toString());
    }

    public ApplicationDTO verifySubscription(APIDTO apiDTO, String applicationName, String subscriptionPolicy) throws ApiException {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication(applicationName, "Unlimited", "http://localhost", "");
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(apiDTO.getId(), applicationDTO.getApplicationId(), subscriptionPolicy);
        Assert.assertEquals((String)subscriptionDTO.getApiId(), (String)apiDTO.getId());
        Assert.assertEquals((String)subscriptionDTO.getApplicationId(), (String)applicationDTO.getApplicationId());
        this.verifySubscriptionApiInfo(subscriptionDTO.getApiInfo(), apiDTO);
        this.verifySubscriptionAppInfo(subscriptionDTO.getApplicationInfo(), applicationDTO);
        Assert.assertEquals((Object)subscriptionDTO.getStatus(), (Object)SubscriptionDTO.StatusEnum.UNBLOCKED);
        Assert.assertEquals((String)subscriptionDTO.getThrottlingPolicy(), (String)subscriptionPolicy);
        return this.restAPIStore.getApplicationById(applicationDTO.getApplicationId());
    }

    public ApplicationKeyDTO verifyKeyGeneration(ApplicationDTO applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum keyType, ArrayList<String> scopes, List<String> grantTypes) throws ApiException {
        String validityTime = "3600";
        String callbackUrl = "http://localhost";
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", "http://localhost", keyType, scopes, grantTypes);
        Assert.assertEquals((String)applicationKeyDTO.getCallbackUrl(), (String)"http://localhost");
        Assert.assertEquals((String)applicationKeyDTO.getKeyType().getValue(), (String)keyType.getValue());
        Assert.assertEquals(new HashSet(applicationKeyDTO.getSupportedGrantTypes()), new HashSet<String>(grantTypes));
        Assert.assertEquals((String)applicationKeyDTO.getKeyState(), (String)WorkflowResponseDTO.WorkflowStatusEnum.APPROVED.getValue());
        ApplicationTokenDTO token = applicationKeyDTO.getToken();
        ArrayList<String> expectedScopes = new ArrayList<String>(Arrays.asList("default"));
        expectedScopes.addAll(scopes);
        Assert.assertEquals(new HashSet(token.getTokenScopes()), new HashSet<String>(expectedScopes));
        Assert.assertEquals((long)token.getValidityTime(), (long)Long.parseLong("3600"));
        return applicationKeyDTO;
    }

    public String generateTokenPasswordGrant(String consumerKey, String consumerSecret, String userName, String password, List<String> scopes) throws APIManagerIntegrationTestException, MalformedURLException {
        String tokenEndpointURL = this.keyManagerUrl + "oauth2/token";
        if (!"carbon.super".equals(this.tenantDomain)) {
            userName = userName + "@" + this.tenantDomain;
        }
        String requestBody = "grant_type=password&username=" + userName + "&password=" + password;
        if (!scopes.isEmpty()) {
            requestBody = requestBody + "&scope=" + String.join((CharSequence)" ", scopes);
        }
        HttpResponse response = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, new URL(tokenEndpointURL));
        JSONObject tokenResponse = new JSONObject(response.getData());
        if (!scopes.isEmpty()) {
            String receivedScopes = tokenResponse.getString("scope");
            Assert.assertEquals(new HashSet<String>(Arrays.asList(receivedScopes.split(" "))), scopes);
        }
        return tokenResponse.getString("access_token");
    }

    public void verifyInvocation(APIDTO apiDTO, String productionAccessToken, String sandboxAccessToken, InvocationStatusCodes expectedStatus) throws IOException {
        List endpointURLs = apiDTO.getEndpointURLs();
        Assert.assertFalse((boolean)endpointURLs.isEmpty());
        block10: for (APIEndpointURLsDTO endpointURL : endpointURLs) {
            String environmentType;
            switch (environmentType = endpointURL.getEnvironmentType()) {
                case "hybrid": {
                    this.sendRequest(endpointURL.getUrLs(), apiDTO, productionAccessToken, expectedStatus);
                    this.sendRequest(endpointURL.getUrLs(), apiDTO, sandboxAccessToken, expectedStatus);
                    continue block10;
                }
                case "production": {
                    this.sendRequest(endpointURL.getUrLs(), apiDTO, productionAccessToken, expectedStatus);
                    continue block10;
                }
                case "sandbox": {
                    this.sendRequest(endpointURL.getUrLs(), apiDTO, sandboxAccessToken, expectedStatus);
                    continue block10;
                }
            }
            Assert.assertTrue((boolean)((Stream)Arrays.stream(new String[]{"hybrid", "production", "sandbox"}).parallel()).anyMatch(environmentType::contains));
        }
    }

    public void verifyInvocation(APIDTO apiDTO, String productionAccessToken, String sandboxAccessToken, InvocationStatusCodes expectedStatus, String requestBody, String expectedResponse, Map<String, String> headers) throws IOException {
        List endpointURLs = apiDTO.getEndpointURLs();
        Assert.assertFalse((boolean)endpointURLs.isEmpty());
        block10: for (APIEndpointURLsDTO endpointURL : endpointURLs) {
            String environmentType;
            switch (environmentType = endpointURL.getEnvironmentType()) {
                case "hybrid": {
                    this.sendRequest(endpointURL.getUrLs(), apiDTO, productionAccessToken, expectedStatus, requestBody, expectedResponse, headers);
                    this.sendRequest(endpointURL.getUrLs(), apiDTO, sandboxAccessToken, expectedStatus, requestBody, expectedResponse, headers);
                    continue block10;
                }
                case "production": {
                    this.sendRequest(endpointURL.getUrLs(), apiDTO, productionAccessToken, expectedStatus, requestBody, expectedResponse, headers);
                    continue block10;
                }
                case "sandbox": {
                    this.sendRequest(endpointURL.getUrLs(), apiDTO, sandboxAccessToken, expectedStatus, requestBody, expectedResponse, headers);
                    continue block10;
                }
            }
            Assert.assertTrue((boolean)((Stream)Arrays.stream(new String[]{"hybrid", "production", "sandbox"}).parallel()).anyMatch(environmentType::contains));
        }
    }

    private HttpUriRequest constructRequest(String targetUrl, String httpMethod) throws IOException {
        targetUrl = targetUrl.replaceAll("\\{\\w+}", "123");
        if ("GET".equals(httpMethod)) {
            return new HttpGet(targetUrl);
        }
        if ("POST".equals(httpMethod)) {
            HttpPost request = new HttpPost(targetUrl);
            request.setEntity((HttpEntity)new StringEntity("<test/>"));
            return request;
        }
        if ("PUT".equals(httpMethod)) {
            HttpPut request = new HttpPut(targetUrl);
            request.setEntity((HttpEntity)new StringEntity("<test/>"));
            return request;
        }
        if ("DELETE".equals(httpMethod)) {
            return new HttpDelete(targetUrl);
        }
        if ("HEAD".equals(httpMethod)) {
            return new HttpHead(targetUrl);
        }
        HttpPatch request = new HttpPatch(targetUrl);
        request.setEntity((HttpEntity)new StringEntity("<test/>"));
        return request;
    }

    private HttpUriRequest constructRequest(String targetUrl, String httpMethod, String requestBody) throws IOException {
        targetUrl = targetUrl.replaceAll("\\{\\w+}", "123");
        Object request = "POST".equals(httpMethod) ? new HttpPost(targetUrl) : ("PUT".equals(httpMethod) ? new HttpPut(targetUrl) : new HttpPatch(targetUrl));
        request.setEntity((HttpEntity)new StringEntity(requestBody));
        return request;
    }

    private void sendRequest(APIURLsDTO apiurLsDTO, APIDTO apiDTO, String accessToken, InvocationStatusCodes expectedStatusCodes) throws IOException {
        List operations = apiDTO.getOperations();
        Map<String, String> pathScopeMapping = this.getPathScopeMapping(apiDTO);
        for (APIOperationsDTO operation : operations) {
            HttpUriRequest request = this.constructRequest(apiurLsDTO.getHttp() + operation.getTarget(), operation.getVerb());
            request.addHeader("Authorization", "Bearer " + accessToken);
            CloseableHttpClient httpClient = HttpClients.custom().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
            Throwable throwable = null;
            try {
                CloseableHttpResponse response = httpClient.execute(request);
                Throwable throwable2 = null;
                try {
                    int expectedCode;
                    String key = operation.getTarget() + operation.getVerb().toLowerCase();
                    if (pathScopeMapping.containsKey(key)) {
                        String scope = pathScopeMapping.get(key);
                        expectedCode = expectedStatusCodes.getStatusCodeForScope(scope);
                    } else {
                        expectedCode = expectedStatusCodes.getDefaultStatusCode();
                    }
                    Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)expectedCode);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (response == null) continue;
                    if (throwable2 != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (httpClient == null) continue;
                if (throwable != null) {
                    try {
                        httpClient.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                httpClient.close();
            }
        }
    }

    private void sendRequest(APIURLsDTO apiurLsDTO, APIDTO apiDTO, String accessToken, InvocationStatusCodes expectedStatusCodes, String requestBody, String expectedResponse, Map<String, String> headers) throws IOException {
        List operations = apiDTO.getOperations();
        Map<String, String> pathScopeMapping = this.getPathScopeMapping(apiDTO);
        for (APIOperationsDTO operation : operations) {
            if (operation.getVerb().equals("GET") || operation.getVerb().equals("DELETE")) continue;
            HttpUriRequest request = this.constructRequest(apiurLsDTO.getHttp() + operation.getTarget(), operation.getVerb(), requestBody);
            request.addHeader("Authorization", "Bearer " + accessToken);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
            CloseableHttpClient httpClient = HttpClients.custom().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
            Throwable throwable = null;
            try {
                CloseableHttpResponse response = httpClient.execute(request);
                Throwable throwable2 = null;
                try {
                    int expectedCode;
                    String key = operation.getTarget() + operation.getVerb().toLowerCase();
                    if (pathScopeMapping.containsKey(key)) {
                        String scope = pathScopeMapping.get(key);
                        expectedCode = expectedStatusCodes.getStatusCodeForScope(scope);
                    } else {
                        expectedCode = expectedStatusCodes.getDefaultStatusCode();
                    }
                    Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)expectedCode);
                    Assert.assertEquals((String)EntityUtils.toString((HttpEntity)response.getEntity()), (String)expectedResponse);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (response == null) continue;
                    if (throwable2 != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (httpClient == null) continue;
                if (throwable != null) {
                    try {
                        httpClient.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                httpClient.close();
            }
        }
    }

    private Map<String, String> getPathScopeMapping(APIDTO apiDTO) {
        HashMap<String, String> pathScopeMapping = new HashMap<String, String>();
        JSONObject apiDefinition = new JSONObject(apiDTO.getApiDefinition());
        JSONObject paths = (JSONObject)apiDefinition.get("paths");
        paths.keys().forEachRemaining(pathKey -> {
            JSONObject resources = (JSONObject)paths.get((String)pathKey);
            resources.keys().forEachRemaining(verbKey -> {
                JSONObject security;
                JSONArray scopes;
                JSONObject resource = (JSONObject)resources.get((String)verbKey);
                JSONArray securities = (JSONArray)resource.get("security");
                if (securities.length() == 1 && (scopes = (JSONArray)(security = (JSONObject)securities.get(0)).get("default")).length() == 1) {
                    pathScopeMapping.put((String)pathKey + verbKey, (String)scopes.get(0));
                }
            });
        });
        return pathScopeMapping;
    }

    private void verifySubscriptionApiInfo(APIInfoDTO apiInfo, APIDTO apiDTO) {
        Assert.assertEquals((String)apiInfo.getId(), (String)apiDTO.getId());
        Assert.assertEquals((String)apiInfo.getProvider(), (String)apiDTO.getProvider());
        Assert.assertEquals((String)apiInfo.getName(), (String)apiDTO.getName());
        this.verifySubscriptionApiInfoPolicies(apiInfo.getThrottlingPolicies(), apiDTO.getTiers());
        Assert.assertEquals((String)apiInfo.getLifeCycleStatus(), (String)apiDTO.getLifeCycleStatus());
        Assert.assertEquals((String)apiInfo.getDescription(), (String)apiDTO.getDescription());
        Assert.assertEquals((String)apiInfo.getContext(), (String)apiDTO.getContext());
    }

    private void verifySubscriptionApiInfoPolicies(List<String> policies, List<APITiersDTO> tiers) {
        Assert.assertEquals((int)policies.size(), (int)tiers.size());
        tiers.sort(Comparator.comparing(APITiersDTO::getTierName));
        policies.sort(Comparator.naturalOrder());
        for (int i = 0; i < policies.size(); ++i) {
            APITiersDTO apiTiersDTO = tiers.get(i);
            Assert.assertEquals((String)policies.get(i), (String)apiTiersDTO.getTierName());
        }
    }

    private void verifySubscriptionAppInfo(ApplicationInfoDTO applicationInfo, ApplicationDTO applicationDTO) {
        Assert.assertEquals((String)applicationInfo.getApplicationId(), (String)applicationDTO.getApplicationId());
        Assert.assertEquals((String)applicationInfo.getDescription(), (String)applicationDTO.getDescription());
        Assert.assertEquals((String)applicationInfo.getName(), (String)applicationDTO.getName());
        Assert.assertEquals(new HashSet(applicationInfo.getGroups()), new HashSet(applicationDTO.getGroups()));
        Assert.assertEquals((String)applicationInfo.getOwner(), (String)applicationDTO.getOwner());
        Assert.assertEquals((String)applicationInfo.getStatus(), (String)applicationDTO.getStatus());
        Assert.assertEquals((String)applicationInfo.getThrottlingPolicy(), (String)applicationDTO.getThrottlingPolicy());
        Assert.assertEquals((Object)applicationInfo.getSubscriptionCount(), (Object)new Integer(applicationDTO.getSubscriptionCount() + 1));
    }
}

