/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.impl;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.wso2.am.integration.clients.publisher.api.ApiClient;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.v1.ApIsApi;
import org.wso2.am.integration.clients.publisher.api.v1.ApiAuditApi;
import org.wso2.am.integration.clients.publisher.api.v1.ApiDocumentsApi;
import org.wso2.am.integration.clients.publisher.api.v1.ApiLifecycleApi;
import org.wso2.am.integration.clients.publisher.api.v1.ApiProductRevisionsApi;
import org.wso2.am.integration.clients.publisher.api.v1.ApiProductsApi;
import org.wso2.am.integration.clients.publisher.api.v1.ApiRevisionsApi;
import org.wso2.am.integration.clients.publisher.api.v1.ClientCertificatesApi;
import org.wso2.am.integration.clients.publisher.api.v1.CommentsApi;
import org.wso2.am.integration.clients.publisher.api.v1.EndpointCertificatesApi;
import org.wso2.am.integration.clients.publisher.api.v1.GlobalMediationPoliciesApi;
import org.wso2.am.integration.clients.publisher.api.v1.GraphQlPoliciesApi;
import org.wso2.am.integration.clients.publisher.api.v1.GraphQlSchemaApi;
import org.wso2.am.integration.clients.publisher.api.v1.GraphQlSchemaIndividualApi;
import org.wso2.am.integration.clients.publisher.api.v1.RolesApi;
import org.wso2.am.integration.clients.publisher.api.v1.ScopesApi;
import org.wso2.am.integration.clients.publisher.api.v1.SubscriptionsApi;
import org.wso2.am.integration.clients.publisher.api.v1.ThrottlingPoliciesApi;
import org.wso2.am.integration.clients.publisher.api.v1.UnifiedSearchApi;
import org.wso2.am.integration.clients.publisher.api.v1.ValidationApi;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIBusinessInformationDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APICorsConfigurationDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIEndpointSecurityDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIKeyDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionDeploymentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIRevisionListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ApiEndpointValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CertMetadataDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ClientCertMetadataDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CommentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.CommentListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLQueryComplexityInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLSchemaDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLSchemaTypeListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.LifecycleHistoryDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.LifecycleStateDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.MediationListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.OpenAPIDefinitionValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.PatchRequestBodyDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.PostRequestBodyDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SearchResultListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ThrottlingPolicyListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.WorkflowResponseDTO;
import org.wso2.am.integration.test.ClientAuthenticator;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APIRevisionDeployUndeployRequest;
import org.wso2.am.integration.test.utils.bean.APIRevisionRequest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class RestAPIPublisherImpl {
    public ApIsApi apIsApi = new ApIsApi();
    private ApiProductsApi apiProductsApi = new ApiProductsApi();
    public ApiDocumentsApi apiDocumentsApi = new ApiDocumentsApi();
    public ApiRevisionsApi apiRevisionsApi = new ApiRevisionsApi();
    public ApiProductRevisionsApi apiProductRevisionsApi = new ApiProductRevisionsApi();
    public ThrottlingPoliciesApi throttlingPoliciesApi = new ThrottlingPoliciesApi();
    public ClientCertificatesApi clientCertificatesApi = new ClientCertificatesApi();
    public EndpointCertificatesApi endpointCertificatesApi = new EndpointCertificatesApi();
    public GraphQlSchemaApi graphQlSchemaApi = new GraphQlSchemaApi();
    public GraphQlSchemaIndividualApi graphQlSchemaIndividualApi = new GraphQlSchemaIndividualApi();
    public ApiLifecycleApi apiLifecycleApi = new ApiLifecycleApi();
    public CommentsApi commentsApi = new CommentsApi();
    public RolesApi rolesApi = new RolesApi();
    public ValidationApi validationApi = new ValidationApi();
    public SubscriptionsApi subscriptionsApi = new SubscriptionsApi();
    public ApiAuditApi apiAuditApi = new ApiAuditApi();
    public GraphQlPoliciesApi graphQlPoliciesApi = new GraphQlPoliciesApi();
    public UnifiedSearchApi unifiedSearchApi = new UnifiedSearchApi();
    public GlobalMediationPoliciesApi globalMediationPoliciesApi = new GlobalMediationPoliciesApi();
    public ScopesApi sharedScopesApi = new ScopesApi();
    public ApiClient apiPublisherClient = new ApiClient();
    public static final String appName = "Integration_Test_App_Publisher";
    public static final String callBackURL = "test.com";
    public static final String tokenScope = "Production";
    public static final String appOwner = "admin";
    public static final String grantType = "password";
    public static final String username = "admin";
    public static final String password = "admin";
    public String tenantDomain;

    @Deprecated
    public RestAPIPublisherImpl() {
        this("admin", "admin", "", "https://localhost:9943");
    }

    public RestAPIPublisherImpl(String username, String password, String tenantDomain, String publisherURL) {
        String tokenURL = publisherURL + "oauth2/token";
        String dcrURL = publisherURL + "client-registration/v0.17/register";
        String accessToken = ClientAuthenticator.getAccessToken("openid apim:api_view apim:api_create apim:api_delete apim:api_publish apim:subscription_view apim:subscription_block apim:external_services_discover apim:threat_protection_policy_create apim:threat_protection_policy_manage apim:document_create apim:document_manage apim:mediation_policy_view apim:mediation_policy_create apim:mediation_policy_manage apim:client_certificates_view apim:client_certificates_add apim:client_certificates_update apim:ep_certificates_view apim:ep_certificates_add apim:ep_certificates_update apim:publisher_settings apim:pub_alert_manage apim:shared_scope_manage apim:api_generate_key", appName, callBackURL, tokenScope, "admin", grantType, dcrURL, username, password, tenantDomain, tokenURL);
        this.apiPublisherClient.addDefaultHeader("Authorization", "Bearer " + accessToken);
        this.apiPublisherClient.setBasePath(publisherURL + "api/am/publisher/v2");
        this.apiPublisherClient.setDebugging(true);
        this.apiPublisherClient.setReadTimeout(600000);
        this.apiPublisherClient.setConnectTimeout(600000);
        this.apiPublisherClient.setWriteTimeout(600000);
        this.apIsApi.setApiClient(this.apiPublisherClient);
        this.apiProductsApi.setApiClient(this.apiPublisherClient);
        this.apiRevisionsApi.setApiClient(this.apiPublisherClient);
        this.apiProductRevisionsApi.setApiClient(this.apiPublisherClient);
        this.graphQlSchemaApi.setApiClient(this.apiPublisherClient);
        this.commentsApi.setApiClient(this.apiPublisherClient);
        this.graphQlSchemaIndividualApi.setApiClient(this.apiPublisherClient);
        this.apiDocumentsApi.setApiClient(this.apiPublisherClient);
        this.throttlingPoliciesApi.setApiClient(this.apiPublisherClient);
        this.apiLifecycleApi.setApiClient(this.apiPublisherClient);
        this.rolesApi.setApiClient(this.apiPublisherClient);
        this.validationApi.setApiClient(this.apiPublisherClient);
        this.clientCertificatesApi.setApiClient(this.apiPublisherClient);
        this.subscriptionsApi.setApiClient(this.apiPublisherClient);
        this.graphQlPoliciesApi.setApiClient(this.apiPublisherClient);
        this.apiAuditApi.setApiClient(this.apiPublisherClient);
        this.unifiedSearchApi.setApiClient(this.apiPublisherClient);
        this.sharedScopesApi.setApiClient(this.apiPublisherClient);
        this.globalMediationPoliciesApi.setApiClient(this.apiPublisherClient);
        this.tenantDomain = tenantDomain;
    }

    public HttpResponse addAPI(APIRequest apiRequest) throws ApiException {
        String osVersion = "v3";
        APIDTO apidto = this.addAPI(apiRequest, osVersion);
        HttpResponse response = null;
        if (apidto != null && StringUtils.isNotEmpty((String)apidto.getId())) {
            response = new HttpResponse(apidto.getId(), 201);
        }
        return response;
    }

    public APIDTO addAPI(APIRequest apiRequest, String osVersion) throws ApiException {
        APIDTO apidto;
        ArrayList<String> roleList;
        APIDTO body = new APIDTO();
        body.setName(apiRequest.getName());
        body.setContext(apiRequest.getContext());
        body.setVersion(apiRequest.getVersion());
        if (apiRequest.getVisibility() != null) {
            body.setVisibility(APIDTO.VisibilityEnum.valueOf((String)apiRequest.getVisibility().toUpperCase()));
            if (APIDTO.VisibilityEnum.RESTRICTED.getValue().equalsIgnoreCase(apiRequest.getVisibility()) && StringUtils.isNotEmpty((String)apiRequest.getRoles())) {
                roleList = new ArrayList<String>(Arrays.asList(apiRequest.getRoles().split(" , ")));
                body.setVisibleRoles(roleList);
            }
        } else {
            body.setVisibility(APIDTO.VisibilityEnum.PUBLIC);
        }
        if (apiRequest.getAccessControl() != null) {
            body.setAccessControl(APIDTO.AccessControlEnum.valueOf((String)apiRequest.getAccessControl().toUpperCase()));
            if (APIDTO.AccessControlEnum.RESTRICTED.getValue().equalsIgnoreCase(apiRequest.getAccessControl()) && StringUtils.isNotEmpty((String)apiRequest.getAccessControlRoles())) {
                roleList = new ArrayList<String>(Arrays.asList(apiRequest.getAccessControlRoles().split(" , ")));
                body.setAccessControlRoles(roleList);
            }
        } else {
            body.setAccessControl(APIDTO.AccessControlEnum.NONE);
        }
        body.setDescription(apiRequest.getDescription());
        body.setProvider(apiRequest.getProvider());
        ArrayList<String> transports = new ArrayList<String>();
        if ("http".equals(apiRequest.getHttp_checked())) {
            transports.add("http");
        }
        if ("https".equals(apiRequest.getHttps_checked())) {
            transports.add("https");
        }
        body.setTransport(transports);
        body.isDefaultVersion(Boolean.valueOf(false));
        body.setCacheTimeout(Integer.valueOf(100));
        ArrayList<String> gatewayEnvironments = new ArrayList<String>();
        gatewayEnvironments.add(apiRequest.getEnvironment());
        body.setGatewayEnvironments(gatewayEnvironments);
        if (apiRequest.getOperationsDTOS() != null) {
            body.setOperations(apiRequest.getOperationsDTOS());
        } else {
            ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
            APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
            if (this.isAsyncApi(apiRequest)) {
                apiOperationsDTO.setVerb("SUBSCRIBE");
            } else {
                apiOperationsDTO.setVerb("GET");
            }
            if ("WEBSUB".equalsIgnoreCase(apiRequest.getType())) {
                apiOperationsDTO.setTarget("_default");
            } else {
                apiOperationsDTO.setTarget("/*");
            }
            apiOperationsDTO.setAuthType("Application & Application User");
            apiOperationsDTO.setThrottlingPolicy("Unlimited");
            operations.add(apiOperationsDTO);
            body.setOperations(operations);
        }
        body.setMediationPolicies(apiRequest.getMediationPolicies());
        body.setBusinessInformation(new APIBusinessInformationDTO());
        body.setCorsConfiguration(new APICorsConfigurationDTO());
        body.setTags(Arrays.asList(apiRequest.getTags().split(",")));
        body.setEndpointConfig((Object)apiRequest.getEndpointConfig());
        body.setSecurityScheme(apiRequest.getSecurityScheme());
        body.setType(APIDTO.TypeEnum.fromValue((String)apiRequest.getType()));
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Unlimited");
        body.setPolicies(Arrays.asList(apiRequest.getTiersCollection().split(",")));
        body.isDefaultVersion(Boolean.valueOf(apiRequest.getDefault_version_checked()));
        try {
            ApiResponse httpInfo = this.apIsApi.createAPIWithHttpInfo(body, osVersion);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
            apidto = (APIDTO)httpInfo.getData();
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        return apidto;
    }

    public APIDTO addAPI(APIDTO apidto, String osVersion) throws ApiException {
        ApiResponse httpInfo = this.apIsApi.createAPIWithHttpInfo(apidto, osVersion);
        Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
        return (APIDTO)httpInfo.getData();
    }

    private boolean isAsyncApi(APIRequest apiRequest) {
        String type = apiRequest.getType();
        return "SSE".equalsIgnoreCase(type) || "WS".equalsIgnoreCase(type) || "WEBSUB".equalsIgnoreCase(type);
    }

    public String createNewAPIVersion(String newVersion, String apiId, boolean defaultVersion) throws ApiException {
        String apiLocation = (String)((List)this.apIsApi.createNewAPIVersionWithHttpInfo(newVersion, apiId, Boolean.valueOf(defaultVersion), null).getHeaders().get("Location")).get(0);
        String[] splitValues = apiLocation.split("/");
        return splitValues[splitValues.length - 1];
    }

    private String getJsonContent(String fileName) throws IOException {
        if (StringUtils.isNotEmpty((String)fileName)) {
            return IOUtils.toString((InputStream)RestAPIPublisherImpl.class.getClassLoader().getResourceAsStream(fileName), (String)StandardCharsets.UTF_8.name());
        }
        return null;
    }

    public HttpResponse changeAPILifeCycleStatus(String apiId, String action, String lifecycleChecklist) throws ApiException {
        WorkflowResponseDTO workflowResponseDTO = this.apiLifecycleApi.changeAPILifecycle(action, apiId, lifecycleChecklist, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)workflowResponseDTO.getLifecycleState().getState())) {
            response = new HttpResponse(workflowResponseDTO.getLifecycleState().getState(), 200);
        }
        return response;
    }

    public WorkflowResponseDTO changeAPILifeCycleStatus(String apiId, String action) throws ApiException {
        ApiResponse workflowResponseDTOApiResponse = this.apiLifecycleApi.changeAPILifecycleWithHttpInfo(action, apiId, null, null);
        Assert.assertEquals((int)200, (int)workflowResponseDTOApiResponse.getStatusCode());
        return (WorkflowResponseDTO)workflowResponseDTOApiResponse.getData();
    }

    public void deprecateAPI(String apiId) throws ApiException {
        this.apiLifecycleApi.changeAPILifecycle("Deprecate", apiId, null, null);
    }

    public void deployPrototypeAPI(String apiId) throws ApiException {
        this.apiLifecycleApi.changeAPILifecycle("Deploy as a Prototype", apiId, null, null);
    }

    public void blockAPI(String apiId) throws ApiException {
        this.apiLifecycleApi.changeAPILifecycle("Block", apiId, null, null);
    }

    public HttpResponse getLifecycleStatus(String apiId) throws ApiException {
        LifecycleStateDTO lifecycleStateDTO = this.apiLifecycleApi.getAPILifecycleState(apiId, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)lifecycleStateDTO.getState())) {
            response = new HttpResponse(lifecycleStateDTO.getState(), 200);
        }
        return response;
    }

    public LifecycleStateDTO getLifecycleStatusDTO(String apiId) throws ApiException {
        ApiResponse apiResponse = this.apiLifecycleApi.getAPILifecycleStateWithHttpInfo(apiId, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
        return (LifecycleStateDTO)apiResponse.getData();
    }

    public LifecycleHistoryDTO getLifecycleHistory(String apiId) throws ApiException {
        ApiResponse apiResponse = this.apiLifecycleApi.getAPILifecycleHistoryWithHttpInfo(apiId, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
        return (LifecycleHistoryDTO)apiResponse.getData();
    }

    public HttpResponse copyAPI(String newVersion, String apiId, Boolean isDefault) throws ApiException {
        APIDTO apiDto = this.apIsApi.createNewAPIVersion(newVersion, apiId, isDefault, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)apiDto.getId())) {
            response = new HttpResponse(apiDto.getId(), 200);
        }
        return response;
    }

    public APIDTO copyAPIWithReturnDTO(String newVersion, String apiId, Boolean isDefault) throws ApiException {
        ApiResponse response = this.apIsApi.createNewAPIVersionWithHttpInfo(newVersion, apiId, isDefault, null);
        Assert.assertEquals((int)201, (int)response.getStatusCode());
        return (APIDTO)response.getData();
    }

    public HttpResponse updateAPI(APIRequest apiRequest, String apiId) throws ApiException {
        APIDTO apidto;
        ArrayList<String> roleList;
        APIDTO body = new APIDTO();
        body.setName(apiRequest.getName());
        body.setContext(apiRequest.getContext());
        body.setVersion(apiRequest.getVersion());
        if (apiRequest.getVisibility() != null) {
            body.setVisibility(APIDTO.VisibilityEnum.valueOf((String)apiRequest.getVisibility().toUpperCase()));
            if (APIDTO.VisibilityEnum.RESTRICTED.getValue().equalsIgnoreCase(apiRequest.getVisibility()) && StringUtils.isNotEmpty((String)apiRequest.getRoles())) {
                roleList = new ArrayList<String>(Arrays.asList(apiRequest.getRoles().split(" , ")));
                body.setVisibleRoles(roleList);
            }
        } else {
            body.setVisibility(APIDTO.VisibilityEnum.PUBLIC);
        }
        if (apiRequest.getAccessControl() != null) {
            body.setAccessControl(APIDTO.AccessControlEnum.valueOf((String)apiRequest.getAccessControl().toUpperCase()));
            if (APIDTO.AccessControlEnum.RESTRICTED.getValue().equalsIgnoreCase(apiRequest.getAccessControl()) && StringUtils.isNotEmpty((String)apiRequest.getAccessControlRoles())) {
                roleList = new ArrayList<String>(Arrays.asList(apiRequest.getAccessControlRoles().split(" , ")));
                body.setAccessControlRoles(roleList);
            }
        } else {
            body.setAccessControl(APIDTO.AccessControlEnum.NONE);
        }
        body.setDescription(apiRequest.getDescription());
        body.setProvider(apiRequest.getProvider());
        ArrayList<String> transports = new ArrayList<String>();
        if ("http".equals(apiRequest.getHttp_checked())) {
            transports.add("http");
        }
        if ("https".equals(apiRequest.getHttps_checked())) {
            transports.add("https");
        }
        body.setTransport(transports);
        body.isDefaultVersion(Boolean.valueOf(false));
        body.setCacheTimeout(Integer.valueOf(100));
        ArrayList<String> gatewayEnvironments = new ArrayList<String>();
        gatewayEnvironments.add(apiRequest.getEnvironment());
        body.setGatewayEnvironments(gatewayEnvironments);
        body.setMediationPolicies(apiRequest.getMediationPolicies());
        if (apiRequest.getOperationsDTOS() != null) {
            body.setOperations(apiRequest.getOperationsDTOS());
        } else {
            ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
            APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
            apiOperationsDTO.setVerb("GET");
            apiOperationsDTO.setTarget("/*");
            apiOperationsDTO.setAuthType("Application & Application User");
            apiOperationsDTO.setThrottlingPolicy("Unlimited");
            operations.add(apiOperationsDTO);
            body.setOperations(operations);
        }
        body.setBusinessInformation(new APIBusinessInformationDTO());
        body.setCorsConfiguration(new APICorsConfigurationDTO());
        body.setTags(Arrays.asList(apiRequest.getTags().split(",")));
        body.setEndpointConfig((Object)apiRequest.getEndpointConfig());
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Unlimited");
        body.setPolicies(Arrays.asList(apiRequest.getTiersCollection().split(",")));
        body.setCategories(apiRequest.getApiCategories());
        try {
            apidto = this.apIsApi.updateAPI(apiId, body, null);
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)apidto.getId())) {
            response = new HttpResponse(apidto.getId(), 200);
        }
        return response;
    }

    public APIDTO updateAPI(APIDTO apidto, String apiId) throws ApiException {
        ApiResponse apiDtoApiResponse = this.apIsApi.updateAPIWithHttpInfo(apiId, apidto, null);
        Assert.assertEquals((int)200, (int)apiDtoApiResponse.getStatusCode());
        return (APIDTO)apiDtoApiResponse.getData();
    }

    public HttpResponse getAPI(String apiId) throws ApiException {
        APIDTO apidto = null;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            apidto = this.apIsApi.getAPI(apiId, null, null);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (StringUtils.isNotEmpty((String)apidto.getId())) {
            response = new HttpResponse(gson.toJson((Object)apidto), 200);
        }
        return response;
    }

    public HttpResponse deleteAPI(String apiId) throws ApiException {
        ApiResponse deleteResponse = this.apIsApi.deleteAPIWithHttpInfo(apiId, null);
        HttpResponse response = null;
        if (deleteResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully deleted the API", 200);
        }
        return response;
    }

    public HttpResponse removeDocumentation(String apiId, String docId) throws ApiException {
        ApiResponse deleteResponse = this.apiDocumentsApi.deleteAPIDocumentWithHttpInfo(apiId, docId, null);
        HttpResponse response = null;
        if (deleteResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully removed the documentation", 200);
        }
        return response;
    }

    public HttpResponse revokeAccessToken(String accessToken, String consumerKey, String authUser) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse updatePermissions(String tierName, String permissionType, String roles) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse updateResourceOfAPI(String apiId, String api) throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse checkValidEndpoint(String endpointUrl, String apiId) throws ApiException {
        ApiEndpointValidationResponseDTO validationResponseDTO = this.validationApi.validateEndpoint(endpointUrl, apiId);
        HttpResponse response = null;
        if (validationResponseDTO.getStatusCode() == 200) {
            response = new HttpResponse(validationResponseDTO.getStatusMessage(), 200);
        }
        return response;
    }

    public HttpResponse changeAPILifeCycleStatusToPublish(String apiId, boolean isRequireReSubscription) throws ApiException {
        ApiResponse responseDTOApiResponse = this.apiLifecycleApi.changeAPILifecycleWithHttpInfo("Publish", apiId, "Re-Subscription:" + isRequireReSubscription, null);
        HttpResponse response = null;
        if (responseDTOApiResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully changed the lifecycle of the API", 200);
        }
        return response;
    }

    public HttpResponse getTierPermissionsPage() throws APIManagerIntegrationTestException {
        return null;
    }

    public HttpResponse addDocument(String apiId, DocumentDTO body) throws ApiException {
        DocumentDTO doc = this.apiDocumentsApi.addAPIDocument(apiId, body, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)doc.getDocumentId())) {
            response = new HttpResponse(doc.getDocumentId(), 200);
        }
        return response;
    }

    public HttpResponse addContentDocument(String apiId, String docId, String docContent) throws ApiException {
        DocumentDTO doc = this.apiDocumentsApi.addAPIDocumentContent(apiId, docId, null, null, docContent);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)doc.getDocumentId())) {
            response = new HttpResponse("Successfully created the documentation", 200);
        }
        return response;
    }

    public HttpResponse updateContentDocument(String apiId, String docId, File docContent) throws ApiException {
        DocumentDTO doc = this.apiDocumentsApi.addAPIDocumentContent(apiId, docId, null, docContent, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)doc.getDocumentId())) {
            response = new HttpResponse("Successfully updated the documentation", 200);
        }
        return response;
    }

    public HttpResponse updateDocument(String apiId, String docId, DocumentDTO documentDTO) throws ApiException {
        DocumentDTO doc = this.apiDocumentsApi.updateAPIDocument(apiId, docId, documentDTO, null);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)doc.getDocumentId())) {
            response = new HttpResponse("Successfully created the documentation", 200);
        }
        return response;
    }

    public DocumentListDTO getDocuments(String apiId) throws ApiException {
        ApiResponse apiResponse = this.apiDocumentsApi.getAPIDocumentsWithHttpInfo(apiId, null, null, null);
        Assert.assertEquals((int)200, (int)apiResponse.getStatusCode());
        return (DocumentListDTO)apiResponse.getData();
    }

    public HttpResponse getDocumentContent(String apiId, String documentId) throws ApiException {
        ApiResponse apiResponse = this.apiDocumentsApi.getAPIDocumentContentByDocumentIdWithHttpInfo(apiId, documentId, null);
        HttpResponse response = null;
        if (apiResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully retrieved the Document content", 200);
        }
        return response;
    }

    public HttpResponse deleteDocument(String apiId, String documentId) throws ApiException {
        ApiResponse deleteResponse = this.apiDocumentsApi.deleteAPIDocumentWithHttpInfo(apiId, documentId, null);
        HttpResponse response = null;
        if (deleteResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully deleted the Document", 200);
        }
        return response;
    }

    public ScopeDTO addSharedScope(ScopeDTO scopeDTO) throws ApiException {
        ApiResponse httpInfo = this.sharedScopesApi.addSharedScopeWithHttpInfo(scopeDTO);
        Assert.assertEquals((int)httpInfo.getStatusCode(), (int)201);
        return (ScopeDTO)httpInfo.getData();
    }

    public ScopeDTO updateSharedScope(String uuid, ScopeDTO scopeDTO) throws ApiException {
        ApiResponse httpInfo = this.sharedScopesApi.updateSharedScopeWithHttpInfo(uuid, scopeDTO);
        Assert.assertEquals((int)httpInfo.getStatusCode(), (int)200);
        return (ScopeDTO)httpInfo.getData();
    }

    public ScopeDTO getSharedScopeById(String uuid) throws ApiException {
        ApiResponse httpInfo = this.sharedScopesApi.getSharedScopeWithHttpInfo(uuid);
        Assert.assertEquals((int)httpInfo.getStatusCode(), (int)200);
        return (ScopeDTO)httpInfo.getData();
    }

    public void deleteSharedScope(String uuid) throws ApiException {
        ApiResponse httpInfo = this.sharedScopesApi.deleteSharedScopeWithHttpInfo(uuid);
        Assert.assertEquals((int)httpInfo.getStatusCode(), (int)200);
    }

    public ScopeListDTO getAllSharedScopes() throws ApiException {
        ApiResponse httpInfo = this.sharedScopesApi.getSharedScopesWithHttpInfo(null, null);
        Assert.assertEquals((int)httpInfo.getStatusCode(), (int)200);
        return (ScopeListDTO)httpInfo.getData();
    }

    public APIListDTO getAllAPIs() throws APIManagerIntegrationTestException, ApiException {
        APIListDTO apis = this.apIsApi.getAllAPIs(null, null, null, null, null, null, null);
        if (apis.getCount() > 0) {
            return apis;
        }
        return null;
    }

    public SearchResultListDTO searchAPIs(String query) throws ApiException {
        ApiResponse searchResponse = this.unifiedSearchApi.searchWithHttpInfo(null, null, query, null);
        Assert.assertEquals((int)200, (int)searchResponse.getStatusCode());
        return (SearchResultListDTO)searchResponse.getData();
    }

    public APIListDTO getAPIs(int offset, int limit) throws ApiException {
        ApiResponse apiResponse = this.apIsApi.getAllAPIsWithHttpInfo(Integer.valueOf(limit), Integer.valueOf(offset), this.tenantDomain, null, null, Boolean.valueOf(false), null);
        Assert.assertEquals((int)200, (int)apiResponse.getStatusCode());
        return (APIListDTO)apiResponse.getData();
    }

    public HttpResponse uploadEndpointCertificate(File certificate, String alias, String endpoint) throws ApiException {
        CertMetadataDTO certificateDTO = this.endpointCertificatesApi.addEndpointCertificate(certificate, alias, endpoint);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)certificateDTO.getAlias())) {
            response = new HttpResponse("Successfully uploaded the certificate", 200);
        }
        return response;
    }

    public ThrottlingPolicyListDTO getTiers(String policyLevel) throws ApiException {
        ThrottlingPolicyListDTO policies = this.throttlingPoliciesApi.getAllThrottlingPolicies(policyLevel, null, null, null);
        if (policies.getCount() > 0) {
            return policies;
        }
        return null;
    }

    public ApiResponse<Void> validateRoles(String roleId) throws ApiException {
        String encodedRoleName = Base64.getUrlEncoder().encodeToString(roleId.getBytes());
        return this.rolesApi.validateSystemRoleWithHttpInfo(encodedRoleName);
    }

    public String getSwaggerByID(String apiId) throws ApiException {
        ApiResponse response = this.apIsApi.getAPISwaggerWithHttpInfo(apiId, null);
        Assert.assertEquals((int)200, (int)response.getStatusCode());
        return (String)response.getData();
    }

    public String updateSwagger(String apiId, String definition) throws ApiException {
        ApiResponse apiResponse = this.apIsApi.updateAPISwaggerWithHttpInfo(apiId, null, definition, null, null);
        Assert.assertEquals((int)200, (int)apiResponse.getStatusCode());
        return (String)apiResponse.getData();
    }

    public OpenAPIDefinitionValidationResponseDTO validateOASDefinition(File oasDefinition) throws ApiException {
        ApiResponse response = this.validationApi.validateOpenAPIDefinitionWithHttpInfo(null, null, oasDefinition);
        Assert.assertEquals((int)200, (int)response.getStatusCode());
        return (OpenAPIDefinitionValidationResponseDTO)response.getData();
    }

    public APIDTO getAPIByID(String apiId, String tenantDomain) throws ApiException {
        ApiResponse apiDtoApiResponse = this.apIsApi.getAPIWithHttpInfo(apiId, tenantDomain, null);
        Assert.assertEquals((int)200, (int)apiDtoApiResponse.getStatusCode());
        return (APIDTO)apiDtoApiResponse.getData();
    }

    public APIDTO getAPIByID(String apiId) throws ApiException {
        return this.apIsApi.getAPI(apiId, this.tenantDomain, null);
    }

    public APIDTO importOASDefinition(File file, String properties) throws ApiException {
        ApiResponse apiDtoApiResponse = this.apIsApi.importOpenAPIDefinitionWithHttpInfo(file, null, properties);
        Assert.assertEquals((int)201, (int)apiDtoApiResponse.getStatusCode());
        return (APIDTO)apiDtoApiResponse.getData();
    }

    public GraphQLValidationResponseDTO validateGraphqlSchemaDefinition(File schemaDefinition) throws ApiException {
        ApiResponse response = this.validationApi.validateGraphQLSchemaWithHttpInfo(schemaDefinition);
        Assert.assertEquals((int)200, (int)response.getStatusCode());
        return (GraphQLValidationResponseDTO)response.getData();
    }

    public APIDTO importGraphqlSchemaDefinition(File file, String properties) throws ApiException {
        ApiResponse apiDtoApiResponse = this.apIsApi.importGraphQLSchemaWithHttpInfo(null, "GRAPHQL", file, properties);
        Assert.assertEquals((int)201, (int)apiDtoApiResponse.getStatusCode());
        return (APIDTO)apiDtoApiResponse.getData();
    }

    public GraphQLSchemaDTO getGraphqlSchemaDefinition(String apiId) throws ApiException {
        ApiResponse schemaDefinitionDTO = this.graphQlSchemaIndividualApi.getAPIGraphQLSchemaWithHttpInfo(apiId, "application/json", null);
        Assert.assertEquals((int)200, (int)schemaDefinitionDTO.getStatusCode());
        return (GraphQLSchemaDTO)schemaDefinitionDTO.getData();
    }

    public void updateGraphqlSchemaDefinition(String apiId, String schemaDefinition) throws ApiException {
        ApiResponse schemaDefinitionDTO = this.graphQlSchemaApi.updateAPIGraphQLSchemaWithHttpInfo(apiId, schemaDefinition, null);
        Assert.assertEquals((int)200, (int)schemaDefinitionDTO.getStatusCode());
    }

    public APIDTO addAPI(APICreationRequestBean apiCreationRequestBean) throws ApiException {
        APIDTO body = new APIDTO();
        body.setName(apiCreationRequestBean.getName());
        body.setContext(apiCreationRequestBean.getContext());
        body.setVersion(apiCreationRequestBean.getVersion());
        if (apiCreationRequestBean.getVisibility() != null) {
            body.setVisibility(APIDTO.VisibilityEnum.valueOf((String)apiCreationRequestBean.getVisibility().toUpperCase()));
            if (APIDTO.VisibilityEnum.RESTRICTED.getValue().equalsIgnoreCase(apiCreationRequestBean.getVisibility()) && StringUtils.isNotEmpty((String)apiCreationRequestBean.getRoles())) {
                ArrayList<String> roleList = new ArrayList<String>(Arrays.asList(apiCreationRequestBean.getRoles().split(" , ")));
                body.setVisibleRoles(roleList);
            }
        } else {
            body.setVisibility(APIDTO.VisibilityEnum.PUBLIC);
        }
        body.setDescription(apiCreationRequestBean.getDescription());
        body.setProvider(apiCreationRequestBean.getProvider());
        body.setTransport((List)new ArrayList<String>(){
            {
                this.add("http");
                this.add("https");
            }
        });
        body.isDefaultVersion(Boolean.valueOf(false));
        body.setCacheTimeout(Integer.valueOf(100));
        ArrayList<String> gatewayEnvironments = new ArrayList<String>();
        gatewayEnvironments.add(apiCreationRequestBean.getEnvironment());
        body.setGatewayEnvironments(gatewayEnvironments);
        ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
        for (APIResourceBean resourceBean : apiCreationRequestBean.getResourceBeanList()) {
            APIOperationsDTO dto = new APIOperationsDTO();
            dto.setTarget(resourceBean.getUriTemplate());
            dto.setAuthType(resourceBean.getResourceMethodAuthType());
            dto.setVerb(resourceBean.getResourceMethod());
            dto.setThrottlingPolicy(resourceBean.getResourceMethodThrottlingTier());
            operations.add(dto);
        }
        body.setOperations(operations);
        body.setBusinessInformation(new APIBusinessInformationDTO());
        body.setCorsConfiguration(new APICorsConfigurationDTO());
        body.setTags(Arrays.asList(apiCreationRequestBean.getTags().split(",")));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"endpoint_type", (Object)"http");
        JSONObject sandUrl = new JSONObject();
        sandUrl.put((Object)"url", (Object)apiCreationRequestBean.getEndpointUrl().toString());
        jsonObject.put((Object)"sandbox_endpoints", (Object)sandUrl);
        jsonObject.put((Object)"production_endpoints", (Object)sandUrl);
        if (APIEndpointSecurityDTO.TypeEnum.BASIC.getValue().equalsIgnoreCase(apiCreationRequestBean.getEndpointType())) {
            JSONObject endpointSecurityGlobal = new JSONObject();
            endpointSecurityGlobal.put((Object)"enabled", (Object)true);
            endpointSecurityGlobal.put((Object)"type", (Object)APIEndpointSecurityDTO.TypeEnum.BASIC.getValue());
            endpointSecurityGlobal.put((Object)"username", (Object)apiCreationRequestBean.getEpUsername());
            endpointSecurityGlobal.put((Object)grantType, (Object)apiCreationRequestBean.getEpPassword());
            JSONObject endpointSecurity = new JSONObject();
            endpointSecurity.put((Object)"production", (Object)endpointSecurityGlobal);
            endpointSecurity.put((Object)"sandbox", (Object)endpointSecurityGlobal);
            jsonObject.put((Object)"endpoint_security", (Object)endpointSecurity);
        }
        body.setEndpointConfig((Object)jsonObject);
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Unlimited");
        if (apiCreationRequestBean.getSubPolicyCollection() != null) {
            String[] tiers;
            for (String tier : tiers = apiCreationRequestBean.getSubPolicyCollection().split(",")) {
                tierList.add(tier);
            }
        }
        body.setPolicies(tierList);
        ApiResponse httpInfo = this.apIsApi.createAPIWithHttpInfo(body, "v3");
        Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
        return (APIDTO)httpInfo.getData();
    }

    public HttpResponse uploadCertificate(File certificate, String alias, String apiId, String tier) throws ApiException {
        ClientCertMetadataDTO certificateDTO = this.clientCertificatesApi.addAPIClientCertificate(apiId, certificate, alias, tier);
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)certificateDTO.getAlias())) {
            response = new HttpResponse("Successfully uploaded the certificate", 200);
        }
        return response;
    }

    public APIDTO updateAPI(APIDTO apidto) throws ApiException {
        ApiResponse response = this.apIsApi.updateAPIWithHttpInfo(apidto.getId(), apidto, null);
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        return (APIDTO)response.getData();
    }

    public SubscriptionListDTO getSubscriptionByAPIID(String apiID) throws ApiException {
        ApiResponse apiResponse = this.subscriptionsApi.getSubscriptionsWithHttpInfo(apiID, Integer.valueOf(10), Integer.valueOf(0), null, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
        return (SubscriptionListDTO)apiResponse.getData();
    }

    public APIProductListDTO getAllApiProducts() throws ApiException {
        ApiResponse apiResponse = this.apiProductsApi.getAllAPIProductsWithHttpInfo(null, null, null, null, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
        return (APIProductListDTO)apiResponse.getData();
    }

    public APIProductDTO getApiProduct(String apiProductId) throws ApiException {
        ApiResponse apiResponse = this.apiProductsApi.getAPIProductWithHttpInfo(apiProductId, null, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
        return (APIProductDTO)apiResponse.getData();
    }

    public APIProductDTO addApiProduct(APIProductDTO apiProductDTO) throws ApiException {
        ApiResponse apiResponse = this.apiProductsApi.createAPIProductWithHttpInfo(apiProductDTO);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)201);
        return (APIProductDTO)apiResponse.getData();
    }

    public void deleteApiProduct(String apiProductId) throws ApiException {
        ApiResponse apiResponse = this.apiProductsApi.deleteAPIProductWithHttpInfo(apiProductId, null);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
    }

    public HttpResponse getAuditApi(String apiId) throws ApiException {
        HttpResponse response = null;
        ApiResponse auditReportResponse = this.apiAuditApi.getAuditReportOfAPIWithHttpInfo(apiId, "application/json");
        if (auditReportResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully audited the report", 200);
        }
        return response;
    }

    public HttpResponse getGraphQLSchemaTypeListResponse(String apiId) throws ApiException {
        HttpResponse response = null;
        ApiResponse graphQLSchemaTypeListDTOApiResponse = this.graphQlPoliciesApi.getGraphQLPolicyComplexityTypesOfAPIWithHttpInfo(apiId);
        if (graphQLSchemaTypeListDTOApiResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully get the GraphQL Schema Type List", 200);
        }
        return response;
    }

    public GraphQLSchemaTypeListDTO getGraphQLSchemaTypeList(String apiId) throws ApiException {
        ApiResponse graphQLSchemaTypeListDTOApiResponse = this.graphQlPoliciesApi.getGraphQLPolicyComplexityTypesOfAPIWithHttpInfo(apiId);
        Assert.assertEquals((int)graphQLSchemaTypeListDTOApiResponse.getStatusCode(), (int)200);
        return (GraphQLSchemaTypeListDTO)graphQLSchemaTypeListDTOApiResponse.getData();
    }

    public void addGraphQLComplexityDetails(GraphQLQueryComplexityInfoDTO graphQLQueryComplexityInfoDTO, String apiID) throws ApiException {
        ApiResponse apiResponse = this.graphQlPoliciesApi.updateGraphQLPolicyComplexityOfAPIWithHttpInfo(apiID, graphQLQueryComplexityInfoDTO);
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
    }

    public HttpResponse getGraphQLComplexityResponse(String apiId) throws ApiException {
        HttpResponse response = null;
        ApiResponse complexityResponse = this.graphQlPoliciesApi.getGraphQLPolicyComplexityOfAPIWithHttpInfo(apiId);
        if (complexityResponse.getStatusCode() == 200) {
            response = new HttpResponse("Successfully get the GraphQL Complexity Details", 200);
        }
        return response;
    }

    public HttpResponse addAPIRevision(APIRevisionRequest apiRevisionRequest) throws ApiException {
        APIRevisionDTO apiRevisionDTO = new APIRevisionDTO();
        apiRevisionDTO.setDescription(apiRevisionRequest.getDescription());
        Gson gson = new Gson();
        try {
            ApiResponse httpInfo = this.apiRevisionsApi.createAPIRevisionWithHttpInfo(apiRevisionRequest.getApiUUID(), apiRevisionDTO);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
            apiRevisionDTO = (APIRevisionDTO)httpInfo.getData();
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        if (apiRevisionDTO != null && StringUtils.isNotEmpty((String)apiRevisionDTO.getId())) {
            response = new HttpResponse(gson.toJson((Object)apiRevisionDTO), 201);
        }
        return response;
    }

    public APIRevisionDTO addAPIRevision(String apiId) throws ApiException {
        APIRevisionDTO apiRevisionDTO = new APIRevisionDTO();
        Gson gson = new Gson();
        try {
            ApiResponse httpInfo = this.apiRevisionsApi.createAPIRevisionWithHttpInfo(apiId, apiRevisionDTO);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
            return (APIRevisionDTO)httpInfo.getData();
        }
        catch (ApiException e) {
            throw new ApiException((Throwable)e);
        }
    }

    public HttpResponse getAPIRevisions(String apiUUID, String query) throws ApiException {
        APIRevisionListDTO apiRevisionListDTO = null;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            apiRevisionListDTO = this.apiRevisionsApi.getAPIRevisions(apiUUID, query);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (StringUtils.isNotEmpty((String)apiRevisionListDTO.getList().toString())) {
            response = new HttpResponse(gson.toJson((Object)apiRevisionListDTO), 200);
        }
        return response;
    }

    public HttpResponse deployAPIRevision(String apiUUID, String revisionUUID, List<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList) throws ApiException {
        Gson gson = new Gson();
        ArrayList<APIRevisionDeploymentDTO> apiRevisionDeploymentDTOList = new ArrayList<APIRevisionDeploymentDTO>();
        ArrayList apiRevisionDeploymentDTOResponseList = new ArrayList();
        for (APIRevisionDeployUndeployRequest apiRevisionDeployRequest : apiRevisionDeployRequestList) {
            APIRevisionDeploymentDTO apiRevisionDeploymentDTO = new APIRevisionDeploymentDTO();
            apiRevisionDeploymentDTO.setName(apiRevisionDeployRequest.getName());
            apiRevisionDeploymentDTO.setVhost(apiRevisionDeployRequest.getVhost());
            apiRevisionDeploymentDTO.setDisplayOnDevportal(Boolean.valueOf(apiRevisionDeployRequest.isDisplayOnDevportal()));
            apiRevisionDeploymentDTOList.add(apiRevisionDeploymentDTO);
        }
        try {
            ApiResponse httpInfo = this.apiRevisionsApi.deployAPIRevisionWithHttpInfo(apiUUID, revisionUUID, apiRevisionDeploymentDTOList);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        response = new HttpResponse(gson.toJson(apiRevisionDeploymentDTOResponseList), 201);
        return response;
    }

    public HttpResponse deployAPIRevision(String apiUUID, String revisionUUID, APIRevisionDeployUndeployRequest apiRevisionDeployRequest) throws ApiException {
        Gson gson = new Gson();
        ArrayList<APIRevisionDeploymentDTO> apiRevisionDeploymentDTOList = new ArrayList<APIRevisionDeploymentDTO>();
        ArrayList apiRevisionDeploymentDTOResponseList = new ArrayList();
        APIRevisionDeploymentDTO apiRevisionDeploymentDTO = new APIRevisionDeploymentDTO();
        apiRevisionDeploymentDTO.setName(apiRevisionDeployRequest.getName());
        apiRevisionDeploymentDTO.setVhost(apiRevisionDeployRequest.getVhost());
        apiRevisionDeploymentDTO.setDisplayOnDevportal(Boolean.valueOf(apiRevisionDeployRequest.isDisplayOnDevportal()));
        apiRevisionDeploymentDTOList.add(apiRevisionDeploymentDTO);
        try {
            ApiResponse httpInfo = this.apiRevisionsApi.deployAPIRevisionWithHttpInfo(apiUUID, revisionUUID, apiRevisionDeploymentDTOList);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        response = new HttpResponse(gson.toJson(apiRevisionDeploymentDTOResponseList), 201);
        return response;
    }

    public HttpResponse undeployAPIRevision(String apiUUID, String revisionUUID, List<APIRevisionDeployUndeployRequest> apiRevisionUndeployRequestList) throws ApiException {
        Gson gson = new Gson();
        ArrayList<APIRevisionDeploymentDTO> apiRevisionUnDeploymentDTOList = new ArrayList<APIRevisionDeploymentDTO>();
        ArrayList apiRevisionUnDeploymentDTOResponseList = new ArrayList();
        for (APIRevisionDeployUndeployRequest apiRevisionUndeployRequest : apiRevisionUndeployRequestList) {
            APIRevisionDeploymentDTO apiRevisionDeploymentDTO = new APIRevisionDeploymentDTO();
            apiRevisionDeploymentDTO.setName(apiRevisionUndeployRequest.getName());
            apiRevisionDeploymentDTO.setVhost(apiRevisionUndeployRequest.getVhost());
            apiRevisionDeploymentDTO.setDisplayOnDevportal(Boolean.valueOf(apiRevisionUndeployRequest.isDisplayOnDevportal()));
            apiRevisionUnDeploymentDTOList.add(apiRevisionDeploymentDTO);
        }
        try {
            ApiResponse httpInfo = this.apiRevisionsApi.undeployAPIRevisionWithHttpInfo(apiUUID, revisionUUID, null, Boolean.valueOf(false), apiRevisionUnDeploymentDTOList);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        response = new HttpResponse(gson.toJson(apiRevisionUnDeploymentDTOResponseList), 201);
        return response;
    }

    public HttpResponse restoreAPIRevision(String apiUUID, String revisionUUID) throws ApiException {
        Gson gson = new Gson();
        APIDTO apidto = null;
        try {
            ApiResponse httpInfo = this.apiRevisionsApi.restoreAPIRevisionWithHttpInfo(apiUUID, revisionUUID);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
            apidto = (APIDTO)httpInfo.getData();
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)apidto.toString())) {
            response = new HttpResponse(gson.toJson((Object)apidto), 201);
        }
        return response;
    }

    public HttpResponse deleteAPIRevision(String apiUUID, String revisionUUID) throws ApiException {
        Gson gson = new Gson();
        APIRevisionListDTO apiRevisionListDTO = null;
        try {
            ApiResponse httpInfo = this.apiRevisionsApi.deleteAPIRevisionWithHttpInfo(apiUUID, revisionUUID);
            Assert.assertEquals((int)200, (int)httpInfo.getStatusCode());
            apiRevisionListDTO = (APIRevisionListDTO)httpInfo.getData();
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)apiRevisionListDTO.toString())) {
            response = new HttpResponse(gson.toJson((Object)apiRevisionListDTO), 200);
        }
        return response;
    }

    public MediationListDTO retrieveMediationPolicies() throws ApiException {
        return this.globalMediationPoliciesApi.getAllGlobalMediationPolicies(Integer.valueOf(100), Integer.valueOf(0), null, null);
    }

    public HttpResponse addAPIProductRevision(APIRevisionRequest apiRevisionRequest) throws ApiException {
        APIRevisionDTO apiRevisionDTO = new APIRevisionDTO();
        apiRevisionDTO.setDescription(apiRevisionRequest.getDescription());
        Gson gson = new Gson();
        try {
            ApiResponse httpInfo = this.apiProductRevisionsApi.createAPIProductRevisionWithHttpInfo(apiRevisionRequest.getApiUUID(), apiRevisionDTO);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
            apiRevisionDTO = (APIRevisionDTO)httpInfo.getData();
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        if (apiRevisionDTO != null && StringUtils.isNotEmpty((String)apiRevisionDTO.getId())) {
            response = new HttpResponse(gson.toJson((Object)apiRevisionDTO), 201);
        }
        return response;
    }

    public HttpResponse getAPIProductRevisions(String apiUUID, String query) throws ApiException {
        APIRevisionListDTO apiRevisionListDTO = null;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            apiRevisionListDTO = this.apiProductRevisionsApi.getAPIProductRevisions(apiUUID, query);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (StringUtils.isNotEmpty((String)apiRevisionListDTO.getList().toString())) {
            response = new HttpResponse(gson.toJson((Object)apiRevisionListDTO), 200);
        }
        return response;
    }

    public HttpResponse deployAPIProductRevision(String apiUUID, String revisionUUID, List<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList) throws ApiException {
        Gson gson = new Gson();
        ArrayList<APIRevisionDeploymentDTO> apiRevisionDeploymentDTOList = new ArrayList<APIRevisionDeploymentDTO>();
        ArrayList apiRevisionDeploymentDTOResponseList = new ArrayList();
        for (APIRevisionDeployUndeployRequest apiRevisionDeployRequest : apiRevisionDeployRequestList) {
            APIRevisionDeploymentDTO apiRevisionDeploymentDTO = new APIRevisionDeploymentDTO();
            apiRevisionDeploymentDTO.setName(apiRevisionDeployRequest.getName());
            apiRevisionDeploymentDTO.setVhost(apiRevisionDeployRequest.getVhost());
            apiRevisionDeploymentDTO.setDisplayOnDevportal(Boolean.valueOf(apiRevisionDeployRequest.isDisplayOnDevportal()));
            apiRevisionDeploymentDTOList.add(apiRevisionDeploymentDTO);
        }
        try {
            ApiResponse httpInfo = this.apiProductRevisionsApi.deployAPIProductRevisionWithHttpInfo(apiUUID, revisionUUID, apiRevisionDeploymentDTOList);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        response = new HttpResponse(gson.toJson(apiRevisionDeploymentDTOResponseList), 201);
        return response;
    }

    public HttpResponse undeployAPIProductRevision(String apiUUID, String revisionUUID, List<APIRevisionDeployUndeployRequest> apiRevisionUndeployRequestList) throws ApiException {
        Gson gson = new Gson();
        ArrayList<APIRevisionDeploymentDTO> apiRevisionUnDeploymentDTOList = new ArrayList<APIRevisionDeploymentDTO>();
        ArrayList apiRevisionUnDeploymentDTOResponseList = new ArrayList();
        for (APIRevisionDeployUndeployRequest apiRevisionUndeployRequest : apiRevisionUndeployRequestList) {
            APIRevisionDeploymentDTO apiRevisionDeploymentDTO = new APIRevisionDeploymentDTO();
            apiRevisionDeploymentDTO.setName(apiRevisionUndeployRequest.getName());
            apiRevisionDeploymentDTO.setVhost(apiRevisionUndeployRequest.getVhost());
            apiRevisionDeploymentDTO.setDisplayOnDevportal(Boolean.valueOf(apiRevisionUndeployRequest.isDisplayOnDevportal()));
            apiRevisionUnDeploymentDTOList.add(apiRevisionDeploymentDTO);
        }
        try {
            ApiResponse httpInfo = this.apiProductRevisionsApi.undeployAPIProductRevisionWithHttpInfo(apiUUID, revisionUUID, null, Boolean.valueOf(false), apiRevisionUnDeploymentDTOList);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        response = new HttpResponse(gson.toJson(apiRevisionUnDeploymentDTOResponseList), 201);
        return response;
    }

    public HttpResponse restoreAPIProductRevision(String apiUUID, String revisionUUID) throws ApiException {
        Gson gson = new Gson();
        APIProductDTO apiProductDTO = null;
        try {
            ApiResponse httpInfo = this.apiProductRevisionsApi.restoreAPIProductRevisionWithHttpInfo(apiUUID, revisionUUID);
            Assert.assertEquals((int)201, (int)httpInfo.getStatusCode());
            apiProductDTO = (APIProductDTO)httpInfo.getData();
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)apiProductDTO.toString())) {
            response = new HttpResponse(gson.toJson((Object)apiProductDTO), 201);
        }
        return response;
    }

    public HttpResponse deleteAPIProductRevision(String apiUUID, String revisionUUID) throws ApiException {
        Gson gson = new Gson();
        APIRevisionListDTO apiRevisionListDTO = null;
        try {
            ApiResponse httpInfo = this.apiProductRevisionsApi.deleteAPIProductRevisionWithHttpInfo(apiUUID, revisionUUID);
            Assert.assertEquals((int)200, (int)httpInfo.getStatusCode());
            apiRevisionListDTO = (APIRevisionListDTO)httpInfo.getData();
        }
        catch (ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new ApiException((Throwable)e);
        }
        HttpResponse response = null;
        if (StringUtils.isNotEmpty((String)apiRevisionListDTO.toString())) {
            response = new HttpResponse(gson.toJson((Object)apiRevisionListDTO), 200);
        }
        return response;
    }

    public ApiResponse<APIKeyDTO> generateInternalApiKey(String apiId) throws ApiException {
        return this.apIsApi.generateInternalAPIKeyWithHttpInfo(apiId);
    }

    public HttpResponse addComment(String apiId, String comment, String category, String replyTo) throws ApiException {
        PostRequestBodyDTO postRequestBodyDTO = new PostRequestBodyDTO();
        postRequestBodyDTO.setContent(comment);
        postRequestBodyDTO.setCategory(category);
        Gson gson = new Gson();
        CommentDTO commentDTO = this.commentsApi.addCommentToAPI(apiId, postRequestBodyDTO, replyTo);
        HttpResponse response = null;
        if (commentDTO != null) {
            response = new HttpResponse(gson.toJson((Object)commentDTO), 200);
        }
        return response;
    }

    public HttpResponse getComment(String commentId, String apiId, String tenantDomain, boolean includeCommentorInfo, Integer limit, Integer offset) throws ApiException {
        CommentDTO commentDTO;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            commentDTO = this.commentsApi.getCommentOfAPI(commentId, apiId, tenantDomain, null, Boolean.valueOf(includeCommentorInfo), limit, offset);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (StringUtils.isNotEmpty((String)commentDTO.getId())) {
            response = new HttpResponse(gson.toJson((Object)commentDTO), 200);
        }
        return response;
    }

    public HttpResponse getComments(String apiId, String tenantDomain, boolean includeCommentorInfo, Integer limit, Integer offset) throws ApiException {
        CommentListDTO commentListDTO;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            commentListDTO = this.commentsApi.getAllCommentsOfAPI(apiId, tenantDomain, limit, offset, Boolean.valueOf(includeCommentorInfo));
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (commentListDTO.getCount() > 0) {
            response = new HttpResponse(gson.toJson((Object)commentListDTO), 200);
        }
        return response;
    }

    public HttpResponse getReplies(String commentId, String apiId, String tenantDomain, boolean includeCommentorInfo, Integer limit, Integer offset) throws ApiException {
        CommentListDTO commentListDTO;
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            commentListDTO = this.commentsApi.getRepliesOfComment(commentId, apiId, tenantDomain, limit, offset, null, Boolean.valueOf(includeCommentorInfo));
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        if (commentListDTO.getCount() > 0) {
            response = new HttpResponse(gson.toJson((Object)commentListDTO), 200);
        }
        return response;
    }

    public HttpResponse editComment(String commentId, String apiId, String comment, String category) throws ApiException {
        HttpResponse response = null;
        Gson gson = new Gson();
        try {
            PatchRequestBodyDTO patchRequestBodyDTO = new PatchRequestBodyDTO();
            patchRequestBodyDTO.setCategory(category);
            patchRequestBodyDTO.setContent(comment);
            CommentDTO editedCommentDTO = this.commentsApi.editCommentOfAPI(commentId, apiId, patchRequestBodyDTO);
            response = editedCommentDTO != null ? new HttpResponse(gson.toJson((Object)editedCommentDTO), 200) : new HttpResponse(null, 200);
        }
        catch (ApiException e) {
            return new HttpResponse(gson.toJson((Object)e.getResponseBody()), e.getCode());
        }
        return response;
    }

    public HttpResponse removeComment(String commentId, String apiId) throws ApiException {
        HttpResponse response;
        try {
            this.commentsApi.deleteComment(commentId, apiId, null);
            response = new HttpResponse("Successfully deleted the comment", 200);
        }
        catch (ApiException e) {
            response = new HttpResponse("Failed to delete the comment", e.getCode());
        }
        return response;
    }

    public ApiResponse<APIProductDTO> updateAPIProduct(APIProductDTO apiProductDTO) throws ApiException {
        return this.apiProductsApi.updateAPIProductWithHttpInfo(apiProductDTO.getId(), apiProductDTO, null);
    }
}

