/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.test.impl;

import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.wso2.am.integration.clients.gateway.api.ApiClient;
import org.wso2.am.integration.clients.gateway.api.ApiException;
import org.wso2.am.integration.clients.gateway.api.v2.DeployApiApi;
import org.wso2.am.integration.clients.gateway.api.v2.GetApiArtifactsApi;
import org.wso2.am.integration.clients.gateway.api.v2.UndeployApiApi;
import org.wso2.am.integration.clients.gateway.api.v2.dto.APIArtifactDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.EndpointsDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.LocalEntryDTO;
import org.wso2.am.integration.clients.gateway.api.v2.dto.SequencesDTO;

public class RestAPIGatewayImpl {
    private String tenantDomain = null;
    GetApiArtifactsApi getApiArtifactsApi = new GetApiArtifactsApi();
    DeployApiApi deployApiApi = new DeployApiApi();
    UndeployApiApi undeployApiApi = new UndeployApiApi();

    public RestAPIGatewayImpl(String username, String password, String tenantDomain) {
        ApiClient apiClient = new ApiClient();
        String basicEncoded = DatatypeConverter.printBase64Binary((byte[])(username + ':' + password).getBytes(StandardCharsets.UTF_8));
        apiClient.addDefaultHeader("Authorization", "Basic " + basicEncoded);
        apiClient.setDebugging(true);
        apiClient.setBasePath("https://localhost:9943/api/am/gateway/v2");
        apiClient.setReadTimeout(600000);
        apiClient.setConnectTimeout(600000);
        apiClient.setWriteTimeout(600000);
        this.getApiArtifactsApi.setApiClient(apiClient);
        this.deployApiApi.setApiClient(apiClient);
        this.undeployApiApi.setApiClient(apiClient);
        this.tenantDomain = tenantDomain;
    }

    public APIArtifactDTO retrieveAPI(String name, String version) throws ApiException {
        return this.getApiArtifactsApi.apiArtifactGet(name, version, this.tenantDomain);
    }

    public EndpointsDTO retrieveEndpoints(String name, String version) throws ApiException {
        return this.getApiArtifactsApi.endPointsGet(name, version, this.tenantDomain);
    }

    public LocalEntryDTO retrieveLocalEntries(String name, String version) throws ApiException {
        return this.getApiArtifactsApi.localEntryGet(name, version, this.tenantDomain);
    }

    public SequencesDTO retrieveSequences(String name, String version) throws ApiException {
        return this.getApiArtifactsApi.sequenceGet(name, version, this.tenantDomain);
    }
}

